/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.config;

import java.util.Optional;
import mezz.jei.config.ClientConfig;
import mezz.jei.config.IngredientFilterConfig;
import mezz.jei.config.ModIdFormattingConfig;
import mezz.jei.events.EventBusHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.client.ConfigGuiHandler;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;

public class JEIClientConfig {
    private static final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
    public static final ClientConfig clientConfig = new ClientConfig(builder);
    public static final IngredientFilterConfig filterConfig = new IngredientFilterConfig(builder);
    public static final ModIdFormattingConfig modNameFormat = new ModIdFormattingConfig(builder);
    private static final ForgeConfigSpec config = builder.build();

    public static void register(IEventBus modEventBus) {
        EventBusHelper.addListener(JEIClientConfig.class, modEventBus, ModConfigEvent.class, JEIClientConfig::reload);
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        modLoadingContext.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)config);
    }

    public static void reload(ModConfigEvent event) {
        if (event.getConfig().getSpec() != config) {
            return;
        }
        clientConfig.reload();
        filterConfig.reload();
        modNameFormat.reload();
    }

    public static void openSettings() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        Optional<Screen> configScreen = ModList.get().getModContainerById("jei").map(ModContainer::getModInfo).flatMap(ConfigGuiHandler::getGuiFactoryFor).map(f -> (Screen)f.apply(mc, mc.f_91080_));
        if (configScreen.isPresent()) {
            mc.m_91152_(configScreen.get());
        } else {
            ClickEvent clickEvent = new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/configured");
            Style style = Style.f_131099_.setUnderlined(Boolean.valueOf(true)).m_131142_(clickEvent);
            TranslatableComponent message = new TranslatableComponent("jei.message.configured");
            message = message.m_6270_(style);
            mc.f_91074_.m_5661_((Component)message, false);
        }
    }
}

