/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.config;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.config.IEditModeConfig;
import mezz.jei.config.IngredientBlacklistType;
import mezz.jei.ingredients.IIngredientListElementInfo;
import mezz.jei.ingredients.IngredientFilter;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EditModeConfig
implements IEditModeConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String[] defaultBlacklist = new String[0];
    private final Set<String> blacklist = new LinkedHashSet<String>();
    @Nullable
    private final File blacklistConfigFile;

    public EditModeConfig(@Nullable File jeiConfigurationDir) {
        Collections.addAll(this.blacklist, defaultBlacklist);
        if (jeiConfigurationDir != null) {
            this.blacklistConfigFile = new File(jeiConfigurationDir, "blacklist.cfg");
            this.loadBlacklistConfig();
        } else {
            this.blacklistConfigFile = null;
        }
    }

    private void loadBlacklistConfig() {
        if (this.blacklistConfigFile != null && this.blacklistConfigFile.exists()) {
            try (FileReader reader = new FileReader(this.blacklistConfigFile);){
                List strings = IOUtils.readLines((Reader)reader);
                this.blacklist.clear();
                this.blacklist.addAll(strings);
            }
            catch (IOException e) {
                LOGGER.error("Failed to load blacklist from file {}", (Object)this.blacklistConfigFile, (Object)e);
            }
        }
    }

    private void saveBlacklist() {
        if (this.blacklistConfigFile != null) {
            try {
                if (this.blacklistConfigFile.createNewFile()) {
                    LOGGER.debug("Created blacklist config file: {}", (Object)this.blacklistConfigFile);
                }
                try (FileWriter writer = new FileWriter(this.blacklistConfigFile);){
                    IOUtils.writeLines(this.blacklist, (String)"\n", (Writer)writer);
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to save blacklist to file {}", (Object)this.blacklistConfigFile, (Object)e);
            }
        }
    }

    @Override
    public <V> void addIngredientToConfigBlacklist(IngredientFilter ingredientFilter, IIngredientManager ingredientManager, V ingredient, IngredientBlacklistType blacklistType, IIngredientHelper<V> ingredientHelper) {
        if (blacklistType == IngredientBlacklistType.ITEM) {
            String uid = EditModeConfig.getIngredientUid(ingredient, IngredientBlacklistType.ITEM, ingredientHelper);
            List<IIngredientListElementInfo<V>> elementsToBeBlacklisted = ingredientFilter.getMatches(ingredient, ingredientHelper, input -> EditModeConfig.getIngredientUid(input, IngredientBlacklistType.WILDCARD, ingredientHelper));
            if (this.areAllBlacklisted(elementsToBeBlacklisted, ingredientHelper, uid)) {
                if (this.addIngredientToConfigBlacklist(ingredientFilter, ingredient, IngredientBlacklistType.WILDCARD, ingredientHelper)) {
                    this.saveBlacklist();
                }
                return;
            }
        }
        if (this.addIngredientToConfigBlacklist(ingredientFilter, ingredient, blacklistType, ingredientHelper)) {
            this.saveBlacklist();
        }
    }

    private <V> boolean addIngredientToConfigBlacklist(IngredientFilter ingredientFilter, V ingredient, IngredientBlacklistType blacklistType, IIngredientHelper<V> ingredientHelper) {
        boolean updated = false;
        if (blacklistType == IngredientBlacklistType.WILDCARD) {
            List<IIngredientListElementInfo<Object>> elementsToBeBlacklisted = ingredientFilter.getMatches(ingredient, ingredientHelper, input -> EditModeConfig.getIngredientUid(input, blacklistType, ingredientHelper));
            for (IIngredientListElementInfo<Object> elementToBeBlacklistedInfo : elementsToBeBlacklisted) {
                Object ingredientToBeBlacklisted = elementToBeBlacklistedInfo.getIngredient();
                String uid = EditModeConfig.getIngredientUid(ingredientToBeBlacklisted, IngredientBlacklistType.ITEM, ingredientHelper);
                updated |= this.blacklist.remove(uid);
            }
        }
        String uid = EditModeConfig.getIngredientUid(ingredient, blacklistType, ingredientHelper);
        return updated |= this.blacklist.add(uid);
    }

    private <V> boolean areAllBlacklisted(List<IIngredientListElementInfo<V>> elementInfos, IIngredientHelper<V> ingredientHelper, String newUid) {
        for (IIngredientListElementInfo<V> elementInfo : elementInfos) {
            V ingredient = elementInfo.getIngredient();
            String uid = EditModeConfig.getIngredientUid(ingredient, IngredientBlacklistType.ITEM, ingredientHelper);
            if (uid.equals(newUid) || this.blacklist.contains(uid)) continue;
            return false;
        }
        return true;
    }

    @Override
    public <V> void removeIngredientFromConfigBlacklist(IngredientFilter ingredientFilter, IIngredientManager ingredientManager, V ingredient, IngredientBlacklistType blacklistType, IIngredientHelper<V> ingredientHelper) {
        String uid;
        boolean updated = false;
        if (blacklistType == IngredientBlacklistType.ITEM) {
            String wildUid = EditModeConfig.getIngredientUid(ingredient, IngredientBlacklistType.WILDCARD, ingredientHelper);
            if (this.blacklist.contains(wildUid)) {
                updated = true;
                this.blacklist.remove(wildUid);
                List<IIngredientListElementInfo<Object>> modMatches = ingredientFilter.getMatches(ingredient, ingredientHelper, input -> EditModeConfig.getIngredientUid(input, IngredientBlacklistType.WILDCARD, ingredientHelper));
                for (IIngredientListElementInfo<Object> modMatch : modMatches) {
                    this.addIngredientToConfigBlacklist(ingredientFilter, modMatch.getIngredient(), IngredientBlacklistType.ITEM, ingredientHelper);
                }
            }
        } else if (blacklistType == IngredientBlacklistType.WILDCARD) {
            List<IIngredientListElementInfo<Object>> modMatches = ingredientFilter.getMatches(ingredient, ingredientHelper, input -> EditModeConfig.getIngredientUid(input, IngredientBlacklistType.WILDCARD, ingredientHelper));
            for (IIngredientListElementInfo<Object> modMatch : modMatches) {
                Object matchIngredient = modMatch.getIngredient();
                String uid2 = EditModeConfig.getIngredientUid(matchIngredient, IngredientBlacklistType.ITEM, ingredientHelper);
                updated |= this.blacklist.remove(uid2);
            }
        }
        if (updated |= this.blacklist.remove(uid = EditModeConfig.getIngredientUid(ingredient, blacklistType, ingredientHelper))) {
            this.saveBlacklist();
        }
    }

    @Override
    public <V> boolean isIngredientOnConfigBlacklist(V ingredient, IIngredientHelper<V> ingredientHelper) {
        for (IngredientBlacklistType ingredientBlacklistType : IngredientBlacklistType.VALUES) {
            if (!this.isIngredientOnConfigBlacklist(ingredient, ingredientBlacklistType, ingredientHelper)) continue;
            return true;
        }
        return false;
    }

    public <V> boolean isIngredientOnConfigBlacklist(V ingredient, IngredientBlacklistType blacklistType, IIngredientHelper<V> ingredientHelper) {
        String uid = EditModeConfig.getIngredientUid(ingredient, blacklistType, ingredientHelper);
        return this.blacklist.contains(uid);
    }

    private static <V> String getIngredientUid(V ingredient, IngredientBlacklistType blacklistType, IIngredientHelper<V> ingredientHelper) {
        return switch (blacklistType) {
            default -> throw new IncompatibleClassChangeError();
            case IngredientBlacklistType.ITEM -> ingredientHelper.getUniqueId(ingredient, UidContext.Ingredient);
            case IngredientBlacklistType.WILDCARD -> ingredientHelper.getWildcardId(ingredient);
        };
    }
}

