/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.collect;

import com.google.common.collect.ImmutableMultimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;

public class MultiMap<K, V, T extends Collection<V>> {
    protected final Map<K, T> map;
    private final Function<K, T> collectionMappingFunction;

    public MultiMap(Supplier<T> collectionSupplier) {
        this(new HashMap(), collectionSupplier);
    }

    public MultiMap(Map<K, T> map, Supplier<T> collectionSupplier) {
        this.map = map;
        this.collectionMappingFunction = k -> (Collection)collectionSupplier.get();
    }

    public T get(K key) {
        return (T)((Collection)this.map.computeIfAbsent(key, this.collectionMappingFunction));
    }

    public boolean put(K key, V value) {
        return this.get(key).add(value);
    }

    public boolean remove(K key, V value) {
        Collection collection = (Collection)this.map.get(key);
        return collection != null && collection.remove(value);
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public boolean contains(K key, V value) {
        Collection collection = (Collection)this.map.get(key);
        return collection != null && collection.contains(value);
    }

    public Set<Map.Entry<K, T>> entrySet() {
        return this.map.entrySet();
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public void clear() {
        this.map.clear();
    }

    public ImmutableMultimap<K, V> toImmutable() {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (Map.Entry<K, T> entry : this.map.entrySet()) {
            K key = entry.getKey();
            for (Object value : (Collection)entry.getValue()) {
                builder.put(key, value);
            }
        }
        return builder.build();
    }
}

