/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.bookmarks;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.config.BookmarkConfig;
import mezz.jei.gui.overlay.IIngredientGridSource;
import mezz.jei.ingredients.IngredientManager;
import net.minecraft.world.item.ItemStack;

public class BookmarkList
implements IIngredientGridSource {
    private final List<Object> list = new LinkedList<Object>();
    private final IngredientManager ingredientManager;
    private final BookmarkConfig bookmarkConfig;
    private final List<IIngredientGridSource.Listener> listeners = new ArrayList<IIngredientGridSource.Listener>();

    public BookmarkList(IngredientManager ingredientManager, BookmarkConfig bookmarkConfig) {
        this.ingredientManager = ingredientManager;
        this.bookmarkConfig = bookmarkConfig;
    }

    public <T> boolean add(T ingredient) {
        IIngredientHelper<T> ingredientHelper = this.ingredientManager.getIngredientHelper(ingredient);
        T normalized = ingredientHelper.normalizeIngredient(ingredient);
        if (!this.contains(normalized) && this.addToList(normalized, true)) {
            this.notifyListenersOfChange();
            this.bookmarkConfig.saveBookmarks(this.ingredientManager, this.list);
            return true;
        }
        return false;
    }

    private <T> boolean contains(T ingredient) {
        IIngredientHelper<T> ingredientHelper = this.ingredientManager.getIngredientHelper(ingredient);
        for (Object existing : this.list) {
            if (ingredient == existing) {
                return true;
            }
            if (!ingredient.getClass().isInstance(existing)) continue;
            Object castExisting = existing;
            if (ingredient instanceof ItemStack) {
                return ItemStack.m_41728_((ItemStack)((ItemStack)ingredient), (ItemStack)((ItemStack)castExisting));
            }
            if (!BookmarkList.equalUids(ingredientHelper, castExisting, ingredient)) continue;
            return true;
        }
        return false;
    }

    private static <T> boolean equalUids(IIngredientHelper<T> ingredientHelper, T a, T b) {
        String uidA = ingredientHelper.getUniqueId(a, UidContext.Ingredient);
        String uidB = ingredientHelper.getUniqueId(b, UidContext.Ingredient);
        return uidA.equals(uidB);
    }

    public boolean remove(Object ingredient) {
        int index = 0;
        for (Object existing : this.list) {
            if (ingredient == existing) {
                this.list.remove(index);
                this.notifyListenersOfChange();
                this.bookmarkConfig.saveBookmarks(this.ingredientManager, this.list);
                return true;
            }
            ++index;
        }
        return false;
    }

    public <T> boolean addToList(T ingredient, boolean addToFront) {
        if (addToFront) {
            this.list.add(0, ingredient);
        } else {
            this.list.add(ingredient);
        }
        return true;
    }

    @Override
    public List<?> getIngredientList(String filterText) {
        return this.list;
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public void addListener(IIngredientGridSource.Listener listener) {
        this.listeners.add(listener);
    }

    public void notifyListenersOfChange() {
        for (IIngredientGridSource.Listener listener : this.listeners) {
            listener.onChange();
        }
    }
}

