/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.entity;

import com.teammetallurgy.aquaculture.entity.FishType;
import com.teammetallurgy.aquaculture.entity.ai.goal.FollowTypeSchoolLeaderGoal;
import com.teammetallurgy.aquaculture.init.AquaItems;
import com.teammetallurgy.aquaculture.init.AquaSounds;
import java.util.HashMap;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.FollowFlockLeaderGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;

public class AquaFishEntity
extends AbstractSchoolingFish {
    public static HashMap<EntityType<AquaFishEntity>, Item> BUCKETS = new HashMap();
    public static HashMap<EntityType<AquaFishEntity>, FishType> TYPES = new HashMap();

    public AquaFishEntity(EntityType<? extends AbstractSchoolingFish> entityType, Level world) {
        super(entityType, world);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.f_25345_.forEach(prioritizedGoal -> {
            if (prioritizedGoal.m_26015_().getClass() == FollowFlockLeaderGoal.class) {
                this.f_21345_.m_25363_(prioritizedGoal.m_26015_());
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new FollowTypeSchoolLeaderGoal(this));
    }

    public ItemStack getPickedResult(HitResult target) {
        return this.m_142563_();
    }

    @Nonnull
    public ItemStack m_142563_() {
        return new ItemStack((ItemLike)BUCKETS.get(this.m_6095_()));
    }

    @Nonnull
    protected SoundEvent m_5699_() {
        if (TYPES.get(this.m_6095_()) == FishType.JELLYFISH) {
            return AquaSounds.JELLYFISH_FLOP;
        }
        return AquaSounds.FISH_FLOP;
    }

    protected SoundEvent m_7515_() {
        return AquaSounds.FISH_AMBIENT;
    }

    protected SoundEvent m_5592_() {
        return AquaSounds.FISH_DEATH;
    }

    protected SoundEvent m_7975_(@Nonnull DamageSource damageSource) {
        return AquaSounds.FISH_HURT;
    }

    @Nonnull
    public EntityDimensions m_6972_(@Nonnull Pose pose) {
        return super.m_6972_(pose);
    }

    public void m_6123_(@Nonnull Player player) {
        super.m_6123_(player);
        if (Objects.equals(this.m_6095_().getRegistryName(), ((Item)AquaItems.JELLYFISH.get()).getRegistryName()) && this.m_6084_() && this.m_20280_((Entity)player) < 1.0 && player.m_6469_(DamageSource.m_19370_((LivingEntity)this), 0.5f)) {
            this.m_5496_(AquaSounds.JELLYFISH_COLLIDE, 0.5f, (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.0f);
            this.m_19970_((LivingEntity)this, (Entity)player);
        }
    }

    public void m_27541_() {
        if (this.f_27520_ != null) {
            super.m_27541_();
        }
    }

    public static boolean canSpawnHere(EntityType<? extends AbstractFish> fish, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, Random random) {
        int seaLevel = world.m_5736_();
        int minY = seaLevel - 13;
        boolean isAllNeighborsSource = AquaFishEntity.isSourceBlock(world, pos.m_142127_()) && AquaFishEntity.isSourceBlock(world, pos.m_142128_()) && AquaFishEntity.isSourceBlock(world, pos.m_142125_()) && AquaFishEntity.isSourceBlock(world, pos.m_142126_());
        return AquaFishEntity.isSourceBlock(world, pos) && isAllNeighborsSource && pos.m_123342_() >= minY && pos.m_123342_() <= seaLevel;
    }

    private static boolean isSourceBlock(LevelAccessor world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return state.m_60734_() instanceof LiquidBlock && world.m_8055_(pos).m_60713_(Blocks.f_49990_) && (Integer)state.m_61143_((Property)LiquidBlock.f_54688_) == 0;
    }
}

