/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.source.span;

import com.jozufozu.flywheel.core.source.SourceFile;
import com.jozufozu.flywheel.core.source.span.CharPos;
import com.jozufozu.flywheel.core.source.span.StringSpan;
import java.util.regex.Matcher;

public abstract class Span
implements CharSequence {
    protected final SourceFile in;
    protected final CharPos start;
    protected final CharPos end;

    public Span(SourceFile in, int start, int end) {
        this(in, in.lines.getCharPos(start), in.lines.getCharPos(end));
    }

    public Span(SourceFile in, CharPos start, CharPos end) {
        this.in = in;
        this.start = start;
        this.end = end;
    }

    public SourceFile getSourceFile() {
        return this.in;
    }

    public CharPos getStart() {
        return this.start;
    }

    public CharPos getEnd() {
        return this.end;
    }

    public int getStartPos() {
        return this.start.pos();
    }

    public int getEndPos() {
        return this.end.pos();
    }

    @Override
    public boolean isEmpty() {
        return this.start == this.end;
    }

    public int lines() {
        return this.end.line() - this.start.line() + 1;
    }

    public int firstLine() {
        return this.start.line();
    }

    public abstract Span subSpan(int var1, int var2);

    public abstract String get();

    public abstract boolean isErr();

    @Override
    public int length() {
        return this.getEndPos() - this.getStartPos();
    }

    @Override
    public char charAt(int index) {
        return this.in.source.charAt(this.start.pos() + index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.subSpan(start, end);
    }

    @Override
    public String toString() {
        return this.get();
    }

    public static Span fromMatcher(SourceFile src, Matcher m, int group) {
        return new StringSpan(src, m.start(group), m.end(group));
    }

    public static Span fromMatcher(Span superSpan, Matcher m, int group) {
        return superSpan.subSpan(m.start(group), m.end(group));
    }

    public static Span fromMatcher(SourceFile src, Matcher m) {
        return new StringSpan(src, m.start(), m.end());
    }

    public static Span fromMatcher(Span superSpan, Matcher m) {
        return superSpan.subSpan(m.start(), m.end());
    }
}

