/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.instancing.instancing;

import com.jozufozu.flywheel.Flywheel;
import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.struct.Instanced;
import com.jozufozu.flywheel.api.struct.StructWriter;
import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.gl.GlVertexArray;
import com.jozufozu.flywheel.backend.gl.buffer.GlBuffer;
import com.jozufozu.flywheel.backend.gl.buffer.GlBufferType;
import com.jozufozu.flywheel.backend.gl.buffer.MappedBuffer;
import com.jozufozu.flywheel.backend.instancing.AbstractInstancer;
import com.jozufozu.flywheel.backend.model.BufferedModel;
import com.jozufozu.flywheel.backend.model.ModelAllocator;
import com.jozufozu.flywheel.core.layout.BufferLayout;
import com.jozufozu.flywheel.core.model.Model;
import java.nio.ByteBuffer;
import org.lwjgl.system.MemoryUtil;

public class GPUInstancer<D extends InstanceData>
extends AbstractInstancer<D> {
    private final ModelAllocator modelAllocator;
    private final BufferLayout instanceFormat;
    private final Instanced<D> instancedType;
    private BufferedModel model;
    private GlVertexArray vao;
    private GlBuffer instanceVBO;
    private int glInstanceCount = 0;
    private boolean deleted;
    private boolean initialized;
    protected boolean anyToUpdate;

    public GPUInstancer(Instanced<D> type, Model model, ModelAllocator modelAllocator) {
        super(type::create, model);
        this.modelAllocator = modelAllocator;
        this.instanceFormat = type.getLayout();
        this.instancedType = type;
    }

    @Override
    public void notifyDirty() {
        this.anyToUpdate = true;
    }

    public void render() {
        if (this.invalid()) {
            return;
        }
        this.vao.bind();
        this.renderSetup();
        if (this.glInstanceCount > 0) {
            this.model.drawInstances(this.glInstanceCount);
        }
        this.instanceVBO.doneForThisFrame();
    }

    private boolean invalid() {
        return this.deleted || this.model == null;
    }

    public void init() {
        if (this.isInitialized()) {
            return;
        }
        this.initialized = true;
        this.vao = new GlVertexArray();
        this.model = this.modelAllocator.alloc(this.modelData, arenaModel -> {
            this.vao.bind();
            arenaModel.setupState(this.vao);
        });
        this.vao.bind();
        this.vao.enableArrays(this.model.getAttributeCount() + this.instanceFormat.getAttributeCount());
        this.instanceVBO = GlBuffer.requestPersistent(GlBufferType.ARRAY_BUFFER);
        this.instanceVBO.setGrowthMargin(this.instanceFormat.getStride() * 16);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isEmpty() {
        return !this.anyToUpdate && !this.anyToRemove && this.glInstanceCount == 0;
    }

    public void delete() {
        if (this.invalid()) {
            return;
        }
        this.deleted = true;
        this.model.delete();
        this.instanceVBO.delete();
        this.vao.delete();
    }

    protected void renderSetup() {
        if (this.anyToRemove) {
            this.removeDeletedInstances();
        }
        this.instanceVBO.bind();
        if (!this.realloc()) {
            if (this.anyToRemove) {
                this.clearBufferTail();
            }
            if (this.anyToUpdate) {
                this.updateBuffer();
            }
            this.glInstanceCount = this.data.size();
        }
        this.instanceVBO.unbind();
        this.anyToUpdate = false;
        this.anyToRemove = false;
    }

    private void clearBufferTail() {
        int size = this.data.size();
        int offset = size * this.instanceFormat.getStride();
        long length = this.instanceVBO.getCapacity() - (long)offset;
        if (length > 0L) {
            try (MappedBuffer buf = this.instanceVBO.getBuffer(offset, length);){
                MemoryUtil.memSet((long)MemoryUtil.memAddress((ByteBuffer)buf.unwrap()), (int)0, (long)length);
            }
            catch (Exception e) {
                Flywheel.LOGGER.error("Error clearing buffer tail:", (Throwable)e);
            }
        }
    }

    private void updateBuffer() {
        int size = this.data.size();
        if (size <= 0) {
            return;
        }
        try (MappedBuffer mapped = this.instanceVBO.getBuffer();){
            StructWriter<D> writer = this.instancedType.getWriter(mapped);
            boolean sequential = true;
            for (int i = 0; i < size; ++i) {
                InstanceData element = (InstanceData)this.data.get(i);
                if (element.checkDirtyAndClear()) {
                    if (!sequential) {
                        writer.seek(i);
                    }
                    writer.write(element);
                    sequential = true;
                    continue;
                }
                sequential = false;
            }
        }
        catch (Exception e) {
            Flywheel.LOGGER.error("Error updating GPUInstancer:", (Throwable)e);
        }
    }

    private boolean realloc() {
        int stride;
        int size = this.data.size();
        int requiredSize = size * (stride = this.instanceFormat.getStride());
        if (this.instanceVBO.ensureCapacity(requiredSize)) {
            try (MappedBuffer buffer = this.instanceVBO.getBuffer();){
                StructWriter<D> writer = this.instancedType.getWriter(buffer);
                for (InstanceData datum : this.data) {
                    writer.write(datum);
                }
            }
            catch (Exception e) {
                Flywheel.LOGGER.error("Error reallocating GPUInstancer:", (Throwable)e);
            }
            this.glInstanceCount = size;
            this.bindInstanceAttributes();
            return true;
        }
        return false;
    }

    private void bindInstanceAttributes() {
        int attributeBaseIndex = this.model.getAttributeCount();
        this.vao.bindAttributes(attributeBaseIndex, this.instanceFormat);
        for (int i = 0; i < this.instanceFormat.getAttributeCount(); ++i) {
            Backend.compat.instancedArrays.vertexAttribDivisor(attributeBaseIndex + i, 1);
        }
    }
}

