/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.instancing;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.api.instance.Instance;
import com.jozufozu.flywheel.api.instance.TickableInstance;
import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.instancing.AbstractInstance;
import com.jozufozu.flywheel.backend.instancing.TaskEngine;
import com.jozufozu.flywheel.backend.instancing.instancing.InstancingEngine;
import com.jozufozu.flywheel.light.LightUpdater;
import com.mojang.math.Vector3f;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;

public abstract class InstanceManager<T>
implements InstancingEngine.OriginShiftListener {
    public final MaterialManager materialManager;
    private final Set<T> queuedAdditions;
    private final Set<T> queuedUpdates;
    protected final Map<T, AbstractInstance> instances;
    protected final Object2ObjectOpenHashMap<T, TickableInstance> tickableInstances;
    protected final Object2ObjectOpenHashMap<T, DynamicInstance> dynamicInstances;
    protected int frame;
    protected int tick;
    private static final int[] divisorSequence = new int[]{1, 2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31};

    public InstanceManager(MaterialManager materialManager) {
        this.materialManager = materialManager;
        this.queuedUpdates = new HashSet<T>(64);
        this.queuedAdditions = new HashSet<T>(64);
        this.instances = new HashMap<T, AbstractInstance>();
        this.dynamicInstances = new Object2ObjectOpenHashMap();
        this.tickableInstances = new Object2ObjectOpenHashMap();
    }

    protected abstract boolean canInstance(T var1);

    protected abstract boolean canCreateInstance(T var1);

    @Nullable
    protected abstract AbstractInstance createRaw(T var1);

    public void tick(TaskEngine taskEngine, double cameraX, double cameraY, double cameraZ) {
        ++this.tick;
        this.processQueuedUpdates();
        int cX = (int)cameraX;
        int cY = (int)cameraY;
        int cZ = (int)cameraZ;
        ArrayList instances = new ArrayList(this.tickableInstances.values());
        int incr = 500;
        int size = instances.size();
        for (int start = 0; start < size; start += incr) {
            int end = Math.min(start + incr, size);
            List sub = instances.subList(start, end);
            taskEngine.submit(() -> {
                for (TickableInstance instance : sub) {
                    this.tickInstance(cX, cY, cZ, instance);
                }
            });
        }
    }

    private void tickInstance(int cX, int cY, int cZ, TickableInstance instance) {
        int dZ;
        int dY;
        if (!instance.decreaseTickRateWithDistance()) {
            instance.tick();
            return;
        }
        BlockPos pos = instance.getWorldPosition();
        int dX = pos.m_123341_() - cX;
        if (this.tick % this.getUpdateDivisor(dX, dY = pos.m_123342_() - cY, dZ = pos.m_123343_() - cZ) == 0) {
            instance.tick();
        }
    }

    public void beginFrame(TaskEngine taskEngine, Camera info) {
        ++this.frame;
        this.processQueuedAdditions();
        Vector3f look = info.m_90596_();
        float lookX = look.m_122239_();
        float lookY = look.m_122260_();
        float lookZ = look.m_122269_();
        int cX = (int)info.m_90583_().f_82479_;
        int cY = (int)info.m_90583_().f_82480_;
        int cZ = (int)info.m_90583_().f_82481_;
        ArrayList instances = new ArrayList(this.dynamicInstances.values());
        int incr = 500;
        int size = instances.size();
        for (int start = 0; start < size; start += incr) {
            int end = Math.min(start + incr, size);
            List sub = instances.subList(start, end);
            taskEngine.submit(() -> {
                for (DynamicInstance dyn : sub) {
                    if (dyn.decreaseFramerateWithDistance() && !this.shouldFrameUpdate(dyn.getWorldPosition(), lookX, lookY, lookZ, cX, cY, cZ)) continue;
                    dyn.beginFrame();
                }
            });
        }
    }

    public void add(T obj) {
        if (!Backend.isOn()) {
            return;
        }
        if (this.canInstance(obj)) {
            this.addInternal(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueAdd(T obj) {
        if (!Backend.isOn()) {
            return;
        }
        Set<T> set = this.queuedAdditions;
        synchronized (set) {
            this.queuedAdditions.add(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueUpdate(T obj) {
        if (!Backend.isOn()) {
            return;
        }
        Set<T> set = this.queuedUpdates;
        synchronized (set) {
            this.queuedUpdates.add(obj);
        }
    }

    public void update(T obj) {
        AbstractInstance instance;
        if (!Backend.isOn()) {
            return;
        }
        if (this.canInstance(obj) && (instance = this.getInstance(obj)) != null) {
            if (instance.shouldReset()) {
                this.removeInternal(obj, instance);
                this.createInternal(obj);
            } else {
                instance.update();
            }
        }
    }

    public void remove(T obj) {
        AbstractInstance instance;
        if (!Backend.isOn()) {
            return;
        }
        if (this.canInstance(obj) && (instance = this.getInstance(obj)) != null) {
            this.removeInternal(obj, instance);
        }
    }

    public void invalidate() {
        this.instances.values().forEach(AbstractInstance::remove);
        this.instances.clear();
        this.dynamicInstances.clear();
        this.tickableInstances.clear();
    }

    @Nullable
    protected <I extends T> AbstractInstance getInstance(I obj) {
        if (!Backend.isOn()) {
            return null;
        }
        return this.instances.get(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processQueuedAdditions() {
        ArrayList<T> queued;
        if (this.queuedAdditions.isEmpty()) {
            return;
        }
        Set<T> set = this.queuedAdditions;
        synchronized (set) {
            queued = new ArrayList<T>(this.queuedAdditions);
            this.queuedAdditions.clear();
        }
        if (!queued.isEmpty()) {
            queued.forEach(this::addInternal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processQueuedUpdates() {
        ArrayList<T> queued;
        Set<T> set = this.queuedUpdates;
        synchronized (set) {
            queued = new ArrayList<T>(this.queuedUpdates);
            this.queuedUpdates.clear();
        }
        if (queued.size() > 0) {
            queued.forEach(this::update);
        }
    }

    protected boolean shouldFrameUpdate(BlockPos worldPos, float lookX, float lookY, float lookZ, int cX, int cY, int cZ) {
        int dZ;
        int dY;
        int dist;
        int dX = worldPos.m_123341_() - cX;
        float dot = ((float)dX + lookX * (float)(dist = 2)) * lookX + ((float)(dY = worldPos.m_123342_() - cY) + lookY * (float)dist) * lookY + ((float)(dZ = worldPos.m_123343_() - cZ) + lookZ * (float)dist) * lookZ;
        if (dot < 0.0f) {
            return false;
        }
        return this.frame % this.getUpdateDivisor(dX, dY, dZ) == 0;
    }

    protected int getUpdateDivisor(int dX, int dY, int dZ) {
        int dSq = dX * dX + dY * dY + dZ * dZ;
        int i = dSq / 2048;
        return divisorSequence[Mth.m_14045_((int)i, (int)0, (int)(divisorSequence.length - 1))];
    }

    protected void addInternal(T obj) {
        if (!Backend.isOn()) {
            return;
        }
        AbstractInstance instance = this.instances.get(obj);
        if (instance == null && this.canCreateInstance(obj)) {
            this.createInternal(obj);
        }
    }

    protected void removeInternal(T obj, AbstractInstance instance) {
        instance.remove();
        this.instances.remove(obj);
        this.dynamicInstances.remove(obj);
        this.tickableInstances.remove(obj);
        LightUpdater.get((BlockAndTintGetter)instance.world).removeListener(instance);
    }

    @Nullable
    protected AbstractInstance createInternal(T obj) {
        AbstractInstance renderer = this.createRaw(obj);
        if (renderer != null) {
            Instance r;
            renderer.init();
            renderer.updateLight();
            LightUpdater.get((BlockAndTintGetter)renderer.world).addListener(renderer);
            this.instances.put(obj, renderer);
            if (renderer instanceof TickableInstance) {
                r = (TickableInstance)((Object)renderer);
                this.tickableInstances.put(obj, (Object)r);
                r.tick();
            }
            if (renderer instanceof DynamicInstance) {
                r = (DynamicInstance)((Object)renderer);
                this.dynamicInstances.put(obj, (Object)r);
                r.beginFrame();
            }
        }
        return renderer;
    }

    @Override
    public void onOriginShift() {
        ArrayList<T> instanced = new ArrayList<T>(this.instances.keySet());
        this.invalidate();
        instanced.forEach(this::add);
    }

    public void detachLightListeners() {
        for (AbstractInstance value : this.instances.values()) {
            LightUpdater.get((BlockAndTintGetter)value.world).removeListener(value);
        }
    }
}

