/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend;

import com.jozufozu.flywheel.api.FlywheelWorld;
import com.jozufozu.flywheel.backend.Loader;
import com.jozufozu.flywheel.backend.OptifineHandler;
import com.jozufozu.flywheel.backend.RenderWork;
import com.jozufozu.flywheel.backend.gl.versioned.GlCompat;
import com.jozufozu.flywheel.config.FlwConfig;
import com.jozufozu.flywheel.config.FlwEngine;
import com.jozufozu.flywheel.core.shader.ProgramSpec;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Backend {
    public static final Logger LOGGER = LogManager.getLogger(Backend.class);
    private static FlwEngine engine;
    public static GlCompat compat;
    private static final Loader loader;

    public static String getBackendDescriptor() {
        return engine == null ? "" : engine.getProperName();
    }

    public static FlwEngine getEngine() {
        return engine;
    }

    @Nullable
    public static ProgramSpec getSpec(ResourceLocation name) {
        return loader.get(name);
    }

    public static void refresh() {
        OptifineHandler.refresh();
        compat = new GlCompat();
        engine = Backend.chooseEngine(compat);
    }

    public static boolean isOn() {
        return engine != FlwEngine.OFF;
    }

    public static boolean canUseInstancing(@Nullable Level world) {
        return Backend.isOn() && Backend.isFlywheelWorld((LevelAccessor)world);
    }

    public static boolean isFlywheelWorld(@Nullable LevelAccessor world) {
        if (world == null) {
            return false;
        }
        if (!world.m_5776_()) {
            return false;
        }
        if (world instanceof FlywheelWorld && ((FlywheelWorld)world).supportsFlywheel()) {
            return true;
        }
        return world == Minecraft.m_91087_().f_91073_;
    }

    public static boolean isGameActive() {
        return Minecraft.m_91087_().f_91073_ != null && Minecraft.m_91087_().f_91074_ != null;
    }

    public static void reloadWorldRenderers() {
        RenderWork.enqueue(() -> ((LevelRenderer)Minecraft.m_91087_().f_91060_).m_109818_());
    }

    private static FlwEngine chooseEngine(GlCompat compat) {
        FlwEngine preferredChoice = FlwConfig.get().getEngine();
        boolean usingShaders = OptifineHandler.usingShaders();
        boolean canUseEngine = switch (preferredChoice) {
            default -> throw new IncompatibleClassChangeError();
            case FlwEngine.OFF -> true;
            case FlwEngine.BATCHING -> {
                if (!usingShaders) {
                    yield true;
                }
                yield false;
            }
            case FlwEngine.INSTANCING -> !usingShaders && compat.instancedArraysSupported();
        };
        return canUseEngine ? preferredChoice : FlwEngine.OFF;
    }

    public static void init() {
    }

    private Backend() {
        throw new UnsupportedOperationException("Backend is a static class!");
    }

    static {
        loader = new Loader();
    }
}

