/*
 * Decompiled with CFR 0.152.
 */
package jeresources.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import jeresources.api.drop.LootDrop;
import jeresources.compatibility.CompatBase;
import jeresources.config.ConfigValues;
import jeresources.util.MobTableBuilder;
import jeresources.util.ReflectionHelper;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.VanillaPackResources;
import net.minecraft.server.packs.repository.ServerPacksSource;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.SimpleReloadableResourceManager;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.PredicateManager;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.resource.PathResourcePack;

public class LootTableHelper {
    private static final Map<DyeColor, ResourceLocation> sheepColors = new HashMap<DyeColor, ResourceLocation>();
    private static LootTables lootTables;

    public static List<LootPool> getPools(LootTable table) {
        return (List)ReflectionHelper.getPrivateValue(LootTable.class, (Object)table, (String)"f_79109_");
    }

    public static List<LootPoolEntryContainer> getLootEntries(LootPool pool) {
        return ReflectionHelper.getPrivateArrayValueAsList(LootPool.class, pool, "f_79023_");
    }

    public static List<LootItemCondition> getLootConditions(LootPool pool) {
        return ReflectionHelper.getPrivateArrayValueAsList(LootPool.class, pool, "f_79024_");
    }

    public static List<LootDrop> toDrops(LootTable table) {
        ArrayList<LootDrop> drops = new ArrayList<LootDrop>();
        LootTables lootTables = LootTableHelper.getLootTables();
        LootTableHelper.getPools(table).forEach(pool -> {
            float totalWeight = LootTableHelper.getLootEntries(pool).stream().filter(entry -> entry instanceof LootPoolSingletonContainer).map(entry -> (LootPoolSingletonContainer)entry).mapToInt(entry -> entry.f_79675_).sum();
            List<LootItemCondition> poolConditions = LootTableHelper.getLootConditions(pool);
            LootTableHelper.getLootEntries(pool).stream().filter(entry -> entry instanceof LootItem).map(entry -> (LootItem)entry).map(entry -> new LootDrop(entry.f_79564_, (float)entry.f_79675_ / totalWeight, entry.f_79636_, entry.f_79677_)).map(drop -> drop.addLootConditions(poolConditions)).forEach(drops::add);
            LootTableHelper.getLootEntries(pool).stream().filter(entry -> entry instanceof LootTableReference).map(entry -> (LootTableReference)entry).map(entry -> LootTableHelper.toDrops(lootTables.m_79217_(entry.f_79754_))).forEach(drops::addAll);
        });
        drops.removeIf(Objects::isNull);
        return drops;
    }

    public static List<LootDrop> toDrops(Level level, ResourceLocation lootTable) {
        return LootTableHelper.toDrops(LootTableHelper.getLootTables(level).m_79217_(lootTable));
    }

    public static List<ResourceLocation> getAllChestLootTablesResourceLocations() {
        ArrayList<ResourceLocation> chestTables = new ArrayList<ResourceLocation>();
        chestTables.add(BuiltInLootTables.f_78741_);
        chestTables.add(BuiltInLootTables.f_78742_);
        chestTables.add(BuiltInLootTables.f_78743_);
        chestTables.add(BuiltInLootTables.f_78744_);
        chestTables.add(BuiltInLootTables.f_78745_);
        chestTables.add(BuiltInLootTables.f_78746_);
        chestTables.add(BuiltInLootTables.f_78747_);
        chestTables.add(BuiltInLootTables.f_78748_);
        chestTables.add(BuiltInLootTables.f_78749_);
        chestTables.add(BuiltInLootTables.f_78750_);
        chestTables.add(BuiltInLootTables.f_78751_);
        chestTables.add(BuiltInLootTables.f_78752_);
        chestTables.add(BuiltInLootTables.f_78753_);
        chestTables.add(BuiltInLootTables.f_78754_);
        chestTables.add(BuiltInLootTables.f_78755_);
        chestTables.add(BuiltInLootTables.f_78756_);
        chestTables.add(BuiltInLootTables.f_78757_);
        chestTables.add(BuiltInLootTables.f_78758_);
        chestTables.add(BuiltInLootTables.f_78759_);
        chestTables.add(BuiltInLootTables.f_78760_);
        chestTables.add(BuiltInLootTables.f_78761_);
        chestTables.add(BuiltInLootTables.f_78762_);
        chestTables.add(BuiltInLootTables.f_78763_);
        chestTables.add(BuiltInLootTables.f_78764_);
        chestTables.add(BuiltInLootTables.f_78686_);
        chestTables.add(BuiltInLootTables.f_78688_);
        chestTables.add(BuiltInLootTables.f_78689_);
        chestTables.add(BuiltInLootTables.f_78690_);
        chestTables.add(BuiltInLootTables.f_78691_);
        chestTables.add(BuiltInLootTables.f_78692_);
        chestTables.add(BuiltInLootTables.f_78693_);
        chestTables.add(BuiltInLootTables.f_78694_);
        chestTables.add(BuiltInLootTables.f_78695_);
        chestTables.add(BuiltInLootTables.f_78696_);
        chestTables.add(BuiltInLootTables.f_78697_);
        chestTables.add(BuiltInLootTables.f_78698_);
        chestTables.add(BuiltInLootTables.f_78699_);
        chestTables.add(BuiltInLootTables.f_78700_);
        chestTables.add(BuiltInLootTables.f_78701_);
        return chestTables;
    }

    public static Map<ResourceLocation, LivingEntity> getAllMobLootTables(Level world) {
        MobTableBuilder mobTableBuilder = new MobTableBuilder(world);
        for (Map.Entry<DyeColor, ResourceLocation> entry : sheepColors.entrySet()) {
            ResourceLocation lootTableList = entry.getValue();
            DyeColor dyeColor = entry.getKey();
            mobTableBuilder.addSheep(lootTableList, (EntityType<Sheep>)EntityType.f_20520_, dyeColor);
        }
        for (EntityType entityType : ForgeRegistries.ENTITIES) {
            if (entityType.m_20674_() == MobCategory.MISC || entityType == EntityType.f_20520_) continue;
            mobTableBuilder.add(entityType.m_20677_(), entityType);
        }
        return mobTableBuilder.getMobTables();
    }

    public static LootTables getLootTables(@Nullable Level level) {
        if (level == null || level.m_142572_() == null) {
            if (lootTables == null) {
                lootTables = new LootTables(new PredicateManager());
                if (((Boolean)ConfigValues.disableLootManagerReloading.get()).booleanValue()) {
                    return lootTables;
                }
                SimpleReloadableResourceManager serverResourceManger = new SimpleReloadableResourceManager(PackType.SERVER_DATA);
                LinkedList<Object> packs = new LinkedList<Object>();
                packs.add(new VanillaPackResources(ServerPacksSource.f_143904_, new String[]{"minecraft"}));
                for (IModFileInfo mod : ModList.get().getModFiles()) {
                    packs.add(new PathResourcePack(mod.getFile().getFileName(), mod.getFile().getFilePath()));
                }
                packs.forEach(arg_0 -> ((SimpleReloadableResourceManager)serverResourceManger).m_10880_(arg_0));
                serverResourceManger.m_7217_((PreparableReloadListener)lootTables);
                CompletableFuture completableFuture = serverResourceManger.m_10715_((Executor)Util.m_183991_(), (Executor)Minecraft.m_91087_(), packs, CompletableFuture.completedFuture(Unit.INSTANCE));
                Minecraft.m_91087_().m_18701_(completableFuture::isDone);
            }
            return lootTables;
        }
        return level.m_142572_().m_129898_();
    }

    public static LootTables getLootTables() {
        return LootTableHelper.getLootTables(CompatBase.getLevel());
    }

    static {
        sheepColors.put(DyeColor.WHITE, BuiltInLootTables.f_78702_);
        sheepColors.put(DyeColor.ORANGE, BuiltInLootTables.f_78703_);
        sheepColors.put(DyeColor.MAGENTA, BuiltInLootTables.f_78704_);
        sheepColors.put(DyeColor.LIGHT_BLUE, BuiltInLootTables.f_78705_);
        sheepColors.put(DyeColor.YELLOW, BuiltInLootTables.f_78706_);
        sheepColors.put(DyeColor.LIME, BuiltInLootTables.f_78707_);
        sheepColors.put(DyeColor.PINK, BuiltInLootTables.f_78708_);
        sheepColors.put(DyeColor.GRAY, BuiltInLootTables.f_78709_);
        sheepColors.put(DyeColor.LIGHT_GRAY, BuiltInLootTables.f_78710_);
        sheepColors.put(DyeColor.CYAN, BuiltInLootTables.f_78711_);
        sheepColors.put(DyeColor.PURPLE, BuiltInLootTables.f_78714_);
        sheepColors.put(DyeColor.BLUE, BuiltInLootTables.f_78715_);
        sheepColors.put(DyeColor.BROWN, BuiltInLootTables.f_78716_);
        sheepColors.put(DyeColor.GREEN, BuiltInLootTables.f_78717_);
        sheepColors.put(DyeColor.RED, BuiltInLootTables.f_78718_);
        sheepColors.put(DyeColor.BLACK, BuiltInLootTables.f_78719_);
    }
}

