/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei.worldgen;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import jeresources.jei.BlankJEIRecipeCategory;
import jeresources.jei.JEIConfig;
import jeresources.jei.worldgen.WorldGenWrapper;
import jeresources.reference.Resources;
import jeresources.util.RenderHelper;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class WorldGenCategory
extends BlankJEIRecipeCategory<WorldGenWrapper> {
    protected static final int X_ITEM = 5;
    protected static final int Y_ITEM = 21;
    protected static final int X_DROP_ITEM = 5;
    protected static final int Y_DROP_ITEM = 66;
    private static final int DROP_ITEM_COUNT = 8;

    public WorldGenCategory() {
        super((IDrawable)JEIConfig.getJeiHelpers().getGuiHelper().createDrawable(Resources.Gui.Jei.TABS, 32, 16, 16, 16));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return JEIConfig.WORLD_GEN;
    }

    @Nonnull
    public Component getTitle() {
        return new TranslatableComponent("jer.worldgen.title");
    }

    @Nonnull
    public IDrawable getBackground() {
        return Resources.Gui.Jei.WORLD_GEN;
    }

    public Class<? extends WorldGenWrapper> getRecipeClass() {
        return WorldGenWrapper.class;
    }

    @Override
    public void draw(WorldGenWrapper recipe, PoseStack poseStack, double mouseX, double mouseY) {
        RenderHelper.drawLine(poseStack, 29, 52, 157, 52, -7829368);
        RenderHelper.drawLine(poseStack, 29, 52, 29, 12, -7829368);
        super.draw(recipe, poseStack, mouseX, mouseY);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull WorldGenWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        int i;
        recipeLayout.getItemStacks().init(0, false, 5, 21);
        for (i = 0; i < 8; ++i) {
            recipeLayout.getItemStacks().init(i + 1, false, 5 + i * 18, 66);
        }
        recipeLayout.getItemStacks().addTooltipCallback((ITooltipCallback)recipeWrapper);
        recipeLayout.getItemStacks().set(0, recipeWrapper.getBlock());
        for (i = 0; i < Math.min(8, recipeWrapper.getDrops().size()); ++i) {
            recipeLayout.getItemStacks().set(i + 1, recipeWrapper.getDrops().get(i));
        }
    }
}

