/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei.mob;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import jeresources.api.drop.LootDrop;
import jeresources.config.Settings;
import jeresources.entry.MobEntry;
import jeresources.util.CollectionHelper;
import jeresources.util.Font;
import jeresources.util.RenderHelper;
import jeresources.util.TranslationHelper;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.item.ItemStack;

public class MobWrapper
implements IRecipeCategoryExtension,
ITooltipCallback<ItemStack> {
    private final MobEntry mob;
    private float scale;
    private int offsetY;

    public MobWrapper(MobEntry mob) {
        this.mob = mob;
        this.scale = this.getScale(mob.getEntity());
        this.offsetY = this.getOffsetY(mob.getEntity());
    }

    public void setIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setOutputs(VanillaTypes.ITEM, this.mob.getDropsItemStacks());
    }

    public LootDrop[] getDrops() {
        return this.mob.getDrops();
    }

    public void drawInfo(int recipeWidth, int recipeHeight, PoseStack poseStack, double mouseX, double mouseY) {
        String entityString;
        LivingEntity LivingEntity2 = this.mob.getEntity();
        RenderHelper.scissor(poseStack, 7, 43, 59, 79);
        this.scale = this.getScale(this.mob.getEntity());
        this.offsetY = this.getOffsetY(this.mob.getEntity());
        RenderHelper.renderEntity(poseStack, 37, 105 - this.offsetY, this.scale, 38.0 - mouseX, (double)(70 - this.offsetY) - mouseY, LivingEntity2);
        RenderHelper.stopScissor();
        Object mobName = this.mob.getMobName();
        if (Settings.showDevData && (entityString = LivingEntity2.m_20149_()) != null) {
            mobName = (String)mobName + " (" + entityString + ")";
        }
        Font.normal.print(poseStack, (String)mobName, 7, 2);
        Font.normal.print(poseStack, (String)(this.mob.getBiomes().length > 1 ? TranslationHelper.translateAndFormat("jer.mob.biome", new Object[0]) : TranslationHelper.translateAndFormat("jer.mob.spawn", new Object[0]) + " " + this.mob.getBiomes()[0]), 7, 12);
        Font.normal.print(poseStack, this.mob.getLightLevel().toString(), 7, 22);
        Font.normal.print(poseStack, TranslationHelper.translateAndFormat("jer.mob.exp", new Object[0]) + ": " + this.mob.getExp(), 7, 32);
    }

    public List<Component> getTooltipStrings(double mouseX, double mouseY) {
        if (this.mob.getBiomes().length > 1 && this.isOnBiome(mouseX, mouseY)) {
            return CollectionHelper.create(TextComponent::new, this.mob.getBiomes());
        }
        return Collections.emptyList();
    }

    public void onTooltip(int slotIndex, boolean input, ItemStack ingredient, List<Component> tooltip) {
        tooltip.add((Component)this.mob.getDrops()[slotIndex].toStringTextComponent());
        List<Component> list = this.getToolTip(ingredient);
        if (list != null) {
            tooltip.addAll(list);
        }
    }

    public LivingEntity getMob() {
        return this.mob.getEntity();
    }

    public List<Component> getToolTip(ItemStack stack) {
        for (LootDrop item : this.mob.getDrops()) {
            if (stack.m_41656_(item.item)) {
                return item.getTooltipText();
            }
            if (!item.canBeCooked() || !stack.m_41656_(item.smeltedItem)) continue;
            return item.getTooltipText(true);
        }
        return null;
    }

    private boolean isOnBiome(double mouseX, double mouseY) {
        return 2.0 <= mouseX && mouseX < 165.0 && 12.0 <= mouseY && mouseY < 22.0;
    }

    private float getScale(LivingEntity LivingEntity2) {
        float height;
        float width = LivingEntity2.m_20205_();
        if (width <= (height = LivingEntity2.m_20206_())) {
            if ((double)height < 0.9) {
                return 50.0f;
            }
            if (height < 1.0f) {
                return 35.0f;
            }
            if ((double)height < 1.8) {
                return 33.0f;
            }
            if (height < 2.0f) {
                return 32.0f;
            }
            if (height < 3.0f) {
                return 24.0f;
            }
            if (height < 4.0f) {
                return 20.0f;
            }
            return 10.0f;
        }
        if (width < 1.0f) {
            return 38.0f;
        }
        if (width < 2.0f) {
            return 27.0f;
        }
        if (width < 3.0f) {
            return 13.0f;
        }
        return 9.0f;
    }

    private int getOffsetY(LivingEntity livingEntity) {
        int offsetY = 0;
        if (livingEntity instanceof Squid) {
            offsetY = 20;
        } else if (livingEntity instanceof Turtle) {
            offsetY = 10;
        } else if (livingEntity instanceof Witch) {
            offsetY = -5;
        } else if (livingEntity instanceof Ghast) {
            offsetY = 15;
        } else if (livingEntity instanceof WitherBoss) {
            offsetY = -15;
        } else if (livingEntity instanceof EnderDragon) {
            offsetY = 15;
        } else if (livingEntity instanceof EnderMan) {
            offsetY = -10;
        } else if (livingEntity instanceof AbstractGolem) {
            offsetY = -10;
        } else if (livingEntity instanceof Animal) {
            offsetY = -20;
        } else if (livingEntity instanceof Villager) {
            offsetY = -15;
        } else if (livingEntity instanceof Husk) {
            offsetY = -15;
        } else if (livingEntity instanceof AbstractIllager) {
            offsetY = -15;
        } else if (livingEntity instanceof WanderingTrader) {
            offsetY = -15;
        } else if (livingEntity instanceof Blaze) {
            offsetY = -10;
        } else if (livingEntity instanceof Creeper) {
            offsetY = -15;
        } else if (livingEntity instanceof AbstractPiglin) {
            offsetY = -15;
        }
        return offsetY;
    }
}

