/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.forge.mixin;

import io.github.kosmx.bendylibForge.ModelPartAccessor;
import io.github.kosmx.bendylibForge.impl.BendableCuboid;
import io.github.kosmx.emotes.arch.emote.EmotePlayImpl;
import io.github.kosmx.emotes.common.tools.SetableSupplier;
import io.github.kosmx.emotes.executor.emotePlayer.IEmotePlayerEntity;
import io.github.kosmx.emotes.executor.emotePlayer.IMutatedBipedModel;
import io.github.kosmx.emotes.executor.emotePlayer.IUpperPartHelper;
import io.github.kosmx.emotes.forge.BendableModelPart;
import java.util.function.Function;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerModel.class}, priority=2000)
public class PlayerModelMixin<T extends LivingEntity>
extends HumanoidModel<T> {
    @Shadow
    @Final
    public ModelPart f_103378_;
    @Shadow
    @Final
    public ModelPart f_103375_;
    @Shadow
    @Final
    public ModelPart f_103374_;
    @Shadow
    @Final
    public ModelPart f_103377_;
    @Shadow
    @Final
    public ModelPart f_103376_;
    public SetableSupplier<EmotePlayImpl> emoteSupplier = new SetableSupplier();
    private IMutatedBipedModel<BendableModelPart, EmotePlayImpl> thisWithMixin;

    public PlayerModelMixin(ModelPart modelPart, Function<ResourceLocation, RenderType> function) {
        super(modelPart, function);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void initBendableStuff(ModelPart p_170821_, boolean p_170822_, CallbackInfo ci) {
        this.thisWithMixin = (IMutatedBipedModel)((Object)this);
        this.emoteSupplier.set(null);
        this.thisWithMixin.setEmoteSupplier(this.emoteSupplier);
        this.addBendMutator(this.f_103378_, Direction.DOWN);
        this.addBendMutator(this.f_103377_, Direction.UP);
        this.addBendMutator(this.f_103375_, Direction.UP);
        this.addBendMutator(this.f_103376_, Direction.UP);
        this.addBendMutator(this.f_103374_, Direction.UP);
        ((IUpperPartHelper)this.f_103375_).setUpperPart(true);
        ((IUpperPartHelper)this.f_103374_).setUpperPart(true);
    }

    private void addBendMutator(ModelPart part, Direction d) {
        ModelPartAccessor.optionalGetCuboid(part, 0).ifPresent(mutableCuboid -> mutableCuboid.registerMutator("bend", data -> new BendableCuboid.Builder().setDirection(d).build(data)));
    }

    private void setDefaultPivot() {
        this.f_102814_.m_104227_(1.9f, 12.0f, 0.0f);
        this.f_102813_.m_104227_(-1.9f, 12.0f, 0.0f);
        this.f_102808_.m_104227_(0.0f, 0.0f, 0.0f);
        this.f_102811_.f_104202_ = 0.0f;
        this.f_102811_.f_104200_ = -5.0f;
        this.f_102812_.f_104202_ = 0.0f;
        this.f_102812_.f_104200_ = 5.0f;
        this.f_102810_.f_104203_ = 0.0f;
        this.f_102813_.f_104202_ = 0.1f;
        this.f_102814_.f_104202_ = 0.1f;
        this.f_102813_.f_104201_ = 12.0f;
        this.f_102814_.f_104201_ = 12.0f;
        this.f_102808_.f_104201_ = 0.0f;
        this.f_102808_.f_104205_ = 0.0f;
        this.f_102810_.f_104201_ = 0.0f;
        this.f_102810_.f_104200_ = 0.0f;
        this.f_102810_.f_104202_ = 0.0f;
        this.f_102810_.f_104204_ = 0.0f;
        this.f_102810_.f_104205_ = 0.0f;
    }

    @Inject(method={"setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V"}, at={@At(value="HEAD")})
    private void setDefaultBeforeRender(T livingEntity, float f, float g, float h, float i, float j, CallbackInfo ci) {
        this.setDefaultPivot();
    }

    @Inject(method={"setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/model/geom/ModelPart;copyFrom(Lnet/minecraft/client/model/geom/ModelPart;)V", ordinal=0)})
    private void setEmote(T livingEntity, float f, float g, float h, float i, float j, CallbackInfo ci) {
        if (livingEntity instanceof AbstractClientPlayer && ((IEmotePlayerEntity)livingEntity).isPlayingEmote()) {
            EmotePlayImpl emote = (EmotePlayImpl)((IEmotePlayerEntity)livingEntity).getEmote();
            this.emoteSupplier.set(emote);
            emote.head.updateBodyPart(this.f_102808_);
            this.f_102809_.m_104315_(this.f_102808_);
            emote.leftArm.updateBodyPart(this.f_102812_);
            emote.rightArm.updateBodyPart(this.f_102811_);
            emote.leftLeg.updateBodyPart(this.f_102814_);
            emote.rightLeg.updateBodyPart(this.f_102813_);
            emote.getPart("torso").updateBodyPart(this.f_102810_);
            this.thisWithMixin.getTorso().bend(emote.torso.getBend());
            this.thisWithMixin.getLeftArm().bend(emote.leftArm.getBend());
            this.thisWithMixin.getLeftLeg().bend(emote.leftLeg.getBend());
            this.thisWithMixin.getRightArm().bend(emote.rightArm.getBend());
            this.thisWithMixin.getRightLeg().bend(emote.rightLeg.getBend());
        } else {
            this.emoteSupplier.set(null);
            this.thisWithMixin.getTorso().bend(null);
            this.thisWithMixin.getLeftArm().bend(null);
            this.thisWithMixin.getRightArm().bend(null);
            this.thisWithMixin.getLeftLeg().bend(null);
            this.thisWithMixin.getRightLeg().bend(null);
        }
    }
}

