/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.forge.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.kosmx.bendylibForge.ModelPartAccessor;
import io.github.kosmx.bendylibForge.impl.BendableCuboid;
import io.github.kosmx.emotes.arch.emote.EmotePlayImpl;
import io.github.kosmx.emotes.common.tools.SetableSupplier;
import io.github.kosmx.emotes.executor.emotePlayer.IMutatedBipedModel;
import io.github.kosmx.emotes.executor.emotePlayer.IUpperPartHelper;
import io.github.kosmx.emotes.forge.BendableModelPart;
import java.util.function.Function;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HumanoidModel.class})
public abstract class BipedEntityModelMixin<T extends LivingEntity>
extends AgeableListModel<T>
implements IMutatedBipedModel<BendableModelPart, EmotePlayImpl> {
    @Shadow
    public ModelPart f_102813_;
    @Shadow
    public ModelPart f_102811_;
    @Shadow
    public ModelPart f_102814_;
    @Shadow
    public ModelPart f_102812_;
    protected SetableSupplier<EmotePlayImpl> emote = new SetableSupplier();
    @Shadow
    public ModelPart f_102810_;
    @Shadow
    @Final
    public ModelPart f_102808_;
    @Shadow
    @Final
    public ModelPart f_102809_;

    @Inject(method={"<init>(Lnet/minecraft/client/model/geom/ModelPart;Ljava/util/function/Function;)V"}, at={@At(value="RETURN")})
    private void InitInject(ModelPart modelPart, Function<ResourceLocation, RenderType> function, CallbackInfo ci) {
        ModelPartAccessor.optionalGetCuboid(modelPart.m_171324_("body"), 0).ifPresent(mutableModelPart -> mutableModelPart.registerMutator("bend", data -> new BendableCuboid.Builder().setDirection(Direction.DOWN).build(data)));
        ModelPartAccessor.optionalGetCuboid(modelPart.m_171324_("right_arm"), 0).ifPresent(mutableModelPart -> mutableModelPart.registerMutator("bend", data -> new BendableCuboid.Builder().setDirection(Direction.UP).build(data)));
        ModelPartAccessor.optionalGetCuboid(modelPart.m_171324_("left_arm"), 0).ifPresent(mutableModelPart -> mutableModelPart.registerMutator("bend", data -> new BendableCuboid.Builder().setDirection(Direction.UP).build(data)));
        ModelPartAccessor.optionalGetCuboid(modelPart.m_171324_("right_leg"), 0).ifPresent(mutableModelPart -> mutableModelPart.registerMutator("bend", data -> new BendableCuboid.Builder().setDirection(Direction.UP).build(data)));
        ModelPartAccessor.optionalGetCuboid(modelPart.m_171324_("left_leg"), 0).ifPresent(mutableModelPart -> mutableModelPart.registerMutator("bend", data -> new BendableCuboid.Builder().setDirection(Direction.UP).build(data)));
        ((IUpperPartHelper)this.f_102811_).setUpperPart(true);
        ((IUpperPartHelper)this.f_102812_).setUpperPart(true);
        ((IUpperPartHelper)this.f_102808_).setUpperPart(true);
        ((IUpperPartHelper)this.f_102809_).setUpperPart(true);
    }

    @Override
    public void setEmoteSupplier(SetableSupplier<EmotePlayImpl> emoteSupplier) {
        this.emote = emoteSupplier;
    }

    @Inject(method={"copyPropertiesTo"}, at={@At(value="RETURN")})
    private void copyMutatedAttributes(HumanoidModel<T> bipedEntityModel, CallbackInfo ci) {
        if (this.emote != null) {
            ((IMutatedBipedModel)bipedEntityModel).setEmoteSupplier(this.emote);
        }
    }

    public void m_7695_(PoseStack matrices, VertexConsumer vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        if (EmotePlayImpl.isRunningEmote(this.emote.get())) {
            this.m_5607_().forEach(part -> {
                if (!((IUpperPartHelper)part).isUpperPart()) {
                    part.m_104306_(matrices, vertices, light, overlay, red, green, blue, alpha);
                }
            });
            this.m_5608_().forEach(part -> {
                if (!((IUpperPartHelper)part).isUpperPart()) {
                    part.m_104306_(matrices, vertices, light, overlay, red, green, blue, alpha);
                }
            });
            SetableSupplier<EmotePlayImpl> emoteSupplier = this.emote;
            matrices.m_85836_();
            BendableModelPart.roteteMatrixStack(matrices, emoteSupplier.get().torso.getBend());
            this.m_5607_().forEach(part -> {
                if (((IUpperPartHelper)part).isUpperPart()) {
                    part.m_104306_(matrices, vertices, light, overlay, red, green, blue, alpha);
                }
            });
            this.m_5608_().forEach(part -> {
                if (((IUpperPartHelper)part).isUpperPart()) {
                    part.m_104306_(matrices, vertices, light, overlay, red, green, blue, alpha);
                }
            });
            matrices.m_85849_();
        } else {
            super.m_7695_(matrices, vertices, light, overlay, red, green, blue, alpha);
        }
    }

    @Override
    public BendableModelPart getTorso() {
        return new BendableModelPart(this.f_102810_);
    }

    @Override
    public BendableModelPart getRightArm() {
        return new BendableModelPart(this.f_102811_);
    }

    @Override
    public BendableModelPart getLeftArm() {
        return new BendableModelPart(this.f_102812_);
    }

    @Override
    public BendableModelPart getRightLeg() {
        return new BendableModelPart(this.f_102813_);
    }

    @Override
    public BendableModelPart getLeftLeg() {
        return new BendableModelPart(this.f_102814_);
    }

    @Override
    public SetableSupplier<EmotePlayImpl> getEmoteSupplier() {
        return this.emote;
    }
}

