/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.bendylibForge.impl;

import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import io.github.kosmx.bendylibForge.impl.IterableRePos;
import net.minecraft.core.Direction;

public interface IBendable {
    default public Matrix4f applyBend(float bendAxis, float bendValue, IterableRePos posSupplier) {
        Vector3f axis = new Vector3f((float)Math.cos(bendAxis), 0.0f, (float)Math.sin(bendAxis));
        Matrix3f matrix3f = new Matrix3f(this.getBendDirection().m_122406_());
        axis.m_122249_(matrix3f);
        Matrix4f transformMatrix = new Matrix4f();
        transformMatrix.m_27624_();
        transformMatrix.m_27644_(Matrix4f.m_27653_((float)this.getBendX(), (float)this.getBendY(), (float)this.getBendZ()));
        transformMatrix.m_27646_(axis.m_122270_(bendValue));
        transformMatrix.m_27644_(Matrix4f.m_27653_((float)(-this.getBendX()), (float)(-this.getBendY()), (float)(-this.getBendZ())));
        Plane basePlane = this.getBasePlane();
        Plane otherPlane = this.getOtherSidePlane();
        Vector3f directionUnit = this.getBendDirection().m_122432_();
        directionUnit.m_122279_(axis);
        Plane bendPlane = new Plane(directionUnit, new Vector3f(this.getBendX(), this.getBendY(), this.getBendZ()));
        float halfSize = this.bendHeight() / 2.0f;
        boolean bl = this.getBendDirection() == Direction.UP || this.getBendDirection() == Direction.SOUTH || this.getBendDirection() == Direction.EAST;
        posSupplier.iteratePositions(iPosWithOrigin -> {
            Vector3f newPos = iPosWithOrigin.getOriginalPos();
            float distFromBend = bl ? -bendPlane.distanceTo(newPos) : bendPlane.distanceTo(newPos);
            float distFromBase = basePlane.distanceTo(newPos);
            float distFromOther = otherPlane.distanceTo(newPos);
            double s = Math.tan(bendValue / 2.0f) * (double)distFromBend;
            Vector3f x = this.getBendDirection().m_122432_();
            if (Math.abs(distFromBase) < Math.abs(distFromOther)) {
                x.m_122261_((float)((double)(-distFromBase / halfSize) * s));
                newPos.m_122253_(x);
                Vector4f reposVector = new Vector4f(newPos);
                reposVector.m_123607_(transformMatrix);
                newPos = new Vector3f(reposVector.m_123601_(), reposVector.m_123615_(), reposVector.m_123616_());
            } else {
                x.m_122261_((float)((double)(-distFromOther / halfSize) * s));
                newPos.m_122253_(x);
            }
            iPosWithOrigin.setPos(newPos);
        });
        return transformMatrix;
    }

    public Direction getBendDirection();

    public float getBendX();

    public float getBendY();

    public float getBendZ();

    public Plane getBasePlane();

    public Plane getOtherSidePlane();

    default public float bendHeight() {
        return this.getBasePlane().distanceTo(this.getOtherSidePlane());
    }

    public static class Plane {
        final Vector3f normal;
        final float normDistance;

        public Plane(Vector3f normal, Vector3f position) {
            this.normal = normal.m_122281_();
            this.normal.m_122278_();
            this.normDistance = -normal.m_122276_(position);
        }

        public float distanceTo(Vector3f pos) {
            return this.normal.m_122276_(pos) + this.normDistance;
        }

        public float distanceTo(Plane otherPlane) {
            Vector3f tmp = this.normal.m_122281_();
            tmp.m_122279_(otherPlane.normal);
            if ((double)tmp.m_122276_(tmp) < 0.01) {
                return this.normDistance + this.normal.m_122276_(otherPlane.normal) * otherPlane.normDistance;
            }
            return 0.0f;
        }
    }
}

