/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client.microphone;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.voice.client.MicrophoneException;
import de.maxhenkel.voicechat.voice.client.microphone.ALMicrophone;
import de.maxhenkel.voicechat.voice.client.microphone.JavaxMicrophone;
import de.maxhenkel.voicechat.voice.client.microphone.Microphone;
import java.util.List;

public class MicrophoneManager {
    private static boolean fallback;

    public static Microphone getMicrophone() throws MicrophoneException {
        Microphone mic;
        if (fallback || VoicechatClient.CLIENT_CONFIG.javaMicrophoneImplementation.get().booleanValue()) {
            mic = MicrophoneManager.getJavaMicrophone();
        } else {
            try {
                mic = MicrophoneManager.getALMicrophone();
            }
            catch (MicrophoneException e) {
                Voicechat.LOGGER.warn("Failed to use OpenAL microphone implementation: {}", (Object)e.getMessage());
                Voicechat.LOGGER.warn("Falling back to Java microphone implementation");
                mic = MicrophoneManager.getJavaMicrophone();
                fallback = true;
            }
        }
        return mic;
    }

    private static Microphone getJavaMicrophone() throws MicrophoneException {
        JavaxMicrophone mic = new JavaxMicrophone(48000, 960, VoicechatClient.CLIENT_CONFIG.microphone.get());
        mic.open();
        return mic;
    }

    private static Microphone getALMicrophone() throws MicrophoneException {
        ALMicrophone mic = new ALMicrophone(48000, 960, VoicechatClient.CLIENT_CONFIG.microphone.get());
        mic.open();
        return mic;
    }

    public static List<String> deviceNames() {
        if (fallback || VoicechatClient.CLIENT_CONFIG.javaMicrophoneImplementation.get().booleanValue()) {
            return JavaxMicrophone.getAllMicrophones();
        }
        return ALMicrophone.getAllMicrophones();
    }
}

