/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.entity.Entity;

public class TalkCache {
    private static final long TIMEOUT = 250L;
    private final Map<UUID, Talk> cache = new HashMap<UUID, Talk>();

    public void updateTalking(UUID entity, boolean whispering) {
        this.cache.put(entity, new Talk(whispering));
    }

    public boolean isTalking(Entity entity) {
        return this.isTalking(entity.m_142081_());
    }

    public boolean isWhispering(Entity entity) {
        return this.isWhispering(entity.m_142081_());
    }

    public boolean isTalking(UUID entity) {
        ClientVoicechat client;
        if (entity.equals(ClientManager.getPlayerStateManager().getOwnID()) && (client = ClientManager.getClient()) != null && client.getMicThread() != null) {
            return client.getMicThread().isTalking();
        }
        Talk lastTalk = this.cache.getOrDefault(entity, new Talk(0L, false));
        return System.currentTimeMillis() - lastTalk.timestamp < 250L;
    }

    public boolean isWhispering(UUID entity) {
        ClientVoicechat client;
        if (entity.equals(ClientManager.getPlayerStateManager().getOwnID()) && (client = ClientManager.getClient()) != null && client.getMicThread() != null) {
            return client.getMicThread().isWhispering();
        }
        Talk lastTalk = this.cache.getOrDefault(entity, new Talk(0L, false));
        return lastTalk.whispering && System.currentTimeMillis() - lastTalk.timestamp < 250L;
    }

    private static class Talk {
        private final long timestamp;
        private final boolean whispering;

        public Talk(long timestamp, boolean whispering) {
            this.timestamp = timestamp;
            this.whispering = whispering;
        }

        public Talk(boolean whispering) {
            this.timestamp = System.currentTimeMillis();
            this.whispering = whispering;
        }
    }
}

