/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import com.mojang.math.Vector3f;
import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.voice.client.SoundManager;
import de.maxhenkel.voicechat.voice.client.SpeakerException;
import de.maxhenkel.voicechat.voice.common.NamedThreadPoolFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec3;
import org.lwjgl.openal.AL11;

public abstract class ALSpeaker {
    protected final Minecraft mc = Minecraft.m_91087_();
    protected final SoundManager soundManager;
    protected final int sampleRate;
    protected final int bufferSize;
    protected final int bufferSampleSize;
    protected int source;
    protected volatile int bufferIndex;
    protected final int[] buffers;
    private final ExecutorService executor;

    public ALSpeaker(SoundManager soundManager, int sampleRate, int bufferSize) {
        this.soundManager = soundManager;
        this.sampleRate = sampleRate;
        this.bufferSize = bufferSize;
        this.bufferSampleSize = bufferSize;
        this.buffers = new int[32];
        this.executor = Executors.newSingleThreadExecutor(NamedThreadPoolFactory.create("SoundSourceThread"));
    }

    public void open() throws SpeakerException {
        this.runInContext(this::openSync);
    }

    private void openSync() {
        if (this.hasValidSourceSync()) {
            return;
        }
        this.source = AL11.alGenSources();
        SoundManager.checkAlError();
        AL11.alSourcei((int)this.source, (int)4103, (int)0);
        SoundManager.checkAlError();
        AL11.alDistanceModel((int)0);
        SoundManager.checkAlError();
        AL11.alGenBuffers((int[])this.buffers);
        SoundManager.checkAlError();
    }

    public void close() {
        this.runInContext(this::closeSync);
    }

    public void closeSync() {
        if (this.hasValidSourceSync()) {
            if (this.getStateSync() == 4114) {
                AL11.alSourceStop((int)this.source);
                SoundManager.checkAlError();
            }
            AL11.alDeleteSources((int)this.source);
            SoundManager.checkAlError();
            AL11.alDeleteBuffers((int[])this.buffers);
            SoundManager.checkAlError();
        }
        this.source = 0;
        this.executor.shutdown();
    }

    protected void setPositionSync(@Nullable Vec3 soundPos) {
        if (soundPos != null) {
            Camera camera = this.mc.f_91063_.m_109153_();
            Vec3 position = camera.m_90583_();
            Vector3f look = camera.m_90596_();
            Vector3f up = camera.m_90597_();
            AL11.alListener3f((int)4100, (float)((float)position.f_82479_), (float)((float)position.f_82480_), (float)((float)position.f_82481_));
            SoundManager.checkAlError();
            AL11.alListenerfv((int)4111, (float[])new float[]{look.m_122239_(), look.m_122260_(), look.m_122269_(), up.m_122239_(), up.m_122260_(), up.m_122269_()});
            SoundManager.checkAlError();
            AL11.alSource3f((int)this.source, (int)4100, (float)((float)soundPos.f_82479_), (float)((float)soundPos.f_82480_), (float)((float)soundPos.f_82481_));
            SoundManager.checkAlError();
        } else {
            AL11.alListener3f((int)4100, (float)0.0f, (float)0.0f, (float)0.0f);
            SoundManager.checkAlError();
            AL11.alListenerfv((int)4111, (float[])new float[]{0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f});
            SoundManager.checkAlError();
            AL11.alSource3f((int)this.source, (int)4100, (float)0.0f, (float)0.0f, (float)0.0f);
            SoundManager.checkAlError();
        }
    }

    public void checkBufferEmpty(Runnable onEmpty) {
        this.runInContext(() -> {
            if (this.getStateSync() == 4116 || this.getQueuedBuffersSync() <= 0) {
                onEmpty.run();
            }
        });
    }

    public void write(short[] data, float volume, @Nullable Vec3 position) {
        this.runInContext(() -> {
            boolean stopped;
            this.removeProcessedBuffersSync();
            int buffers = this.getQueuedBuffersSync();
            boolean bl = stopped = this.getStateSync() == 4113 || this.getStateSync() == 4116 || buffers <= 1;
            if (stopped) {
                for (int i = 0; i < VoicechatClient.CLIENT_CONFIG.outputBufferSize.get(); ++i) {
                    this.writeSync(new short[this.bufferSampleSize], 1.0f, position);
                }
            }
            this.writeSync(data, volume, position);
            if (stopped) {
                AL11.alSourcePlay((int)this.source);
                SoundManager.checkAlError();
            }
        });
    }

    private void writeSync(short[] data, float volume, @Nullable Vec3 position) {
        this.setPositionSync(position);
        AL11.alSourcef((int)this.source, (int)4110, (float)6.0f);
        SoundManager.checkAlError();
        AL11.alSourcef((int)this.source, (int)4106, (float)volume);
        SoundManager.checkAlError();
        AL11.alListenerf((int)4106, (float)1.0f);
        SoundManager.checkAlError();
        int queuedBuffers = this.getQueuedBuffersSync();
        if (queuedBuffers >= this.buffers.length) {
            Voicechat.LOGGER.warn("Full playback buffer: {}/{}", (Object)queuedBuffers, (Object)this.buffers.length);
            int sampleOffset = AL11.alGetSourcei((int)this.source, (int)4133);
            SoundManager.checkAlError();
            int buffersToSkip = queuedBuffers - VoicechatClient.CLIENT_CONFIG.outputBufferSize.get();
            AL11.alSourcei((int)this.source, (int)4133, (int)(sampleOffset + buffersToSkip * this.bufferSampleSize));
            SoundManager.checkAlError();
            this.removeProcessedBuffersSync();
        }
        AL11.alBufferData((int)this.buffers[this.bufferIndex], (int)4353, (short[])data, (int)this.sampleRate);
        SoundManager.checkAlError();
        AL11.alSourceQueueBuffers((int)this.source, (int)this.buffers[this.bufferIndex]);
        SoundManager.checkAlError();
        this.bufferIndex = (this.bufferIndex + 1) % this.buffers.length;
    }

    private void removeProcessedBuffersSync() {
        int processed = AL11.alGetSourcei((int)this.source, (int)4118);
        SoundManager.checkAlError();
        for (int i = 0; i < processed; ++i) {
            AL11.alSourceUnqueueBuffers((int)this.source);
            SoundManager.checkAlError();
        }
    }

    private int getStateSync() {
        int state = AL11.alGetSourcei((int)this.source, (int)4112);
        SoundManager.checkAlError();
        return state;
    }

    private int getQueuedBuffersSync() {
        int buffers = AL11.alGetSourcei((int)this.source, (int)4117);
        SoundManager.checkAlError();
        return buffers;
    }

    private boolean hasValidSourceSync() {
        boolean validSource = AL11.alIsSource((int)this.source);
        SoundManager.checkAlError();
        return validSource;
    }

    public void runInContext(Runnable runnable) {
        this.soundManager.runInContext(this.executor, runnable);
    }
}

