/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.maxhenkel.voicechat.gui.VoiceChatScreenBase;
import de.maxhenkel.voicechat.intercompatibility.ClientCompatibilityManager;
import de.maxhenkel.voicechat.voice.client.KeyEvents;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public abstract class ListScreen<T>
extends VoiceChatScreenBase {
    private static final ResourceLocation TEXTURE = new ResourceLocation("voicechat", "textures/gui/gui_generic_small.png");
    protected List<T> elements;
    protected int index;
    protected Button previous;
    protected Button back;
    protected Button next;
    protected Screen parent;

    public ListScreen(Screen parent, List<T> elements, Component title) {
        super(title, 248, 85);
        this.parent = parent;
        this.elements = elements;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.previous = new Button(this.guiLeft + 10, this.guiTop + 60, 60, 20, (Component)new TranslatableComponent("message.voicechat.previous"), button -> {
            this.index = (this.index - 1 + this.elements.size()) % this.elements.size();
            this.updateCurrentElement();
        });
        this.back = new Button(this.guiLeft + this.xSize / 2 - 30, this.guiTop + 60, 60, 20, (Component)new TranslatableComponent("message.voicechat.back"), button -> this.f_96541_.m_91152_(this.parent));
        this.next = new Button(this.guiLeft + this.xSize - 70, this.guiTop + 60, 60, 20, (Component)new TranslatableComponent("message.voicechat.next"), button -> {
            this.index = (this.index + 1) % this.elements.size();
            this.updateCurrentElement();
        });
        this.updateCurrentElement();
    }

    public void updateCurrentElement() {
        this.m_169413_();
        this.m_142416_((GuiEventListener)this.previous);
        this.m_142416_((GuiEventListener)this.back);
        this.m_142416_((GuiEventListener)this.next);
        if (this.elements.size() <= 1) {
            this.next.f_93624_ = false;
            this.previous.f_93624_ = false;
        }
    }

    @Nullable
    public T getCurrentElement() {
        if (this.elements.size() <= 0) {
            return null;
        }
        return this.elements.get(this.index);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == ClientCompatibilityManager.INSTANCE.getBoundKeyOf(this.f_96541_.f_91066_.f_92092_).m_84873_() || keyCode == ClientCompatibilityManager.INSTANCE.getBoundKeyOf(KeyEvents.KEY_VOICE_CHAT).m_84873_()) {
            this.f_96541_.m_91152_(null);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    @Override
    public void renderBackground(PoseStack poseStack, int mouseX, int mouseY, float delta) {
        if (this.isIngame()) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
            this.m_93228_(poseStack, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        }
    }

    @Override
    public void renderForeground(PoseStack poseStack, int mouseX, int mouseY, float delta) {
        this.renderText(poseStack, this.getCurrentElement(), mouseX, mouseY, delta);
    }

    protected abstract void renderText(PoseStack var1, @Nullable T var2, int var3, int var4, float var5);
}

