/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.maxhenkel.voicechat.gui.AdjustVolumeScreen;
import de.maxhenkel.voicechat.gui.SkinUtils;
import de.maxhenkel.voicechat.gui.VoiceChatScreenBase;
import de.maxhenkel.voicechat.gui.widgets.WidgetBase;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class GroupList
extends WidgetBase {
    private static final ResourceLocation TEXTURE = new ResourceLocation("voicechat", "textures/gui/gui_group.png");
    private static final ResourceLocation SPEAKER_OFF = new ResourceLocation("voicechat", "textures/icons/speaker_small_off.png");
    private static final ResourceLocation SPEAKER = new ResourceLocation("voicechat", "textures/icons/speaker_small.png");
    private static final ResourceLocation CHANGE_VOLUME = new ResourceLocation("voicechat", "textures/icons/change_volume.png");
    protected Supplier<List<PlayerState>> playerStates;
    protected int offset;
    private final VoiceChatScreenBase.HoverArea[] hoverAreas;
    private final int columnHeight;
    private final int columnCount;
    private final ClientVoicechat voiceChatClient;

    public GroupList(VoiceChatScreenBase screen, int posX, int posY, int xSize, int ySize, Supplier<List<PlayerState>> playerStates) {
        super(screen, posX, posY, xSize, ySize);
        this.playerStates = playerStates;
        this.columnHeight = 22;
        this.columnCount = 8;
        this.hoverAreas = new VoiceChatScreenBase.HoverArea[this.columnCount];
        for (int i = 0; i < this.hoverAreas.length; ++i) {
            this.hoverAreas[i] = new VoiceChatScreenBase.HoverArea(0, i * this.columnHeight, xSize, this.columnHeight);
        }
        this.voiceChatClient = ClientManager.getClient();
        if (this.voiceChatClient == null) {
            this.mc.m_91152_(null);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.voiceChatClient.getConnection() == null || !this.voiceChatClient.getConnection().isAuthenticated()) {
            this.mc.m_91152_(null);
        }
    }

    @Override
    public void drawGuiContainerForegroundLayer(PoseStack matrixStack, int mouseX, int mouseY) {
        super.drawGuiContainerForegroundLayer(matrixStack, mouseX, mouseY);
        List<PlayerState> entries = this.playerStates.get();
        for (int i = this.getOffset(); i < entries.size() && i < this.getOffset() + this.columnCount; ++i) {
            int pos = i - this.getOffset();
            int startY = this.guiTop + pos * this.columnHeight;
            PlayerState state = entries.get(i);
            this.mc.f_91062_.m_92889_(matrixStack, (Component)new TextComponent(state.getName()), (float)(this.guiLeft + 3 + 16 + 1 + 16 + 3), (float)(startY + 7), 0);
        }
    }

    @Override
    public void drawGuiContainerBackgroundLayer(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(matrixStack, partialTicks, mouseX, mouseY);
        List<PlayerState> entries = this.playerStates.get();
        for (int i = this.getOffset(); i < entries.size() && i < this.getOffset() + this.columnCount; ++i) {
            PlayerState state = entries.get(i);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
            int pos = i - this.getOffset();
            VoiceChatScreenBase.HoverArea hoverArea = this.hoverAreas[pos];
            boolean hovered = hoverArea.isHovered(this.guiLeft, this.guiTop, mouseX, mouseY) && !state.getUuid().equals(ClientManager.getPlayerStateManager().getOwnID());
            int startY = this.guiTop + pos * this.columnHeight;
            if (hovered) {
                Screen.m_93133_((PoseStack)matrixStack, (int)this.guiLeft, (int)startY, (float)195.0f, (float)39.0f, (int)160, (int)this.columnHeight, (int)512, (int)512);
            } else {
                Screen.m_93133_((PoseStack)matrixStack, (int)this.guiLeft, (int)startY, (float)195.0f, (float)17.0f, (int)160, (int)this.columnHeight, (int)512, (int)512);
            }
            matrixStack.m_85836_();
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_157456_((int)0, (ResourceLocation)SkinUtils.getSkin(state.getUuid()));
            matrixStack.m_85837_((double)(this.guiLeft + 3), (double)(startY + 3), 0.0);
            matrixStack.m_85841_(2.0f, 2.0f, 1.0f);
            Screen.m_93133_((PoseStack)matrixStack, (int)0, (int)0, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            Screen.m_93133_((PoseStack)matrixStack, (int)0, (int)0, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            matrixStack.m_85849_();
            if (state.isDisabled()) {
                this.drawIcon(matrixStack, startY, SPEAKER_OFF);
            } else if (this.voiceChatClient.getTalkCache().isTalking(state.getUuid())) {
                this.drawIcon(matrixStack, startY, SPEAKER);
            }
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)CHANGE_VOLUME);
            if (!hovered) continue;
            Screen.m_93133_((PoseStack)matrixStack, (int)(this.guiLeft + this.xSize - 3 - 16), (int)(startY + 3), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        if (entries.size() > this.columnCount) {
            float h = this.ySize - 17;
            float perc = (float)this.getOffset() / (float)(entries.size() - this.columnCount);
            int posY = this.guiTop + (int)(h * perc);
            Screen.m_93133_((PoseStack)matrixStack, (int)(this.guiLeft + this.xSize + 6), (int)posY, (float)195.0f, (float)0.0f, (int)12, (int)17, (int)512, (int)512);
        } else {
            Screen.m_93133_((PoseStack)matrixStack, (int)(this.guiLeft + this.xSize + 6), (int)this.guiTop, (float)207.0f, (float)0.0f, (int)12, (int)17, (int)512, (int)512);
        }
    }

    private void drawIcon(PoseStack matrixStack, int startY, ResourceLocation texture) {
        matrixStack.m_85836_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        matrixStack.m_85837_((double)(this.guiLeft + 3 + 16 + 1), (double)(startY + 3), 0.0);
        Screen.m_93133_((PoseStack)matrixStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        matrixStack.m_85849_();
    }

    public int getOffset() {
        List<PlayerState> entries = this.playerStates.get();
        if (entries.size() <= this.columnCount) {
            this.offset = 0;
        } else if (this.offset > entries.size() - this.columnCount) {
            this.offset = entries.size() - this.columnCount;
        }
        return this.offset;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        List<PlayerState> entries = this.playerStates.get();
        if (entries.size() > this.columnCount) {
            this.offset = delta < 0.0 ? Math.min(this.getOffset() + 1, entries.size() - this.columnCount) : Math.max(this.getOffset() - 1, 0);
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, delta);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        List<PlayerState> entries = this.playerStates.get();
        for (int i = 0; i < this.hoverAreas.length && this.getOffset() + i < entries.size(); ++i) {
            PlayerState state;
            if (!this.hoverAreas[i].isHovered(this.guiLeft, this.guiTop, (int)mouseX, (int)mouseY) || (state = entries.get(this.getOffset() + i)).getUuid().equals(ClientManager.getPlayerStateManager().getOwnID())) continue;
            this.mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
            this.mc.m_91152_((Screen)new AdjustVolumeScreen(this.screen, Collections.singletonList(state)));
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }
}

