/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.JoinGroupScreen;
import de.maxhenkel.voicechat.gui.VoiceChatScreenBase;
import de.maxhenkel.voicechat.gui.tooltips.DisableTooltipSupplier;
import de.maxhenkel.voicechat.gui.tooltips.HideGroupHudTooltipSupplier;
import de.maxhenkel.voicechat.gui.tooltips.MuteTooltipSupplier;
import de.maxhenkel.voicechat.gui.widgets.GroupList;
import de.maxhenkel.voicechat.gui.widgets.ImageButton;
import de.maxhenkel.voicechat.gui.widgets.ToggleImageButton;
import de.maxhenkel.voicechat.net.LeaveGroupPacket;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientPlayerStateManager;
import de.maxhenkel.voicechat.voice.client.GroupChatManager;
import de.maxhenkel.voicechat.voice.client.MicrophoneActivationType;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import java.util.Collections;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class GroupScreen
extends VoiceChatScreenBase {
    private static final ResourceLocation TEXTURE = new ResourceLocation("voicechat", "textures/gui/gui_group.png");
    private static final ResourceLocation LEAVE = new ResourceLocation("voicechat", "textures/icons/leave.png");
    private static final ResourceLocation MICROPHONE = new ResourceLocation("voicechat", "textures/icons/microphone_button.png");
    private static final ResourceLocation SPEAKER = new ResourceLocation("voicechat", "textures/icons/speaker_button.png");
    private static final ResourceLocation GROUP_HUD = new ResourceLocation("voicechat", "textures/icons/group_hud_button.png");
    private final ClientGroup group;
    private GroupList playerList;
    private ToggleImageButton mute;
    private ToggleImageButton disable;
    private ToggleImageButton showHUD;
    private ImageButton leave;

    public GroupScreen(ClientGroup group) {
        super((Component)new TranslatableComponent("gui.voicechat.group.title"), 195, 222);
        this.group = group;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.hoverAreas.clear();
        this.m_169413_();
        ClientPlayerStateManager stateManager = ClientManager.getPlayerStateManager();
        this.playerList = new GroupList(this, 9, 16, 160, 176, GroupChatManager::getGroupMembers);
        this.mute = new ToggleImageButton(this.guiLeft + 8, this.guiTop + 196, MICROPHONE, stateManager::isMuted, button -> stateManager.setMuted(!stateManager.isMuted()), new MuteTooltipSupplier(this, stateManager));
        this.m_142416_((GuiEventListener)this.mute);
        this.disable = new ToggleImageButton(this.guiLeft + 31, this.guiTop + 196, SPEAKER, stateManager::isDisabled, button -> stateManager.setDisabled(!stateManager.isDisabled()), new DisableTooltipSupplier(this, stateManager));
        this.m_142416_((GuiEventListener)this.disable);
        this.showHUD = new ToggleImageButton(this.guiLeft + 54, this.guiTop + 196, GROUP_HUD, VoicechatClient.CLIENT_CONFIG.showGroupHUD::get, button -> VoicechatClient.CLIENT_CONFIG.showGroupHUD.set(VoicechatClient.CLIENT_CONFIG.showGroupHUD.get() == false).save(), new HideGroupHudTooltipSupplier(this));
        this.m_142416_((GuiEventListener)this.showHUD);
        this.leave = new ImageButton(this.guiLeft + 168, this.guiTop + 196, LEAVE, button -> {
            NetManager.sendToServer(new LeaveGroupPacket());
            this.f_96541_.m_91152_((Screen)new JoinGroupScreen());
        }, (button, matrices, mouseX, mouseY) -> this.m_96617_(matrices, Collections.singletonList(new TranslatableComponent("message.voicechat.leave_group").m_7532_()), mouseX, mouseY));
        this.m_142416_((GuiEventListener)this.leave);
        this.checkButtons();
    }

    public void m_96624_() {
        super.m_96624_();
        this.checkButtons();
    }

    private void checkButtons() {
        this.mute.f_93623_ = VoicechatClient.CLIENT_CONFIG.microphoneActivationType.get().equals((Object)MicrophoneActivationType.VOICE);
        this.showHUD.f_93623_ = VoicechatClient.CLIENT_CONFIG.hideIcons.get() == false;
    }

    @Override
    public void renderBackground(PoseStack poseStack, int mouseX, int mouseY, float delta) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        GroupScreen.m_93133_((PoseStack)poseStack, (int)this.guiLeft, (int)this.guiTop, (float)0.0f, (float)0.0f, (int)this.xSize, (int)this.ySize, (int)512, (int)512);
    }

    @Override
    public void renderForeground(PoseStack poseStack, int mouseX, int mouseY, float delta) {
        this.playerList.drawGuiContainerBackgroundLayer(poseStack, delta, mouseX, mouseY);
        this.playerList.drawGuiContainerForegroundLayer(poseStack, mouseX, mouseY);
        this.f_96547_.m_92889_(poseStack, (Component)new TextComponent(this.group.getName()), (float)(this.guiLeft + 8), (float)(this.guiTop + 5), 0x404040);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.playerList.mouseScrolled(mouseX, mouseY, amount)) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.playerList.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.playerList.mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }
}

