/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.config;

import de.maxhenkel.voicechat.config.ServerConfig;
import de.maxhenkel.voicechat.configbuilder.Config;
import de.maxhenkel.voicechat.configbuilder.ConfigEntry;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;

public class ForgeServerConfig
extends ServerConfig {
    public ForgeServerConfig(ForgeConfigSpec.Builder builder) {
        this.voiceChatPort = ForgeServerConfig.wrapConfigEntry(builder.worldRestart().comment("The port of the voice chat server").defineInRange("voice_chat.port", 24454, -1, 65535));
        this.voiceChatBindAddress = ForgeServerConfig.wrapConfigEntry(builder.worldRestart().comment(new String[]{"The IP address to bind the voice chat server on", "Leave empty to bind to an IP address chosen by the kernel"}).define("voice_chat.bind_address", (Object)""));
        this.voiceChatDistance = ForgeServerConfig.wrapConfigEntry(builder.worldRestart().comment("The distance to where the voice can be heard").defineInRange("voice_chat.max_voice_distance", 48.0, 1.0, 1000000.0));
        this.voiceChatFadeDistance = ForgeServerConfig.wrapConfigEntry(builder.worldRestart().comment("The distance to where the voice starts fading").defineInRange("voice_chat.min_voice_distance", 4.0, 1.0, 1000000.0));
        this.crouchDistanceMultiplier = ForgeServerConfig.wrapConfigEntry(builder.worldRestart().comment("The multiplier the voice distance will be reduced by when sneaking").defineInRange("voice_chat.crouch_distance_multiplier", 1.0, 0.01, 1.0));
        this.whisperDistanceMultiplier = ForgeServerConfig.wrapConfigEntry(builder.worldRestart().comment("The multiplier the voice distance will be reduced by when whispering").defineInRange("voice_chat.whisper_distance_multiplier", 0.5, 0.01, 1.0));
        this.voiceChatCodec = ForgeServerConfig.wrapConfigEntry(builder.worldRestart().comment("The opus codec").defineEnum("voice_chat.codec", (Enum)ServerConfig.Codec.VOIP));
        this.voiceChatMtuSize = ForgeServerConfig.wrapConfigEntry(builder.worldRestart().comment(new String[]{"The maximum size in bytes in a voice packet", "Set this to a lower value if your voice packets don't arrive"}).defineInRange("voice_chat.mtu_size", 1024, 256, 10000));
        this.keepAlive = ForgeServerConfig.wrapConfigEntry(builder.worldRestart().comment(new String[]{"The frequency in which keep alive packets are sent", "Setting this to a higher value may result in timeouts"}).defineInRange("voice_chat.keep_alive", 1000, 1000, Integer.MAX_VALUE));
        this.groupsEnabled = ForgeServerConfig.wrapConfigEntry(builder.worldRestart().comment("If group chats are allowed").define("voice_chat.enable_groups", true));
        this.openGroups = ForgeServerConfig.wrapConfigEntry(builder.worldRestart().comment("If players in group chats can be heard locally").define("voice_chat.open_groups", false));
        this.voiceHost = ForgeServerConfig.wrapConfigEntry(builder.worldRestart().comment(new String[]{"The host name that clients should use to connect to the voice chat", "Don't change this value if you don't know what you are doing"}).define("voice_chat.voice_host", (Object)""));
        this.allowRecording = ForgeServerConfig.wrapConfigEntry(builder.worldRestart().comment("If players are allowed to record the voice chat").define("voice_chat.allow_recording", true));
        this.spectatorInteraction = ForgeServerConfig.wrapConfigEntry(builder.worldRestart().comment("If spectators are allowed to talk to other players").define("voice_chat.spectator_interaction", false));
        this.spectatorPlayerPossession = ForgeServerConfig.wrapConfigEntry(builder.worldRestart().comment("If spectators can talk to players they are spectating").define("voice_chat.spectator_player_possession", false));
    }

    public static <T> ConfigEntry<T> wrapConfigEntry(final ForgeConfigSpec.ConfigValue<T> configValue) {
        return new ConfigEntry<T>(){

            @Override
            public T get() {
                return configValue.get();
            }

            @Override
            public ConfigEntry<T> set(T t) {
                configValue.set(t);
                return this;
            }

            @Override
            public ConfigEntry<T> reset() {
                throw new UnsupportedOperationException("Can't reset Forge config value");
            }

            @Override
            public ConfigEntry<T> save() {
                configValue.save();
                return this;
            }

            @Override
            public ConfigEntry<T> saveSync() {
                throw new UnsupportedOperationException("Can't synchronously save Forge config value");
            }

            @Override
            public T getDefault() {
                throw new UnsupportedOperationException("Cannot get default config value");
            }

            @Override
            public Config getConfig() {
                return ForgeServerConfig.fromBuilder(configValue.next());
            }
        };
    }

    public static Config fromBuilder(ForgeConfigSpec.Builder builder) {
        Map entries;
        try {
            Field field = builder.getClass().getDeclaredField("storage");
            com.electronwill.nightconfig.core.Config config = (com.electronwill.nightconfig.core.Config)field.get(builder);
            entries = config.valueMap();
        }
        catch (Exception e) {
            entries = new HashMap();
        }
        HashMap finalEntries = entries;
        return () -> finalEntries;
    }
}

