/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.audio;

import com.sonicether.soundphysics.SoundPhysics;
import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.voice.client.SoundManager;
import de.maxhenkel.voicechat.voice.client.SpeakerException;
import de.maxhenkel.voicechat.voice.common.NamedThreadPoolFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import net.minecraftforge.fml.ModList;

public class ForgeSoundManager
extends SoundManager {
    private boolean soundPhysicsLoaded;
    private final ExecutorService executor = Executors.newSingleThreadExecutor(NamedThreadPoolFactory.create("VoiceChatSoundPhysicsThread"));

    public ForgeSoundManager(@Nullable String deviceName) throws SpeakerException {
        super(deviceName);
        if (!VoicechatClient.CLIENT_CONFIG.soundPhysics.get().booleanValue()) {
            return;
        }
        if (ModList.get().isLoaded("sound_physics_remastered")) {
            try {
                Class.forName("com.sonicether.soundphysics.SoundPhysics");
                this.initSoundPhysics();
                this.soundPhysicsLoaded = true;
                Voicechat.LOGGER.info("Successfully initialized Sound Physics Remastered");
            }
            catch (Exception e) {
                Voicechat.LOGGER.warn("Failed to load Sound Physics Remastered: {}", (Object)e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private void initSoundPhysics() {
        this.runInContext(this.executor, SoundPhysics::init);
    }

    public boolean isSoundPhysicsLoaded() {
        return this.soundPhysicsLoaded;
    }

    @Override
    public void close() {
        super.close();
        this.executor.shutdown();
    }
}

