/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat;

import de.maxhenkel.voicechat.ForgeVoicechatClientMod;
import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.config.ForgeClientConfig;
import de.maxhenkel.voicechat.config.ForgeServerConfig;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.intercompatibility.ForgeCommonCompatibilityManager;
import java.io.InputStream;
import java.util.Properties;
import java.util.function.Function;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="voicechat")
public class ForgeVoicechatMod
extends Voicechat {
    private final ForgeCommonCompatibilityManager compatibilityManager = new ForgeCommonCompatibilityManager();

    public ForgeVoicechatMod() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        SERVER_CONFIG = ForgeVoicechatMod.registerConfig(ModConfig.Type.SERVER, ForgeServerConfig::new);
        VoicechatClient.CLIENT_CONFIG = ForgeVoicechatMod.registerConfig(ModConfig.Type.CLIENT, ForgeClientConfig::new);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        this.initialize();
        MinecraftForge.EVENT_BUS.register((Object)this.compatibilityManager);
    }

    @SubscribeEvent
    public void clientSetup(FMLClientSetupEvent event) {
        new ForgeVoicechatClientMod();
    }

    @Override
    public int readCompatibilityVersion() throws Exception {
        InputStream in = this.getClass().getClassLoader().getResourceAsStream("compatibility.properties");
        Properties props = new Properties();
        props.load(in);
        return Integer.parseInt(props.getProperty("compatibility_version"));
    }

    @Override
    public CommonCompatibilityManager createCompatibilityManager() {
        return this.compatibilityManager;
    }

    public static <T> T registerConfig(ModConfig.Type type, Function<ForgeConfigSpec.Builder, T> consumer) {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        T config = consumer.apply(builder);
        ForgeConfigSpec spec = builder.build();
        ModLoadingContext.get().registerConfig(type, (IConfigSpec)spec);
        return config;
    }
}

