/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.mixinhandlers;

import fudge.notenoughcrashes.StateManager;
import fudge.notenoughcrashes.config.NecConfig;
import fudge.notenoughcrashes.gui.CrashScreen;
import fudge.notenoughcrashes.mixinhandlers.EntryPointCatcher;
import fudge.notenoughcrashes.patches.MinecraftClientAccess;
import fudge.notenoughcrashes.stacktrace.CrashUtils;
import fudge.notenoughcrashes.utils.GlUtil;
import fudge.notenoughcrashes.utils.NecLocalization;
import java.util.Queue;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.profiling.metrics.profiling.InactiveMetricsRecorder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InGameCatcher {
    private static final Logger LOGGER = LogManager.getLogger((String)"Not Enough Crashes In Game Crashes");
    private static int clientCrashCount = 0;
    private static int serverCrashCount = 0;

    public static void handleClientCrash(CrashReport report) {
        InGameCatcher.addInfoToCrash(report);
        InGameCatcher.resetStates();
        boolean reported = report.m_127524_() instanceof ReportedException;
        LOGGER.fatal(reported ? "Reported" : "Unreported exception thrown!", report.m_127524_());
        InGameCatcher.displayCrashScreen(report, ++clientCrashCount, true);
        InGameCatcher.getClient().m_91374_();
    }

    private static void resetStates() {
        GlUtil.resetState();
        StateManager.resetStates();
        InGameCatcher.resetModState();
        InGameCatcher.resetCriticalGameState();
    }

    public static void cleanupBeforeMinecraft(Queue<Runnable> renderTaskQueue) {
        if (InGameCatcher.getClient().m_91403_() != null) {
            InGameCatcher.getClient().m_91403_().m_104910_().m_129507_(Component.m_130674_((String)String.format("[%s] Client crashed", "Not Enough Crashes")));
        }
        InGameCatcher.getClient().m_91320_((Screen)new GenericDirtMessageScreen(NecLocalization.translatedText("menu.savingLevel")));
        renderTaskQueue.clear();
    }

    private static void resetCriticalGameState() {
        Minecraft client = InGameCatcher.getClient();
        if (((MinecraftClientAccess)client).getRecorder().m_142763_()) {
            client.m_167946_(null);
            ((MinecraftClientAccess)client).setRecorder(InactiveMetricsRecorder.f_146153_);
        }
        client.f_91074_ = null;
        client.f_91073_ = null;
    }

    private static void resetModState() {
    }

    public static void handleServerCrash(CrashReport report) {
        InGameCatcher.addInfoToCrash(report);
        InGameCatcher.displayCrashScreen(report, ++serverCrashCount, false);
    }

    private static Minecraft getClient() {
        return Minecraft.m_91087_();
    }

    public static void addInfoToCrash(CrashReport report) {
        report.m_178626_().m_143522_("Client Crashes Since Restart", () -> String.valueOf(clientCrashCount));
        report.m_178626_().m_143522_("Integrated Server Crashes Since Restart", () -> String.valueOf(serverCrashCount));
    }

    private static void displayCrashScreen(CrashReport report, int crashCount, boolean clientCrash) {
        try {
            if (EntryPointCatcher.crashedDuringStartup()) {
                throw new IllegalStateException("Could not initialize startup crash screen");
            }
            if (crashCount > NecConfig.getCurrent().crashLimit()) {
                throw new IllegalStateException("The game has crashed an excessive amount of times");
            }
            CrashUtils.outputReport(report, clientCrash);
            InGameCatcher.getClient().f_91065_.m_93076_().m_93795_(true);
            InGameCatcher.getClient().m_91152_((Screen)new CrashScreen(report));
        }
        catch (Throwable t) {
            LOGGER.error("An uncaught exception occured while displaying the crash screen, making normal report instead", t);
            Minecraft.m_91332_((CrashReport)report);
            System.exit(report.m_127527_() != null ? -1 : -2);
        }
    }
}

