/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.gui;

import fudge.notenoughcrashes.NotEnoughCrashes;
import fudge.notenoughcrashes.gui.util.TextWidget;
import fudge.notenoughcrashes.gui.util.Widget;
import fudge.notenoughcrashes.platform.CommonModMetadata;
import fudge.notenoughcrashes.stacktrace.ModIdentifier;
import fudge.notenoughcrashes.upload.CrashyUpload;
import fudge.notenoughcrashes.upload.LegacyCrashLogUpload;
import fudge.notenoughcrashes.utils.NecLocalization;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.CrashReport;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class ProblemScreen
extends Screen {
    private static final Set<String> IGNORED_MODS = new HashSet<String>(Arrays.asList("minecraft", "fabricloader", "loadcatcher", "jumploader", "quilt_loader", "forge", "notenoughcrashes"));
    private static final int GREEN = 65280;
    private static final int GRAY = 0x9A9A9A;
    private static final Component uploadToCrashyText = NecLocalization.translatedText("notenoughcrashes.gui.uploadToCrashy").m_6881_().m_6270_(Style.f_131099_.m_178520_(65280));
    private static final Component uploadToCrashyLoadingText = NecLocalization.translatedText("notenoughcrashes.gui.loadingCrashyUpload");
    private List<Widget> widgets = new ArrayList<Widget>();
    protected CrashReport report;
    private String uploadedCrashLink = null;
    protected int xLeft = Integer.MAX_VALUE;
    protected int xRight = Integer.MIN_VALUE;
    protected int yTop = Integer.MAX_VALUE;
    protected int yBottom = Integer.MIN_VALUE;
    protected int x;
    protected int y;
    private String crashyLink = null;

    protected void addWidget(Widget widget) {
        this.widgets.add(widget);
    }

    public abstract ProblemScreen construct(CrashReport var1);

    protected ProblemScreen(CrashReport report) {
        super(Component.m_130674_((String)""));
        this.report = report;
    }

    private Component getSuspectedModsText() {
        Set<CommonModMetadata> suspectedMods = ModIdentifier.getSuspectedModsOf(this.report);
        suspectedMods.removeIf(mod -> IGNORED_MODS.contains(mod.id()));
        if (suspectedMods.isEmpty()) {
            return NecLocalization.translatedText("notenoughcrashes.crashscreen.noModsErrored");
        }
        return (Component)suspectedMods.stream().sorted(Comparator.comparing(CommonModMetadata::name)).map(mod -> {
            String issuesPage = mod.issuesPage();
            MutableComponent modText = Component.m_237113_((String)mod.name());
            if (issuesPage != null) {
                modText.m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, issuesPage)));
            }
            return modText;
        }).reduce((existing, next) -> existing.m_7220_(Component.m_130674_((String)", ")).m_7220_((Component)next)).get();
    }

    private void addSuspectedModsWidget() {
        this.addWidget(new TextWidget(this.getSuspectedModsText(), 0xE0E000, this.f_96547_, this.f_96543_ / 2, this.y + 29));
    }

    private void handleLegacyLinkClick(Button buttonWidget) {
        try {
            if (this.uploadedCrashLink == null) {
                this.uploadedCrashLink = LegacyCrashLogUpload.upload(this.report.m_127526_());
            }
            Minecraft.m_91087_().m_91152_((Screen)new ConfirmLinkScreen(b -> {
                if (b) {
                    Util.m_137581_().m_137646_(this.uploadedCrashLink);
                }
                Minecraft.m_91087_().m_91152_((Screen)this.construct(this.report));
            }, this.uploadedCrashLink, true));
        }
        catch (Throwable e) {
            NotEnoughCrashes.getLogger().error("Exception when crash menu button clicked:", e);
            buttonWidget.m_93666_(NecLocalization.translatedText("notenoughcrashes.gui.failed"));
            buttonWidget.f_93623_ = false;
        }
    }

    private void handleCrashyUploadClick(Button buttonWidget) {
        try {
            if (this.crashyLink == null) {
                buttonWidget.f_93623_ = false;
                buttonWidget.m_93666_(uploadToCrashyLoadingText);
                CrashyUpload.uploadToCrashy(this.report.m_127526_()).thenAccept(link -> {
                    this.crashyLink = link;
                    buttonWidget.f_93623_ = true;
                    buttonWidget.m_93666_(uploadToCrashyText);
                    Util.m_137581_().m_137646_(this.crashyLink);
                });
            } else {
                Util.m_137581_().m_137646_(this.crashyLink);
            }
        }
        catch (Throwable e) {
            NotEnoughCrashes.getLogger().error("Exception uploading to crashy", e);
            buttonWidget.m_93666_(NecLocalization.translatedText("notenoughcrashes.gui.failed"));
            buttonWidget.f_93623_ = false;
        }
    }

    public void m_7856_() {
        this.widgets = new ArrayList<Widget>();
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)NecLocalization.translatedText("notenoughcrashes.gui.getLink").m_6881_().m_6270_(Style.f_131099_.m_178520_(0x9A9A9A)), this::handleLegacyLinkClick).m_252987_(this.f_96543_ / 2 - 155 + 160, this.f_96544_ / 4 + 144 + 12, 150, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)uploadToCrashyText, this::handleCrashyUploadClick).m_252987_(this.f_96543_ / 2 - 155 + 160, this.f_96544_ / 4 + 120 + 12, 150, 20).m_253136_());
        this.x = this.f_96543_ / 2 - 155;
        this.y = this.f_96544_ / 4;
        this.addSuspectedModsWidget();
    }

    public boolean m_6375_(double x, double y, int int_1) {
        File file;
        for (Widget widget : this.widgets) {
            widget.onClick(x, y);
        }
        if (x >= (double)this.xLeft && x <= (double)this.xRight && y >= (double)this.yTop && y <= (double)this.yBottom && (file = this.report.m_127527_()) != null) {
            Util.m_137581_().m_137644_(file);
        }
        return super.m_6375_(x, y, int_1);
    }

    public boolean m_6913_() {
        return false;
    }

    protected void drawFileNameString(GuiGraphics context, int y) {
        String fileNameString = this.report.m_127527_() != null ? "\u00a7n" + this.report.m_127527_().getName() : NecLocalization.localize("notenoughcrashes.crashscreen.reportSaveFailed");
        int stLen = this.f_96547_.m_92895_(fileNameString);
        this.xLeft = this.f_96543_ / 2 - stLen / 2;
        this.xRight = this.f_96543_ / 2 + stLen / 2;
        context.m_280488_(this.f_96547_, fileNameString, this.xLeft, y += 11, 65280);
        this.yTop = y;
        this.yBottom = y + 10;
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        for (Widget widget : this.widgets) {
            widget.draw(context);
        }
        super.m_88315_(context, mouseX, mouseY, delta);
    }
}

