/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import info.journeymap.shaded.org.jetbrains.annotations.NotNull;
import java.awt.Color;
import journeymap.client.Constants;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class TextBox
extends EditBox {
    protected final String numericRegex;
    protected final boolean numeric;
    protected final boolean allowNegative;
    protected int minLength;
    protected Integer clampMin;
    protected Integer clampMax;
    private long lastClick = 0L;

    public TextBox(Object text, Font fontRenderer, int width, int height) {
        this(text, fontRenderer, width, height, false, false);
    }

    public TextBox(Object text, Font fontRenderer, int width, int height, boolean isNumeric, boolean negative) {
        super(fontRenderer, 0, 0, width, height, (Component)Constants.getStringTextComponent(text.toString()));
        this.m_94199_(256);
        this.m_94144_(text.toString());
        this.numeric = isNumeric;
        this.allowNegative = negative;
        String regex = null;
        if (this.numeric) {
            regex = this.allowNegative ? "[^-?\\d]" : "[^\\d]";
        }
        this.numericRegex = regex;
    }

    public void setClamp(Integer min, Integer max) {
        this.clampMin = min;
        this.clampMax = max;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public void m_94164_(@NotNull String par1Str) {
        if (this.numeric) {
            String fixed = par1Str.replaceAll(this.numericRegex, "");
            if (this.allowNegative) {
                par1Str = "-".equals(fixed) && this.m_94207_() != 0 && !this.isAllSelected() ? "" : fixed;
            }
        }
        super.m_94164_(par1Str);
    }

    public void setText(Object object) {
        super.m_94144_(object.toString());
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public boolean hasMinLength() {
        String text = this.m_94155_();
        int textLen = text == null ? 0 : text.length();
        return this.minLength <= textLen;
    }

    public boolean m_5534_(char c, int key) {
        boolean typed = false;
        if (this.m_198029_()) {
            typed = super.m_5534_(c, key);
            if (this.numeric && typed) {
                this.clamp();
            }
        }
        return typed;
    }

    public boolean m_7933_(int key, int value, int modifier) {
        boolean pressed = false;
        if (this.m_198029_()) {
            pressed = super.m_7933_(key, value, modifier);
        }
        return pressed;
    }

    public boolean m_6348_(double mouseX, double mouseY, int mouseButton) {
        return super.m_6348_(mouseX, mouseY, mouseButton);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double mouseDX, double mouseDY) {
        if (this.m_5953_(mouseX, mouseY)) {
            if (this.m_93696_() && button == 0) {
                int i = Mth.m_14107_((double)mouseX) - super.m_252754_();
                if (this.m_94219_()) {
                    i -= 4;
                }
                String s = this.f_94092_.m_92834_(this.m_94155_().substring(this.f_94100_), this.m_94210_());
                this.m_94208_(this.f_94092_.m_92834_(s, i).length() + this.f_94100_);
                return true;
            }
            return super.m_7979_(mouseX, mouseY, button, mouseDX, mouseDY);
        }
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        super.m_94208_(super.m_94207_());
        if (this.m_5953_(mouseX, mouseY) && super.m_6375_(mouseX, mouseY, mouseButton)) {
            long sysTime = Util.m_137550_();
            boolean doubleClick = sysTime - this.lastClick < 200L;
            this.lastClick = sysTime;
            if (doubleClick) {
                this.selectAll();
            }
            this.m_93692_(true);
            return true;
        }
        this.m_93692_(false);
        return false;
    }

    public void m_93692_(boolean focused) {
        super.m_93692_(focused);
    }

    public void selectAll() {
        this.m_94201_(false);
        this.m_94208_(0);
    }

    public boolean isAllSelected() {
        return this.m_94155_().equals(this.m_94173_());
    }

    public void m_94196_(int position) {
        super.m_94196_(position);
    }

    public boolean m_274382_() {
        return this.f_93622_;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        if (this.m_94213_() && !this.hasMinLength()) {
            int red = Color.red.getRGB();
            int x1 = this.m_252754_() - 1;
            int y1 = this.m_252907_() - 1;
            int x2 = x1 + this.m_5711_() + 1;
            int y2 = y1 + this.m_93694_() + 1;
            graphics.m_280509_(x1, y1, x2, y1 + 1, red);
            graphics.m_280509_(x1, y2, x2, y2 + 1, red);
            graphics.m_280509_(x1, y1, x1 + 1, y2, red);
            graphics.m_280509_(x2, y1, x2 + 1, y2, red);
        }
    }

    public Integer clamp() {
        return this.clamp(this.m_94155_());
    }

    public Integer clamp(String text) {
        int val;
        if (!this.numeric) {
            return null;
        }
        if (this.clampMin != null) {
            if (text == null || text.length() == 0 || text.equals("-")) {
                return null;
            }
            try {
                val = Math.max(this.clampMin, Integer.parseInt(text));
            }
            catch (Exception e) {
                return this.clampMin;
            }
            if (this.clampMax != null) {
                try {
                    val = Math.min(this.clampMax, val);
                }
                catch (Exception e) {
                    return this.clampMax;
                }
            }
        } else {
            try {
                val = Integer.parseInt(text);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (val != Integer.parseInt(text)) {
            this.setText(val);
        }
        return val;
    }

    public int m_252754_() {
        return super.m_252754_();
    }

    public void m_252865_(int x) {
        super.m_252865_(x);
    }

    public int m_252907_() {
        return super.m_252907_();
    }

    public void m_253211_(int y) {
        super.m_253211_(y);
    }

    public int m_5711_() {
        return this.f_93618_;
    }

    public void m_93674_(int w) {
        this.f_93618_ = w;
    }

    public int m_93694_() {
        return this.f_93619_;
    }

    public void m_293384_(int h) {
        this.f_93619_ = h;
    }

    public int getCenterX() {
        return this.m_252754_() + this.m_5711_() / 2;
    }

    public int getMiddleY() {
        return this.m_252907_() + this.m_93694_() / 2;
    }

    public int getBottomY() {
        return this.m_252907_() + this.m_93694_();
    }

    public int getRightX() {
        return this.m_252754_() + this.m_5711_();
    }
}

