/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.widget.editbox;

import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinEditBox;
import de.keksuccino.fancymenu.util.input.CharacterFilter;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.widget.NavigatableWidget;
import de.keksuccino.fancymenu.util.rendering.ui.widget.UniqueWidget;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtendedEditBox
extends EditBox
implements UniqueWidget,
NavigatableWidget {
    private static final Logger LOGGER = LogManager.getLogger();
    protected CharacterFilter characterFilter;
    protected CharacterRenderFormatter characterRenderFormatter;
    protected DrawableColor backgroundColor = DrawableColor.of(new Color(0, 0, 0));
    protected DrawableColor borderNormalColor = DrawableColor.of(new Color(-6250336));
    protected DrawableColor borderFocusedColor = DrawableColor.of(new Color(255, 255, 255));
    protected DrawableColor textColor = DrawableColor.of(new Color(0xE0E0E0));
    protected DrawableColor textColorUneditable = DrawableColor.of(new Color(0x707070));
    protected DrawableColor suggestionTextColor = DrawableColor.of(new Color(-8355712));
    protected boolean textShadow = true;
    protected final Font font;
    @Nullable
    protected String identifier;
    protected boolean focusable = true;
    protected boolean navigatable = true;
    protected boolean canConsumeUserInput = true;
    @Nullable
    protected String inputPrefix;
    @Nullable
    protected String inputSuffix;

    public ExtendedEditBox(Font font, int x, int y, int width, int height, Component hint) {
        super(font, x, y, width, height, hint);
        this.font = font;
    }

    public ExtendedEditBox(Font font, int x, int y, int width, int height, @Nullable EditBox editBox, Component hint) {
        super(font, x, y, width, height, editBox, hint);
        this.font = font;
    }

    public void m_87963_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        IMixinEditBox access = (IMixinEditBox)((Object)this);
        boolean bordered = access.getBorderedFancyMenu();
        if (this.m_94213_()) {
            Component hint;
            graphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, this.backgroundColor.getColorInt());
            if (bordered) {
                int borderColor = this.m_93696_() ? this.borderFocusedColor.getColorInt() : this.borderNormalColor.getColorInt();
                UIBase.renderBorder(graphics, (float)(this.m_252754_() - 1), (float)(this.m_252907_() - 1), (float)(this.m_252754_() + this.f_93618_ + 1), (float)(this.m_252907_() + this.f_93619_ + 1), 1.0f, borderColor, true, true, true, true);
            }
            int textColor = access.getIsEditableFancyMenu() ? this.textColor.getColorInt() : this.textColorUneditable.getColorInt();
            int cursorPos = this.m_94207_() - access.getDisplayPosFancyMenu();
            int highlightPos = access.getHighlightPosFancyMenu() - access.getDisplayPosFancyMenu();
            String text = this.font.m_92834_(this.m_94155_().substring(access.getDisplayPosFancyMenu()), this.m_94210_());
            boolean isCursorInsideVisibleText = cursorPos >= 0 && cursorPos <= text.length();
            boolean isCursorVisible = this.m_93696_() && (Util.m_137550_() - ((IMixinEditBox)((Object)this)).getFocusedTimeFancyMenu()) / 300L % 2L == 0L && isCursorInsideVisibleText;
            int textX = bordered ? this.m_252754_() + 4 : this.m_252754_();
            int textY = bordered ? this.m_252907_() + (this.f_93619_ - 8) / 2 : this.m_252907_();
            int textXAfterCursor = textX;
            if (highlightPos > text.length()) {
                highlightPos = text.length();
            }
            int textCharacterRenderIndex = access.getDisplayPosFancyMenu();
            if (!text.isEmpty()) {
                String textBeforeCursor = isCursorInsideVisibleText ? text.substring(0, cursorPos) : text;
                MutableComponent beforeCursorComp = Component.m_237113_((String)"");
                if (this.characterRenderFormatter == null) {
                    beforeCursorComp = Component.m_237113_((String)textBeforeCursor);
                } else {
                    for (char c : textBeforeCursor.toCharArray()) {
                        MutableComponent comp = this.characterRenderFormatter.formatComponent(this, Component.m_237113_((String)String.valueOf(c)), textCharacterRenderIndex, c, text, this.m_94155_());
                        beforeCursorComp.m_7220_((Component)comp);
                        ++textCharacterRenderIndex;
                    }
                }
                textXAfterCursor = graphics.m_280614_(this.font, (Component)beforeCursorComp, textX, textY, textColor, this.textShadow);
            }
            boolean renderSmallCursor = this.m_94207_() < this.m_94155_().length() || this.m_94155_().length() >= access.getMaxLengthFancyMenu();
            int finalTextXAfterCursor = textXAfterCursor;
            if (!isCursorInsideVisibleText) {
                finalTextXAfterCursor = cursorPos > 0 ? textX + this.f_93618_ : textX;
            } else if (renderSmallCursor) {
                finalTextXAfterCursor = textXAfterCursor - 1;
                if (this.textShadow) {
                    --textXAfterCursor;
                }
            }
            if (!text.isEmpty() && isCursorInsideVisibleText && cursorPos < text.length()) {
                String textAfterCursor = text.substring(cursorPos);
                MutableComponent afterCursorComp = Component.m_237113_((String)"");
                if (this.characterRenderFormatter == null) {
                    afterCursorComp = Component.m_237113_((String)textAfterCursor);
                } else {
                    for (char c : textAfterCursor.toCharArray()) {
                        MutableComponent comp = this.characterRenderFormatter.formatComponent(this, Component.m_237113_((String)String.valueOf(c)), textCharacterRenderIndex, c, text, this.m_94155_());
                        afterCursorComp.m_7220_((Component)comp);
                        ++textCharacterRenderIndex;
                    }
                }
                graphics.m_280614_(this.font, (Component)afterCursorComp, textXAfterCursor, textY, textColor, this.textShadow);
            }
            if ((hint = access.getHintFancyMenu()) != null && text.isEmpty() && !this.m_93696_()) {
                graphics.m_280614_(this.font, hint, textXAfterCursor, textY, textColor, this.textShadow);
            }
            if (!renderSmallCursor && access.getSuggestionFancyMenu() != null) {
                graphics.m_280056_(this.font, access.getSuggestionFancyMenu(), finalTextXAfterCursor - 1, textY, this.suggestionTextColor.getColorInt(), this.textShadow);
            }
            if (isCursorVisible) {
                if (renderSmallCursor) {
                    graphics.m_280509_(finalTextXAfterCursor, textY - 1, finalTextXAfterCursor + 1, textY + 1 + 9, textColor);
                } else {
                    Objects.requireNonNull(this.font);
                    Objects.requireNonNull(this.font);
                    graphics.m_280509_(finalTextXAfterCursor, textY + 9 - 2, finalTextXAfterCursor + 5, textY + 9 - 1, textColor);
                }
            }
            if (highlightPos != cursorPos) {
                int l1 = textX + this.font.m_92895_(text.substring(0, highlightPos));
                access.invokeRenderHighlightFancyMenu(graphics, finalTextXAfterCursor, textY - 1, l1 - 1, textY + 1 + 9);
            }
        }
    }

    public void m_293384_(int height) {
        this.f_93619_ = height;
    }

    public int getDisplayPosition() {
        return ((IMixinEditBox)((Object)this)).getDisplayPosFancyMenu();
    }

    public void setDisplayPosition(int position) {
        ((IMixinEditBox)((Object)this)).setDisplayPosFancyMenu(position);
    }

    public int getHighlightPosition() {
        return ((IMixinEditBox)((Object)this)).getHighlightPosFancyMenu();
    }

    @Nullable
    public CharacterFilter getCharacterFilter() {
        return this.characterFilter;
    }

    public ExtendedEditBox setCharacterFilter(@Nullable CharacterFilter characterFilter) {
        this.characterFilter = characterFilter;
        return this;
    }

    public boolean hasTextShadow() {
        return this.textShadow;
    }

    public ExtendedEditBox setTextShadow(boolean textShadow) {
        this.textShadow = textShadow;
        return this;
    }

    @NotNull
    public DrawableColor getBackgroundColor() {
        return this.backgroundColor;
    }

    public ExtendedEditBox setBackgroundColor(@NotNull DrawableColor backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @NotNull
    public DrawableColor getBorderNormalColor() {
        return this.borderNormalColor;
    }

    public ExtendedEditBox setBorderNormalColor(@NotNull DrawableColor borderNormalColor) {
        this.borderNormalColor = borderNormalColor;
        return this;
    }

    @NotNull
    public DrawableColor getBorderFocusedColor() {
        return this.borderFocusedColor;
    }

    public ExtendedEditBox setBorderFocusedColor(@NotNull DrawableColor borderFocusedColor) {
        this.borderFocusedColor = borderFocusedColor;
        return this;
    }

    @Nullable
    public CharacterRenderFormatter getCharacterRenderFormatter() {
        return this.characterRenderFormatter;
    }

    public ExtendedEditBox setCharacterRenderFormatter(@Nullable CharacterRenderFormatter characterRenderFormatter) {
        this.characterRenderFormatter = characterRenderFormatter;
        return this;
    }

    @NotNull
    public DrawableColor getTextColor() {
        return this.textColor;
    }

    public ExtendedEditBox setTextColor(@NotNull DrawableColor textColor) {
        this.textColor = textColor;
        return this;
    }

    @NotNull
    public DrawableColor getTextColorUneditable() {
        return this.textColorUneditable;
    }

    public ExtendedEditBox setTextColorUneditable(@NotNull DrawableColor textColorUneditable) {
        this.textColorUneditable = textColorUneditable;
        return this;
    }

    @NotNull
    public DrawableColor getSuggestionTextColor() {
        return this.suggestionTextColor;
    }

    public ExtendedEditBox setSuggestionTextColor(@NotNull DrawableColor suggestionTextColor) {
        this.suggestionTextColor = suggestionTextColor;
        return this;
    }

    public boolean canConsumeUserInput() {
        return this.canConsumeUserInput;
    }

    public ExtendedEditBox setCanConsumeUserInput(boolean canConsumeUserInput) {
        this.canConsumeUserInput = canConsumeUserInput;
        return this;
    }

    @Nullable
    public String getInputPrefix() {
        return this.inputPrefix;
    }

    public ExtendedEditBox setInputPrefix(@Nullable String inputPrefix) {
        this.inputPrefix = inputPrefix;
        this.m_94144_(this.getValueWithoutPrefixSuffix());
        return this;
    }

    @Nullable
    public String getInputSuffix() {
        return this.inputSuffix;
    }

    public ExtendedEditBox setInputSuffix(@Nullable String inputSuffix) {
        this.inputSuffix = inputSuffix;
        this.m_94144_(this.getValueWithoutPrefixSuffix());
        return this;
    }

    public ExtendedEditBox applyInputPrefixSuffixCharacterRenderFormatter() {
        this.setCharacterRenderFormatter((editBox, component, characterIndex, character, visiblePartOfLine, fullLine) -> {
            if (this.inputSuffix != null && characterIndex > Math.max(0, editBox.m_94155_().length() - this.inputSuffix.length() - 1)) {
                component.m_130948_(Style.f_131099_.m_178520_(this.getTextColorUneditable().getColorInt()));
            }
            if (this.inputPrefix != null && characterIndex < this.inputPrefix.length()) {
                component.m_130948_(Style.f_131099_.m_178520_(this.getTextColorUneditable().getColorInt()));
            }
            return component;
        });
        return this;
    }

    @Deprecated
    public void m_94202_(int color) {
        this.textColor = DrawableColor.of(new Color(color));
    }

    @Deprecated
    public void m_94205_(int color) {
        this.textColorUneditable = DrawableColor.of(new Color(color));
    }

    public void m_94144_(@NotNull String value) {
        Object v = this.getWithoutPrefixSuffix(value);
        if (this.inputPrefix != null) {
            v = this.inputPrefix + (String)v;
        }
        if (this.inputSuffix != null) {
            v = (String)v + this.inputSuffix;
        }
        super.m_94144_((String)v);
    }

    public boolean m_5534_(char character, int modifiers) {
        if (this.characterFilter != null && !this.characterFilter.isAllowedChar(character)) {
            return false;
        }
        return super.m_5534_(character, modifiers);
    }

    public void m_94164_(@NotNull String textToWrite) {
        if (this.isInPrefixSuffix(this.m_94207_(), 0, 0)) {
            return;
        }
        if (this.isInPrefixSuffix(this.getHighlightPosition(), 0, 0)) {
            return;
        }
        if (this.characterFilter != null) {
            textToWrite = this.characterFilter.filterForAllowedChars(textToWrite);
        }
        super.m_94164_(textToWrite);
    }

    public void m_94180_(int i) {
        if (this.isInPrefixSuffix(this.m_94207_(), -1, -1) || this.isInPrefixSuffix(this.m_94207_(), 0, 0)) {
            return;
        }
        if (this.isInPrefixSuffix(this.getHighlightPosition(), 0, 0)) {
            return;
        }
        super.m_94180_(i);
    }

    public boolean isInPrefixSuffix(int index, int prefixIndexOffset, int suffixIndexOffset) {
        int cursorPrefix = index + prefixIndexOffset;
        int cursorSuffix = index + suffixIndexOffset;
        if (this.inputPrefix != null && cursorPrefix < this.inputPrefix.length()) {
            return true;
        }
        if (this.inputSuffix != null) {
            int i;
            int n = i = this.inputPrefix != null ? this.inputPrefix.length() + this.getValueWithoutPrefixSuffix().length() : this.getValueWithoutPrefixSuffix().length();
            if (cursorSuffix > i) {
                return true;
            }
        }
        return false;
    }

    public String getValueWithoutPrefixSuffix() {
        return this.getWithoutPrefixSuffix(this.m_94155_());
    }

    protected String getWithoutPrefixSuffix(@NotNull String value) {
        String v;
        if (value.isEmpty()) {
            return value;
        }
        boolean containsPrefix = this.inputPrefix != null && value.startsWith(this.inputPrefix);
        boolean containsSuffix = this.inputSuffix != null && value.endsWith(this.inputSuffix);
        String string = v = containsPrefix ? value.substring(this.inputPrefix.length()) : value;
        if (containsSuffix) {
            v = v.substring(0, Math.max(0, v.length() - this.inputSuffix.length()));
        }
        return v;
    }

    public boolean m_7933_(int keycode, int scancode, int modifiers) {
        if (!this.canConsumeUserInput) {
            return false;
        }
        if (Screen.m_96634_((int)keycode) && (this.inputPrefix != null || this.inputSuffix != null)) {
            if (this.inputSuffix != null) {
                this.m_94192_(this.m_94155_().length() - this.inputSuffix.length(), false);
            } else {
                this.m_94201_(false);
            }
            this.m_94208_(this.inputPrefix != null ? this.inputPrefix.length() : 0);
            return true;
        }
        return super.m_7933_(keycode, scancode, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.canConsumeUserInput) {
            return false;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return false;
    }

    public ExtendedEditBox setWidgetIdentifierFancyMenu(@Nullable String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Override
    @Nullable
    public String getWidgetIdentifierFancyMenu() {
        return this.identifier;
    }

    public void m_93692_(boolean focused) {
        if (!this.focusable) {
            super.m_93692_(false);
            return;
        }
        super.m_93692_(focused);
    }

    public boolean m_93696_() {
        if (!this.focusable) {
            return false;
        }
        return super.m_93696_();
    }

    @Override
    public boolean isFocusable() {
        return this.focusable;
    }

    @Override
    public void setFocusable(boolean focusable) {
        this.focusable = focusable;
    }

    @Override
    public boolean isNavigatable() {
        return this.navigatable;
    }

    @Override
    public void setNavigatable(boolean navigatable) {
        this.navigatable = navigatable;
    }

    @FunctionalInterface
    public static interface CharacterRenderFormatter {
        @NotNull
        public MutableComponent formatComponent(@NotNull ExtendedEditBox var1, @NotNull MutableComponent var2, int var3, char var4, @NotNull String var5, @NotNull String var6);
    }
}

