/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.screen;

import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotificationScreen
extends Screen {
    protected List<Component> textLines;
    protected DrawableColor headlineColor;
    protected boolean headlineBold = false;
    protected Consumer<Boolean> callback;
    protected ExtendedButton okayButton;

    @NotNull
    public static NotificationScreen error(@NotNull Consumer<Boolean> callback, Component ... textLines) {
        return NotificationScreen.ofComponents(callback, textLines).setHeadlineBold(true).setHeadlineColor(UIBase.getUIColorTheme().error_text_color);
    }

    @NotNull
    public static NotificationScreen error(@NotNull Consumer<Boolean> callback, String ... textLines) {
        return NotificationScreen.ofStrings(callback, textLines).setHeadlineBold(true).setHeadlineColor(UIBase.getUIColorTheme().error_text_color);
    }

    @NotNull
    public static NotificationScreen warning(@NotNull Consumer<Boolean> callback, Component ... textLines) {
        return NotificationScreen.ofComponents(callback, textLines).setHeadlineBold(true).setHeadlineColor(UIBase.getUIColorTheme().warning_text_color);
    }

    @NotNull
    public static NotificationScreen warning(@NotNull Consumer<Boolean> callback, String ... textLines) {
        return NotificationScreen.ofStrings(callback, textLines).setHeadlineBold(true).setHeadlineColor(UIBase.getUIColorTheme().warning_text_color);
    }

    @NotNull
    public static NotificationScreen notificationWithHeadline(@NotNull Consumer<Boolean> callback, Component ... textLines) {
        return NotificationScreen.ofComponents(callback, textLines).setHeadlineBold(true);
    }

    @NotNull
    public static NotificationScreen notificationWithHeadline(@NotNull Consumer<Boolean> callback, String ... textLines) {
        return NotificationScreen.ofStrings(callback, textLines).setHeadlineBold(true);
    }

    @NotNull
    public static NotificationScreen ofStrings(@NotNull Consumer<Boolean> callback, String ... textLines) {
        NotificationScreen s = new NotificationScreen(callback, new ArrayList<Component>());
        for (String line : textLines) {
            s.textLines.add((Component)Component.m_237113_((String)line));
        }
        return s;
    }

    @NotNull
    public static NotificationScreen ofStrings(@NotNull Consumer<Boolean> callback, @NotNull List<String> textLines) {
        return NotificationScreen.ofStrings(callback, textLines.toArray(new String[0]));
    }

    @NotNull
    public static NotificationScreen ofComponents(@NotNull Consumer<Boolean> callback, Component ... textLines) {
        return new NotificationScreen(callback, Arrays.asList(textLines));
    }

    @NotNull
    public static NotificationScreen ofComponents(@NotNull Consumer<Boolean> callback, @NotNull List<Component> textLines) {
        return new NotificationScreen(callback, textLines);
    }

    protected NotificationScreen(@NotNull Consumer<Boolean> callback, @NotNull List<Component> textLines) {
        super((Component)(!textLines.isEmpty() ? textLines.get(0) : Component.m_237119_()));
        this.callback = callback;
        this.textLines = textLines;
    }

    protected void m_7856_() {
        this.okayButton = new ExtendedButton(0, 0, 150, 20, (Component)Component.m_237115_((String)"fancymenu.guicomponents.ok"), button -> this.callback.accept(true));
        this.m_7787_((GuiEventListener)this.okayButton);
        UIBase.applyDefaultWidgetSkinTo(this.okayButton);
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, UIBase.getUIColorTheme().screen_background_color.getColorInt());
        int y = this.f_96544_ / 2 - this.textLines.size() * 14 / 2;
        int lineCounter = 0;
        for (Component c : this.textLines) {
            MutableComponent line = c.m_6881_();
            if (lineCounter == 0) {
                if (this.headlineColor != null) {
                    line.m_6270_(line.m_7383_().m_178520_(this.headlineColor.getColorInt()));
                }
                if (this.headlineBold) {
                    line.m_6270_(line.m_7383_().m_131136_(Boolean.valueOf(true)));
                }
            }
            int textWidth = this.f_96547_.m_92852_((FormattedText)line);
            graphics.m_280614_(this.f_96547_, (Component)line, this.f_96543_ / 2 - textWidth / 2, y, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
            y += 14;
            ++lineCounter;
        }
        this.okayButton.m_252865_(this.f_96543_ / 2 - this.okayButton.m_5711_() / 2);
        this.okayButton.m_253211_(this.f_96544_ - 40);
        this.okayButton.m_88315_(graphics, mouseX, mouseY, partial);
        super.m_88315_(graphics, mouseX, mouseY, partial);
    }

    public void m_280273_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
    }

    @Nullable
    public DrawableColor getHeadlineColor() {
        return this.headlineColor;
    }

    public NotificationScreen setHeadlineColor(@Nullable DrawableColor headlineColor) {
        this.headlineColor = headlineColor;
        return this;
    }

    public boolean isHeadlineBold() {
        return this.headlineBold;
    }

    public NotificationScreen setHeadlineBold(boolean headlineBold) {
        this.headlineBold = headlineBold;
        return this;
    }

    public boolean m_7933_(int button, int p_96553_, int p_96554_) {
        if (button == 257) {
            this.callback.accept(true);
            return true;
        }
        return super.m_7933_(button, p_96553_, p_96554_);
    }

    public void m_7379_() {
        this.callback.accept(true);
    }
}

