/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.networking;

import de.keksuccino.fancymenu.networking.PacketHandler;
import de.keksuccino.fancymenu.networking.PacketHandlerForge;
import de.keksuccino.fancymenu.networking.bridge.BridgePacketHandlerForge;
import de.keksuccino.fancymenu.networking.bridge.BridgePacketMessageForge;
import de.keksuccino.fancymenu.networking.packets.Packets;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.PacketDistributor;

public class PacketsForge {
    public static void init() {
        Packets.registerAll();
        PacketsForge.registerForgeBridgePacket();
        PacketHandler.setSendToClientLogic((player, s) -> {
            BridgePacketMessageForge msg = new BridgePacketMessageForge();
            msg.direction = "client";
            msg.dataWithIdentifier = s;
            PacketHandlerForge.send(PacketDistributor.PLAYER.with(player), msg);
        });
        PacketHandler.setSendToServerLogic(s -> {
            BridgePacketMessageForge msg = new BridgePacketMessageForge();
            msg.direction = "server";
            msg.dataWithIdentifier = s;
            PacketHandlerForge.sendToServer(msg);
        });
    }

    private static void registerForgeBridgePacket() {
        PacketHandlerForge.registerMessage(BridgePacketMessageForge.class, (msg, buf) -> {
            buf.m_130070_(msg.direction);
            buf.m_130070_(msg.dataWithIdentifier);
        }, buf -> {
            BridgePacketMessageForge msg = new BridgePacketMessageForge();
            msg.direction = buf.m_130277_();
            msg.dataWithIdentifier = buf.m_130277_();
            return msg;
        }, (msg, context) -> {
            context.enqueueWork(() -> {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                    if (msg.direction.equals("server")) {
                        BridgePacketHandlerForge.handle(context.getSender(), msg, PacketHandler.PacketDirection.TO_SERVER);
                    } else if (msg.direction.equals("client")) {
                        BridgePacketHandlerForge.handle(null, msg, PacketHandler.PacketDirection.TO_CLIENT);
                    }
                });
                DistExecutor.unsafeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> {
                    if (msg.direction.equals("server")) {
                        BridgePacketHandlerForge.handle(context.getSender(), msg, PacketHandler.PacketDirection.TO_SERVER);
                    }
                });
            });
            context.setPacketHandled(true);
        });
    }
}

