/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.overlay;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.overlay.CustomizationOverlayMenuBar;
import de.keksuccino.fancymenu.customization.overlay.CustomizationOverlayUI;
import de.keksuccino.fancymenu.customization.overlay.DebugOverlay;
import de.keksuccino.fancymenu.events.screen.InitOrResizeScreenCompletedEvent;
import de.keksuccino.fancymenu.events.screen.RenderScreenEvent;
import de.keksuccino.fancymenu.events.screen.ScreenKeyPressedEvent;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.event.acara.EventListener;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CustomizableScreen;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class CustomizationOverlay {
    private static final Logger LOGGER = LogManager.getLogger();
    private static CustomizationOverlayMenuBar overlayMenuBar;
    private static DebugOverlay debugOverlay;

    public static void init() {
        EventHandler.INSTANCE.registerListenersOf(new CustomizationOverlay());
    }

    public static void rebuildOverlay() {
        overlayMenuBar = CustomizationOverlayUI.buildMenuBar(overlayMenuBar == null || overlayMenuBar.isExpanded());
        CustomizationOverlay.rebuildDebugOverlay();
    }

    public static void rebuildDebugOverlay() {
        if (debugOverlay != null) {
            debugOverlay.resetOverlay();
        }
        debugOverlay = CustomizationOverlayUI.buildDebugOverlay(overlayMenuBar);
    }

    @Nullable
    public static CustomizationOverlayMenuBar getCurrentMenuBarInstance() {
        return overlayMenuBar;
    }

    @Nullable
    public static DebugOverlay getCurrentDebugOverlayInstance() {
        return debugOverlay;
    }

    @EventListener(priority=-1000)
    public void onInitScreenPost(InitOrResizeScreenCompletedEvent e) {
        if (!ScreenCustomization.isScreenBlacklisted(e.getScreen().getClass().getName())) {
            CustomizationOverlay.rebuildOverlay();
            if (overlayMenuBar != null && debugOverlay != null) {
                CustomizableScreen c;
                Screen screen;
                if (FancyMenu.getOptions().showCustomizationOverlay.getValue().booleanValue()) {
                    e.getWidgets().add(0, overlayMenuBar);
                    screen = e.getScreen();
                    if (screen instanceof CustomizableScreen) {
                        c = (CustomizableScreen)screen;
                        c.removeOnInitChildrenFancyMenu().add(overlayMenuBar);
                    }
                }
                if (FancyMenu.getOptions().showDebugOverlay.getValue().booleanValue()) {
                    e.getWidgets().add(1, (GuiEventListener)debugOverlay);
                    screen = e.getScreen();
                    if (screen instanceof CustomizableScreen) {
                        c = (CustomizableScreen)screen;
                        c.removeOnInitChildrenFancyMenu().add((GuiEventListener)debugOverlay);
                    }
                }
            } else {
                LOGGER.error("[FANCYMENU] Failed to rebuild overlay!", (Throwable)new NullPointerException("Debug or Customization overlay was NULL!"));
            }
        }
    }

    @EventListener(priority=-1)
    public void onRenderPost(RenderScreenEvent.Post e) {
        if (!ScreenCustomization.isScreenBlacklisted(e.getScreen().getClass().getName()) && overlayMenuBar != null && debugOverlay != null) {
            if (FancyMenu.getOptions().showDebugOverlay.getValue().booleanValue()) {
                CustomizationOverlay.debugOverlay.allowRender = true;
                debugOverlay.m_88315_(e.getGraphics(), e.getMouseX(), e.getMouseY(), e.getPartial());
                CustomizationOverlay.debugOverlay.allowRender = false;
            }
            if (FancyMenu.getOptions().showCustomizationOverlay.getValue().booleanValue()) {
                CustomizationOverlay.overlayMenuBar.allowRender = true;
                overlayMenuBar.m_88315_(e.getGraphics(), e.getMouseX(), e.getMouseY(), e.getPartial());
                CustomizationOverlay.overlayMenuBar.allowRender = false;
            }
        }
    }

    @EventListener
    public void onScreenKeyPressed(ScreenKeyPressedEvent e) {
        if (!ScreenCustomization.isScreenBlacklisted(e.getScreen().getClass().getName())) {
            String keyName = e.getKeyName();
            if (keyName.equals("c") && Screen.m_96637_() && Screen.m_96639_()) {
                FancyMenu.getOptions().showCustomizationOverlay.setValue(FancyMenu.getOptions().showCustomizationOverlay.getValue() == false);
                ScreenCustomization.reInitCurrentScreen();
            }
            if (keyName.equals("d") && Screen.m_96637_() && Screen.m_96639_()) {
                FancyMenu.getOptions().showDebugOverlay.setValue(FancyMenu.getOptions().showDebugOverlay.getValue() == false);
                ScreenCustomization.reInitCurrentScreen();
            }
            if (keyName.equals("r") && Screen.m_96637_() && Screen.m_96639_()) {
                ScreenCustomization.reloadFancyMenu();
            }
        }
    }
}

