/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.loadingrequirement.requirements;

import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirement;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementInstance;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.StringBuilderScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorFormattingRule;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.EditBoxSuggestions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class IsLanguageRequirement
extends LoadingRequirement {
    public IsLanguageRequirement() {
        super("fancymenu_loading_requirement_is_language");
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isRequirementMet(@Nullable String value) {
        if (value != null) {
            return Minecraft.m_91087_().f_91066_.f_92075_.equalsIgnoreCase(value);
        }
        return false;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return I18n.m_118938_((String)"fancymenu.helper.editor.items.visibilityrequirements.language", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.helper.editor.items.visibilityrequirements.language.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return null;
    }

    @Override
    public String getValueDisplayName() {
        return "";
    }

    @Override
    public String getValuePreset() {
        return "en_us";
    }

    @Override
    public List<TextEditorFormattingRule> getValueFormattingRules() {
        return null;
    }

    @Override
    public void editValue(@NotNull Screen parentScreen, @NotNull LoadingRequirementInstance requirementInstance) {
        IsLanguageValueConfigScreen s = new IsLanguageValueConfigScreen(Objects.requireNonNullElse(requirementInstance.value, ""), callback -> {
            if (callback != null) {
                requirementInstance.value = callback;
            }
            Minecraft.m_91087_().m_91152_(parentScreen);
        });
        Minecraft.m_91087_().m_91152_((Screen)s);
    }

    public static class IsLanguageValueConfigScreen
    extends StringBuilderScreen {
        @NotNull
        protected String langId;
        protected CellScreen.TextInputCell langIdCell;
        protected EditBoxSuggestions langIdSuggestions;

        protected IsLanguageValueConfigScreen(@NotNull String value, @NotNull Consumer<String> callback) {
            super((Component)Component.m_237115_((String)"fancymenu.editor.elements.visibilityrequirements.edit_value"), callback);
            this.langId = value;
        }

        @Override
        protected void initCells() {
            this.addSpacerCell(20);
            String id = this.getLangIdString();
            this.addLabelCell((Component)Component.m_237115_((String)"fancymenu.loading_requirements.is_language.lang_id"));
            this.langIdCell = this.addTextInputCell(null, true, true).setText(id);
            this.addCellGroupEndSpacerCell();
            this.langIdSuggestions = EditBoxSuggestions.createWithCustomSuggestions(this, this.langIdCell.editBox, EditBoxSuggestions.SuggestionsRenderPosition.ABOVE_EDIT_BOX, new ArrayList<String>(Minecraft.m_91087_().m_91102_().m_264450_().keySet()));
            UIBase.applyDefaultWidgetSkinTo(this.langIdSuggestions);
            this.langIdCell.editBox.m_94151_(s -> this.langIdSuggestions.m_93881_());
            this.addSpacerCell(20);
        }

        @Override
        public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partial) {
            super.m_88315_(graphics, mouseX, mouseY, partial);
            this.langIdSuggestions.m_280540_(graphics, mouseX, mouseY);
        }

        @Override
        public boolean m_7933_(int $$0, int $$1, int $$2) {
            if (this.langIdSuggestions.m_93888_($$0, $$1, $$2)) {
                return true;
            }
            return super.m_7933_($$0, $$1, $$2);
        }

        public boolean m_6050_(double $$0, double $$1, double scrollDeltaX, double scrollDeltaY) {
            if (this.langIdSuggestions.m_93882_(scrollDeltaY)) {
                return true;
            }
            return super.m_6050_($$0, $$1, scrollDeltaX, scrollDeltaY);
        }

        public boolean m_6375_(double $$0, double $$1, int $$2) {
            if (this.langIdSuggestions.m_93884_($$0, $$1, $$2)) {
                return true;
            }
            return super.m_6375_($$0, $$1, $$2);
        }

        @Override
        @NotNull
        public String buildString() {
            return this.getLangIdString();
        }

        @NotNull
        protected String getLangIdString() {
            if (this.langIdCell != null) {
                return this.langIdCell.getText();
            }
            return this.langId;
        }
    }
}

