/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.layer;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Window;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.animation.AnimationHandler;
import de.keksuccino.fancymenu.customization.deep.AbstractDeepElement;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.elements.button.vanillawidget.VanillaWidgetElement;
import de.keksuccino.fancymenu.customization.layer.ElementFactory;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.customization.layout.Layout;
import de.keksuccino.fancymenu.customization.layout.LayoutBase;
import de.keksuccino.fancymenu.customization.layout.LayoutHandler;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementContainer;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.customization.screen.identifier.ScreenIdentifierHandler;
import de.keksuccino.fancymenu.customization.widget.ScreenWidgetDiscoverer;
import de.keksuccino.fancymenu.customization.widget.WidgetMeta;
import de.keksuccino.fancymenu.events.ModReloadEvent;
import de.keksuccino.fancymenu.events.screen.CloseScreenEvent;
import de.keksuccino.fancymenu.events.screen.InitOrResizeScreenEvent;
import de.keksuccino.fancymenu.events.screen.OpenScreenEvent;
import de.keksuccino.fancymenu.events.screen.OpenScreenPostInitEvent;
import de.keksuccino.fancymenu.events.screen.RenderScreenEvent;
import de.keksuccino.fancymenu.events.screen.RenderedScreenBackgroundEvent;
import de.keksuccino.fancymenu.events.screen.ScreenTickEvent;
import de.keksuccino.fancymenu.events.widget.RenderGuiListBackgroundEvent;
import de.keksuccino.fancymenu.events.widget.RenderGuiListHeaderFooterEvent;
import de.keksuccino.fancymenu.events.widget.RenderTabNavigationBarHeaderBackgroundEvent;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinAbstractSelectionList;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinScreen;
import de.keksuccino.fancymenu.util.ScreenTitleUtils;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.event.acara.EventListener;
import de.keksuccino.fancymenu.util.file.GameDirectoryUtils;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CustomizableScreen;
import de.keksuccino.fancymenu.util.resource.resources.audio.IAudio;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.math.MathUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScreenCustomizationLayer
implements ElementFactory {
    private static final Logger LOGGER = LogManager.getLogger();
    protected String screenIdentifier;
    public LayoutBase layoutBase = new LayoutBase();
    @NotNull
    public List<AbstractElement> allElements = new ArrayList<AbstractElement>();
    public Layout.OrderedElementCollection normalElements = new Layout.OrderedElementCollection();
    public List<VanillaWidgetElement> vanillaWidgetElements = new ArrayList<VanillaWidgetElement>();
    public List<AbstractDeepElement> deepElements = new ArrayList<AbstractDeepElement>();
    public Map<String, RandomLayoutContainer> randomLayoutGroups = new HashMap<String, RandomLayoutContainer>();
    public List<Layout> activeLayouts = new ArrayList<Layout>();
    public List<String> delayAppearanceFirstTime = new ArrayList<String>();
    public List<ThreadCaller> delayThreads = new ArrayList<ThreadCaller>();
    public boolean backgroundDrawable;
    public boolean forceDisableCustomMenuTitle = false;
    public float backgroundOpacity = 1.0f;
    public Map<LoadingRequirementContainer, Boolean> cachedLayoutWideLoadingRequirements = new HashMap<LoadingRequirementContainer, Boolean>();
    @NotNull
    public List<WidgetMeta> cachedScreenWidgetMetas = new ArrayList<WidgetMeta>();
    public boolean loadEarly = false;
    public static Map<Class<?>, Component> cachedOriginalMenuTitles = new HashMap();

    public ScreenCustomizationLayer(@NotNull String screenIdentifier) {
        Objects.requireNonNull(screenIdentifier);
        this.screenIdentifier = screenIdentifier;
        EventHandler.INSTANCE.registerListenersOf(this);
    }

    @NotNull
    public String getScreenIdentifier() {
        return this.screenIdentifier;
    }

    public void resetLayer() {
        this.delayAppearanceFirstTime.clear();
        for (RandomLayoutContainer c : this.randomLayoutGroups.values()) {
            c.lastLayoutPath = null;
        }
    }

    @EventListener
    public void onModReload(ModReloadEvent e) {
        this.resetLayer();
    }

    @EventListener
    public void onOpenScreen(OpenScreenEvent e) {
        if (!this.shouldCustomize(e.getScreen())) {
            return;
        }
        if (!cachedOriginalMenuTitles.containsKey(e.getScreen().getClass())) {
            cachedOriginalMenuTitles.put(e.getScreen().getClass(), e.getScreen().m_96636_());
        }
    }

    @EventListener
    public void onOpenScreenPostInit(OpenScreenPostInitEvent e) {
        if (!this.shouldCustomize(e.getScreen())) {
            return;
        }
        this.allElements.forEach(AbstractElement::onOpenScreen);
        if (this.layoutBase.menuBackground != null) {
            this.layoutBase.menuBackground.onOpenScreen();
        }
    }

    @EventListener
    public void onCloseScreen(CloseScreenEvent e) {
        IAudio audio;
        if (!this.shouldCustomize(e.getScreen())) {
            return;
        }
        this.allElements.forEach(element -> {
            element.onCloseScreen();
            element.onDestroyElement();
        });
        if (this.layoutBase.menuBackground != null) {
            this.layoutBase.menuBackground.onCloseScreen();
        }
        if (this.layoutBase.closeAudio != null && (audio = this.layoutBase.closeAudio.get()) != null) {
            audio.stop();
            audio.play();
        }
    }

    @EventListener
    public void onInitOrResizeScreenPre(InitOrResizeScreenEvent.Pre e) {
        for (ThreadCaller t : this.delayThreads) {
            t.running.set(false);
        }
        this.delayThreads.clear();
        if (!this.shouldCustomize(e.getScreen())) {
            return;
        }
        this.allElements.forEach(element -> {
            if (e.getInitializationPhase() == InitOrResizeScreenEvent.InitializationPhase.RESIZE) {
                element.onBeforeResizeScreen();
            }
            element.onDestroyElement();
        });
        if (e.getInitializationPhase() == InitOrResizeScreenEvent.InitializationPhase.RESIZE && this.layoutBase.menuBackground != null) {
            this.layoutBase.menuBackground.onBeforeResizeScreen();
        }
        List<Layout> rawLayouts = LayoutHandler.getEnabledLayoutsForScreenIdentifier(this.getScreenIdentifier(), true);
        ArrayList<Layout> normalLayouts = new ArrayList<Layout>();
        this.activeLayouts.clear();
        this.layoutBase = new LayoutBase();
        this.normalElements = new Layout.OrderedElementCollection();
        this.vanillaWidgetElements.clear();
        this.deepElements.clear();
        this.allElements.clear();
        this.backgroundOpacity = 1.0f;
        this.backgroundDrawable = false;
        this.cachedLayoutWideLoadingRequirements.clear();
        for (RandomLayoutContainer randomLayoutContainer : this.randomLayoutGroups.values()) {
            randomLayoutContainer.onlyFirstTime = false;
            randomLayoutContainer.clearLayouts();
        }
        for (Layout layout : rawLayouts) {
            LoadingRequirementContainer loadingRequirementContainer = layout.layoutWideLoadingRequirementContainer;
            this.cachedLayoutWideLoadingRequirements.put(loadingRequirementContainer, loadingRequirementContainer.requirementsMet());
            if (!loadingRequirementContainer.requirementsMet()) continue;
            if (layout.randomMode) {
                RandomLayoutContainer randomContainer;
                String group = layout.randomGroup;
                if (!this.randomLayoutGroups.containsKey(group)) {
                    this.randomLayoutGroups.put(group, new RandomLayoutContainer(group, this));
                }
                if ((randomContainer = this.randomLayoutGroups.get(group)) == null) continue;
                randomContainer.setOnlyFirstTime(layout.randomOnlyFirstTime);
                randomContainer.addLayout(layout);
                continue;
            }
            normalLayouts.add(layout);
        }
        ArrayList<String> trashLayoutGroups = new ArrayList<String>();
        for (Map.Entry<String, RandomLayoutContainer> entry : this.randomLayoutGroups.entrySet()) {
            if (!entry.getValue().getLayouts().isEmpty()) continue;
            trashLayoutGroups.add(entry.getKey());
        }
        for (String string : trashLayoutGroups) {
            this.randomLayoutGroups.remove(string);
        }
        this.activeLayouts = new ArrayList<Layout>(normalLayouts);
        this.randomLayoutGroups.values().forEach(container -> this.activeLayouts.add(container.getRandomLayout()));
        this.layoutBase = LayoutBase.stackLayoutBases(this.activeLayouts.toArray(new LayoutBase[0]));
        Window window = Minecraft.m_91087_().m_91268_();
        if (this.layoutBase.forcedScale != 0.0f) {
            float f = this.layoutBase.forcedScale;
            if (f <= 0.0f) {
                f = 1.0f;
            }
            window.m_85378_((double)f);
            e.getScreen().f_96543_ = window.m_85445_();
            e.getScreen().f_96544_ = window.m_85446_();
        }
        if (this.layoutBase.autoScalingWidth != 0 && this.layoutBase.autoScalingHeight != 0 && this.layoutBase.forcedScale != 0.0f) {
            double d = (double)e.getScreen().f_96543_ * window.m_85449_();
            double guiHeight = (double)e.getScreen().f_96544_ * window.m_85449_();
            double percentX = d / (double)this.layoutBase.autoScalingWidth * 100.0;
            double percentY = guiHeight / (double)this.layoutBase.autoScalingHeight * 100.0;
            double newScaleX = percentX / 100.0 * window.m_85449_();
            double newScaleY = percentY / 100.0 * window.m_85449_();
            double newScale = Math.min(newScaleX, newScaleY);
            window.m_85378_(newScale);
            e.getScreen().f_96543_ = window.m_85445_();
            e.getScreen().f_96544_ = window.m_85446_();
        }
    }

    @EventListener
    public void onInitOrResizeScreenPost(InitOrResizeScreenEvent.Post e) {
        Iterator audio;
        if (!this.shouldCustomize(e.getScreen())) {
            return;
        }
        if (ScreenCustomization.isNewMenu() && this.layoutBase.openAudio != null && (audio = this.layoutBase.openAudio.get()) != null) {
            audio.stop();
            audio.play();
        }
        this.cachedScreenWidgetMetas = ScreenWidgetDiscoverer.getWidgetsOfScreen(e.getScreen(), false, false);
        this.constructElementInstances(this.getScreenIdentifier(), this.cachedScreenWidgetMetas, this.activeLayouts, this.normalElements, this.vanillaWidgetElements, this.deepElements);
        this.allElements.addAll(this.normalElements.backgroundElements);
        this.allElements.addAll(this.normalElements.foregroundElements);
        this.allElements.addAll(this.deepElements);
        this.allElements.addAll(this.vanillaWidgetElements);
        for (AbstractElement ae : this.allElements) {
            List widgetsToRegister;
            if (ScreenCustomization.isNewMenu()) {
                this.handleAppearanceDelayFor(ae);
            }
            if ((widgetsToRegister = ae.getWidgetsToRegister()) != null) {
                widgetsToRegister = Lists.reverse(widgetsToRegister);
                for (GuiEventListener w : widgetsToRegister) {
                    if (!(w instanceof NarratableEntry) || ((IMixinScreen)e.getScreen()).getChildrenFancyMenu().contains(w)) continue;
                    ((IMixinScreen)e.getScreen()).getChildrenFancyMenu().add(0, w);
                    Screen screen = e.getScreen();
                    if (!(screen instanceof CustomizableScreen)) continue;
                    CustomizableScreen c = (CustomizableScreen)screen;
                    c.removeOnInitChildrenFancyMenu().add(w);
                }
            }
            if (!(ae instanceof VanillaWidgetElement)) continue;
            VanillaWidgetElement v = (VanillaWidgetElement)ae;
            v.updateWidget();
        }
        for (AbstractElement ae : Lists.reverse(this.allElements)) {
            ((IMixinScreen)e.getScreen()).getChildrenFancyMenu().add(0, ae);
            Screen screen = e.getScreen();
            if (!(screen instanceof CustomizableScreen)) continue;
            CustomizableScreen c = (CustomizableScreen)screen;
            c.removeOnInitChildrenFancyMenu().add(ae);
        }
        if (this.layoutBase.menuBackground != null) {
            ((IMixinScreen)e.getScreen()).getChildrenFancyMenu().add(0, this.layoutBase.menuBackground);
            Screen screen = e.getScreen();
            if (screen instanceof CustomizableScreen) {
                CustomizableScreen c = (CustomizableScreen)screen;
                c.removeOnInitChildrenFancyMenu().add(this.layoutBase.menuBackground);
            }
        }
        if (e.getInitializationPhase() == InitOrResizeScreenEvent.InitializationPhase.RESIZE && this.layoutBase.menuBackground != null) {
            this.layoutBase.menuBackground.onAfterResizeScreen();
        }
    }

    protected void handleAppearanceDelayFor(AbstractElement element) {
        if (element.appearanceDelay != null && element.appearanceDelay != AbstractElement.AppearanceDelay.NO_DELAY) {
            if (element.appearanceDelay == AbstractElement.AppearanceDelay.FIRST_TIME && this.delayAppearanceFirstTime.contains(element.getInstanceIdentifier())) {
                return;
            }
            if (element.appearanceDelay == AbstractElement.AppearanceDelay.FIRST_TIME && !this.delayAppearanceFirstTime.contains(element.getInstanceIdentifier())) {
                this.delayAppearanceFirstTime.add(element.getInstanceIdentifier());
            }
            element.visible = false;
            if (element.fadeIn) {
                element.opacity = 0.1f;
            }
            ThreadCaller c = new ThreadCaller();
            this.delayThreads.add(c);
            new Thread(() -> {
                long start = System.currentTimeMillis();
                float delay = (float)(1000.0 * (double)element.appearanceDelayInSeconds);
                boolean fade = false;
                while (c.running.get()) {
                    try {
                        long now = System.currentTimeMillis();
                        if (!fade) {
                            if (now >= start + (long)((int)delay)) {
                                element.visible = true;
                                if (!element.fadeIn) {
                                    return;
                                }
                                fade = true;
                            }
                        } else {
                            float o = element.opacity + 0.03f * element.fadeInSpeed;
                            if (o > 1.0f) {
                                o = 1.0f;
                            }
                            if (element.opacity < 1.0f) {
                                element.opacity = o;
                            } else {
                                return;
                            }
                        }
                        Thread.sleep(50L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }).start();
        }
    }

    @EventListener
    public void onScreenTickPre(ScreenTickEvent.Post e) {
        if (!this.shouldCustomize(e.getScreen())) {
            return;
        }
        if (this.layoutBase.menuBackground != null) {
            this.layoutBase.menuBackground.tick();
        }
        for (AbstractElement element : this.allElements) {
            element.tick();
        }
    }

    @EventListener(priority=3)
    public void onRenderPre(RenderScreenEvent.Pre e) {
        if (!this.shouldCustomize(e.getScreen())) {
            return;
        }
        for (Map.Entry<LoadingRequirementContainer, Boolean> m : this.cachedLayoutWideLoadingRequirements.entrySet()) {
            if (m.getKey().requirementsMet() == m.getValue().booleanValue()) continue;
            ScreenCustomization.reInitCurrentScreen();
            break;
        }
        if (this.layoutBase.customMenuTitle != null && !this.forceDisableCustomMenuTitle) {
            ScreenTitleUtils.setScreenTitle(e.getScreen(), (Component)Component.m_237113_((String)PlaceholderParser.replacePlaceholders(this.layoutBase.customMenuTitle)));
        }
    }

    @EventListener
    public void onRenderPost(RenderScreenEvent.Post e) {
        if (!this.shouldCustomize(e.getScreen())) {
            return;
        }
        if (!this.backgroundDrawable) {
            for (AbstractElement abstractElement : new ArrayList<AbstractElement>(this.normalElements.backgroundElements)) {
                abstractElement.m_88315_(e.getGraphics(), e.getMouseX(), e.getMouseY(), e.getPartial());
            }
        }
        for (AbstractElement abstractElement : new ArrayList<VanillaWidgetElement>(this.vanillaWidgetElements)) {
            abstractElement.m_88315_(e.getGraphics(), e.getMouseX(), e.getMouseY(), e.getPartial());
        }
        for (AbstractElement abstractElement : new ArrayList<AbstractDeepElement>(this.deepElements)) {
            abstractElement.m_88315_(e.getGraphics(), e.getMouseX(), e.getMouseY(), e.getPartial());
        }
        for (AbstractElement abstractElement : new ArrayList<AbstractElement>(this.normalElements.foregroundElements)) {
            abstractElement.m_88315_(e.getGraphics(), e.getMouseX(), e.getMouseY(), e.getPartial());
        }
    }

    @EventListener
    public void drawToBackground(RenderedScreenBackgroundEvent e) {
        if (!ScreenCustomization.isCurrentMenuScrollable()) {
            this.renderBackground(e.getGraphics(), MouseInput.getMouseX(), MouseInput.getMouseY(), Minecraft.m_91087_().m_91297_(), e.getScreen());
        }
    }

    @EventListener
    public void onRenderListBackground(RenderGuiListBackgroundEvent.Post e) {
        Screen s = Minecraft.m_91087_().f_91080_;
        if (s != null && this.shouldCustomize(s)) {
            this.renderBackground(e.getGraphics(), MouseInput.getMouseX(), MouseInput.getMouseY(), Minecraft.m_91087_().m_91297_(), s);
        }
    }

    @EventListener
    public void onRenderListHeaderFooterPre(RenderGuiListHeaderFooterEvent.Pre e) {
        GuiGraphics graphics = e.getGraphics();
        if (this.shouldCustomize(Minecraft.m_91087_().f_91080_)) {
            ResourceLocation loc;
            ITexture footerTexture;
            IMixinAbstractSelectionList access = (IMixinAbstractSelectionList)e.getList();
            ITexture headerTexture = this.layoutBase.scrollListHeaderTexture != null ? this.layoutBase.scrollListHeaderTexture.get() : null;
            ITexture iTexture = footerTexture = this.layoutBase.scrollListFooterTexture != null ? this.layoutBase.scrollListFooterTexture.get() : null;
            if (headerTexture != null) {
                e.setCanceled(true);
                loc = headerTexture.getResourceLocation();
                if (loc != null) {
                    RenderingUtils.resetShaderColor(graphics);
                    if (this.layoutBase.preserveScrollListHeaderFooterAspectRatio) {
                        int[] headerSize = headerTexture.getAspectRatio().getAspectRatioSizeByMinimumSize(access.getWidthFancyMenu(), access.getY0FancyMenu());
                        int headerWidth = headerSize[0];
                        int headerHeight = headerSize[1];
                        int headerX = access.getX0FancyMenu() + access.getWidthFancyMenu() / 2 - headerWidth / 2;
                        int headerY = access.getY0FancyMenu() / 2 - headerHeight / 2;
                        graphics.m_280588_(access.getX0FancyMenu(), 0, access.getX0FancyMenu() + access.getWidthFancyMenu(), access.getY0FancyMenu());
                        graphics.m_280163_(loc, headerX, headerY, 0.0f, 0.0f, headerWidth, headerHeight, headerWidth, headerHeight);
                        graphics.m_280618_();
                    } else if (this.layoutBase.repeatScrollListHeaderTexture) {
                        RenderingUtils.blitRepeat(graphics, loc, access.getX0FancyMenu(), 0, access.getWidthFancyMenu(), access.getY0FancyMenu(), headerTexture.getWidth(), headerTexture.getHeight());
                    } else {
                        graphics.m_280163_(loc, access.getX0FancyMenu(), 0, 0.0f, 0.0f, access.getWidthFancyMenu(), access.getY0FancyMenu(), access.getWidthFancyMenu(), access.getY0FancyMenu());
                    }
                }
            }
            if (footerTexture != null) {
                e.setCanceled(true);
                loc = footerTexture.getResourceLocation();
                if (loc != null) {
                    RenderingUtils.resetShaderColor(graphics);
                    if (this.layoutBase.preserveScrollListHeaderFooterAspectRatio) {
                        int footerOriginalHeight = access.getHeightFancyMenu() - access.getY1FancyMenu();
                        int[] footerSize = footerTexture.getAspectRatio().getAspectRatioSizeByMinimumSize(access.getWidthFancyMenu(), footerOriginalHeight);
                        int footerWidth = footerSize[0];
                        int footerHeight = footerSize[1];
                        int footerX = access.getX0FancyMenu() + access.getWidthFancyMenu() / 2 - footerWidth / 2;
                        int footerY = access.getY1FancyMenu() + footerOriginalHeight / 2 - footerHeight / 2;
                        graphics.m_280588_(access.getX0FancyMenu(), access.getY1FancyMenu(), access.getX0FancyMenu() + access.getWidthFancyMenu(), access.getY1FancyMenu() + footerOriginalHeight);
                        graphics.m_280163_(loc, footerX, footerY, 0.0f, 0.0f, footerWidth, footerHeight, footerWidth, footerHeight);
                        graphics.m_280618_();
                    } else if (this.layoutBase.repeatScrollListFooterTexture) {
                        int footerHeight = access.getHeightFancyMenu() - access.getY1FancyMenu();
                        RenderingUtils.blitRepeat(graphics, loc, access.getX0FancyMenu(), access.getY1FancyMenu(), access.getWidthFancyMenu(), footerHeight, footerTexture.getWidth(), footerTexture.getHeight());
                    } else {
                        int footerHeight = access.getHeightFancyMenu() - access.getY1FancyMenu();
                        graphics.m_280163_(loc, access.getX0FancyMenu(), access.getY1FancyMenu(), 0.0f, 0.0f, access.getWidthFancyMenu(), footerHeight, access.getWidthFancyMenu(), footerHeight);
                    }
                }
            }
            RenderingUtils.resetShaderColor(graphics);
            if (this.layoutBase.renderScrollListHeaderShadow) {
                graphics.m_280024_(access.getX0FancyMenu(), access.getY0FancyMenu(), access.getX1FancyMenu(), access.getY0FancyMenu() + 4, -16777216, 0);
            }
            if (this.layoutBase.renderScrollListFooterShadow) {
                graphics.m_280024_(access.getX0FancyMenu(), access.getY1FancyMenu() - 4, access.getX1FancyMenu(), access.getY1FancyMenu(), 0, -16777216);
            }
            RenderingUtils.resetShaderColor(graphics);
        }
    }

    @EventListener
    public void onRenderTabNavigationBarHeaderBackgroundPre(RenderTabNavigationBarHeaderBackgroundEvent.Pre e) {
        GuiGraphics graphics = e.getGraphics();
        if (this.shouldCustomize(Minecraft.m_91087_().f_91080_)) {
            ResourceLocation loc;
            ITexture headerTexture;
            ITexture iTexture = headerTexture = this.layoutBase.scrollListHeaderTexture != null ? this.layoutBase.scrollListHeaderTexture.get() : null;
            if (headerTexture != null && (loc = headerTexture.getResourceLocation()) != null) {
                e.setCanceled(true);
                RenderingUtils.resetShaderColor(graphics);
                if (this.layoutBase.preserveScrollListHeaderFooterAspectRatio) {
                    int[] headerSize = headerTexture.getAspectRatio().getAspectRatioSizeByMinimumSize(e.getHeaderWidth(), e.getHeaderHeight());
                    int headerWidth = headerSize[0];
                    int headerHeight = headerSize[1];
                    int headerX = e.getHeaderWidth() / 2 - headerWidth / 2;
                    int headerY = e.getHeaderHeight() / 2 - headerHeight / 2;
                    graphics.m_280588_(0, 0, e.getHeaderWidth(), e.getHeaderHeight());
                    graphics.m_280163_(loc, headerX, headerY, 0.0f, 0.0f, headerWidth, headerHeight, headerWidth, headerHeight);
                    graphics.m_280618_();
                } else if (this.layoutBase.repeatScrollListHeaderTexture) {
                    RenderingUtils.blitRepeat(graphics, loc, 0, 0, e.getHeaderWidth(), e.getHeaderHeight(), headerTexture.getWidth(), headerTexture.getHeight());
                } else {
                    graphics.m_280163_(loc, 0, 0, 0.0f, 0.0f, e.getHeaderWidth(), e.getHeaderHeight(), e.getHeaderWidth(), e.getHeaderHeight());
                }
                RenderingUtils.resetShaderColor(graphics);
            }
        }
    }

    protected void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partial, Screen screen) {
        if (!this.shouldCustomize(screen)) {
            return;
        }
        if (this.layoutBase.menuBackground != null) {
            this.layoutBase.menuBackground.keepBackgroundAspectRatio = this.layoutBase.preserveBackgroundAspectRatio;
            this.layoutBase.menuBackground.opacity = this.backgroundOpacity;
            this.layoutBase.menuBackground.m_88315_(graphics, mouseX, mouseY, partial);
            this.layoutBase.menuBackground.opacity = 1.0f;
        }
        for (AbstractElement elements : new ArrayList<AbstractElement>(this.normalElements.backgroundElements)) {
            elements.m_88315_(graphics, mouseX, mouseY, partial);
        }
        this.backgroundDrawable = true;
    }

    @Nullable
    public AbstractElement getElementByInstanceIdentifier(String instanceIdentifier) {
        instanceIdentifier = instanceIdentifier.replace("vanillabtn:", "").replace("button_compatibility_id:", "");
        for (AbstractElement element : this.allElements) {
            if (!element.getInstanceIdentifier().equals(instanceIdentifier)) continue;
            return element;
        }
        return null;
    }

    protected boolean shouldCustomize(@Nullable Screen screen) {
        if (screen == null) {
            return false;
        }
        if (ScreenCustomizationLayerHandler.isBeforeFinishInitialMinecraftReload() && !this.loadEarly) {
            return false;
        }
        if (!ScreenIdentifierHandler.isIdentifierOfScreen(this.getScreenIdentifier(), screen)) {
            return false;
        }
        return ScreenCustomization.isCustomizationEnabledForScreen(screen);
    }

    public static class RandomLayoutContainer {
        public final String id;
        protected List<Layout> layouts = new ArrayList<Layout>();
        protected boolean onlyFirstTime = false;
        protected String lastLayoutPath = null;
        public ScreenCustomizationLayer parent;

        public RandomLayoutContainer(String id, ScreenCustomizationLayer parent) {
            this.id = id;
            this.parent = parent;
        }

        public List<Layout> getLayouts() {
            return this.layouts;
        }

        public void addLayout(Layout layout) {
            this.layouts.add(layout);
        }

        public void addLayouts(List<Layout> layouts) {
            this.layouts.addAll(layouts);
        }

        public void clearLayouts() {
            this.layouts.clear();
        }

        public void setOnlyFirstTime(boolean b) {
            this.onlyFirstTime = b;
        }

        public boolean isOnlyFirstTime() {
            return this.onlyFirstTime;
        }

        public void resetLastLayout() {
            this.lastLayoutPath = null;
        }

        @Nullable
        public Layout getRandomLayout() {
            if (!this.layouts.isEmpty()) {
                if ((this.onlyFirstTime || !ScreenCustomization.isNewMenu()) && this.lastLayoutPath != null) {
                    File f = new File(GameDirectoryUtils.getAbsoluteGameDirectoryPath(this.lastLayoutPath));
                    if (f.exists()) {
                        for (Layout layout : this.layouts) {
                            if (layout.layoutFile == null || !layout.layoutFile.getAbsolutePath().replace("\\", "/").equals(f.getAbsolutePath())) continue;
                            return layout;
                        }
                    } else {
                        AnimationHandler.resetAnimations();
                        AnimationHandler.resetAnimationSounds();
                        AnimationHandler.stopAnimationSounds();
                    }
                }
                int i = MathUtils.getRandomNumberInRange((int)0, (int)(this.layouts.size() - 1));
                Layout layout = this.layouts.get(i);
                if (layout.layoutFile != null) {
                    this.lastLayoutPath = layout.layoutFile.getAbsolutePath();
                    return layout;
                }
            }
            return null;
        }
    }

    public static class ThreadCaller {
        AtomicBoolean running = new AtomicBoolean(true);
    }
}

