/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element;

import com.google.common.collect.Lists;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.SerializedElement;
import de.keksuccino.fancymenu.customization.element.anchor.ElementAnchorPoints;
import de.keksuccino.fancymenu.customization.element.editor.AbstractEditorElement;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementContainer;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.SerializationUtils;
import de.keksuccino.fancymenu.util.file.ResourceFile;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.audio.IAudio;
import de.keksuccino.fancymenu.util.resource.resources.text.IText;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.fancymenu.util.resource.resources.video.IVideo;
import de.keksuccino.konkrete.math.MathUtils;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ElementBuilder<E extends AbstractElement, L extends AbstractEditorElement> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String identifier;

    public ElementBuilder(@NotNull String uniqueElementIdentifier) {
        this.identifier = uniqueElementIdentifier;
    }

    @NotNull
    public abstract E buildDefaultInstance();

    public abstract E deserializeElement(@NotNull SerializedElement var1);

    @Nullable
    public E deserializeElementInternal(@NotNull SerializedElement serialized) {
        try {
            String loadingRequirementContainerIdentifier;
            String stretchYString;
            String stretchXString;
            String h;
            String w;
            String anchorElement;
            String anchor;
            String delaySec;
            AbstractElement.AppearanceDelay appearanceDelay;
            String delay;
            String fis;
            E element = this.deserializeElement(serialized);
            String id = serialized.getValue("instance_identifier");
            if (id == null) {
                id = serialized.getValue("actionid");
            }
            if (id == null) {
                id = ScreenCustomization.generateUniqueIdentifier();
            }
            if (id.equals("null")) {
                id = ScreenCustomization.generateUniqueIdentifier();
                LOGGER.warn("[FANCYMENU] Automatically corrected broken element instance identifier from 'null' to '" + id + "'! This could break parts of its parent layout!");
            }
            ((AbstractElement)element).setInstanceIdentifier(id);
            ((AbstractElement)element).customElementLayerName = serialized.getValue("custom_element_layer_name");
            String fi = serialized.getValue("fade_in");
            if (fi == null) {
                fi = serialized.getValue("fadein");
            }
            if (fi != null && fi.equalsIgnoreCase("true")) {
                ((AbstractElement)element).fadeIn = true;
            }
            if ((fis = serialized.getValue("fade_in_speed")) == null) {
                fis = serialized.getValue("fadeinspeed");
            }
            if (fis != null && MathUtils.isFloat((String)fis)) {
                ((AbstractElement)element).fadeInSpeed = Float.parseFloat(fis);
            }
            if ((delay = serialized.getValue("appearance_delay")) == null) {
                String dae;
                String da = serialized.getValue("delayappearance");
                if (da != null && da.equalsIgnoreCase("true")) {
                    delay = AbstractElement.AppearanceDelay.FIRST_TIME.name;
                }
                if ((dae = serialized.getValue("delayappearanceeverytime")) != null && dae.equalsIgnoreCase("true")) {
                    delay = AbstractElement.AppearanceDelay.EVERY_TIME.name;
                }
            }
            if (delay != null && (appearanceDelay = AbstractElement.AppearanceDelay.getByName(delay)) != null) {
                ((AbstractElement)element).appearanceDelay = appearanceDelay;
            }
            if ((delaySec = serialized.getValue("appearance_delay_seconds")) == null) {
                delaySec = serialized.getValue("delayappearanceseconds");
            }
            if (delaySec != null && MathUtils.isFloat((String)delaySec)) {
                ((AbstractElement)element).appearanceDelayInSeconds = Float.parseFloat(delaySec);
            }
            String x = serialized.getValue("x");
            String y = serialized.getValue("y");
            if (x != null && MathUtils.isInteger((String)(x = PlaceholderParser.replacePlaceholders(x)))) {
                ((AbstractElement)element).posOffsetX = Integer.parseInt(x);
            }
            if (y != null && MathUtils.isInteger((String)(y = PlaceholderParser.replacePlaceholders(y)))) {
                ((AbstractElement)element).posOffsetY = Integer.parseInt(y);
            }
            if ((anchor = serialized.getValue("anchor_point")) == null) {
                anchor = serialized.getValue("orientation");
            }
            if (anchor != null) {
                ((AbstractElement)element).anchorPoint = ElementAnchorPoints.getAnchorPointByName(anchor);
                if (((AbstractElement)element).anchorPoint == null) {
                    ((AbstractElement)element).anchorPoint = ElementAnchorPoints.TOP_LEFT;
                }
            }
            if ((anchorElement = serialized.getValue("anchor_point_element")) == null) {
                anchorElement = serialized.getValue("orientation_element");
            }
            if (anchorElement != null) {
                ((AbstractElement)element).anchorPointElementIdentifier = anchorElement;
            }
            if ((w = serialized.getValue("width")) != null) {
                if (w.equals("%guiwidth%")) {
                    ((AbstractElement)element).stretchX = true;
                } else {
                    if (MathUtils.isInteger((String)w)) {
                        ((AbstractElement)element).baseWidth = Integer.parseInt(w);
                    }
                    if (((AbstractElement)element).baseWidth < 0) {
                        ((AbstractElement)element).baseWidth = 0;
                    }
                }
            }
            if ((h = serialized.getValue("height")) != null) {
                if (h.equals("%guiheight%")) {
                    ((AbstractElement)element).stretchY = true;
                } else {
                    if (MathUtils.isInteger((String)h)) {
                        ((AbstractElement)element).baseHeight = Integer.parseInt(h);
                    }
                    if (((AbstractElement)element).baseHeight < 0) {
                        ((AbstractElement)element).baseHeight = 0;
                    }
                }
            }
            if ((stretchXString = serialized.getValue("stretch_x")) != null && stretchXString.equals("true")) {
                ((AbstractElement)element).stretchX = true;
            }
            if ((stretchYString = serialized.getValue("stretch_y")) != null && stretchYString.equals("true")) {
                ((AbstractElement)element).stretchY = true;
            }
            ((AbstractElement)element).advancedWidth = serialized.getValue("advanced_width");
            ((AbstractElement)element).advancedHeight = serialized.getValue("advanced_height");
            ((AbstractElement)element).advancedX = serialized.getValue("advanced_posx");
            ((AbstractElement)element).advancedY = serialized.getValue("advanced_posy");
            String stayOnScreen = serialized.getValue("stay_on_screen");
            if (stayOnScreen == null || stayOnScreen.equals("false")) {
                ((AbstractElement)element).stayOnScreen = false;
            }
            if ((loadingRequirementContainerIdentifier = serialized.getValue("element_loading_requirement_container_identifier")) != null) {
                LoadingRequirementContainer c = LoadingRequirementContainer.deserializeWithIdentifier(loadingRequirementContainerIdentifier, serialized);
                if (c != null) {
                    ((AbstractElement)element).loadingRequirementContainer = c;
                }
            } else {
                ((AbstractElement)element).loadingRequirementContainer = LoadingRequirementContainer.deserializeToSingleContainer(serialized);
            }
            return element;
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to deserialize element: " + this.getIdentifier());
            ex.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static ResourceSupplier<ITexture> deserializeImageResourceSupplier(@Nullable String resourceSource) {
        return SerializationUtils.deserializeImageResourceSupplier(resourceSource);
    }

    @Nullable
    public static ResourceSupplier<IAudio> deserializeAudioResourceSupplier(@Nullable String resourceSource) {
        return SerializationUtils.deserializeAudioResourceSupplier(resourceSource);
    }

    @Nullable
    public static ResourceSupplier<IVideo> deserializeVideoResourceSupplier(@Nullable String resourceSource) {
        return SerializationUtils.deserializeVideoResourceSupplier(resourceSource);
    }

    @Nullable
    public static ResourceSupplier<IText> deserializeTextResourceSupplier(@Nullable String resourceSource) {
        return SerializationUtils.deserializeTextResourceSupplier(resourceSource);
    }

    @Nullable
    public static ResourceFile deserializeResourceFile(@Nullable String gameDirectoryFilePath) {
        return SerializationUtils.deserializeResourceFile(gameDirectoryFilePath);
    }

    @NotNull
    protected <T extends Number> T deserializeNumber(@NotNull Class<T> type, @NotNull T fallbackValue, @Nullable String serialized) {
        return SerializationUtils.deserializeNumber(type, fallbackValue, serialized);
    }

    protected boolean deserializeBoolean(boolean fallbackValue, @Nullable String serialized) {
        return SerializationUtils.deserializeBoolean(fallbackValue, serialized);
    }

    protected abstract SerializedElement serializeElement(@NotNull E var1, @NotNull SerializedElement var2);

    @Nullable
    public SerializedElement serializeElementInternal(@NotNull AbstractElement element) {
        try {
            SerializedElement sec = ElementBuilder.removeReservedPropertyKeys(this.serializeElement(element, new SerializedElement()));
            sec.putProperty("element_type", element.builder.getIdentifier());
            sec.putProperty("instance_identifier", element.getInstanceIdentifier());
            if (element.customElementLayerName != null) {
                sec.putProperty("custom_element_layer_name", element.customElementLayerName);
            }
            sec.putProperty("appearance_delay", element.appearanceDelay.name);
            sec.putProperty("appearance_delay_seconds", "" + element.appearanceDelayInSeconds);
            sec.putProperty("fade_in", "" + element.fadeIn);
            sec.putProperty("fade_in_speed", "" + element.fadeInSpeed);
            sec.putProperty("anchor_point", element.anchorPoint != null ? element.anchorPoint.getName() : ElementAnchorPoints.TOP_LEFT.getName());
            if (element.anchorPoint == ElementAnchorPoints.ELEMENT && element.anchorPointElementIdentifier != null) {
                sec.putProperty("anchor_point_element", element.anchorPointElementIdentifier);
            }
            if (element.advancedX != null) {
                sec.putProperty("advanced_posx", element.advancedX);
            }
            if (element.advancedY != null) {
                sec.putProperty("advanced_posy", element.advancedY);
            }
            if (element.advancedWidth != null) {
                sec.putProperty("advanced_width", element.advancedWidth);
            }
            if (element.advancedHeight != null) {
                sec.putProperty("advanced_height", element.advancedHeight);
            }
            if (element.appearanceDelay == null) {
                element.appearanceDelay = AbstractElement.AppearanceDelay.NO_DELAY;
            }
            sec.putProperty("x", "" + element.posOffsetX);
            sec.putProperty("y", "" + element.posOffsetY);
            sec.putProperty("width", "" + element.baseWidth);
            sec.putProperty("height", "" + element.baseHeight);
            sec.putProperty("stretch_x", "" + element.stretchX);
            sec.putProperty("stretch_y", "" + element.stretchY);
            sec.putProperty("stay_on_screen", "" + element.stayOnScreen);
            sec.putProperty("element_loading_requirement_container_identifier", element.loadingRequirementContainer.identifier);
            element.loadingRequirementContainer.serializeToExistingPropertyContainer(sec);
            return sec;
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to serialize element: " + this.getIdentifier());
            ex.printStackTrace();
            return null;
        }
    }

    @NotNull
    public abstract L wrapIntoEditorElement(@NotNull E var1, @NotNull LayoutEditorScreen var2);

    @Nullable
    public L wrapIntoEditorElementInternal(@NotNull AbstractElement element, @NotNull LayoutEditorScreen editor) {
        try {
            return this.wrapIntoEditorElement(element, editor);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @NotNull
    public abstract Component getDisplayName(@Nullable AbstractElement var1);

    @Nullable
    public abstract Component[] getDescription(@Nullable AbstractElement var1);

    @NotNull
    public String getIdentifier() {
        return this.identifier;
    }

    public boolean isDeprecated() {
        return false;
    }

    private static SerializedElement removeReservedPropertyKeys(SerializedElement serialized) {
        ArrayList reserved = Lists.newArrayList((Object[])new String[]{"action", "element_type", "actionid", "instance_identifier", "button_identifier"});
        ArrayList<String> removed = new ArrayList<String>();
        for (String s : reserved) {
            if (!serialized.hasProperty(s)) continue;
            serialized.removeProperty(s);
            removed.add(s);
        }
        if (!removed.isEmpty()) {
            StringBuilder keys = new StringBuilder();
            for (String s : removed) {
                if (keys.length() > 0) {
                    keys.append(", ");
                }
                keys.append(s);
            }
            LOGGER.error("[FANCYMENU] Failed to add properties to serialized element! Keys reserved by the system: " + keys);
        }
        return serialized;
    }

    protected static boolean isEditor() {
        return Minecraft.m_91087_().f_91080_ instanceof LayoutEditorScreen;
    }
}

