/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.animation;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.customization.animation.AdvancedAnimation;
import de.keksuccino.fancymenu.customization.animation.AnimationData;
import de.keksuccino.fancymenu.customization.animation.AnimationHandlerEvents;
import de.keksuccino.fancymenu.customization.animation.ResourcePackAnimationRenderer;
import de.keksuccino.fancymenu.customization.animation.exceptions.AnimationNotFoundException;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.file.FileUtils;
import de.keksuccino.fancymenu.util.properties.PropertiesParser;
import de.keksuccino.fancymenu.util.properties.PropertyContainer;
import de.keksuccino.fancymenu.util.properties.PropertyContainerSet;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.rendering.animation.IAnimationRenderer;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimationHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final File ANIMATIONS_DIR = FileUtils.createDirectory(new File(FancyMenu.MOD_DIR, "/animations"));
    private static final Map<String, AnimationData> ANIMATIONS = new HashMap<String, AnimationData>();
    private static final List<String> EXTERNAL_ANIMATION_NAMES = new ArrayList<String>();
    protected static boolean preloadCompleted = false;
    protected static boolean initialized = false;

    public static void init() {
        if (!initialized) {
            EventHandler.INSTANCE.registerListenersOf(new AnimationHandlerEvents());
        }
        initialized = true;
    }

    public static void register(@NotNull IAnimationRenderer animation, @NotNull String name, @NotNull AnimationData.Type type) {
        if (!ANIMATIONS.containsKey(name)) {
            ANIMATIONS.put(name, new AnimationData(animation, name, type));
            if (type == AnimationData.Type.EXTERNAL) {
                EXTERNAL_ANIMATION_NAMES.add(name);
            }
        } else {
            LOGGER.error("[FANCYMENU] Failed to register animation! Animation with same name already exists: " + name);
        }
    }

    public static void unregister(@NotNull IAnimationRenderer animation) {
        AnimationData d = null;
        for (AnimationData a : ANIMATIONS.values()) {
            if (a.animation != animation) continue;
            d = a;
            break;
        }
        if (d != null) {
            AnimationHandler.unregister(d.name);
        }
    }

    public static void unregister(@NotNull String name) {
        if (AnimationHandler.animationExists(name)) {
            ANIMATIONS.remove(name);
            EXTERNAL_ANIMATION_NAMES.remove(name);
        }
    }

    public static void discoverAndRegisterExternalAnimations() {
        preloadCompleted = false;
        AnimationHandler.clearExternalAnimations();
        File[] filesArray = ANIMATIONS_DIR.listFiles();
        if (filesArray == null) {
            return;
        }
        for (File a : filesArray) {
            File audio2;
            File audio1;
            List<PropertyContainer> introFrameSecs;
            List<PropertyContainer> mainFrameSecs;
            String resourceNamespace;
            String replayString;
            String loopString;
            PropertyContainer m;
            String name;
            List<PropertyContainer> metas;
            PropertyContainerSet props;
            File p;
            String mainAudio = null;
            String introAudio = null;
            int fps = 0;
            boolean loop = true;
            boolean replayIntro = false;
            ArrayList<String> frameNamesMain = new ArrayList<String>();
            ArrayList<String> frameNamesIntro = new ArrayList<String>();
            boolean mainContainsJpegs = false;
            boolean introContainsJpegs = false;
            if (!a.isDirectory() || !(p = new File(a.getAbsolutePath().replace("\\", "/") + "/animation.properties")).exists() || (props = PropertiesParser.deserializeSetFromFile(p.getPath())) == null || (metas = props.getContainersOfType("animation-meta")).isEmpty() || (name = (m = metas.get(0)).getValue("name")) == null) continue;
            String fpsString = m.getValue("fps");
            if (fpsString != null && MathUtils.isInteger((String)fpsString)) {
                fps = Integer.parseInt(fpsString);
            }
            if ((loopString = m.getValue("loop")) != null && loopString.equalsIgnoreCase("false")) {
                loop = false;
            }
            if ((replayString = m.getValue("replayintro")) != null && replayString.equalsIgnoreCase("true")) {
                replayIntro = true;
            }
            if ((resourceNamespace = m.getValue("namespace")) == null || (mainFrameSecs = props.getContainersOfType("frames-main")).isEmpty()) continue;
            PropertyContainer mainFrames = mainFrameSecs.get(0);
            Map<String, String> mainFramesMap = mainFrames.getProperties();
            ArrayList<String> mainFrameKeys = new ArrayList<String>();
            for (Map.Entry<String, String> me : mainFramesMap.entrySet()) {
                String frameNumber;
                if (!me.getKey().startsWith("frame_") || !MathUtils.isInteger((String)(frameNumber = me.getKey().split("_", 2)[1]))) continue;
                mainFrameKeys.add(me.getKey());
            }
            mainFrameKeys.sort((o1, o2) -> {
                String n1 = o1.split("_", 2)[1];
                String n2 = o2.split("_", 2)[1];
                int i1 = Integer.parseInt(n1);
                int i2 = Integer.parseInt(n2);
                return Integer.compare(i1, i2);
            });
            for (String s : mainFrameKeys) {
                String frameName = "frames_main/" + mainFramesMap.get(s);
                if (frameName.toLowerCase().endsWith(".jpg") || frameName.toLowerCase().endsWith(".jpeg")) {
                    mainContainsJpegs = true;
                    break;
                }
                frameNamesMain.add(frameName);
            }
            if (!(introFrameSecs = props.getContainersOfType("frames-intro")).isEmpty()) {
                PropertyContainer introFrames = introFrameSecs.get(0);
                Map<String, String> introFramesMap = introFrames.getProperties();
                ArrayList<String> introFrameKeys = new ArrayList<String>();
                for (Map.Entry<String, String> me : introFramesMap.entrySet()) {
                    String frameNumber;
                    if (!me.getKey().startsWith("frame_") || !MathUtils.isInteger((String)(frameNumber = me.getKey().split("_", 2)[1]))) continue;
                    introFrameKeys.add(me.getKey());
                }
                introFrameKeys.sort((o1, o2) -> {
                    String n1 = o1.split("_", 2)[1];
                    String n2 = o2.split("_", 2)[1];
                    int i1 = Integer.parseInt(n1);
                    int i2 = Integer.parseInt(n2);
                    return Integer.compare(i1, i2);
                });
                for (String s : introFrameKeys) {
                    String frameName = "frames_intro/" + introFramesMap.get(s);
                    if (frameName.toLowerCase().endsWith(".jpg") || frameName.toLowerCase().endsWith(".jpeg")) {
                        introContainsJpegs = true;
                        break;
                    }
                    frameNamesIntro.add(frameName);
                }
            }
            if ((audio1 = new File(a.getAbsolutePath().replace("\\", "/") + "/audio/mainaudio.wav")).exists()) {
                mainAudio = audio1.getPath();
            }
            if ((audio2 = new File(a.getAbsolutePath().replace("\\", "/") + "/audio/introaudio.wav")).exists()) {
                introAudio = audio2.getPath();
            }
            ResourcePackAnimationRenderer in = null;
            ResourcePackAnimationRenderer an = null;
            if (!mainContainsJpegs && !introContainsJpegs) {
                if (!frameNamesIntro.isEmpty() && !frameNamesMain.isEmpty()) {
                    in = new ResourcePackAnimationRenderer(resourceNamespace, frameNamesIntro, fps, loop, 0, 0, 100, 100);
                    an = new ResourcePackAnimationRenderer(resourceNamespace, frameNamesMain, fps, loop, 0, 0, 100, 100);
                } else if (!frameNamesMain.isEmpty()) {
                    an = new ResourcePackAnimationRenderer(resourceNamespace, frameNamesMain, fps, loop, 0, 0, 100, 100);
                }
            } else {
                LOGGER.error("[FANCYMENU] Unable to load animation! Animation contains JPEG frames, which are not supported by Minecraft anymore: " + name);
            }
            try {
                AdvancedAnimation ani;
                if (in != null) {
                    ani = new AdvancedAnimation(in, an, introAudio, mainAudio, replayIntro);
                    ani.propertiesPath = a.getPath();
                    AnimationHandler.register(ani, name, AnimationData.Type.EXTERNAL);
                    ani.prepareAnimation();
                    LOGGER.info("[FANCYMENU] Animation found: " + name);
                    continue;
                }
                if (an != null) {
                    ani = new AdvancedAnimation(null, an, introAudio, mainAudio, false);
                    ani.propertiesPath = a.getPath();
                    AnimationHandler.register(ani, name, AnimationData.Type.EXTERNAL);
                    ani.prepareAnimation();
                    LOGGER.info("[FANCYMENU] Animation found:  " + name);
                    continue;
                }
                LOGGER.error("[FANCYMENU] Failed to register animation: " + name);
            }
            catch (AnimationNotFoundException ex) {
                LOGGER.error("[FANCYMENU] An error happened while trying to register an animation: " + name, (Throwable)ex);
            }
        }
    }

    @NotNull
    public static List<String> getExternalAnimationNames() {
        return new ArrayList<String>(EXTERNAL_ANIMATION_NAMES);
    }

    private static void clearExternalAnimations() {
        for (String s : EXTERNAL_ANIMATION_NAMES) {
            ANIMATIONS.remove(s);
        }
    }

    public static boolean animationExists(@NotNull String name) {
        return ANIMATIONS.containsKey(name);
    }

    @NotNull
    public static List<IAnimationRenderer> getAnimations() {
        ArrayList<IAnimationRenderer> renderers = new ArrayList<IAnimationRenderer>();
        for (Map.Entry<String, AnimationData> m : ANIMATIONS.entrySet()) {
            renderers.add(m.getValue().animation);
        }
        return renderers;
    }

    @Nullable
    public static IAnimationRenderer getAnimation(String name) {
        if (AnimationHandler.animationExists(name)) {
            return AnimationHandler.ANIMATIONS.get((Object)name).animation;
        }
        return null;
    }

    public static void resetAnimations() {
        for (AnimationData d : ANIMATIONS.values()) {
            d.animation.resetAnimation();
        }
    }

    public static void resetAnimationSounds() {
        for (AnimationData d : ANIMATIONS.values()) {
            if (!(d.animation instanceof AdvancedAnimation)) continue;
            ((AdvancedAnimation)d.animation).resetAudio();
        }
    }

    public static void stopAnimationSounds() {
        for (AnimationData d : ANIMATIONS.values()) {
            if (!(d.animation instanceof AdvancedAnimation)) continue;
            ((AdvancedAnimation)d.animation).stopAudio();
        }
    }

    public static void updateAnimationSizes() {
        for (IAnimationRenderer a : AnimationHandler.getAnimations()) {
            IAnimationRenderer intro;
            if (a instanceof ResourcePackAnimationRenderer) {
                ((ResourcePackAnimationRenderer)a).setupAnimationSize();
                continue;
            }
            if (!(a instanceof AdvancedAnimation)) continue;
            IAnimationRenderer main = ((AdvancedAnimation)a).getMainAnimationRenderer();
            if (main instanceof ResourcePackAnimationRenderer) {
                ((ResourcePackAnimationRenderer)main).setupAnimationSize();
            }
            if (!((intro = ((AdvancedAnimation)a).getIntroAnimationRenderer()) instanceof ResourcePackAnimationRenderer)) continue;
            ((ResourcePackAnimationRenderer)intro).setupAnimationSize();
        }
    }

    public static void preloadAnimations(boolean ignoreAlreadyPreloaded) {
        Exception error = null;
        if (!preloadCompleted || ignoreAlreadyPreloaded) {
            LOGGER.info("[FANCYMENU] Preloading animations! This could cause the loading screen to freeze for a while..");
            try {
                ArrayList<ResourcePackAnimationRenderer> l = new ArrayList<ResourcePackAnimationRenderer>();
                for (IAnimationRenderer iAnimationRenderer : AnimationHandler.getAnimations()) {
                    if (iAnimationRenderer instanceof AdvancedAnimation) {
                        IAnimationRenderer main = ((AdvancedAnimation)iAnimationRenderer).getMainAnimationRenderer();
                        IAnimationRenderer intro = ((AdvancedAnimation)iAnimationRenderer).getIntroAnimationRenderer();
                        if (main instanceof ResourcePackAnimationRenderer) {
                            l.add((ResourcePackAnimationRenderer)main);
                        }
                        if (!(intro instanceof ResourcePackAnimationRenderer)) continue;
                        l.add((ResourcePackAnimationRenderer)intro);
                        continue;
                    }
                    if (!(iAnimationRenderer instanceof ResourcePackAnimationRenderer)) continue;
                    l.add((ResourcePackAnimationRenderer)iAnimationRenderer);
                }
                for (ResourcePackAnimationRenderer resourcePackAnimationRenderer : l) {
                    for (ResourceLocation rl : resourcePackAnimationRenderer.getAnimationFrames()) {
                        TextureManager t = Minecraft.m_91087_().m_91097_();
                        t.m_118506_(rl);
                    }
                }
            }
            catch (Exception ex) {
                error = ex;
            }
            if (error == null) {
                LOGGER.info("[FANCYMENU] Animation pre-loading completed!");
            } else {
                LOGGER.warn("[FANCYMENU] An error happened while trying to pre-load animations!", (Throwable)error);
            }
            preloadCompleted = true;
        }
    }

    public static boolean preloadingCompleted() {
        return preloadCompleted;
    }
}

