/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.text.markdown.ScrollableMarkdownRenderer;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.fancymenu.util.resource.ResourceSource;
import de.keksuccino.fancymenu.util.resource.ResourceSourceType;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.text.IText;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class CreditsScreen
extends Screen {
    private static final ResourceSource CREDITS_SOURCE = ResourceSource.of("fancymenu:credits_and_copyright.md", ResourceSourceType.LOCATION);
    protected ScrollableMarkdownRenderer markdownRenderer;
    protected int headerHeight = 20;
    protected int footerHeight = 40;
    protected int border = 40;
    protected Screen parent;
    protected boolean textSet = false;
    protected ResourceSupplier<IText> creditsTextSupplier = ResourceSupplier.text(CREDITS_SOURCE.getSerializationSource());

    public CreditsScreen(@NotNull Screen parent) {
        super((Component)Component.m_237119_());
        this.parent = parent;
    }

    protected void m_7856_() {
        int centerX = this.f_96543_ / 2;
        int scrollWidth = this.f_96543_ - this.border * 2;
        int scrollHeight = this.f_96544_ - this.headerHeight - this.footerHeight;
        if (this.markdownRenderer == null) {
            this.markdownRenderer = new ScrollableMarkdownRenderer(centerX - scrollWidth / 2, this.headerHeight, scrollWidth, scrollHeight);
        } else {
            this.markdownRenderer.rebuild(centerX - scrollWidth / 2, this.headerHeight, scrollWidth, scrollHeight);
        }
        this.markdownRenderer.getMarkdownRenderer().setHeadlineLineColor(UIBase.getUIColorTheme().screen_background_color_darker);
        this.markdownRenderer.getMarkdownRenderer().setTextBaseColor(UIBase.getUIColorTheme().generic_text_base_color);
        this.markdownRenderer.getMarkdownRenderer().setTextShadow(false);
        this.m_142416_((GuiEventListener)this.markdownRenderer);
        UIBase.applyDefaultWidgetSkinTo((ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButton(centerX - 100, this.f_96544_ - this.footerHeight / 2 - 10, 200, 20, (Component)Component.m_237115_((String)"fancymenu.common.close"), var1 -> this.m_7379_())));
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        List<String> lines;
        IText text;
        if (!this.textSet && (text = this.creditsTextSupplier.get()) != null && (lines = text.getTextLines()) != null) {
            StringBuilder lineString = new StringBuilder();
            for (String s : lines) {
                lineString.append(s).append("\n");
            }
            this.markdownRenderer.setText(lineString.toString());
            this.textSet = true;
        }
        RenderSystem.enableBlend();
        graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, UIBase.getUIColorTheme().screen_background_color_darker.getColorInt());
        RenderingUtils.resetShaderColor(graphics);
        graphics.m_280509_(0, this.f_96544_ - this.footerHeight, this.f_96543_, this.f_96544_, UIBase.getUIColorTheme().area_background_color.getColorInt());
        RenderingUtils.resetShaderColor(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partial);
    }

    public void m_280273_(@NotNull GuiGraphics graphics, int $$1, int $$2, float $$3) {
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollDeltaX, double scrollDeltaY) {
        return this.markdownRenderer.m_6050_(mouseX, mouseY, scrollDeltaX, scrollDeltaY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return this.markdownRenderer.m_6348_(mouseX, mouseY, button);
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_(this.parent);
    }

    public boolean m_6913_() {
        return true;
    }
}

