#version 150

uniform sampler2D Sampler0;
uniform vec2 ScreenSize;
uniform float Time;
uniform mat3 IViewRotMat;
uniform float RealTime;

in vec4 vertexColor;
in vec2 texCoord0;
in vec3 position;
in vec2 inSize;
in float newTime;

out vec4 fragColor;

void main() {
    float hue = fract(RealTime);

    float r = abs(hue * 6.0 - 3.0) - 1.0;
    float g = 2.0 - abs(hue * 6.0 - 2.0);
    float b = 2.0 - abs(hue * 6.0 - 4.0);
    vec3 color = clamp(vec3(r, g, b), 0.0, 1.0);
    vec4 textureColor = texture(Sampler0, texCoord0);

    fragColor = vec4(color.r * textureColor.r, color.g * textureColor.g, color.b * textureColor.b, textureColor.a);
}
