/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.gui;

import com.chaosthedude.naturescompass.NaturesCompass;
import com.chaosthedude.naturescompass.gui.BiomeSearchEntry;
import com.chaosthedude.naturescompass.gui.BiomeSearchList;
import com.chaosthedude.naturescompass.gui.TransparentButton;
import com.chaosthedude.naturescompass.gui.TransparentTextField;
import com.chaosthedude.naturescompass.items.NaturesCompassItem;
import com.chaosthedude.naturescompass.network.CompassSearchPacket;
import com.chaosthedude.naturescompass.network.TeleportPacket;
import com.chaosthedude.naturescompass.sorting.ISorting;
import com.chaosthedude.naturescompass.sorting.NameSorting;
import com.chaosthedude.naturescompass.util.BiomeUtils;
import com.chaosthedude.naturescompass.util.CompassState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;

@OnlyIn(value=Dist.CLIENT)
public class NaturesCompassScreen
extends Screen {
    public Level level;
    private Player player;
    private List<Biome> allowedBiomes;
    private List<Biome> biomesMatchingSearch;
    private ItemStack stack;
    private NaturesCompassItem natureCompass;
    private Button startSearchButton;
    private Button teleportButton;
    private Button cancelButton;
    private Button sortByButton;
    private TransparentTextField searchTextField;
    private BiomeSearchList selectionList;
    private ISorting<?> sortingCategory;

    public NaturesCompassScreen(Level level, Player player, ItemStack stack, NaturesCompassItem natureCompass, List<ResourceLocation> allowedBiomes) {
        super((Component)Component.m_237115_((String)"string.naturescompass.selectBiome"));
        this.level = level;
        this.player = player;
        this.stack = stack;
        this.natureCompass = natureCompass;
        this.allowedBiomes = new ArrayList<Biome>();
        this.loadAllowedBiomes(allowedBiomes);
        this.sortingCategory = new NameSorting();
        this.biomesMatchingSearch = new ArrayList<Biome>(this.allowedBiomes);
    }

    public boolean m_6050_(double par1, double par2, double par3, double par4) {
        return this.selectionList.m_6050_(par1, par2, par3, par4);
    }

    protected void m_7856_() {
        this.setupWidgets();
    }

    public void m_86600_() {
        boolean bl = this.teleportButton.f_93623_ = this.natureCompass.getState(this.stack) == CompassState.FOUND;
        if (this.allowedBiomes.size() != NaturesCompass.allowedBiomes.size()) {
            this.teleportButton.f_93624_ = NaturesCompass.canTeleport;
            this.m_169411_((GuiEventListener)this.selectionList);
            this.loadAllowedBiomes(NaturesCompass.allowedBiomes);
            this.biomesMatchingSearch = new ArrayList<Biome>(this.allowedBiomes);
            this.selectionList = new BiomeSearchList(this, this.f_96541_, this.f_96543_ + 110, this.f_96544_, 40, this.f_96544_, 45);
            this.m_142416_((GuiEventListener)this.selectionList);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.m_280137_(this.f_96547_, I18n.m_118938_((String)"string.naturescompass.selectBiome", (Object[])new Object[0]), 65, 15, 0xFFFFFF);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean ret = super.m_7933_(keyCode, scanCode, modifiers);
        if (this.searchTextField.m_93696_()) {
            this.processSearchTerm();
            return true;
        }
        return ret;
    }

    public boolean m_5534_(char typedChar, int keyCode) {
        boolean ret = super.m_5534_(typedChar, keyCode);
        if (this.searchTextField.m_93696_()) {
            this.processSearchTerm();
            return true;
        }
        return ret;
    }

    public void selectBiome(BiomeSearchEntry entry) {
        boolean enable;
        this.startSearchButton.f_93623_ = enable = entry != null;
    }

    public void searchForBiome(Biome biome) {
        if (BiomeUtils.getKeyForBiome(this.level, biome).isPresent()) {
            NaturesCompass.network.send((Object)new CompassSearchPacket(BiomeUtils.getKeyForBiome(this.level, biome).get(), this.player.m_20183_()), PacketDistributor.SERVER.noArg());
        }
        this.f_96541_.m_91152_(null);
    }

    public void teleport() {
        NaturesCompass.network.send((Object)new TeleportPacket(), PacketDistributor.SERVER.noArg());
        this.f_96541_.m_91152_(null);
    }

    public ISorting<?> getSortingCategory() {
        return this.sortingCategory;
    }

    public void processSearchTerm() {
        this.biomesMatchingSearch = new ArrayList<Biome>();
        String searchTerm = this.searchTextField.m_94155_().toLowerCase();
        for (Biome biome : this.allowedBiomes) {
            if (searchTerm.startsWith("$")) {
                if (!BiomeUtils.getBiomeTags(this.level, biome).toLowerCase().contains(searchTerm.substring(1))) continue;
                this.biomesMatchingSearch.add(biome);
                continue;
            }
            if (searchTerm.startsWith("@")) {
                if (!BiomeUtils.getBiomeSource(this.level, biome).toLowerCase().contains(searchTerm.substring(1))) continue;
                this.biomesMatchingSearch.add(biome);
                continue;
            }
            if (!BiomeUtils.getBiomeNameForDisplay(this.level, biome).toLowerCase().contains(searchTerm)) continue;
            this.biomesMatchingSearch.add(biome);
        }
        this.selectionList.refreshList();
    }

    public List<Biome> sortBiomes() {
        List<Biome> biomes = this.biomesMatchingSearch;
        Collections.sort(biomes, new NameSorting());
        Collections.sort(biomes, this.sortingCategory);
        return biomes;
    }

    private void setupWidgets() {
        this.m_169413_();
        this.cancelButton = (Button)this.m_142416_((GuiEventListener)new TransparentButton(10, this.f_96544_ - 30, 110, 20, (Component)Component.m_237115_((String)"gui.cancel"), onPress -> this.f_96541_.m_91152_(null)));
        this.sortByButton = (Button)this.m_142416_((GuiEventListener)new TransparentButton(10, 65, 110, 20, (Component)Component.m_237113_((String)(I18n.m_118938_((String)"string.naturescompass.sortBy", (Object[])new Object[0]) + ": " + this.sortingCategory.getLocalizedName())), onPress -> {
            this.sortingCategory = this.sortingCategory.next();
            this.sortByButton.m_93666_((Component)Component.m_237113_((String)(I18n.m_118938_((String)"string.naturescompass.sortBy", (Object[])new Object[0]) + ": " + this.sortingCategory.getLocalizedName())));
            this.selectionList.refreshList();
        }));
        this.startSearchButton = (Button)this.m_142416_((GuiEventListener)new TransparentButton(10, 40, 110, 20, (Component)Component.m_237115_((String)"string.naturescompass.startSearch"), onPress -> {
            if (this.selectionList.hasSelection()) {
                ((BiomeSearchEntry)this.selectionList.m_93511_()).searchForBiome();
            }
        }));
        this.teleportButton = (Button)this.m_142416_((GuiEventListener)new TransparentButton(this.f_96543_ - 120, 10, 110, 20, (Component)Component.m_237115_((String)"string.naturescompass.teleport"), onPress -> this.teleport()));
        this.startSearchButton.f_93623_ = false;
        this.teleportButton.f_93624_ = NaturesCompass.canTeleport;
        this.searchTextField = (TransparentTextField)this.m_142416_((GuiEventListener)new TransparentTextField(this.f_96547_, 130, 10, 140, 20, (Component)Component.m_237115_((String)"string.naturescompass.search")));
        if (this.selectionList == null) {
            this.selectionList = new BiomeSearchList(this, this.f_96541_, this.f_96543_ + 110, this.f_96544_, 40, this.f_96544_, 45);
        }
        this.m_142416_((GuiEventListener)this.selectionList);
    }

    private void loadAllowedBiomes(List<ResourceLocation> allowedBiomeKeys) {
        this.allowedBiomes = new ArrayList<Biome>();
        for (ResourceLocation biomeKey : allowedBiomeKeys) {
            Optional<Biome> optionalBiome = BiomeUtils.getBiomeForKey(this.level, biomeKey);
            if (!optionalBiome.isPresent()) continue;
            this.allowedBiomes.add(optionalBiome.get());
        }
    }
}

