/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.configuration.ClientboundFinishConfigurationPacket;
import net.minecraftforge.common.util.HexDumper;
import net.minecraftforge.network.ICustomPacket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class PacketLogger {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker MARKER = MarkerManager.getMarker((String)"PACKETLOG");
    private final Connection connection;
    public boolean enabled = false;

    public PacketLogger(Connection connection) {
        this.connection = connection;
    }

    public void send(Packet<?> packet) {
        this.common(this.connection.m_178313_(), this.connection.m_178314_(), packet);
    }

    public void recv(Packet<?> packet) {
        this.common(this.connection.m_178313_(), this.connection.m_178313_(), packet);
    }

    private void common(PacketFlow side, PacketFlow flow, Packet<?> packet) {
        if (!this.enabled) {
            return;
        }
        if (packet instanceof ClientboundFinishConfigurationPacket) {
            this.enabled = false;
        }
        if (packet instanceof ICustomPacket) {
            FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
            packet.m_5779_(data);
            LOGGER.info(MARKER, "{} {} {}\n{}", (Object)PacketLogger.side(side), (Object)PacketLogger.dir(flow), (Object)packet.getClass().getName(), (Object)HexDumper.dump((ByteBuf)data));
        } else {
            LOGGER.info(MARKER, "{} {} {}", (Object)PacketLogger.side(side), (Object)PacketLogger.dir(flow), (Object)packet.getClass().getName());
        }
    }

    private static String side(PacketFlow side) {
        return side == PacketFlow.CLIENTBOUND ? "CLIENT" : "SERVER";
    }

    private static String dir(PacketFlow flow) {
        return flow == PacketFlow.CLIENTBOUND ? "S->C" : "C->S";
    }
}

