/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class ConditionalAdvancement {
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private static final ResourceLocation DOESNT_MATTER = new ResourceLocation("doesnt", "matter");
        private List<Pair> advancements = new ArrayList<Pair>();
        private ICondition condition;

        public Builder condition(ICondition value) {
            this.condition = value;
            return this;
        }

        public Builder advancement(Consumer<Consumer<Advancement.Builder>> callable) {
            callable.accept(this::advancement);
            return this;
        }

        public Builder advancement(Advancement.Builder builder) {
            return this.advancement(builder.m_138403_(DOESNT_MATTER).f_290952_());
        }

        public Builder advancement(FinishedRecipe fromRecipe) {
            return this.advancement(fromRecipe.m_126373_());
        }

        public Builder advancement(AdvancementHolder holder) {
            return this.advancement(holder.f_290952_());
        }

        private Builder advancement(Advancement value) {
            if (this.condition == null) {
                throw new IllegalStateException("Can not add a advancement with no conditions.");
            }
            if (value == null) {
                throw new IllegalStateException("Can not add a null advancement");
            }
            this.advancements.add(new Pair(this.condition, value));
            this.condition = null;
            return this;
        }

        public IResult build() {
            return new Result(List.copyOf(this.advancements));
        }

        public JsonObject write() {
            JsonObject json = new JsonObject();
            JsonArray array = new JsonArray();
            json.add("advancements", (JsonElement)array);
            for (Pair pair : this.advancements) {
                JsonObject holder = pair.adv().m_294498_();
                if (holder.has("forge:condition")) {
                    throw new IllegalStateException("Recipe already serialized conditions!");
                }
                ForgeHooks.writeCondition(pair.condition(), holder);
                array.add((JsonElement)holder);
            }
            return json;
        }
    }

    private record Result(List<Pair> advancements) implements IResult
    {
        @Override
        public JsonObject serializeToJson() {
            JsonObject json = new JsonObject();
            JsonArray array = new JsonArray();
            json.add("advancements", (JsonElement)array);
            for (Pair pair : this.advancements) {
                JsonObject holder = pair.adv().m_294498_();
                if (holder.has("forge:condition")) {
                    throw new IllegalStateException("Recipe already serialized conditions!");
                }
                ForgeHooks.writeCondition(pair.condition(), holder);
                array.add((JsonElement)holder);
            }
            return json;
        }
    }

    private record Pair(ICondition condition, Advancement adv) {
    }

    public static interface IResult {
        public JsonObject serializeToJson();
    }
}

