/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.CrashReportDetail;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketListener;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketUtils;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.common.ClientboundKeepAlivePacket;
import net.minecraft.network.protocol.common.ServerCommonPacketListener;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ServerboundKeepAlivePacket;
import net.minecraft.network.protocol.common.ServerboundPongPacket;
import net.minecraft.network.protocol.common.ServerboundResourcePackPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.network.ICustomPacket;
import org.slf4j.Logger;

public abstract class ServerCommonPacketListenerImpl
implements ServerCommonPacketListener {
    private static final Logger f_291096_ = LogUtils.getLogger();
    public static final int f_290500_ = 15000;
    private static final Component f_290625_ = Component.m_237115_((String)"disconnect.timeout");
    protected final MinecraftServer f_291389_;
    protected final Connection f_291338_;
    private long f_290835_;
    private boolean f_291554_;
    private long f_291155_;
    private int f_291042_;
    private volatile boolean f_290367_ = false;

    public ServerCommonPacketListenerImpl(MinecraftServer p_299469_, Connection p_300872_, CommonListenerCookie p_300277_) {
        this.f_291389_ = p_299469_;
        this.f_291338_ = p_300872_;
        this.f_290835_ = Util.m_137550_();
        this.f_291042_ = p_300277_.f_291325_();
    }

    public void m_7026_(Component p_300550_) {
        if (this.m_293330_()) {
            f_291096_.info("Stopping singleplayer server as player logged out");
            this.f_291389_.m_7570_(false);
        }
    }

    public void m_295033_(ServerboundKeepAlivePacket p_299975_) {
        if (this.f_291554_ && p_299975_.m_293668_() == this.f_291155_) {
            int i = (int)(Util.m_137550_() - this.f_290835_);
            this.f_291042_ = (this.f_291042_ * 3 + i) / 4;
            this.f_291554_ = false;
        } else if (!this.m_293330_()) {
            this.m_294716_(f_290625_);
        }
    }

    public void m_293596_(ServerboundPongPacket p_299461_) {
    }

    public void m_293234_(ServerboundCustomPayloadPacket p_300164_) {
        ForgeHooks.onCustomPayload((ICustomPacket)p_300164_, (Connection)this.f_291338_);
    }

    public void m_293248_(ServerboundResourcePackPacket p_300656_) {
        PacketUtils.m_131363_((Packet)p_300656_, (PacketListener)this, (BlockableEventLoop)this.f_291389_);
        if (p_300656_.m_294355_() == ServerboundResourcePackPacket.Action.DECLINED && this.f_291389_.m_142205_()) {
            f_291096_.info("Disconnecting {} due to resource pack rejection", (Object)this.m_293343_().getName());
            this.m_294716_((Component)Component.m_237115_((String)"multiplayer.requiredTexturePrompt.disconnect"));
        }
    }

    protected void m_295188_() {
        this.f_291389_.m_129905_().m_6180_("keepAlive");
        long i = Util.m_137550_();
        if (i - this.f_290835_ >= 15000L) {
            if (this.f_291554_) {
                this.m_294716_(f_290625_);
            } else {
                this.f_291554_ = true;
                this.f_290835_ = i;
                this.f_291155_ = i;
                this.m_141995_((Packet<?>)new ClientboundKeepAlivePacket(this.f_291155_));
            }
        }
        this.f_291389_.m_129905_().m_7238_();
    }

    public void m_295499_() {
        this.f_290367_ = true;
    }

    public void m_293169_() {
        this.f_290367_ = false;
        this.f_291338_.m_295610_();
    }

    public void m_141995_(Packet<?> p_300558_) {
        this.m_295553_(p_300558_, null);
    }

    public void m_295553_(Packet<?> p_300325_, @Nullable PacketSendListener p_301165_) {
        boolean flag = !this.f_290367_ || !this.f_291389_.m_18695_();
        try {
            this.f_291338_.m_294750_(p_300325_, p_301165_, flag);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_(throwable, "Sending packet");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Packet being sent");
            crashreportcategory.m_128165_("Packet class", (CrashReportDetail<String>)((CrashReportDetail)() -> p_300325_.getClass().getCanonicalName()));
            throw new ReportedException(crashreport);
        }
    }

    public void m_294716_(Component p_299122_) {
        this.f_291338_.m_243124_((Packet<?>)new ClientboundDisconnectPacket(p_299122_), PacketSendListener.m_243092_(() -> this.f_291338_.m_129507_(p_299122_)));
        this.f_291338_.m_129540_();
        this.f_291389_.m_18709_(this.f_291338_::m_129541_);
    }

    protected boolean m_293330_() {
        return this.f_291389_.m_7779_(this.m_293343_());
    }

    protected abstract GameProfile m_293343_();

    @VisibleForDebug
    public GameProfile m_295644_() {
        return this.m_293343_();
    }

    public int m_293018_() {
        return this.f_291042_;
    }

    protected CommonListenerCookie m_295477_(ClientInformation p_297318_) {
        return new CommonListenerCookie(this.m_293343_(), this.f_291042_, p_297318_);
    }

    public Connection getConnection() {
        return this.f_291338_;
    }
}

