/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.Dumpable;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.Tickable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class TextureAtlas
extends AbstractTexture
implements Dumpable,
Tickable {
    private static final Logger f_118261_ = LogUtils.getLogger();
    @Deprecated
    public static final ResourceLocation f_118259_ = InventoryMenu.f_39692_;
    @Deprecated
    public static final ResourceLocation f_118260_ = new ResourceLocation("textures/atlas/particles.png");
    private List<SpriteContents> f_118263_ = List.of();
    private List<TextureAtlasSprite.Ticker> f_118262_ = List.of();
    private Map<ResourceLocation, TextureAtlasSprite> f_118264_ = Map.of();
    @Nullable
    private TextureAtlasSprite f_301625_;
    private final ResourceLocation f_118265_;
    private final int f_118266_;
    private int f_276067_;
    private int f_276070_;
    private int f_276072_;

    public TextureAtlas(ResourceLocation p_118269_) {
        this.f_118265_ = p_118269_;
        this.f_118266_ = RenderSystem.maxSupportedTextureSize();
    }

    @Override
    public void m_6704_(ResourceManager p_118282_) {
    }

    public void m_247065_(SpriteLoader.Preparations p_250662_) {
        f_118261_.info("Created: {}x{}x{} {}-atlas", new Object[]{p_250662_.f_243669_(), p_250662_.f_244632_(), p_250662_.f_244353_(), this.f_118265_});
        TextureUtil.prepareImage((int)this.m_117963_(), (int)p_250662_.f_244353_(), (int)p_250662_.f_243669_(), (int)p_250662_.f_244632_());
        this.f_276067_ = p_250662_.f_243669_();
        this.f_276070_ = p_250662_.f_244632_();
        this.f_276072_ = p_250662_.f_244353_();
        this.m_118329_();
        this.f_118264_ = Map.copyOf(p_250662_.f_243807_());
        this.f_301625_ = this.f_118264_.get(MissingTextureAtlasSprite.m_118071_());
        if (this.f_301625_ == null) {
            throw new IllegalStateException("Atlas '" + this.f_118265_ + "' (" + this.f_118264_.size() + " sprites) has no missing texture sprite");
        }
        ArrayList<SpriteContents> list = new ArrayList<SpriteContents>();
        ArrayList<TextureAtlasSprite.Ticker> list1 = new ArrayList<TextureAtlasSprite.Ticker>();
        for (TextureAtlasSprite textureatlassprite : p_250662_.f_243807_().values()) {
            list.add(textureatlassprite.m_245424_());
            try {
                textureatlassprite.m_118416_();
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.m_127521_(throwable, "Stitching texture atlas");
                CrashReportCategory crashreportcategory = crashreport.m_127514_("Texture being stitched together");
                crashreportcategory.m_128159_("Atlas path", this.f_118265_);
                crashreportcategory.m_128159_("Sprite", textureatlassprite);
                throw new ReportedException(crashreport);
            }
            TextureAtlasSprite.Ticker textureatlassprite$ticker = textureatlassprite.m_247406_();
            if (textureatlassprite$ticker == null) continue;
            list1.add(textureatlassprite$ticker);
        }
        this.f_118263_ = List.copyOf(list);
        this.f_118262_ = List.copyOf(list1);
        ForgeHooksClient.onTextureStitchedPost((TextureAtlas)this);
    }

    public void m_276079_(ResourceLocation p_276106_, Path p_276127_) throws IOException {
        String s = p_276106_.m_179910_();
        TextureUtil.writeAsPNG((Path)p_276127_, (String)s, (int)this.m_117963_(), (int)this.f_276072_, (int)this.f_276067_, (int)this.f_276070_);
        TextureAtlas.m_260988_(p_276127_, s, this.f_118264_);
    }

    private static void m_260988_(Path p_261769_, String p_262102_, Map<ResourceLocation, TextureAtlasSprite> p_261722_) {
        Path path = p_261769_.resolve(p_262102_ + ".txt");
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            for (Map.Entry entry : p_261722_.entrySet().stream().sorted(Map.Entry.comparingByKey()).toList()) {
                TextureAtlasSprite textureatlassprite = (TextureAtlasSprite)entry.getValue();
                writer.write(String.format(Locale.ROOT, "%s\tx=%d\ty=%d\tw=%d\th=%d%n", entry.getKey(), textureatlassprite.m_174743_(), textureatlassprite.m_174744_(), textureatlassprite.m_245424_().m_246492_(), textureatlassprite.m_245424_().m_245330_()));
            }
        }
        catch (IOException ioexception) {
            f_118261_.warn("Failed to write file {}", (Object)path, (Object)ioexception);
        }
    }

    public void m_118270_() {
        this.m_117966_();
        for (TextureAtlasSprite.Ticker textureatlassprite$ticker : this.f_118262_) {
            textureatlassprite$ticker.m_245385_();
        }
    }

    public void m_7673_() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(this::m_118270_);
        } else {
            this.m_118270_();
        }
    }

    public TextureAtlasSprite m_118316_(ResourceLocation p_118317_) {
        TextureAtlasSprite textureatlassprite = this.f_118264_.getOrDefault(p_118317_, this.f_301625_);
        if (textureatlassprite == null) {
            throw new IllegalStateException("Tried to lookup sprite, but atlas is not initialized");
        }
        return textureatlassprite;
    }

    public void m_118329_() {
        this.f_118263_.forEach(SpriteContents::close);
        this.f_118262_.forEach(TextureAtlasSprite.Ticker::close);
        this.f_118263_ = List.of();
        this.f_118262_ = List.of();
        this.f_118264_ = Map.of();
        this.f_301625_ = null;
    }

    public ResourceLocation m_118330_() {
        return this.f_118265_;
    }

    public int m_245285_() {
        return this.f_118266_;
    }

    int m_276092_() {
        return this.f_276067_;
    }

    int m_276095_() {
        return this.f_276070_;
    }

    public void m_247255_(SpriteLoader.Preparations p_251993_) {
        this.m_117960_(false, p_251993_.f_244353_() > 0);
    }

    public Set<ResourceLocation> getTextureLocations() {
        return Collections.unmodifiableSet(this.f_118264_.keySet());
    }
}

