/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.multiplayer.LegacyServerPinger;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.resolver.ResolvedServerAddress;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.client.multiplayer.resolver.ServerNameResolver;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.status.ClientStatusPacketListener;
import net.minecraft.network.protocol.status.ClientboundPongResponsePacket;
import net.minecraft.network.protocol.status.ClientboundStatusResponsePacket;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.network.protocol.status.ServerboundPingRequestPacket;
import net.minecraft.network.protocol.status.ServerboundStatusRequestPacket;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ServerStatusPinger {
    private static final Logger f_105449_ = LogUtils.getLogger();
    private static final Component f_171810_ = Component.m_237115_((String)"multiplayer.status.cannot_connect").m_130938_(p_265659_ -> p_265659_.m_178520_(-65536));
    private final List<Connection> f_105450_ = Collections.synchronizedList(Lists.newArrayList());

    public void m_105459_(final ServerData p_105460_, final Runnable p_105461_) throws UnknownHostException {
        final ServerAddress serveraddress = ServerAddress.m_171864_((String)p_105460_.f_105363_);
        Optional<InetSocketAddress> optional = ServerNameResolver.f_171881_.m_171890_(serveraddress).map(ResolvedServerAddress::m_142641_);
        if (optional.isEmpty()) {
            this.m_171814_(ConnectScreen.f_169260_, p_105460_);
        } else {
            final InetSocketAddress inetsocketaddress = optional.get();
            final Connection connection = Connection.m_178300_(inetsocketaddress, false, null);
            this.f_105450_.add(connection);
            p_105460_.f_105365_ = Component.m_237115_((String)"multiplayer.status.pinging");
            p_105460_.f_105366_ = -1L;
            p_105460_.f_105370_ = Collections.emptyList();
            ClientStatusPacketListener clientstatuspacketlistener = new ClientStatusPacketListener(){
                private boolean f_105475_;
                private boolean f_105476_;
                private long f_105477_;

                public void m_6440_(ClientboundStatusResponsePacket p_105489_) {
                    if (this.f_105476_) {
                        connection.m_129507_((Component)Component.m_237115_((String)"multiplayer.status.unrequested"));
                    } else {
                        this.f_105476_ = true;
                        ServerStatus serverstatus = p_105489_.f_134886_();
                        p_105460_.f_105365_ = serverstatus.f_134900_();
                        serverstatus.f_134902_().ifPresentOrElse(p_273307_ -> {
                            p_272776_.f_105368_ = Component.m_237113_((String)p_273307_.f_134962_());
                            p_272776_.f_105367_ = p_273307_.f_134963_();
                        }, () -> {
                            p_273651_.f_105368_ = Component.m_237115_((String)"multiplayer.status.old");
                            p_273651_.f_105367_ = 0;
                        });
                        serverstatus.f_134901_().ifPresentOrElse(p_273230_ -> {
                            p_272779_.f_105364_ = ServerStatusPinger.m_105466_(p_273230_.f_271178_(), p_273230_.f_271503_());
                            p_272779_.f_263840_ = p_273230_;
                            if (!p_273230_.f_134919_().isEmpty()) {
                                ArrayList<Component> list = new ArrayList<Component>(p_273230_.f_134919_().size());
                                for (GameProfile gameprofile : p_273230_.f_134919_()) {
                                    list.add((Component)Component.m_237113_((String)gameprofile.getName()));
                                }
                                if (p_273230_.f_134919_().size() < p_273230_.f_271178_()) {
                                    list.add((Component)Component.m_237110_((String)"multiplayer.status.and_more", (Object[])new Object[]{p_273230_.f_271178_() - p_273230_.f_134919_().size()}));
                                }
                                p_272779_.f_105370_ = list;
                            } else {
                                p_272779_.f_105370_ = List.of();
                            }
                        }, () -> {
                            p_273287_.f_105364_ = Component.m_237115_((String)"multiplayer.status.unknown").m_130940_(ChatFormatting.DARK_GRAY);
                        });
                        serverstatus.f_134903_().ifPresent(p_272704_ -> {
                            if (!Arrays.equals(p_272704_.f_271462_(), p_105460_.m_271916_())) {
                                p_105460_.m_271813_(ServerData.m_301662_(p_272704_.f_271462_()));
                                p_105461_.run();
                            }
                        });
                        ForgeHooksClient.processForgeListPingData((ServerStatus)serverstatus, (ServerData)p_105460_);
                        this.f_105477_ = Util.m_137550_();
                        connection.m_129512_((Packet<?>)new ServerboundPingRequestPacket(this.f_105477_));
                        this.f_105475_ = true;
                    }
                }

                public void m_105486_(ClientboundPongResponsePacket p_105487_) {
                    long i = this.f_105477_;
                    long j = Util.m_137550_();
                    p_105460_.f_105366_ = j - i;
                    connection.m_129507_((Component)Component.m_237115_((String)"multiplayer.status.finished"));
                }

                public void m_7026_(Component p_105485_) {
                    if (!this.f_105475_) {
                        ServerStatusPinger.this.m_171814_(p_105485_, p_105460_);
                        ServerStatusPinger.this.m_171811_(inetsocketaddress, serveraddress, p_105460_);
                    }
                }

                public boolean m_6198_() {
                    return connection.m_129536_();
                }
            };
            try {
                connection.m_292894_(serveraddress.m_171863_(), serveraddress.m_171866_(), clientstatuspacketlistener);
                connection.m_129512_((Packet<?>)new ServerboundStatusRequestPacket());
            }
            catch (Throwable throwable) {
                f_105449_.error("Failed to ping server {}", (Object)serveraddress, (Object)throwable);
            }
        }
    }

    void m_171814_(Component p_171815_, ServerData p_171816_) {
        f_105449_.error("Can't ping {}: {}", (Object)p_171816_.f_105363_, (Object)p_171815_.getString());
        p_171816_.f_105365_ = f_171810_;
        p_171816_.f_105364_ = CommonComponents.f_237098_;
    }

    void m_171811_(InetSocketAddress p_171812_, final ServerAddress p_300887_, final ServerData p_171813_) {
        ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)Connection.f_129462_.get())).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel p_105498_) {
                try {
                    p_105498_.config().setOption(ChannelOption.TCP_NODELAY, (Object)true);
                }
                catch (ChannelException channelException) {
                    // empty catch block
                }
                p_105498_.pipeline().addLast(new ChannelHandler[]{new LegacyServerPinger(p_300887_, (p_298744_, p_300358_, p_297298_, p_299389_, p_297985_) -> {
                    p_298695_.f_105367_ = -1;
                    p_298695_.f_105368_ = Component.m_237113_((String)p_300358_);
                    p_298695_.f_105365_ = Component.m_237113_((String)p_297298_);
                    p_298695_.f_105364_ = ServerStatusPinger.m_105466_(p_299389_, p_297985_);
                    p_298695_.f_263840_ = new ServerStatus.Players(p_297985_, p_299389_, List.of());
                })});
            }
        })).channel(NioSocketChannel.class)).connect(p_171812_.getAddress(), p_171812_.getPort());
    }

    public static Component m_105466_(int p_105467_, int p_105468_) {
        MutableComponent component = Component.m_237113_((String)Integer.toString(p_105467_)).m_130940_(ChatFormatting.GRAY);
        MutableComponent component1 = Component.m_237113_((String)Integer.toString(p_105468_)).m_130940_(ChatFormatting.GRAY);
        return Component.m_237110_((String)"multiplayer.status.player_count", (Object[])new Object[]{component, component1}).m_130940_(ChatFormatting.DARK_GRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_105453_() {
        List<Connection> list = this.f_105450_;
        synchronized (list) {
            Iterator<Connection> iterator = this.f_105450_.iterator();
            while (iterator.hasNext()) {
                Connection connection = iterator.next();
                if (connection.m_129536_()) {
                    connection.m_129483_();
                    continue;
                }
                iterator.remove();
                connection.m_129541_();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_105465_() {
        List<Connection> list = this.f_105450_;
        synchronized (list) {
            Iterator<Connection> iterator = this.f_105450_.iterator();
            while (iterator.hasNext()) {
                Connection connection = iterator.next();
                if (!connection.m_129536_()) continue;
                iterator.remove();
                connection.m_129507_((Component)Component.m_237115_((String)"multiplayer.status.cancelled"));
            }
        }
    }
}

