/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.time.Instant;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.DebugQueryHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.MapRenderer;
import net.minecraft.client.gui.components.toasts.RecipeToast;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.client.gui.screens.DemoIntroScreen;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.WinScreen;
import net.minecraft.client.gui.screens.achievement.StatsUpdateListener;
import net.minecraft.client.gui.screens.inventory.BookViewScreen;
import net.minecraft.client.gui.screens.inventory.CommandBlockEditScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.HorseInventoryScreen;
import net.minecraft.client.gui.screens.multiplayer.ServerReconfigScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.client.multiplayer.ChunkBatchSizeCalculator;
import net.minecraft.client.multiplayer.ClientAdvancements;
import net.minecraft.client.multiplayer.ClientCommonPacketListenerImpl;
import net.minecraft.client.multiplayer.ClientConfigurationPacketListenerImpl;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientSuggestionProvider;
import net.minecraft.client.multiplayer.CommonListenerCookie;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.multiplayer.PingDebugMonitor;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.multiplayer.ProfileKeyPairManager;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.particle.ItemPickupParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.KeyboardInput;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.client.renderer.debug.BrainDebugRenderer;
import net.minecraft.client.renderer.debug.NeighborsUpdateRenderer;
import net.minecraft.client.renderer.debug.VillageSectionsDebugRenderer;
import net.minecraft.client.renderer.debug.WorldGenAttemptRenderer;
import net.minecraft.client.resources.sounds.BeeAggressiveSoundInstance;
import net.minecraft.client.resources.sounds.BeeFlyingSoundInstance;
import net.minecraft.client.resources.sounds.GuardianAttackSoundInstance;
import net.minecraft.client.resources.sounds.MinecartSoundInstance;
import net.minecraft.client.resources.sounds.SnifferSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.client.searchtree.SearchRegistry;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ArgumentSignatures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketListener;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.LastSeenMessagesTracker;
import net.minecraft.network.chat.LocalChatSession;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.MessageSignatureCache;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.chat.SignableCommand;
import net.minecraft.network.chat.SignedMessageBody;
import net.minecraft.network.chat.SignedMessageChain;
import net.minecraft.network.chat.SignedMessageLink;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketUtils;
import net.minecraft.network.protocol.common.ClientboundUpdateTagsPacket;
import net.minecraft.network.protocol.common.custom.BeeDebugPayload;
import net.minecraft.network.protocol.common.custom.BrainDebugPayload;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.common.custom.GameEventDebugPayload;
import net.minecraft.network.protocol.common.custom.GameEventListenerDebugPayload;
import net.minecraft.network.protocol.common.custom.GameTestAddMarkerDebugPayload;
import net.minecraft.network.protocol.common.custom.GameTestClearMarkersDebugPayload;
import net.minecraft.network.protocol.common.custom.GoalDebugPayload;
import net.minecraft.network.protocol.common.custom.HiveDebugPayload;
import net.minecraft.network.protocol.common.custom.NeighborUpdatesDebugPayload;
import net.minecraft.network.protocol.common.custom.PathfindingDebugPayload;
import net.minecraft.network.protocol.common.custom.PoiAddedDebugPayload;
import net.minecraft.network.protocol.common.custom.PoiRemovedDebugPayload;
import net.minecraft.network.protocol.common.custom.PoiTicketCountDebugPayload;
import net.minecraft.network.protocol.common.custom.RaidsDebugPayload;
import net.minecraft.network.protocol.common.custom.StructuresDebugPayload;
import net.minecraft.network.protocol.common.custom.VillageSectionsDebugPayload;
import net.minecraft.network.protocol.common.custom.WorldGenAttemptDebugPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundAddExperienceOrbPacket;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.network.protocol.game.ClientboundAwardStatsPacket;
import net.minecraft.network.protocol.game.ClientboundBlockChangedAckPacket;
import net.minecraft.network.protocol.game.ClientboundBlockDestructionPacket;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundBlockEventPacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundBossEventPacket;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ClientboundChunkBatchFinishedPacket;
import net.minecraft.network.protocol.game.ClientboundChunkBatchStartPacket;
import net.minecraft.network.protocol.game.ClientboundChunksBiomesPacket;
import net.minecraft.network.protocol.game.ClientboundClearTitlesPacket;
import net.minecraft.network.protocol.game.ClientboundCommandSuggestionsPacket;
import net.minecraft.network.protocol.game.ClientboundCommandsPacket;
import net.minecraft.network.protocol.game.ClientboundContainerClosePacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetContentPacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetDataPacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.network.protocol.game.ClientboundCooldownPacket;
import net.minecraft.network.protocol.game.ClientboundCustomChatCompletionsPacket;
import net.minecraft.network.protocol.game.ClientboundDamageEventPacket;
import net.minecraft.network.protocol.game.ClientboundDeleteChatPacket;
import net.minecraft.network.protocol.game.ClientboundDisguisedChatPacket;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.network.protocol.game.ClientboundForgetLevelChunkPacket;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.protocol.game.ClientboundHorseScreenOpenPacket;
import net.minecraft.network.protocol.game.ClientboundHurtAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundInitializeBorderPacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacketData;
import net.minecraft.network.protocol.game.ClientboundLoginPacket;
import net.minecraft.network.protocol.game.ClientboundMapItemDataPacket;
import net.minecraft.network.protocol.game.ClientboundMerchantOffersPacket;
import net.minecraft.network.protocol.game.ClientboundMoveEntityPacket;
import net.minecraft.network.protocol.game.ClientboundMoveVehiclePacket;
import net.minecraft.network.protocol.game.ClientboundOpenBookPacket;
import net.minecraft.network.protocol.game.ClientboundOpenScreenPacket;
import net.minecraft.network.protocol.game.ClientboundOpenSignEditorPacket;
import net.minecraft.network.protocol.game.ClientboundPlaceGhostRecipePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEndPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEnterPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerLookAtPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerPositionPacket;
import net.minecraft.network.protocol.game.ClientboundRecipePacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundRemoveMobEffectPacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import net.minecraft.network.protocol.game.ClientboundRotateHeadPacket;
import net.minecraft.network.protocol.game.ClientboundSectionBlocksUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSelectAdvancementsTabPacket;
import net.minecraft.network.protocol.game.ClientboundServerDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderLerpSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.network.protocol.game.ClientboundSetCameraPacket;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.network.protocol.game.ClientboundSetChunkCacheCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetChunkCacheRadiusPacket;
import net.minecraft.network.protocol.game.ClientboundSetDefaultSpawnPositionPacket;
import net.minecraft.network.protocol.game.ClientboundSetDisplayObjectivePacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.network.protocol.game.ClientboundSetHealthPacket;
import net.minecraft.network.protocol.game.ClientboundSetObjectivePacket;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.network.protocol.game.ClientboundSetPlayerTeamPacket;
import net.minecraft.network.protocol.game.ClientboundSetScorePacket;
import net.minecraft.network.protocol.game.ClientboundSetSimulationDistancePacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTimePacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundSoundEntityPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.protocol.game.ClientboundStartConfigurationPacket;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.ClientboundTabListPacket;
import net.minecraft.network.protocol.game.ClientboundTagQueryPacket;
import net.minecraft.network.protocol.game.ClientboundTakeItemEntityPacket;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateAdvancementsPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateAttributesPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateRecipesPacket;
import net.minecraft.network.protocol.game.CommonPlayerSpawnInfo;
import net.minecraft.network.protocol.game.ServerboundAcceptTeleportationPacket;
import net.minecraft.network.protocol.game.ServerboundChatAckPacket;
import net.minecraft.network.protocol.game.ServerboundChatCommandPacket;
import net.minecraft.network.protocol.game.ServerboundChatPacket;
import net.minecraft.network.protocol.game.ServerboundChatSessionUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundChunkBatchReceivedPacket;
import net.minecraft.network.protocol.game.ServerboundClientCommandPacket;
import net.minecraft.network.protocol.game.ServerboundConfigurationAcknowledgedPacket;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.network.protocol.game.ServerboundMoveVehiclePacket;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.protocol.status.ClientboundPongResponsePacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.RecipeBook;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatsCounter;
import net.minecraft.util.Crypt;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SignatureValidator;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.Container;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.ProfileKeyPair;
import net.minecraft.world.entity.player.ProfilePublicKey;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.HorseInventoryMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Score;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.Event;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ClientPacketListener
extends ClientCommonPacketListenerImpl
implements TickablePacketListener,
ClientGamePacketListener {
    private static final Logger f_104883_ = LogUtils.getLogger();
    private static final Component f_242953_ = Component.m_237115_((String)"multiplayer.unsecureserver.toast.title");
    private static final Component f_242949_ = Component.m_237115_((String)"multiplayer.unsecureserver.toast");
    private static final Component f_244321_ = Component.m_237115_((String)"multiplayer.disconnect.invalid_packet");
    private static final Component f_243809_ = Component.m_237115_((String)"multiplayer.disconnect.chat_validation_failed");
    private static final Component f_291494_ = Component.m_237115_((String)"connect.reconfiguring");
    private static final int f_243949_ = 64;
    private final GameProfile f_104886_;
    private ClientLevel f_104889_;
    private ClientLevel.ClientLevelData f_104890_;
    private final Map<UUID, PlayerInfo> f_104892_ = Maps.newHashMap();
    private final Set<PlayerInfo> f_244156_ = new ReferenceOpenHashSet();
    private final ClientAdvancements f_104893_;
    private final ClientSuggestionProvider f_104894_;
    private final DebugQueryHandler f_104896_ = new DebugQueryHandler(this);
    private int f_104897_ = 3;
    private int f_194190_ = 3;
    private final RandomSource f_104898_ = RandomSource.m_216337_();
    public CommandDispatcher<SharedSuggestionProvider> f_104899_ = new CommandDispatcher();
    private final RecipeManager f_104900_ = new RecipeManager();
    private final UUID f_104901_ = UUID.randomUUID();
    private Set<ResourceKey<Level>> f_104902_;
    private final RegistryAccess.Frozen f_104903_;
    private final FeatureFlagSet f_244039_;
    @Nullable
    private LocalChatSession f_252517_;
    private SignedMessageChain.Encoder f_240902_ = SignedMessageChain.Encoder.f_243849_;
    private LastSeenMessagesTracker f_244346_ = new LastSeenMessagesTracker(20);
    private MessageSignatureCache f_244113_ = MessageSignatureCache.m_246587_();
    private final ChunkBatchSizeCalculator f_291253_ = new ChunkBatchSizeCalculator();
    private final PingDebugMonitor f_290671_;
    private boolean f_291332_ = false;
    private volatile boolean f_291533_;

    public ClientPacketListener(Minecraft p_253924_, Connection p_253614_, CommonListenerCookie p_298329_) {
        super(p_253924_, p_253614_, p_298329_);
        this.f_104886_ = p_298329_.f_291743_();
        this.f_104903_ = p_298329_.f_291549_();
        this.f_244039_ = p_298329_.f_290859_();
        this.f_104893_ = new ClientAdvancements(p_253924_, this.f_291019_);
        this.f_104894_ = new ClientSuggestionProvider(this, p_253924_);
        this.f_290671_ = new PingDebugMonitor(this, p_253924_.m_293199_().m_294664_());
    }

    public ClientSuggestionProvider m_105137_() {
        return this.f_104894_;
    }

    public void m_261044_() {
        this.f_291533_ = true;
        this.f_104889_ = null;
        this.f_291019_.m_261027_();
    }

    public RecipeManager m_105141_() {
        return this.f_104900_;
    }

    public void m_5998_(ClientboundLoginPacket p_105030_) {
        ClientLevel.ClientLevelData clientlevel$clientleveldata;
        PacketUtils.m_131363_((Packet)p_105030_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        this.m_295411_();
        this.f_291812_.f_91072_ = new MultiPlayerGameMode(this.f_291812_, this);
        CommonPlayerSpawnInfo commonplayerspawninfo = p_105030_.f_291078_();
        ArrayList list = Lists.newArrayList((Iterable)p_105030_.f_132365_());
        Collections.shuffle(list);
        this.f_104902_ = Sets.newLinkedHashSet((Iterable)list);
        ResourceKey resourcekey = commonplayerspawninfo.f_290731_();
        Holder.Reference holder = this.f_104903_.m_175515_(Registries.f_256787_).m_246971_(commonplayerspawninfo.f_291865_());
        this.f_104897_ = p_105030_.f_132370_();
        this.f_194190_ = p_105030_.f_195761_();
        boolean flag = commonplayerspawninfo.f_290330_();
        boolean flag1 = commonplayerspawninfo.f_290486_();
        this.f_104890_ = clientlevel$clientleveldata = new ClientLevel.ClientLevelData(Difficulty.NORMAL, p_105030_.f_132362_(), flag1);
        this.f_104889_ = new ClientLevel(this, clientlevel$clientleveldata, resourcekey, holder, this.f_104897_, this.f_194190_, this.f_291812_::m_91307_, this.f_291812_.f_91060_, flag, commonplayerspawninfo.f_290589_());
        this.f_291812_.m_91156_(this.f_104889_);
        if (this.f_291812_.f_91074_ == null) {
            this.f_291812_.f_91074_ = this.f_291812_.f_91072_.m_105246_(this.f_104889_, new StatsCounter(), new ClientRecipeBook());
            this.f_291812_.f_91074_.m_146922_(-180.0f);
            if (this.f_291812_.m_91092_() != null) {
                this.f_291812_.m_91092_().m_120046_(this.f_291812_.f_91074_.m_20148_());
            }
        }
        this.f_291812_.f_91064_.m_113434_();
        this.f_291812_.f_91074_.m_172530_();
        ForgeHooksClient.firePlayerLogin((MultiPlayerGameMode)this.f_291812_.f_91072_, (LocalPlayer)this.f_291812_.f_91074_, (Connection)this.f_291812_.m_91403_().f_290549_);
        this.f_291812_.f_91074_.m_20234_(p_105030_.f_132360_());
        this.f_104889_.m_104739_(this.f_291812_.f_91074_);
        this.f_291812_.f_91074_.f_108618_ = new KeyboardInput(this.f_291812_.f_91066_);
        this.f_291812_.f_91072_.m_105221_(this.f_291812_.f_91074_);
        this.f_291812_.f_91075_ = this.f_291812_.f_91074_;
        this.f_291812_.m_91152_((Screen)new ReceivingLevelScreen());
        this.f_291812_.f_91074_.m_36393_(p_105030_.f_132371_());
        this.f_291812_.f_91074_.m_108711_(p_105030_.f_132372_());
        this.f_291812_.f_91074_.m_294300_(p_105030_.f_291478_());
        this.f_291812_.f_91074_.m_219749_(commonplayerspawninfo.f_290601_());
        this.f_291812_.f_91074_.m_287199_(commonplayerspawninfo.f_291470_());
        this.f_291812_.f_91072_.m_171805_(commonplayerspawninfo.f_291098_(), commonplayerspawninfo.f_290730_());
        this.f_291812_.f_91066_.m_193770_(p_105030_.f_132370_());
        this.f_252517_ = null;
        this.f_244346_ = new LastSeenMessagesTracker(20);
        this.f_244113_ = MessageSignatureCache.m_246587_();
        if (this.f_290549_.m_129535_()) {
            this.f_291812_.m_231465_().m_252904_().thenAcceptAsync(p_253341_ -> p_253341_.ifPresent(this::m_260951_), (Executor)((Object)this.f_291812_));
        }
        this.f_291019_.m_260888_(commonplayerspawninfo.f_291098_(), p_105030_.f_132362_());
        this.f_291812_.m_278644_().m_278768_(this.f_291812_);
    }

    public void m_6771_(ClientboundAddEntityPacket p_104958_) {
        PacketUtils.m_131363_((Packet)p_104958_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        Entity entity = this.m_301496_(p_104958_);
        if (entity != null) {
            entity.m_141965_(p_104958_);
            this.f_104889_.m_104739_(entity);
            this.m_233663_(entity);
        } else {
            f_104883_.warn("Skipping Entity with id {}", (Object)p_104958_.m_131508_());
        }
    }

    @Nullable
    private Entity m_301496_(ClientboundAddEntityPacket p_301611_) {
        EntityType entitytype = p_301611_.m_131508_();
        if (entitytype == EntityType.f_20532_) {
            PlayerInfo playerinfo = this.m_104949_(p_301611_.m_131499_());
            if (playerinfo == null) {
                f_104883_.warn("Server attempted to add player prior to sending player info (Player id {})", (Object)p_301611_.m_131499_());
                return null;
            }
            return new RemotePlayer(this.f_104889_, playerinfo.m_105312_());
        }
        return entitytype.m_20615_(this.f_104889_);
    }

    private void m_233663_(Entity p_233664_) {
        if (p_233664_ instanceof AbstractMinecart) {
            AbstractMinecart abstractminecart = (AbstractMinecart)p_233664_;
            this.f_291812_.m_91106_().m_120367_((SoundInstance)new MinecartSoundInstance(abstractminecart));
        } else if (p_233664_ instanceof Bee) {
            Bee bee = (Bee)((Object)p_233664_);
            boolean flag = bee.m_21660_();
            Object beesoundinstance = flag ? new BeeAggressiveSoundInstance(bee) : new BeeFlyingSoundInstance(bee);
            this.f_291812_.m_91106_().m_120372_((TickableSoundInstance)beesoundinstance);
        }
    }

    public void m_7708_(ClientboundAddExperienceOrbPacket p_104960_) {
        PacketUtils.m_131363_((Packet)p_104960_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        double d0 = p_104960_.m_131527_();
        double d1 = p_104960_.m_131528_();
        double d2 = p_104960_.m_131529_();
        ExperienceOrb entity = new ExperienceOrb(this.f_104889_, d0, d1, d2, p_104960_.m_131530_());
        entity.m_217006_(d0, d1, d2);
        entity.m_146922_(0.0f);
        entity.m_146926_(0.0f);
        entity.m_20234_(p_104960_.m_131524_());
        this.f_104889_.m_104739_(entity);
    }

    public void m_8048_(ClientboundSetEntityMotionPacket p_105092_) {
        PacketUtils.m_131363_((Packet)p_105092_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        Entity entity = this.f_104889_.m_6815_(p_105092_.m_133192_());
        if (entity != null) {
            entity.m_6001_((double)p_105092_.m_133195_() / 8000.0, (double)p_105092_.m_133196_() / 8000.0, (double)p_105092_.m_133197_() / 8000.0);
        }
    }

    public void m_6455_(ClientboundSetEntityDataPacket p_105088_) {
        PacketUtils.m_131363_((Packet)p_105088_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        Entity entity = this.f_104889_.m_6815_(p_105088_.f_133143_());
        if (entity != null) {
            entity.m_20088_().m_135356_(p_105088_.f_133144_());
        }
    }

    public void m_6435_(ClientboundTeleportEntityPacket p_105124_) {
        PacketUtils.m_131363_((Packet)p_105124_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        Entity entity = this.f_104889_.m_6815_(p_105124_.m_133545_());
        if (entity != null) {
            double d0 = p_105124_.m_133548_();
            double d1 = p_105124_.m_133549_();
            double d2 = p_105124_.m_133550_();
            entity.m_217006_(d0, d1, d2);
            if (!entity.m_6109_()) {
                float f = (float)(p_105124_.m_133551_() * 360) / 256.0f;
                float f1 = (float)(p_105124_.m_133552_() * 360) / 256.0f;
                entity.m_6453_(d0, d1, d2, f, f1, 3);
                entity.m_6853_(p_105124_.m_133553_());
            }
        }
    }

    public void m_5612_(ClientboundSetCarriedItemPacket p_105078_) {
        PacketUtils.m_131363_((Packet)p_105078_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        if (Inventory.m_36045_(p_105078_.m_133079_())) {
            this.f_291812_.f_91074_.m_150109_().f_35977_ = p_105078_.m_133079_();
        }
    }

    public void m_7865_(ClientboundMoveEntityPacket p_105036_) {
        PacketUtils.m_131363_((Packet)p_105036_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        Entity entity = p_105036_.m_132519_((Level)this.f_104889_);
        if (entity != null && !entity.m_6109_()) {
            if (p_105036_.m_132534_()) {
                VecDeltaCodec vecdeltacodec = entity.m_217001_();
                Vec3 vec3 = vecdeltacodec.m_238021_((long)p_105036_.m_178997_(), (long)p_105036_.m_178998_(), (long)p_105036_.m_178999_());
                vecdeltacodec.m_238033_(vec3);
                float f = p_105036_.m_132533_() ? (float)(p_105036_.m_132531_() * 360) / 256.0f : entity.m_293582_();
                float f1 = p_105036_.m_132533_() ? (float)(p_105036_.m_132532_() * 360) / 256.0f : entity.m_293123_();
                entity.m_6453_(vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), f, f1, 3);
            } else if (p_105036_.m_132533_()) {
                float f2 = (float)(p_105036_.m_132531_() * 360) / 256.0f;
                float f3 = (float)(p_105036_.m_132532_() * 360) / 256.0f;
                entity.m_6453_(entity.m_293268_(), entity.m_293950_(), entity.m_292720_(), f2, f3, 3);
            }
            entity.m_6853_(p_105036_.m_132535_());
        }
    }

    public void m_6176_(ClientboundRotateHeadPacket p_105068_) {
        PacketUtils.m_131363_((Packet)p_105068_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        Entity entity = p_105068_.m_132969_((Level)this.f_104889_);
        if (entity != null) {
            float f = (float)(p_105068_.m_132977_() * 360) / 256.0f;
            entity.m_6541_(f, 3);
        }
    }

    public void m_182047_(ClientboundRemoveEntitiesPacket p_182633_) {
        PacketUtils.m_131363_((Packet)p_182633_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        p_182633_.m_182730_().forEach(p_205521_ -> this.f_104889_.m_171642_(p_205521_, Entity.RemovalReason.DISCARDED));
    }

    public void m_5682_(ClientboundPlayerPositionPacket p_105056_) {
        double d5;
        double d4;
        double d3;
        double d2;
        double d1;
        double d0;
        PacketUtils.m_131363_((Packet)p_105056_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        LocalPlayer player = this.f_291812_.f_91074_;
        Vec3 vec3 = player.m_20184_();
        boolean flag = p_105056_.m_132826_().contains(RelativeMovement.X);
        boolean flag1 = p_105056_.m_132826_().contains(RelativeMovement.Y);
        boolean flag2 = p_105056_.m_132826_().contains(RelativeMovement.Z);
        if (flag) {
            d0 = vec3.m_7096_();
            d1 = player.m_20185_() + p_105056_.m_132818_();
            player.f_19790_ += p_105056_.m_132818_();
            player.f_19854_ += p_105056_.m_132818_();
        } else {
            d0 = 0.0;
            player.f_19790_ = d1 = p_105056_.m_132818_();
            player.f_19854_ = d1;
        }
        if (flag1) {
            d2 = vec3.m_7098_();
            d3 = player.m_20186_() + p_105056_.m_132821_();
            player.f_19791_ += p_105056_.m_132821_();
            player.f_19855_ += p_105056_.m_132821_();
        } else {
            d2 = 0.0;
            player.f_19791_ = d3 = p_105056_.m_132821_();
            player.f_19855_ = d3;
        }
        if (flag2) {
            d4 = vec3.m_7094_();
            d5 = player.m_20189_() + p_105056_.m_132822_();
            player.f_19792_ += p_105056_.m_132822_();
            player.f_19856_ += p_105056_.m_132822_();
        } else {
            d4 = 0.0;
            player.f_19792_ = d5 = p_105056_.m_132822_();
            player.f_19856_ = d5;
        }
        player.m_6034_(d1, d3, d5);
        player.m_20334_(d0, d2, d4);
        float f = p_105056_.m_132823_();
        float f1 = p_105056_.m_132824_();
        if (p_105056_.m_132826_().contains(RelativeMovement.X_ROT)) {
            player.m_146926_(player.m_146909_() + f1);
            player.f_19860_ += f1;
        } else {
            player.m_146926_(f1);
            player.f_19860_ = f1;
        }
        if (p_105056_.m_132826_().contains(RelativeMovement.Y_ROT)) {
            player.m_146922_(player.m_146908_() + f);
            player.f_19859_ += f;
        } else {
            player.m_146922_(f);
            player.f_19859_ = f;
        }
        this.f_290549_.m_129512_((Packet<?>)new ServerboundAcceptTeleportationPacket(p_105056_.m_132825_()));
        this.f_290549_.m_129512_((Packet<?>)new ServerboundMovePlayerPacket.PosRot(player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_146908_(), player.m_146909_(), false));
    }

    public void m_5771_(ClientboundSectionBlocksUpdatePacket p_105070_) {
        PacketUtils.m_131363_((Packet)p_105070_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        p_105070_.m_132992_((p_284633_, p_284634_) -> this.f_104889_.m_233653_((BlockPos)p_284633_, (BlockState)((Object)p_284634_), 19));
    }

    public void m_183388_(ClientboundLevelChunkWithLightPacket p_194241_) {
        PacketUtils.m_131363_((Packet)p_194241_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        int i = p_194241_.m_195717_();
        int j = p_194241_.m_195718_();
        this.m_194198_(i, j, p_194241_.m_195719_());
        ClientboundLightUpdatePacketData clientboundlightupdatepacketdata = p_194241_.m_195720_();
        this.f_104889_.m_194171_(() -> {
            this.m_194248_(i, j, clientboundlightupdatepacketdata);
            LevelChunk levelchunk = this.f_104889_.m_7726_().m_62227_(i, j, false);
            if (levelchunk != null) {
                this.m_194212_(levelchunk, i, j);
            }
        });
    }

    public void m_274374_(ClientboundChunksBiomesPacket p_275437_) {
        PacketUtils.m_131363_((Packet)p_275437_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        for (ClientboundChunksBiomesPacket.ChunkBiomeData clientboundchunksbiomespacket$chunkbiomedata : p_275437_.f_273816_()) {
            this.f_104889_.m_7726_().m_274444_(clientboundchunksbiomespacket$chunkbiomedata.f_273927_().f_45578_, clientboundchunksbiomespacket$chunkbiomedata.f_273927_().f_45579_, clientboundchunksbiomespacket$chunkbiomedata.m_274543_());
        }
        for (ClientboundChunksBiomesPacket.ChunkBiomeData clientboundchunksbiomespacket$chunkbiomedata1 : p_275437_.f_273816_()) {
            this.f_104889_.m_171649_(new ChunkPos(clientboundchunksbiomespacket$chunkbiomedata1.f_273927_().f_45578_, clientboundchunksbiomespacket$chunkbiomedata1.f_273927_().f_45579_));
        }
        for (ClientboundChunksBiomesPacket.ChunkBiomeData clientboundchunksbiomespacket$chunkbiomedata2 : p_275437_.f_273816_()) {
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    for (int k = this.f_104889_.m_151560_(); k < this.f_104889_.m_151561_(); ++k) {
                        this.f_291812_.f_91060_.m_109770_(clientboundchunksbiomespacket$chunkbiomedata2.f_273927_().f_45578_ + i, k, clientboundchunksbiomespacket$chunkbiomedata2.f_273927_().f_45579_ + j);
                    }
                }
            }
        }
    }

    private void m_194198_(int p_194199_, int p_194200_, ClientboundLevelChunkPacketData p_194201_) {
        this.f_104889_.m_7726_().m_194116_(p_194199_, p_194200_, p_194201_.m_195656_(), p_194201_.m_195678_(), p_194201_.m_195657_(p_194199_, p_194200_));
    }

    private void m_194212_(LevelChunk p_194213_, int p_194214_, int p_194215_) {
        LevelLightEngine levellightengine = this.f_104889_.m_7726_().m_7827_();
        LevelChunkSection[] alevelchunksection = p_194213_.m_7103_();
        ChunkPos chunkpos = p_194213_.m_7697_();
        for (int i = 0; i < alevelchunksection.length; ++i) {
            LevelChunkSection levelchunksection = alevelchunksection[i];
            int j = this.f_104889_.m_151568_(i);
            levellightengine.m_6191_(SectionPos.m_123196_((ChunkPos)chunkpos, (int)j), levelchunksection.m_188008_());
            this.f_104889_.m_104793_(p_194214_, j, p_194215_);
        }
    }

    public void m_5729_(ClientboundForgetLevelChunkPacket p_105014_) {
        PacketUtils.m_131363_((Packet)p_105014_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        this.f_104889_.m_7726_().m_104455_(p_105014_.f_290761_());
        this.m_194252_(p_105014_);
    }

    private void m_194252_(ClientboundForgetLevelChunkPacket p_194253_) {
        ChunkPos chunkpos = p_194253_.f_290761_();
        this.f_104889_.m_194171_(() -> {
            LevelLightEngine levellightengine = this.f_104889_.m_5518_();
            levellightengine.m_9335_(chunkpos, false);
            for (int i = levellightengine.m_164447_(); i < levellightengine.m_164448_(); ++i) {
                SectionPos sectionpos = SectionPos.m_123196_((ChunkPos)chunkpos, (int)i);
                levellightengine.m_284126_(LightLayer.BLOCK, sectionpos, (DataLayer)null);
                levellightengine.m_284126_(LightLayer.SKY, sectionpos, (DataLayer)null);
            }
            for (int j = this.f_104889_.m_151560_(); j < this.f_104889_.m_151561_(); ++j) {
                levellightengine.m_6191_(SectionPos.m_123196_((ChunkPos)chunkpos, (int)j), true);
            }
        });
    }

    public void m_6773_(ClientboundBlockUpdatePacket p_104980_) {
        PacketUtils.m_131363_((Packet)p_104980_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        this.f_104889_.m_233653_(p_104980_.m_131749_(), p_104980_.m_131746_(), 19);
    }

    public void m_292634_(ClientboundStartConfigurationPacket p_298839_) {
        this.f_290549_.m_294044_();
        PacketUtils.m_131363_((Packet)p_298839_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        this.f_291812_.m_294188_((Screen)new ServerReconfigScreen(f_291494_, this.f_290549_));
        this.f_290549_.m_129505_((PacketListener)new ClientConfigurationPacketListenerImpl(this.f_291812_, this.f_290549_, new CommonListenerCookie(this.f_104886_, this.f_291019_, this.f_104903_, this.f_244039_, this.f_291180_, this.f_291024_, this.f_291028_)));
        this.f_290549_.m_294304_();
        this.m_295327_((Packet<?>)new ServerboundConfigurationAcknowledgedPacket());
    }

    public void m_8001_(ClientboundTakeItemEntityPacket p_105122_) {
        PacketUtils.m_131363_((Packet)p_105122_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        Entity entity = this.f_104889_.m_6815_(p_105122_.m_133524_());
        LivingEntity livingentity = (LivingEntity)this.f_104889_.m_6815_(p_105122_.m_133527_());
        if (livingentity == null) {
            livingentity = this.f_291812_.f_91074_;
        }
        if (entity != null) {
            if (entity instanceof ExperienceOrb) {
                this.f_104889_.m_7785_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.1f, (this.f_104898_.m_188501_() - this.f_104898_.m_188501_()) * 0.35f + 0.9f, false);
            } else {
                this.f_104889_.m_7785_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, (this.f_104898_.m_188501_() - this.f_104898_.m_188501_()) * 1.4f + 2.0f, false);
            }
            this.f_291812_.f_91061_.m_107344_((Particle)new ItemPickupParticle(this.f_291812_.m_91290_(), this.f_291812_.m_91269_(), this.f_104889_, entity, (Entity)livingentity));
            if (entity instanceof ItemEntity) {
                ItemEntity itementity = (ItemEntity)entity;
                ItemStack itemstack = itementity.m_32055_();
                if (!itemstack.m_41619_()) {
                    itemstack.m_41774_(p_105122_.m_133528_());
                }
                if (itemstack.m_41619_()) {
                    this.f_104889_.m_171642_(p_105122_.m_133524_(), Entity.RemovalReason.DISCARDED);
                }
            } else if (!(entity instanceof ExperienceOrb)) {
                this.f_104889_.m_171642_(p_105122_.m_133524_(), Entity.RemovalReason.DISCARDED);
            }
        }
    }

    public void m_213990_(ClientboundSystemChatPacket p_233708_) {
        PacketUtils.m_131363_((Packet)p_233708_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        this.f_291812_.m_240442_().m_240494_(p_233708_.f_237849_(), p_233708_.f_240374_());
    }

    public void m_213629_(ClientboundPlayerChatPacket p_233702_) {
        PacketUtils.m_131363_((Packet)p_233702_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        Optional optional = p_233702_.f_244090_().m_252762_(this.f_244113_);
        Optional optional1 = p_233702_.f_240897_().m_242652_((RegistryAccess)this.f_104903_);
        if (!optional.isEmpty() && !optional1.isEmpty()) {
            UUID uuid = p_233702_.f_243918_();
            PlayerInfo playerinfo = this.m_104949_(uuid);
            if (playerinfo == null) {
                f_104883_.error("Received player chat packet for unknown player with ID: {}", (Object)uuid);
                this.f_290549_.m_129507_(f_243809_);
            } else {
                RemoteChatSession remotechatsession = playerinfo.m_247593_();
                SignedMessageLink signedmessagelink = remotechatsession != null ? new SignedMessageLink(p_233702_.f_244283_(), uuid, remotechatsession.f_244448_()) : SignedMessageLink.m_245187_((UUID)uuid);
                PlayerChatMessage playerchatmessage = new PlayerChatMessage(signedmessagelink, p_233702_.f_243836_(), (SignedMessageBody)optional.get(), p_233702_.f_243686_(), p_233702_.f_243744_());
                if (!playerinfo.m_241043_().m_241126_(playerchatmessage)) {
                    this.f_291812_.m_240442_().m_294071_(uuid, (ChatType.Bound)optional1.get());
                } else {
                    this.f_291812_.m_240442_().m_247425_(playerchatmessage, playerinfo.m_105312_(), (ChatType.Bound)optional1.get());
                    this.f_244113_.m_247208_(playerchatmessage);
                }
            }
        } else {
            this.f_290549_.m_129507_(f_244321_);
        }
    }

    public void m_7039_(ClientboundDisguisedChatPacket p_251920_) {
        PacketUtils.m_131363_((Packet)p_251920_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        Optional optional = p_251920_.f_244252_().m_242652_((RegistryAccess)this.f_104903_);
        if (optional.isEmpty()) {
            this.f_290549_.m_129507_(f_244321_);
        } else {
            this.f_291812_.m_240442_().m_245141_(p_251920_.f_244491_(), (ChatType.Bound)optional.get());
        }
    }

    public void m_241037_(ClientboundDeleteChatPacket p_241325_) {
        PacketUtils.m_131363_((Packet)p_241325_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        Optional optional = p_241325_.f_240904_().m_253223_(this.f_244113_);
        if (optional.isEmpty()) {
            this.f_290549_.m_129507_(f_244321_);
        } else {
            this.f_244346_.m_246067_((MessageSignature)optional.get());
            if (!this.f_291812_.m_240442_().m_240956_((MessageSignature)optional.get())) {
                this.f_291812_.f_91065_.m_93076_().m_240953_((MessageSignature)optional.get());
            }
        }
    }

    public void m_7791_(ClientboundAnimatePacket p_104968_) {
        PacketUtils.m_131363_((Packet)p_104968_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        Entity entity = this.f_104889_.m_6815_(p_104968_.m_131624_());
        if (entity != null) {
            if (p_104968_.m_131627_() == 0) {
                LivingEntity livingentity = (LivingEntity)entity;
                livingentity.m_6674_(InteractionHand.MAIN_HAND);
            } else if (p_104968_.m_131627_() == 3) {
                LivingEntity livingentity1 = (LivingEntity)entity;
                livingentity1.m_6674_(InteractionHand.OFF_HAND);
            } else if (p_104968_.m_131627_() == 2) {
                Player player = (Player)entity;
                player.m_6145_(false, false);
            } else if (p_104968_.m_131627_() == 4) {
                this.f_291812_.f_91061_.m_107329_(entity, (ParticleOptions)ParticleTypes.f_123797_);
            } else if (p_104968_.m_131627_() == 5) {
                this.f_291812_.f_91061_.m_107329_(entity, (ParticleOptions)ParticleTypes.f_123808_);
            }
        }
    }

    public void m_264143_(ClientboundHurtAnimationPacket p_265581_) {
        PacketUtils.m_131363_((Packet)p_265581_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        Entity entity = this.f_104889_.m_6815_(p_265581_.f_263825_());
        if (entity != null) {
            entity.m_6053_(p_265581_.f_263826_());
        }
    }

    public void m_7885_(ClientboundSetTimePacket p_105108_) {
        PacketUtils.m_131363_((Packet)p_105108_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        this.f_291812_.f_91073_.m_104637_(p_105108_.m_133358_());
        this.f_291812_.f_91073_.m_104746_(p_105108_.m_133361_());
        this.f_291019_.m_261206_(p_105108_.m_133358_());
    }

    public void m_6571_(ClientboundSetDefaultSpawnPositionPacket p_105084_) {
        PacketUtils.m_131363_((Packet)p_105084_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        this.f_291812_.f_91073_.m_104752_(p_105084_.m_133123_(), p_105084_.m_133126_());
        Screen screen = this.f_291812_.f_91080_;
        if (screen instanceof ReceivingLevelScreen) {
            ReceivingLevelScreen receivinglevelscreen = (ReceivingLevelScreen)screen;
            receivinglevelscreen.m_202375_();
        }
    }

    public void m_6403_(ClientboundSetPassengersPacket p_105102_) {
        PacketUtils.m_131363_((Packet)p_105102_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        Entity entity = this.f_104889_.m_6815_(p_105102_.m_133286_());
        if (entity == null) {
            f_104883_.warn("Received passengers for unknown entity");
        } else {
            boolean flag = entity.m_20367_(this.f_291812_.f_91074_);
            entity.m_20153_();
            for (int i : p_105102_.m_133283_()) {
                Entity entity1 = this.f_104889_.m_6815_(i);
                if (entity1 == null) continue;
                entity1.m_7998_(entity, true);
                if (entity1 != this.f_291812_.f_91074_ || flag) continue;
                if (entity instanceof Boat) {
                    this.f_291812_.f_91074_.f_19859_ = entity.m_146908_();
                    this.f_291812_.f_91074_.m_146922_(entity.m_146908_());
                    this.f_291812_.f_91074_.m_5616_(entity.m_146908_());
                }
                MutableComponent component = Component.m_237110_((String)"mount.onboard", (Object[])new Object[]{this.f_291812_.f_91066_.f_92090_.m_90863_()});
                this.f_291812_.f_91065_.m_93063_((Component)component, false);
                this.f_291812_.m_240477_().m_168785_((Component)component);
            }
        }
    }

    public void m_5599_(ClientboundSetEntityLinkPacket p_105090_) {
        PacketUtils.m_131363_((Packet)p_105090_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        Entity entity = this.f_104889_.m_6815_(p_105090_.m_133172_());
        if (entity instanceof Mob) {
            ((Mob)entity).m_21506_(p_105090_.m_133175_());
        }
    }

    private static ItemStack m_104927_(Player p_104928_) {
        for (InteractionHand interactionhand : InteractionHand.values()) {
            ItemStack itemstack = p_104928_.m_21120_(interactionhand);
            if (!itemstack.m_150930_(Items.f_42747_)) continue;
            return itemstack;
        }
        return new ItemStack(Items.f_42747_);
    }

    public void m_7628_(ClientboundEntityEventPacket p_105010_) {
        PacketUtils.m_131363_((Packet)p_105010_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        Entity entity = p_105010_.m_132094_((Level)this.f_104889_);
        if (entity != null) {
            switch (p_105010_.m_132102_()) {
                case 21: {
                    this.f_291812_.m_91106_().m_120367_((SoundInstance)new GuardianAttackSoundInstance((Guardian)entity));
                    break;
                }
                case 35: {
                    int i = 40;
                    this.f_291812_.f_91061_.m_107332_(entity, (ParticleOptions)ParticleTypes.f_123767_, 30);
                    this.f_104889_.m_7785_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12513_, entity.m_5720_(), 1.0f, 1.0f, false);
                    if (entity != this.f_291812_.f_91074_) break;
                    this.f_291812_.f_91063_.m_109113_(ClientPacketListener.m_104927_(this.f_291812_.f_91074_));
                    break;
                }
                case 63: {
                    this.f_291812_.m_91106_().m_120367_((SoundInstance)new SnifferSoundInstance((Sniffer)((Object)entity)));
                    break;
                }
                default: {
                    entity.m_7822_(p_105010_.m_132102_());
                }
            }
        }
    }

    public void m_269082_(ClientboundDamageEventPacket p_270800_) {
        PacketUtils.m_131363_((Packet)p_270800_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        Entity entity = this.f_104889_.m_6815_(p_270800_.f_268504_());
        if (entity != null) {
            entity.m_269138_(p_270800_.m_269591_((Level)this.f_104889_));
        }
    }

    public void m_5547_(ClientboundSetHealthPacket p_105098_) {
        PacketUtils.m_131363_((Packet)p_105098_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        this.f_291812_.f_91074_.m_108760_(p_105098_.m_133247_());
        this.f_291812_.f_91074_.m_36324_().m_38705_(p_105098_.m_133250_());
        this.f_291812_.f_91074_.m_36324_().m_38717_(p_105098_.m_133251_());
    }

    public void m_6747_(ClientboundSetExperiencePacket p_105096_) {
        PacketUtils.m_131363_((Packet)p_105096_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        this.f_291812_.f_91074_.m_108644_(p_105096_.m_133228_(), p_105096_.m_133231_(), p_105096_.m_133232_());
    }

    public void m_7992_(ClientboundRespawnPacket p_105066_) {
        List<SynchedEntityData.DataValue<?>> list;
        PacketUtils.m_131363_((Packet)p_105066_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        CommonPlayerSpawnInfo commonplayerspawninfo = p_105066_.f_290899_();
        ResourceKey resourcekey = commonplayerspawninfo.f_290731_();
        Holder.Reference holder = this.f_104903_.m_175515_(Registries.f_256787_).m_246971_(commonplayerspawninfo.f_291865_());
        LocalPlayer localplayer = this.f_291812_.f_91074_;
        if (resourcekey != localplayer.m_9236_().m_46472_()) {
            ClientLevel.ClientLevelData clientlevel$clientleveldata;
            Scoreboard scoreboard = this.f_104889_.m_6188_();
            Map<String, MapItemSavedData> map = this.f_104889_.m_171684_();
            boolean flag = commonplayerspawninfo.f_290330_();
            boolean flag1 = commonplayerspawninfo.f_290486_();
            this.f_104890_ = clientlevel$clientleveldata = new ClientLevel.ClientLevelData(this.f_104890_.m_5472_(), this.f_104890_.m_5466_(), flag1);
            this.f_104889_ = new ClientLevel(this, clientlevel$clientleveldata, resourcekey, holder, this.f_104897_, this.f_194190_, this.f_291812_::m_91307_, this.f_291812_.f_91060_, flag, commonplayerspawninfo.f_290589_());
            this.f_104889_.m_104669_(scoreboard);
            this.f_104889_.m_171672_(map);
            this.f_291812_.m_91156_(this.f_104889_);
            this.f_291812_.m_91152_((Screen)new ReceivingLevelScreen());
        }
        this.f_291812_.f_91075_ = null;
        if (localplayer.m_242612_()) {
            localplayer.m_6915_();
        }
        LocalPlayer localplayer1 = p_105066_.m_263558_((byte)2) ? this.f_291812_.f_91072_.m_105250_(this.f_104889_, localplayer.m_108630_(), localplayer.m_108631_(), localplayer.m_6144_(), localplayer.m_20142_()) : this.f_291812_.f_91072_.m_105246_(this.f_104889_, localplayer.m_108630_(), localplayer.m_108631_());
        localplayer1.m_20234_(localplayer.m_19879_());
        this.f_291812_.f_91074_ = localplayer1;
        if (resourcekey != localplayer.m_9236_().m_46472_()) {
            this.f_291812_.m_91397_().m_120186_();
        }
        this.f_291812_.f_91075_ = localplayer1;
        if (p_105066_.m_263558_((byte)2) && (list = localplayer.m_20088_().m_252804_()) != null) {
            localplayer1.m_20088_().m_135356_(list);
        }
        if (p_105066_.m_263558_((byte)1)) {
            localplayer1.m_21204_().m_22159_(localplayer.m_21204_());
        }
        localplayer1.updateSyncFields(localplayer);
        localplayer1.m_172530_();
        ForgeHooksClient.firePlayerRespawn((MultiPlayerGameMode)this.f_291812_.f_91072_, (LocalPlayer)localplayer, (LocalPlayer)localplayer1, (Connection)localplayer1.f_108617_.f_290549_);
        this.f_104889_.m_104739_(localplayer1);
        localplayer1.m_146922_(-180.0f);
        localplayer1.f_108618_ = new KeyboardInput(this.f_291812_.f_91066_);
        this.f_291812_.f_91072_.m_105221_(localplayer1);
        localplayer1.m_36393_(localplayer.m_36330_());
        localplayer1.m_108711_(localplayer.m_108632_());
        localplayer1.m_219749_(commonplayerspawninfo.f_290601_());
        localplayer1.m_287199_(commonplayerspawninfo.f_291470_());
        localplayer1.f_108589_ = localplayer.f_108589_;
        localplayer1.f_108590_ = localplayer.f_108590_;
        if (this.f_291812_.f_91080_ instanceof DeathScreen || this.f_291812_.f_91080_ instanceof DeathScreen.TitleConfirmScreen) {
            this.f_291812_.m_91152_(null);
        }
        this.f_291812_.f_91072_.m_171805_(commonplayerspawninfo.f_291098_(), commonplayerspawninfo.f_290730_());
    }

    public void m_7345_(ClientboundExplodePacket p_105012_) {
        PacketUtils.m_131363_((Packet)p_105012_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        Explosion explosion = new Explosion(this.f_291812_.f_91073_, null, p_105012_.m_132132_(), p_105012_.m_132133_(), p_105012_.m_132134_(), p_105012_.m_132135_(), p_105012_.m_132136_());
        explosion.m_46075_(true);
        this.f_291812_.f_91074_.m_20256_(this.f_291812_.f_91074_.m_20184_().m_82520_((double)p_105012_.m_132127_(), (double)p_105012_.m_132130_(), (double)p_105012_.m_132131_()));
    }

    public void m_6905_(ClientboundHorseScreenOpenPacket p_105018_) {
        PacketUtils.m_131363_((Packet)p_105018_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        Entity entity = this.f_104889_.m_6815_(p_105018_.m_132208_());
        if (entity instanceof AbstractHorse) {
            AbstractHorse abstracthorse = (AbstractHorse)((Object)entity);
            LocalPlayer localplayer = this.f_291812_.f_91074_;
            SimpleContainer simplecontainer = new SimpleContainer(p_105018_.m_132207_());
            HorseInventoryMenu horseinventorymenu = new HorseInventoryMenu(p_105018_.m_132204_(), localplayer.m_150109_(), (Container)simplecontainer, abstracthorse);
            localplayer.f_36096_ = horseinventorymenu;
            this.f_291812_.m_91152_((Screen)new HorseInventoryScreen(horseinventorymenu, localplayer.m_150109_(), abstracthorse));
        }
    }

    public void m_5980_(ClientboundOpenScreenPacket p_105042_) {
        PacketUtils.m_131363_((Packet)p_105042_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        MenuScreens.m_96201_(p_105042_.m_132628_(), this.f_291812_, p_105042_.m_132625_(), p_105042_.m_132629_());
    }

    public void m_5735_(ClientboundContainerSetSlotPacket p_105000_) {
        PacketUtils.m_131363_((Packet)p_105000_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        LocalPlayer player = this.f_291812_.f_91074_;
        ItemStack itemstack = p_105000_.m_131995_();
        int i = p_105000_.m_131994_();
        this.f_291812_.m_91301_().m_120568_(itemstack);
        if (p_105000_.m_131991_() == -1) {
            if (!(this.f_291812_.f_91080_ instanceof CreativeModeInventoryScreen)) {
                player.f_36096_.m_142503_(itemstack);
            }
        } else if (p_105000_.m_131991_() == -2) {
            player.m_150109_().m_6836_(i, itemstack);
        } else {
            boolean flag = false;
            Screen screen = this.f_291812_.f_91080_;
            if (screen instanceof CreativeModeInventoryScreen) {
                CreativeModeInventoryScreen creativemodeinventoryscreen = (CreativeModeInventoryScreen)screen;
                boolean bl = flag = !creativemodeinventoryscreen.m_258017_();
            }
            if (p_105000_.m_131991_() == 0 && InventoryMenu.m_150592_(i)) {
                ItemStack itemstack1;
                if (!itemstack.m_41619_() && ((itemstack1 = player.f_36095_.m_38853_(i).m_7993_()).m_41619_() || itemstack1.m_41613_() < itemstack.m_41613_())) {
                    itemstack.m_41754_(5);
                }
                player.f_36095_.m_182406_(i, p_105000_.m_182716_(), itemstack);
            } else if (!(p_105000_.m_131991_() != player.f_36096_.f_38840_ || p_105000_.m_131991_() == 0 && flag)) {
                player.f_36096_.m_182406_(i, p_105000_.m_182716_(), itemstack);
            }
        }
    }

    public void m_6837_(ClientboundContainerSetContentPacket p_104996_) {
        PacketUtils.m_131363_((Packet)p_104996_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        LocalPlayer player = this.f_291812_.f_91074_;
        if (p_104996_.m_131954_() == 0) {
            player.f_36095_.m_182410_(p_104996_.m_182709_(), p_104996_.m_131957_(), p_104996_.m_182708_());
        } else if (p_104996_.m_131954_() == player.f_36096_.f_38840_) {
            player.f_36096_.m_182410_(p_104996_.m_182709_(), p_104996_.m_131957_(), p_104996_.m_182708_());
        }
    }

    public void m_8047_(ClientboundOpenSignEditorPacket p_105044_) {
        PacketUtils.m_131363_((Packet)p_105044_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        BlockPos blockpos = p_105044_.m_132640_();
        BlockEntity $$3 = this.f_104889_.m_7702_(blockpos);
        if ($$3 instanceof SignBlockEntity) {
            SignBlockEntity signblockentity = (SignBlockEntity)$$3;
            this.f_291812_.f_91074_.m_7739_(signblockentity, p_105044_.m_276774_());
        } else {
            BlockState blockstate = this.f_104889_.m_8055_(blockpos);
            SignBlockEntity signblockentity1 = new SignBlockEntity(blockpos, blockstate);
            signblockentity1.m_142339_(this.f_104889_);
            this.f_291812_.f_91074_.m_7739_(signblockentity1, p_105044_.m_276774_());
        }
    }

    public void m_7545_(ClientboundBlockEntityDataPacket p_104976_) {
        PacketUtils.m_131363_((Packet)p_104976_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        BlockPos blockpos = p_104976_.m_131704_();
        this.f_291812_.f_91073_.m_141902_(blockpos, p_104976_.m_195645_()).ifPresent(p_205557_ -> {
            p_205557_.onDataPacket(this.f_290549_, p_104976_);
            if (p_205557_ instanceof CommandBlockEntity && this.f_291812_.f_91080_ instanceof CommandBlockEditScreen) {
                ((CommandBlockEditScreen)this.f_291812_.f_91080_).m_98398_();
            }
        });
    }

    public void m_7257_(ClientboundContainerSetDataPacket p_104998_) {
        PacketUtils.m_131363_((Packet)p_104998_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        LocalPlayer player = this.f_291812_.f_91074_;
        if (player.f_36096_ != null && player.f_36096_.f_38840_ == p_104998_.m_131972_()) {
            player.f_36096_.m_7511_(p_104998_.m_131975_(), p_104998_.m_131976_());
        }
    }

    public void m_7277_(ClientboundSetEquipmentPacket p_105094_) {
        PacketUtils.m_131363_((Packet)p_105094_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        Entity entity = this.f_104889_.m_6815_(p_105094_.m_133210_());
        if (entity != null) {
            p_105094_.m_133213_().forEach(p_205528_ -> entity.m_8061_((EquipmentSlot)p_205528_.getFirst(), (ItemStack)((Object)((Object)p_205528_.getSecond()))));
        }
    }

    public void m_7776_(ClientboundContainerClosePacket p_104994_) {
        PacketUtils.m_131363_((Packet)p_104994_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        this.f_291812_.f_91074_.m_108763_();
    }

    public void m_7364_(ClientboundBlockEventPacket p_104978_) {
        PacketUtils.m_131363_((Packet)p_104978_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        this.f_291812_.f_91073_.m_7696_(p_104978_.m_131725_(), p_104978_.m_131730_(), p_104978_.m_131728_(), p_104978_.m_131729_());
    }

    public void m_5943_(ClientboundBlockDestructionPacket p_104974_) {
        PacketUtils.m_131363_((Packet)p_104974_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        this.f_291812_.f_91073_.m_6801_(p_104974_.m_131685_(), p_104974_.m_131688_(), p_104974_.m_131689_());
    }

    public void m_7616_(ClientboundGameEventPacket p_105016_) {
        PacketUtils.m_131363_((Packet)p_105016_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        LocalPlayer player = this.f_291812_.f_91074_;
        ClientboundGameEventPacket.Type clientboundgameeventpacket$type = p_105016_.m_132178_();
        float f = p_105016_.m_132181_();
        int i = Mth.m_14143_((float)(f + 0.5f));
        if (clientboundgameeventpacket$type == ClientboundGameEventPacket.f_132153_) {
            ((Player)player).m_5661_((Component)Component.m_237115_((String)"block.minecraft.spawn.not_valid"), false);
        } else if (clientboundgameeventpacket$type == ClientboundGameEventPacket.f_132154_) {
            this.f_104889_.m_6106_().m_5565_(true);
            this.f_104889_.m_46734_(0.0f);
        } else if (clientboundgameeventpacket$type == ClientboundGameEventPacket.f_132155_) {
            this.f_104889_.m_6106_().m_5565_(false);
            this.f_104889_.m_46734_(1.0f);
        } else if (clientboundgameeventpacket$type == ClientboundGameEventPacket.f_132156_) {
            this.f_291812_.f_91072_.m_105279_(GameType.m_46393_((int)i));
        } else if (clientboundgameeventpacket$type == ClientboundGameEventPacket.f_132157_) {
            if (i == 0) {
                this.f_291812_.f_91074_.f_108617_.m_295327_((Packet<?>)new ServerboundClientCommandPacket(ServerboundClientCommandPacket.Action.PERFORM_RESPAWN));
                this.f_291812_.m_91152_((Screen)new ReceivingLevelScreen());
            } else if (i == 1) {
                this.f_291812_.m_91152_((Screen)new WinScreen(true, () -> {
                    this.f_291812_.f_91074_.f_108617_.m_295327_((Packet<?>)new ServerboundClientCommandPacket(ServerboundClientCommandPacket.Action.PERFORM_RESPAWN));
                    this.f_291812_.m_91152_(null);
                }));
            }
        } else if (clientboundgameeventpacket$type == ClientboundGameEventPacket.f_132158_) {
            Options options = this.f_291812_.f_91066_;
            if (f == 0.0f) {
                this.f_291812_.m_91152_((Screen)new DemoIntroScreen());
            } else if (f == 101.0f) {
                this.f_291812_.f_91065_.m_93076_().m_93785_((Component)Component.m_237110_((String)"demo.help.movement", (Object[])new Object[]{options.f_92085_.m_90863_(), options.f_92086_.m_90863_(), options.f_92087_.m_90863_(), options.f_92088_.m_90863_()}));
            } else if (f == 102.0f) {
                this.f_291812_.f_91065_.m_93076_().m_93785_((Component)Component.m_237110_((String)"demo.help.jump", (Object[])new Object[]{options.f_92089_.m_90863_()}));
            } else if (f == 103.0f) {
                this.f_291812_.f_91065_.m_93076_().m_93785_((Component)Component.m_237110_((String)"demo.help.inventory", (Object[])new Object[]{options.f_92092_.m_90863_()}));
            } else if (f == 104.0f) {
                this.f_291812_.f_91065_.m_93076_().m_93785_((Component)Component.m_237110_((String)"demo.day.6", (Object[])new Object[]{options.f_92102_.m_90863_()}));
            }
        } else if (clientboundgameeventpacket$type == ClientboundGameEventPacket.f_132159_) {
            this.f_104889_.m_6263_(player, player.m_20185_(), player.m_20188_(), player.m_20189_(), SoundEvents.f_11686_, SoundSource.PLAYERS, 0.18f, 0.45f);
        } else if (clientboundgameeventpacket$type == ClientboundGameEventPacket.f_132160_) {
            this.f_104889_.m_46734_(f);
        } else if (clientboundgameeventpacket$type == ClientboundGameEventPacket.f_132161_) {
            this.f_104889_.m_46707_(f);
        } else if (clientboundgameeventpacket$type == ClientboundGameEventPacket.f_132162_) {
            this.f_104889_.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12295_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        } else if (clientboundgameeventpacket$type == ClientboundGameEventPacket.f_132163_) {
            this.f_104889_.m_7106_((ParticleOptions)ParticleTypes.f_123807_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 0.0, 0.0, 0.0);
            if (i == 1) {
                this.f_104889_.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11880_, SoundSource.HOSTILE, 1.0f, 1.0f);
            }
        } else if (clientboundgameeventpacket$type == ClientboundGameEventPacket.f_132164_) {
            this.f_291812_.f_91074_.m_108711_(f == 0.0f);
        } else if (clientboundgameeventpacket$type == ClientboundGameEventPacket.f_290437_) {
            this.f_291812_.f_91074_.m_294300_(f == 1.0f);
        }
    }

    public void m_7633_(ClientboundMapItemDataPacket p_105032_) {
        PacketUtils.m_131363_((Packet)p_105032_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        MapRenderer maprenderer = this.f_291812_.f_91063_.m_109151_();
        int i = p_105032_.m_132445_();
        String s = MapItem.m_42848_(i);
        MapItemSavedData mapitemsaveddata = this.f_291812_.f_91073_.m_7489_(s);
        if (mapitemsaveddata == null) {
            mapitemsaveddata = MapItemSavedData.m_164776_((byte)p_105032_.m_178982_(), (boolean)p_105032_.m_178983_(), this.f_291812_.f_91073_.m_46472_());
            this.f_291812_.f_91073_.m_257583_(s, mapitemsaveddata);
        }
        p_105032_.m_132437_(mapitemsaveddata);
        maprenderer.m_168765_(i, mapitemsaveddata);
    }

    public void m_7704_(ClientboundLevelEventPacket p_105024_) {
        PacketUtils.m_131363_((Packet)p_105024_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        if (p_105024_.m_132274_()) {
            this.f_291812_.f_91073_.m_6798_(p_105024_.m_132277_(), p_105024_.m_132279_(), p_105024_.m_132278_());
        } else {
            this.f_291812_.f_91073_.m_46796_(p_105024_.m_132277_(), p_105024_.m_132279_(), p_105024_.m_132278_());
        }
    }

    public void m_5498_(ClientboundUpdateAdvancementsPacket p_105126_) {
        PacketUtils.m_131363_((Packet)p_105126_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        this.f_104893_.m_104399_(p_105126_);
    }

    public void m_7553_(ClientboundSelectAdvancementsTabPacket p_105072_) {
        PacketUtils.m_131363_((Packet)p_105072_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        ResourceLocation resourcelocation = p_105072_.m_133013_();
        if (resourcelocation == null) {
            this.f_104893_.m_104401_((AdvancementHolder)null, false);
        } else {
            AdvancementHolder advancementholder = this.f_104893_.m_295984_(resourcelocation);
            this.f_104893_.m_104401_(advancementholder, false);
        }
    }

    public void m_7443_(ClientboundCommandsPacket p_104990_) {
        PacketUtils.m_131363_((Packet)p_104990_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        CommandBuildContext context = CommandBuildContext.m_255418_((HolderLookup.Provider)this.f_104903_, (FeatureFlagSet)this.f_244039_);
        this.f_104899_ = new CommandDispatcher(p_104990_.m_237624_(context));
        this.f_104899_ = ClientCommandHandler.mergeServerCommands(this.f_104899_, (CommandBuildContext)context);
    }

    public void m_7183_(ClientboundStopSoundPacket p_105116_) {
        PacketUtils.m_131363_((Packet)p_105116_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        this.f_291812_.m_91106_().m_120386_(p_105116_.m_133476_(), p_105116_.m_133479_());
    }

    public void m_7589_(ClientboundCommandSuggestionsPacket p_104988_) {
        PacketUtils.m_131363_((Packet)p_104988_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        this.f_104894_.m_105171_(p_104988_.m_131854_(), p_104988_.m_131857_());
    }

    public void m_6327_(ClientboundUpdateRecipesPacket p_105132_) {
        PacketUtils.m_131363_((Packet)p_105132_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        this.f_104900_.m_44024_(p_105132_.m_133644_());
        ClientRecipeBook clientrecipebook = this.f_291812_.f_91074_.m_108631_();
        clientrecipebook.m_266394_(this.f_104900_.m_44051_(), this.f_291812_.f_91073_.m_9598_());
        this.f_291812_.m_231374_(SearchRegistry.f_301428_, clientrecipebook.m_90639_());
        ForgeHooksClient.onRecipesUpdated((RecipeManager)this.f_104900_);
    }

    public void m_7244_(ClientboundPlayerLookAtPacket p_105054_) {
        PacketUtils.m_131363_((Packet)p_105054_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        Vec3 vec3 = p_105054_.m_132785_((Level)this.f_104889_);
        if (vec3 != null) {
            this.f_291812_.f_91074_.m_7618_(p_105054_.m_132793_(), vec3);
        }
    }

    public void m_6148_(ClientboundTagQueryPacket p_105120_) {
        PacketUtils.m_131363_((Packet)p_105120_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        if (!this.f_104896_.m_90705_(p_105120_.m_133506_(), p_105120_.m_133509_())) {
            f_104883_.debug("Got unhandled response to tag query {}", (Object)p_105120_.m_133506_());
        }
    }

    public void m_7271_(ClientboundAwardStatsPacket p_104970_) {
        PacketUtils.m_131363_((Packet)p_104970_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        for (Map.Entry entry : p_104970_.m_131643_().entrySet()) {
            Stat stat = (Stat)entry.getKey();
            int i = (Integer)entry.getValue();
            this.f_291812_.f_91074_.m_108630_().m_6085_((Player)this.f_291812_.f_91074_, stat, i);
        }
        if (this.f_291812_.f_91080_ instanceof StatsUpdateListener) {
            ((StatsUpdateListener)this.f_291812_.f_91080_).m_7819_();
        }
    }

    public void m_8076_(ClientboundRecipePacket p_105058_) {
        PacketUtils.m_131363_((Packet)p_105058_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        ClientRecipeBook clientrecipebook = this.f_291812_.f_91074_.m_108631_();
        clientrecipebook.m_12687_(p_105058_.m_132869_());
        ClientboundRecipePacket.State clientboundrecipepacket$state = p_105058_.m_132870_();
        switch (clientboundrecipepacket$state) {
            case REMOVE: {
                for (ResourceLocation resourcelocation3 : p_105058_.m_132865_()) {
                    this.f_104900_.m_44043_(resourcelocation3).ifPresent(arg_0 -> ((ClientRecipeBook)clientrecipebook).m_12713_(arg_0));
                }
                break;
            }
            case INIT: {
                for (ResourceLocation resourcelocation1 : p_105058_.m_132865_()) {
                    this.f_104900_.m_44043_(resourcelocation1).ifPresent(arg_0 -> ((ClientRecipeBook)clientrecipebook).m_12700_(arg_0));
                }
                for (ResourceLocation resourcelocation2 : p_105058_.m_132868_()) {
                    this.f_104900_.m_44043_(resourcelocation2).ifPresent(arg_0 -> ((ClientRecipeBook)clientrecipebook).m_12723_(arg_0));
                }
                break;
            }
            case ADD: {
                for (ResourceLocation resourcelocation : p_105058_.m_132865_()) {
                    this.f_104900_.m_44043_(resourcelocation).ifPresent(p_296226_ -> {
                        clientrecipebook.m_12700_((RecipeHolder)p_296226_);
                        clientrecipebook.m_12723_((RecipeHolder)p_296226_);
                        if (p_296226_.f_291008_().m_271738_()) {
                            RecipeToast.m_94817_((ToastComponent)this.f_291812_.m_91300_(), (RecipeHolder)p_296226_);
                        }
                    });
                }
                break;
            }
        }
        clientrecipebook.m_90639_().forEach(p_205540_ -> p_205540_.m_100499_((RecipeBook)clientrecipebook));
        if (this.f_291812_.f_91080_ instanceof RecipeUpdateListener) {
            ((RecipeUpdateListener)this.f_291812_.f_91080_).m_6916_();
        }
    }

    public void m_7915_(ClientboundUpdateMobEffectPacket p_105130_) {
        MobEffect mobeffect;
        PacketUtils.m_131363_((Packet)p_105130_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        Entity entity = this.f_104889_.m_6815_(p_105130_.m_133622_());
        if (entity instanceof LivingEntity && (mobeffect = p_105130_.m_237878_()) != null) {
            MobEffectInstance mobeffectinstance = new MobEffectInstance(mobeffect, p_105130_.m_133625_(), p_105130_.m_133624_(), p_105130_.m_133627_(), p_105130_.m_133626_(), p_105130_.m_133628_(), null, Optional.ofNullable(p_105130_.m_237879_()));
            ((LivingEntity)entity).m_147215_(mobeffectinstance, null);
        }
    }

    @Override
    public void m_105133_(ClientboundUpdateTagsPacket p_298004_) {
        super.m_105133_(p_298004_);
        this.m_295411_();
    }

    private void m_295411_() {
        if (!this.f_290549_.m_129531_()) {
            Blocks.m_50758_();
        }
        CreativeModeTabs.m_257478_().stream().filter(CreativeModeTab::hasSearchBar).forEach(CreativeModeTab::m_257466_);
        MinecraftForge.EVENT_BUS.post((Event)new TagsUpdatedEvent((RegistryAccess)this.f_104903_, true, this.f_290549_.m_129531_()));
    }

    public void m_142234_(ClientboundPlayerCombatEndPacket p_171771_) {
    }

    public void m_142058_(ClientboundPlayerCombatEnterPacket p_171773_) {
    }

    public void m_142747_(ClientboundPlayerCombatKillPacket p_171775_) {
        PacketUtils.m_131363_((Packet)p_171775_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        Entity entity = this.f_104889_.m_6815_(p_171775_.m_179078_());
        if (entity == this.f_291812_.f_91074_) {
            if (this.f_291812_.f_91074_.m_108632_()) {
                this.f_291812_.m_91152_((Screen)new DeathScreen(p_171775_.m_179079_(), this.f_104889_.m_6106_().m_5466_()));
            } else {
                this.f_291812_.f_91074_.m_7583_();
            }
        }
    }

    public void m_6664_(ClientboundChangeDifficultyPacket p_104984_) {
        PacketUtils.m_131363_((Packet)p_104984_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        this.f_104890_.m_104851_(p_104984_.m_131820_());
        this.f_104890_.m_104858_(p_104984_.m_131817_());
    }

    public void m_6447_(ClientboundSetCameraPacket p_105076_) {
        PacketUtils.m_131363_((Packet)p_105076_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        Entity entity = p_105076_.m_133059_((Level)this.f_104889_);
        if (entity != null) {
            this.f_291812_.m_91118_(entity);
        }
    }

    public void m_142237_(ClientboundInitializeBorderPacket p_171767_) {
        PacketUtils.m_131363_((Packet)p_171767_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        WorldBorder worldborder = this.f_104889_.m_6857_();
        worldborder.m_61949_(p_171767_.m_178886_(), p_171767_.m_178887_());
        long i = p_171767_.m_178890_();
        if (i > 0L) {
            worldborder.m_61919_(p_171767_.m_178889_(), p_171767_.m_178888_(), i);
        } else {
            worldborder.m_61917_(p_171767_.m_178888_());
        }
        worldborder.m_61923_(p_171767_.m_178891_());
        worldborder.m_61952_(p_171767_.m_178893_());
        worldborder.m_61944_(p_171767_.m_178892_());
    }

    public void m_142612_(ClientboundSetBorderCenterPacket p_171781_) {
        PacketUtils.m_131363_((Packet)p_171781_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        this.f_104889_.m_6857_().m_61949_(p_171781_.m_179224_(), p_171781_.m_179223_());
    }

    public void m_142686_(ClientboundSetBorderLerpSizePacket p_171783_) {
        PacketUtils.m_131363_((Packet)p_171783_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        this.f_104889_.m_6857_().m_61919_(p_171783_.m_179238_(), p_171783_.m_179239_(), p_171783_.m_179240_());
    }

    public void m_142238_(ClientboundSetBorderSizePacket p_171785_) {
        PacketUtils.m_131363_((Packet)p_171785_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        this.f_104889_.m_6857_().m_61917_(p_171785_.m_179252_());
    }

    public void m_142696_(ClientboundSetBorderWarningDistancePacket p_171789_) {
        PacketUtils.m_131363_((Packet)p_171789_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        this.f_104889_.m_6857_().m_61952_(p_171789_.m_179276_());
    }

    public void m_142056_(ClientboundSetBorderWarningDelayPacket p_171787_) {
        PacketUtils.m_131363_((Packet)p_171787_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        this.f_104889_.m_6857_().m_61944_(p_171787_.m_179264_());
    }

    public void m_142766_(ClientboundClearTitlesPacket p_171765_) {
        PacketUtils.m_131363_((Packet)p_171765_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        this.f_291812_.f_91065_.m_168713_();
        if (p_171765_.m_178788_()) {
            this.f_291812_.f_91065_.m_93006_();
        }
    }

    public void m_213672_(ClientboundServerDataPacket p_233704_) {
        PacketUtils.m_131363_((Packet)p_233704_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        if (this.f_291024_ != null) {
            this.f_291024_.f_105365_ = p_233704_.m_271805_();
            p_233704_.m_271815_().map(ServerData::m_301662_).ifPresent(this.f_291024_::m_271813_);
            this.f_291024_.m_242965_(p_233704_.m_242957_());
            ServerList.m_105446_((ServerData)this.f_291024_);
            if (!this.f_291332_ && !p_233704_.m_242957_()) {
                SystemToast systemtoast = SystemToast.m_94847_((Minecraft)this.f_291812_, (SystemToast.SystemToastIds)SystemToast.SystemToastIds.UNSECURE_SERVER_WARNING, (Component)f_242953_, (Component)f_242949_);
                this.f_291812_.m_91300_().m_94922_((Toast)systemtoast);
                this.f_291332_ = true;
            }
        }
    }

    public void m_240695_(ClientboundCustomChatCompletionsPacket p_240832_) {
        PacketUtils.m_131363_((Packet)p_240832_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        this.f_104894_.m_240713_(p_240832_.f_240661_(), p_240832_.f_240663_());
    }

    public void m_142456_(ClientboundSetActionBarTextPacket p_171779_) {
        PacketUtils.m_131363_((Packet)p_171779_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        this.f_291812_.f_91065_.m_93063_(p_171779_.m_179210_(), false);
    }

    public void m_142442_(ClientboundSetTitleTextPacket p_171793_) {
        PacketUtils.m_131363_((Packet)p_171793_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        this.f_291812_.f_91065_.m_168714_(p_171793_.m_179399_());
    }

    public void m_141913_(ClientboundSetSubtitleTextPacket p_171791_) {
        PacketUtils.m_131363_((Packet)p_171791_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        this.f_291812_.f_91065_.m_168711_(p_171791_.m_179385_());
    }

    public void m_142185_(ClientboundSetTitlesAnimationPacket p_171795_) {
        PacketUtils.m_131363_((Packet)p_171795_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        this.f_291812_.f_91065_.m_168684_(p_171795_.m_179415_(), p_171795_.m_179416_(), p_171795_.m_179417_());
    }

    public void m_6235_(ClientboundTabListPacket p_105118_) {
        PacketUtils.m_131363_((Packet)p_105118_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        this.f_291812_.f_91065_.m_93088_().m_94558_(p_105118_.m_133489_().getString().isEmpty() ? null : p_105118_.m_133489_());
        this.f_291812_.f_91065_.m_93088_().m_94554_(p_105118_.m_133492_().getString().isEmpty() ? null : p_105118_.m_133492_());
    }

    public void m_6476_(ClientboundRemoveMobEffectPacket p_105062_) {
        PacketUtils.m_131363_((Packet)p_105062_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        Entity entity = p_105062_.m_132901_((Level)this.f_104889_);
        if (entity instanceof LivingEntity) {
            ((LivingEntity)entity).m_6234_(p_105062_.m_132909_());
        }
    }

    public void m_213565_(ClientboundPlayerInfoRemovePacket p_248731_) {
        PacketUtils.m_131363_((Packet)p_248731_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        for (UUID uuid : p_248731_.f_244383_()) {
            this.f_291812_.m_91266_().m_100690_(uuid);
            PlayerInfo playerinfo = this.f_104892_.remove(uuid);
            if (playerinfo == null) continue;
            this.f_244156_.remove(playerinfo);
        }
    }

    public void m_214045_(ClientboundPlayerInfoUpdatePacket p_250115_) {
        PacketUtils.m_131363_((Packet)p_250115_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        for (ClientboundPlayerInfoUpdatePacket.Entry clientboundplayerinfoupdatepacket$entry : p_250115_.m_245290_()) {
            PlayerInfo playerinfo = new PlayerInfo(Objects.requireNonNull(clientboundplayerinfoupdatepacket$entry.f_243688_()), this.m_253150_());
            if (this.f_104892_.putIfAbsent(clientboundplayerinfoupdatepacket$entry.f_244142_(), playerinfo) != null) continue;
            this.f_291812_.m_91266_().m_100676_(playerinfo);
        }
        for (ClientboundPlayerInfoUpdatePacket.Entry clientboundplayerinfoupdatepacket$entry1 : p_250115_.m_246778_()) {
            PlayerInfo playerinfo1 = this.f_104892_.get(clientboundplayerinfoupdatepacket$entry1.f_244142_());
            if (playerinfo1 == null) {
                f_104883_.warn("Ignoring player info update for unknown player {}", (Object)clientboundplayerinfoupdatepacket$entry1.f_244142_());
                continue;
            }
            for (ClientboundPlayerInfoUpdatePacket.Action clientboundplayerinfoupdatepacket$action : p_250115_.m_246097_()) {
                this.m_247639_(clientboundplayerinfoupdatepacket$action, clientboundplayerinfoupdatepacket$entry1, playerinfo1);
            }
        }
    }

    private void m_247639_(ClientboundPlayerInfoUpdatePacket.Action p_248954_, ClientboundPlayerInfoUpdatePacket.Entry p_251310_, PlayerInfo p_251146_) {
        switch (p_248954_) {
            case INITIALIZE_CHAT: {
                this.m_245842_(p_251310_, p_251146_);
                break;
            }
            case UPDATE_GAME_MODE: {
                if (p_251146_.m_105325_() != p_251310_.f_244162_() && this.f_291812_.f_91074_ != null && this.f_291812_.f_91074_.m_20148_().equals(p_251310_.f_244142_())) {
                    this.f_291812_.f_91074_.m_287171_(p_251310_.f_244162_());
                }
                p_251146_.m_105317_(p_251310_.f_244162_());
                break;
            }
            case UPDATE_LISTED: {
                if (p_251310_.f_243700_()) {
                    this.f_244156_.add(p_251146_);
                    break;
                }
                this.f_244156_.remove(p_251146_);
                break;
            }
            case UPDATE_LATENCY: {
                p_251146_.m_105313_(p_251310_.f_244322_());
                break;
            }
            case UPDATE_DISPLAY_NAME: {
                p_251146_.m_105323_(p_251310_.f_244512_());
            }
        }
    }

    private void m_245842_(ClientboundPlayerInfoUpdatePacket.Entry p_248806_, PlayerInfo p_251136_) {
        GameProfile gameprofile = p_251136_.m_105312_();
        SignatureValidator signaturevalidator = this.f_291812_.m_231417_();
        if (signaturevalidator == null) {
            f_104883_.warn("Ignoring chat session from {} due to missing Services public key", (Object)gameprofile.getName());
            p_251136_.m_253204_(this.m_253150_());
        } else {
            RemoteChatSession.Data remotechatsession$data = p_248806_.f_244153_();
            if (remotechatsession$data != null) {
                try {
                    RemoteChatSession remotechatsession = remotechatsession$data.m_247588_(gameprofile, signaturevalidator);
                    p_251136_.m_246479_(remotechatsession);
                }
                catch (ProfilePublicKey.ValidationException profilepublickey$validationexception) {
                    f_104883_.error("Failed to validate profile key for player: '{}'", (Object)gameprofile.getName(), (Object)profilepublickey$validationexception);
                    p_251136_.m_253204_(this.m_253150_());
                }
            } else {
                p_251136_.m_253204_(this.m_253150_());
            }
        }
    }

    private boolean m_253150_() {
        return this.f_291024_ != null && this.f_291024_.m_242962_();
    }

    public void m_5767_(ClientboundPlayerAbilitiesPacket p_105048_) {
        PacketUtils.m_131363_((Packet)p_105048_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        LocalPlayer player = this.f_291812_.f_91074_;
        player.m_150110_().f_35935_ = p_105048_.m_132677_();
        player.m_150110_().f_35937_ = p_105048_.m_132679_();
        player.m_150110_().f_35934_ = p_105048_.m_132674_();
        player.m_150110_().f_35936_ = p_105048_.m_132678_();
        player.m_150110_().m_35943_(p_105048_.m_132680_());
        player.m_150110_().m_35948_(p_105048_.m_132681_());
    }

    public void m_8068_(ClientboundSoundPacket p_105114_) {
        PacketUtils.m_131363_((Packet)p_105114_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        this.f_291812_.f_91073_.m_262808_(this.f_291812_.f_91074_, p_105114_.m_133459_(), p_105114_.m_133460_(), p_105114_.m_133461_(), p_105114_.m_263229_(), p_105114_.m_133458_(), p_105114_.m_133462_(), p_105114_.m_133463_(), p_105114_.m_237848_());
    }

    public void m_5863_(ClientboundSoundEntityPacket p_105112_) {
        PacketUtils.m_131363_((Packet)p_105112_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        Entity entity = this.f_104889_.m_6815_(p_105112_.m_133430_());
        if (entity != null) {
            this.f_291812_.f_91073_.m_213890_(this.f_291812_.f_91074_, entity, p_105112_.m_263456_(), p_105112_.m_133429_(), p_105112_.m_133431_(), p_105112_.m_133432_(), p_105112_.m_237837_());
        }
    }

    public void m_7685_(ClientboundBossEventPacket p_104982_) {
        PacketUtils.m_131363_((Packet)p_104982_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        this.f_291812_.f_91065_.m_93090_().m_93711_(p_104982_);
    }

    public void m_7701_(ClientboundCooldownPacket p_105002_) {
        PacketUtils.m_131363_((Packet)p_105002_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        if (p_105002_.m_132011_() == 0) {
            this.f_291812_.f_91074_.m_36335_().m_41527_(p_105002_.m_132008_());
        } else {
            this.f_291812_.f_91074_.m_36335_().m_41524_(p_105002_.m_132008_(), p_105002_.m_132011_());
        }
    }

    public void m_7410_(ClientboundMoveVehiclePacket p_105038_) {
        PacketUtils.m_131363_((Packet)p_105038_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        Entity entity = this.f_291812_.f_91074_.m_20201_();
        if (entity != this.f_291812_.f_91074_ && entity.m_6109_()) {
            entity.m_19890_(p_105038_.m_132591_(), p_105038_.m_132594_(), p_105038_.m_132595_(), p_105038_.m_132596_(), p_105038_.m_132597_());
            this.f_290549_.m_129512_((Packet<?>)new ServerboundMoveVehiclePacket(entity));
        }
    }

    public void m_6503_(ClientboundOpenBookPacket p_105040_) {
        PacketUtils.m_131363_((Packet)p_105040_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        ItemStack itemstack = this.f_291812_.f_91074_.m_21120_(p_105040_.m_132608_());
        if (itemstack.m_150930_(Items.f_42615_)) {
            this.f_291812_.m_91152_((Screen)new BookViewScreen((BookViewScreen.BookAccess)new BookViewScreen.WrittenBookAccess(itemstack)));
        }
    }

    @Override
    public void m_105003_(CustomPacketPayload p_300286_) {
        if (p_300286_ instanceof PathfindingDebugPayload) {
            PathfindingDebugPayload pathfindingdebugpayload = (PathfindingDebugPayload)p_300286_;
            this.f_291812_.f_91064_.f_113413_.m_113611_(pathfindingdebugpayload.f_290536_(), pathfindingdebugpayload.f_291873_(), pathfindingdebugpayload.f_291217_());
        } else if (p_300286_ instanceof NeighborUpdatesDebugPayload) {
            NeighborUpdatesDebugPayload neighborupdatesdebugpayload = (NeighborUpdatesDebugPayload)p_300286_;
            ((NeighborsUpdateRenderer)this.f_291812_.f_91064_.f_113418_).m_113596_(neighborupdatesdebugpayload.f_291308_(), neighborupdatesdebugpayload.f_290702_());
        } else if (p_300286_ instanceof StructuresDebugPayload) {
            StructuresDebugPayload structuresdebugpayload = (StructuresDebugPayload)p_300286_;
            this.f_291812_.f_91064_.f_113420_.m_113682_(structuresdebugpayload.f_291102_(), structuresdebugpayload.f_291713_(), structuresdebugpayload.f_291455_());
        } else if (p_300286_ instanceof WorldGenAttemptDebugPayload) {
            WorldGenAttemptDebugPayload worldgenattemptdebugpayload = (WorldGenAttemptDebugPayload)p_300286_;
            ((WorldGenAttemptRenderer)this.f_291812_.f_91064_.f_113422_).m_113737_(worldgenattemptdebugpayload.f_291689_(), worldgenattemptdebugpayload.f_290326_(), worldgenattemptdebugpayload.f_291188_(), worldgenattemptdebugpayload.f_290800_(), worldgenattemptdebugpayload.f_291344_(), worldgenattemptdebugpayload.f_291261_());
        } else if (p_300286_ instanceof PoiTicketCountDebugPayload) {
            PoiTicketCountDebugPayload poiticketcountdebugpayload = (PoiTicketCountDebugPayload)p_300286_;
            this.f_291812_.f_91064_.f_113425_.m_113230_(poiticketcountdebugpayload.f_291600_(), poiticketcountdebugpayload.f_291747_());
        } else if (p_300286_ instanceof PoiAddedDebugPayload) {
            PoiAddedDebugPayload poiaddeddebugpayload = (PoiAddedDebugPayload)p_300286_;
            BrainDebugRenderer.PoiInfo braindebugrenderer$poiinfo = new BrainDebugRenderer.PoiInfo(poiaddeddebugpayload.f_290840_(), poiaddeddebugpayload.f_291238_(), poiaddeddebugpayload.f_290692_());
            this.f_291812_.f_91064_.f_113425_.m_113226_(braindebugrenderer$poiinfo);
        } else if (p_300286_ instanceof PoiRemovedDebugPayload) {
            PoiRemovedDebugPayload poiremoveddebugpayload = (PoiRemovedDebugPayload)p_300286_;
            this.f_291812_.f_91064_.f_113425_.m_113228_(poiremoveddebugpayload.f_290491_());
        } else if (p_300286_ instanceof VillageSectionsDebugPayload) {
            VillageSectionsDebugPayload villagesectionsdebugpayload = (VillageSectionsDebugPayload)p_300286_;
            VillageSectionsDebugRenderer villagesectionsdebugrenderer = this.f_291812_.f_91064_.f_113426_;
            villagesectionsdebugpayload.f_290824_().forEach(arg_0 -> ((VillageSectionsDebugRenderer)villagesectionsdebugrenderer).m_113709_(arg_0));
            villagesectionsdebugpayload.f_291861_().forEach(arg_0 -> ((VillageSectionsDebugRenderer)villagesectionsdebugrenderer).m_113711_(arg_0));
        } else if (p_300286_ instanceof GoalDebugPayload) {
            GoalDebugPayload goaldebugpayload = (GoalDebugPayload)p_300286_;
            this.f_291812_.f_91064_.f_113429_.m_113548_(goaldebugpayload.f_290936_(), goaldebugpayload.f_290389_(), goaldebugpayload.f_290879_());
        } else if (p_300286_ instanceof BrainDebugPayload) {
            BrainDebugPayload braindebugpayload = (BrainDebugPayload)p_300286_;
            this.f_291812_.f_91064_.f_113425_.m_113219_(braindebugpayload.f_291293_());
        } else if (p_300286_ instanceof BeeDebugPayload) {
            BeeDebugPayload beedebugpayload = (BeeDebugPayload)p_300286_;
            this.f_291812_.f_91064_.f_113427_.m_113066_(beedebugpayload.f_291784_());
        } else if (p_300286_ instanceof HiveDebugPayload) {
            HiveDebugPayload hivedebugpayload = (HiveDebugPayload)p_300286_;
            this.f_291812_.f_91064_.f_113427_.m_113071_(hivedebugpayload.f_291746_(), this.f_104889_.m_46467_());
        } else if (p_300286_ instanceof GameTestAddMarkerDebugPayload) {
            GameTestAddMarkerDebugPayload gametestaddmarkerdebugpayload = (GameTestAddMarkerDebugPayload)p_300286_;
            this.f_291812_.f_91064_.f_113430_.m_113524_(gametestaddmarkerdebugpayload.f_291551_(), gametestaddmarkerdebugpayload.f_290458_(), gametestaddmarkerdebugpayload.f_291302_(), gametestaddmarkerdebugpayload.f_290945_());
        } else if (p_300286_ instanceof GameTestClearMarkersDebugPayload) {
            this.f_291812_.f_91064_.f_113430_.m_5630_();
        } else if (p_300286_ instanceof RaidsDebugPayload) {
            RaidsDebugPayload raidsdebugpayload = (RaidsDebugPayload)p_300286_;
            this.f_291812_.f_91064_.f_113428_.m_113663_((Collection)raidsdebugpayload.f_291474_());
        } else if (p_300286_ instanceof GameEventDebugPayload) {
            GameEventDebugPayload gameeventdebugpayload = (GameEventDebugPayload)p_300286_;
            this.f_291812_.f_91064_.f_173815_.m_234513_(gameeventdebugpayload.f_290975_(), gameeventdebugpayload.f_291471_());
        } else if (p_300286_ instanceof GameEventListenerDebugPayload) {
            GameEventListenerDebugPayload gameeventlistenerdebugpayload = (GameEventListenerDebugPayload)p_300286_;
            this.f_291812_.f_91064_.f_173815_.m_173830_(gameeventlistenerdebugpayload.f_290887_(), gameeventlistenerdebugpayload.f_291067_());
        } else {
            this.m_292823_(p_300286_);
        }
    }

    private void m_292823_(CustomPacketPayload p_301051_) {
        f_104883_.warn("Unknown custom packet payload: {}", (Object)p_301051_.m_292644_());
    }

    public void m_7957_(ClientboundSetObjectivePacket p_105100_) {
        PacketUtils.m_131363_((Packet)p_105100_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        Scoreboard scoreboard = this.f_104889_.m_6188_();
        String s = p_105100_.m_133266_();
        if (p_105100_.m_133270_() == 0) {
            scoreboard.m_83436_(s, ObjectiveCriteria.f_83588_, p_105100_.m_133269_(), p_105100_.m_133271_());
        } else {
            Objective objective = scoreboard.m_83477_(s);
            if (objective != null) {
                if (p_105100_.m_133270_() == 1) {
                    scoreboard.m_83502_(objective);
                } else if (p_105100_.m_133270_() == 2) {
                    objective.m_83314_(p_105100_.m_133271_());
                    objective.m_83316_(p_105100_.m_133269_());
                }
            }
        }
    }

    public void m_7519_(ClientboundSetScorePacket p_105106_) {
        PacketUtils.m_131363_((Packet)p_105106_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        Scoreboard scoreboard = this.f_104889_.m_6188_();
        String s = p_105106_.m_133342_();
        switch (p_105106_.m_133344_()) {
            case CHANGE: {
                Objective objective = scoreboard.m_83477_(s);
                if (objective != null) {
                    Score score = scoreboard.m_83471_(p_105106_.m_133339_(), objective);
                    score.m_83402_(p_105106_.m_133343_());
                    break;
                }
                f_104883_.warn("Received packet for unknown scoreboard: {}", (Object)s);
                break;
            }
            case REMOVE: {
                scoreboard.m_83479_(p_105106_.m_133339_(), scoreboard.m_83477_(s));
            }
        }
    }

    public void m_5556_(ClientboundSetDisplayObjectivePacket p_105086_) {
        PacketUtils.m_131363_((Packet)p_105086_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        Scoreboard scoreboard = this.f_104889_.m_6188_();
        String s = p_105086_.m_133142_();
        Objective objective = s == null ? null : scoreboard.m_83477_(s);
        scoreboard.m_7136_(p_105086_.m_133139_(), objective);
    }

    public void m_5582_(ClientboundSetPlayerTeamPacket p_105104_) {
        PlayerTeam playerteam;
        PacketUtils.m_131363_((Packet)p_105104_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        Scoreboard scoreboard = this.f_104889_.m_6188_();
        ClientboundSetPlayerTeamPacket.Action clientboundsetplayerteampacket$action = p_105104_.m_179338_();
        if (clientboundsetplayerteampacket$action == ClientboundSetPlayerTeamPacket.Action.ADD) {
            playerteam = scoreboard.m_83492_(p_105104_.m_133311_());
        } else {
            playerteam = scoreboard.m_83489_(p_105104_.m_133311_());
            if (playerteam == null) {
                f_104883_.warn("Received packet for unknown team {}: team action: {}, player action: {}", new Object[]{p_105104_.m_133311_(), p_105104_.m_179338_(), p_105104_.m_179335_()});
                return;
            }
        }
        Optional optional = p_105104_.m_179339_();
        optional.ifPresent(p_233670_ -> {
            Team.CollisionRule team$collisionrule;
            playerteam.m_83353_(p_233670_.m_179363_());
            playerteam.m_83351_(p_233670_.m_179367_());
            playerteam.m_83342_(p_233670_.m_179366_());
            Team.Visibility team$visibility = Team.Visibility.m_83579_((String)p_233670_.m_179368_());
            if (team$visibility != null) {
                playerteam.m_83346_(team$visibility);
            }
            if ((team$collisionrule = Team.CollisionRule.m_83555_((String)p_233670_.m_179369_())) != null) {
                playerteam.m_83344_(team$collisionrule);
            }
            playerteam.m_83360_(p_233670_.m_179370_());
            playerteam.m_83365_(p_233670_.m_179371_());
        });
        ClientboundSetPlayerTeamPacket.Action clientboundsetplayerteampacket$action1 = p_105104_.m_179335_();
        if (clientboundsetplayerteampacket$action1 == ClientboundSetPlayerTeamPacket.Action.ADD) {
            for (String s : p_105104_.m_133315_()) {
                scoreboard.m_6546_(s, playerteam);
            }
        } else if (clientboundsetplayerteampacket$action1 == ClientboundSetPlayerTeamPacket.Action.REMOVE) {
            for (String s1 : p_105104_.m_133315_()) {
                scoreboard.m_6519_(s1, playerteam);
            }
        }
        if (clientboundsetplayerteampacket$action == ClientboundSetPlayerTeamPacket.Action.REMOVE) {
            scoreboard.m_83475_(playerteam);
        }
    }

    public void m_7406_(ClientboundLevelParticlesPacket p_105026_) {
        PacketUtils.m_131363_((Packet)p_105026_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        if (p_105026_.m_132321_() == 0) {
            double d0 = p_105026_.m_132320_() * p_105026_.m_132317_();
            double d2 = p_105026_.m_132320_() * p_105026_.m_132318_();
            double d4 = p_105026_.m_132320_() * p_105026_.m_132319_();
            try {
                this.f_104889_.m_6493_(p_105026_.m_132322_(), p_105026_.m_132311_(), p_105026_.m_132314_(), p_105026_.m_132315_(), p_105026_.m_132316_(), d0, d2, d4);
            }
            catch (Throwable throwable1) {
                f_104883_.warn("Could not spawn particle effect {}", (Object)p_105026_.m_132322_());
            }
        } else {
            for (int i = 0; i < p_105026_.m_132321_(); ++i) {
                double d1 = this.f_104898_.m_188583_() * (double)p_105026_.m_132317_();
                double d3 = this.f_104898_.m_188583_() * (double)p_105026_.m_132318_();
                double d5 = this.f_104898_.m_188583_() * (double)p_105026_.m_132319_();
                double d6 = this.f_104898_.m_188583_() * (double)p_105026_.m_132320_();
                double d7 = this.f_104898_.m_188583_() * (double)p_105026_.m_132320_();
                double d8 = this.f_104898_.m_188583_() * (double)p_105026_.m_132320_();
                try {
                    this.f_104889_.m_6493_(p_105026_.m_132322_(), p_105026_.m_132311_(), p_105026_.m_132314_() + d1, p_105026_.m_132315_() + d3, p_105026_.m_132316_() + d5, d6, d7, d8);
                    continue;
                }
                catch (Throwable throwable) {
                    f_104883_.warn("Could not spawn particle effect {}", (Object)p_105026_.m_132322_());
                    return;
                }
            }
        }
    }

    public void m_7710_(ClientboundUpdateAttributesPacket p_105128_) {
        PacketUtils.m_131363_((Packet)p_105128_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        Entity entity = this.f_104889_.m_6815_(p_105128_.m_133588_());
        if (entity != null) {
            if (!(entity instanceof LivingEntity)) {
                throw new IllegalStateException("Server tried to update attributes of a non-living entity (actually: " + entity + ")");
            }
            AttributeMap attributemap = ((LivingEntity)entity).m_21204_();
            for (ClientboundUpdateAttributesPacket.AttributeSnapshot clientboundupdateattributespacket$attributesnapshot : p_105128_.m_133591_()) {
                AttributeInstance attributeinstance = attributemap.m_22146_(clientboundupdateattributespacket$attributesnapshot.m_133601_());
                if (attributeinstance == null) {
                    f_104883_.warn("Entity {} does not have attribute {}", (Object)entity, (Object)BuiltInRegistries.f_256951_.m_7981_((Object)clientboundupdateattributespacket$attributesnapshot.m_133601_()));
                    continue;
                }
                attributeinstance.m_22100_(clientboundupdateattributespacket$attributesnapshot.m_133602_());
                attributeinstance.m_22132_();
                for (AttributeModifier attributemodifier : clientboundupdateattributespacket$attributesnapshot.m_133603_()) {
                    attributeinstance.m_22118_(attributemodifier);
                }
            }
        }
    }

    public void m_7339_(ClientboundPlaceGhostRecipePacket p_105046_) {
        PacketUtils.m_131363_((Packet)p_105046_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        AbstractContainerMenu abstractcontainermenu = this.f_291812_.f_91074_.f_36096_;
        if (abstractcontainermenu.f_38840_ == p_105046_.m_132658_()) {
            this.f_104900_.m_44043_(p_105046_.m_132655_()).ifPresent(p_296228_ -> {
                if (this.f_291812_.f_91080_ instanceof RecipeUpdateListener) {
                    RecipeBookComponent recipebookcomponent = ((RecipeUpdateListener)this.f_291812_.f_91080_).m_5564_();
                    recipebookcomponent.m_7173_((RecipeHolder<?>)p_296228_, (List<Slot>)p_296227_.f_38839_);
                }
            });
        }
    }

    public void m_183514_(ClientboundLightUpdatePacket p_194243_) {
        PacketUtils.m_131363_((Packet)p_194243_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        int i = p_194243_.m_132349_();
        int j = p_194243_.m_132352_();
        ClientboundLightUpdatePacketData clientboundlightupdatepacketdata = p_194243_.m_195722_();
        this.f_104889_.m_194171_(() -> this.m_194248_(i, j, clientboundlightupdatepacketdata));
    }

    private void m_194248_(int p_194249_, int p_194250_, ClientboundLightUpdatePacketData p_194251_) {
        LevelLightEngine levellightengine = this.f_104889_.m_7726_().m_7827_();
        BitSet bitset = p_194251_.m_195740_();
        BitSet bitset1 = p_194251_.m_195751_();
        Iterator<byte[]> iterator = p_194251_.m_195754_().iterator();
        this.m_171734_(p_194249_, p_194250_, levellightengine, LightLayer.SKY, bitset, bitset1, iterator);
        BitSet bitset2 = p_194251_.m_195757_();
        BitSet bitset3 = p_194251_.m_195758_();
        Iterator<byte[]> iterator1 = p_194251_.m_195759_().iterator();
        this.m_171734_(p_194249_, p_194250_, levellightengine, LightLayer.BLOCK, bitset2, bitset3, iterator1);
        levellightengine.m_9335_(new ChunkPos(p_194249_, p_194250_), true);
    }

    public void m_7330_(ClientboundMerchantOffersPacket p_105034_) {
        PacketUtils.m_131363_((Packet)p_105034_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        AbstractContainerMenu abstractcontainermenu = this.f_291812_.f_91074_.f_36096_;
        if (p_105034_.m_132468_() == abstractcontainermenu.f_38840_ && abstractcontainermenu instanceof MerchantMenu) {
            MerchantMenu merchantmenu = (MerchantMenu)abstractcontainermenu;
            merchantmenu.m_40046_(p_105034_.m_132471_());
            merchantmenu.m_40066_(p_105034_.m_132473_());
            merchantmenu.m_40069_(p_105034_.m_132472_());
            merchantmenu.m_40048_(p_105034_.m_132474_());
            merchantmenu.m_40058_(p_105034_.m_132475_());
        }
    }

    public void m_7299_(ClientboundSetChunkCacheRadiusPacket p_105082_) {
        PacketUtils.m_131363_((Packet)p_105082_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        this.f_104897_ = p_105082_.m_133108_();
        this.f_291812_.f_91066_.m_193770_(this.f_104897_);
        this.f_104889_.m_7726_().m_104416_(p_105082_.m_133108_());
    }

    public void m_183623_(ClientboundSetSimulationDistancePacket p_194245_) {
        PacketUtils.m_131363_((Packet)p_194245_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        this.f_194190_ = p_194245_.f_195796_();
        this.f_104889_.m_194174_(this.f_194190_);
    }

    public void m_8065_(ClientboundSetChunkCacheCenterPacket p_105080_) {
        PacketUtils.m_131363_((Packet)p_105080_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        this.f_104889_.m_7726_().m_104459_(p_105080_.m_133094_(), p_105080_.m_133097_());
    }

    public void m_214108_(ClientboundBlockChangedAckPacket p_233698_) {
        PacketUtils.m_131363_((Packet)p_233698_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        this.f_104889_.m_233651_(p_233698_.f_237578_());
    }

    public void m_264308_(ClientboundBundlePacket p_265195_) {
        PacketUtils.m_131363_((Packet)p_265195_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        for (Packet packet : p_265195_.m_264216_()) {
            packet.m_5797_((PacketListener)this);
        }
    }

    public void m_292715_(ClientboundChunkBatchStartPacket p_297740_) {
        this.f_291253_.m_293630_();
    }

    public void m_293721_(ClientboundChunkBatchFinishedPacket p_300262_) {
        this.f_291253_.m_293201_(p_300262_.f_291136_());
        this.m_295327_((Packet<?>)new ServerboundChunkBatchReceivedPacket(this.f_291253_.m_293338_()));
    }

    public void m_105486_(ClientboundPongResponsePacket p_297651_) {
        this.f_290671_.m_295898_(p_297651_);
    }

    private void m_171734_(int p_171735_, int p_171736_, LevelLightEngine p_171737_, LightLayer p_171738_, BitSet p_171739_, BitSet p_171740_, Iterator<byte[]> p_171741_) {
        for (int i = 0; i < p_171737_.m_164446_(); ++i) {
            int j = p_171737_.m_164447_() + i;
            boolean flag = p_171739_.get(i);
            boolean flag1 = p_171740_.get(i);
            if (!flag && !flag1) continue;
            p_171737_.m_284126_(p_171738_, SectionPos.m_123173_((int)p_171735_, (int)j, (int)p_171736_), flag ? new DataLayer((byte[])p_171741_.next().clone()) : new DataLayer());
            this.f_104889_.m_104793_(p_171735_, j, p_171736_);
        }
    }

    public Connection m_104910_() {
        return this.f_290549_;
    }

    public boolean m_6198_() {
        return this.f_290549_.m_129536_() && !this.f_291533_;
    }

    public Collection<PlayerInfo> m_246170_() {
        return this.f_244156_;
    }

    public Collection<PlayerInfo> m_105142_() {
        return this.f_104892_.values();
    }

    public Collection<UUID> m_105143_() {
        return this.f_104892_.keySet();
    }

    @Nullable
    public PlayerInfo m_104949_(UUID p_104950_) {
        return this.f_104892_.get(p_104950_);
    }

    @Nullable
    public PlayerInfo m_104938_(String p_104939_) {
        for (PlayerInfo playerinfo : this.f_104892_.values()) {
            if (!playerinfo.m_105312_().getName().equals(p_104939_)) continue;
            return playerinfo;
        }
        return null;
    }

    public GameProfile m_105144_() {
        return this.f_104886_;
    }

    public ClientAdvancements m_105145_() {
        return this.f_104893_;
    }

    public CommandDispatcher<SharedSuggestionProvider> m_105146_() {
        return this.f_104899_;
    }

    public ClientLevel m_105147_() {
        return this.f_104889_;
    }

    public DebugQueryHandler m_105149_() {
        return this.f_104896_;
    }

    public UUID m_105150_() {
        return this.f_104901_;
    }

    public Set<ResourceKey<Level>> m_105151_() {
        return this.f_104902_;
    }

    @Override
    public RegistryAccess.Frozen m_105152_() {
        return this.f_104903_;
    }

    public void m_242011_(PlayerChatMessage p_242356_, boolean p_242455_) {
        MessageSignature messagesignature = p_242356_.f_244279_();
        if (messagesignature != null && this.f_244346_.m_245220_(messagesignature, p_242455_) && this.f_244346_.m_245480_() > 64) {
            this.m_247711_();
        }
    }

    private void m_247711_() {
        int i = this.f_244346_.m_245313_();
        if (i > 0) {
            this.m_295327_((Packet<?>)new ServerboundChatAckPacket(i));
        }
    }

    public void m_246175_(String p_249888_) {
        if ((p_249888_ = ForgeHooksClient.onClientSendMessage((String)p_249888_)).isEmpty()) {
            return;
        }
        Instant instant = Instant.now();
        long i = Crypt.SaltSupplier.m_216113_();
        LastSeenMessagesTracker.Update lastseenmessagestracker$update = this.f_244346_.m_246442_();
        MessageSignature messagesignature = this.f_240902_.m_240988_(new SignedMessageBody(p_249888_, instant, i, lastseenmessagestracker$update.f_243872_()));
        this.m_295327_((Packet<?>)new ServerboundChatPacket(p_249888_, instant, i, messagesignature, lastseenmessagestracker$update.f_244473_()));
    }

    public void m_246623_(String p_250092_) {
        if (ClientCommandHandler.runCommand((String)p_250092_)) {
            return;
        }
        Instant instant = Instant.now();
        long i = Crypt.SaltSupplier.m_216113_();
        LastSeenMessagesTracker.Update lastseenmessagestracker$update = this.f_244346_.m_246442_();
        ArgumentSignatures argumentsignatures = ArgumentSignatures.m_245158_((SignableCommand)SignableCommand.m_246497_(this.m_245186_(p_250092_)), p_247875_ -> {
            SignedMessageBody signedmessagebody = new SignedMessageBody(p_247875_, instant, i, lastseenmessagestracker$update.f_243872_());
            return this.f_240902_.m_240988_(signedmessagebody);
        });
        this.m_295327_((Packet<?>)new ServerboundChatCommandPacket(p_250092_, instant, i, argumentsignatures, lastseenmessagestracker$update.f_244473_()));
    }

    public boolean m_246979_(String p_251509_) {
        if (SignableCommand.m_246497_(this.m_245186_(p_251509_)).f_244150_().isEmpty()) {
            LastSeenMessagesTracker.Update lastseenmessagestracker$update = this.f_244346_.m_246442_();
            this.m_295327_((Packet<?>)new ServerboundChatCommandPacket(p_251509_, Instant.now(), 0L, ArgumentSignatures.f_240907_, lastseenmessagestracker$update.f_244473_()));
            return true;
        }
        return false;
    }

    private ParseResults<SharedSuggestionProvider> m_245186_(String p_249982_) {
        return this.f_104899_.parse(p_249982_, (Object)this.f_104894_);
    }

    public void m_9933_() {
        ProfileKeyPairManager profilekeypairmanager;
        if (this.f_290549_.m_129535_() && (profilekeypairmanager = this.f_291812_.m_231465_()).m_253130_()) {
            profilekeypairmanager.m_252904_().thenAcceptAsync(p_253339_ -> p_253339_.ifPresent(this::m_260951_), (Executor)((Object)this.f_291812_));
        }
        this.m_295826_();
        if (this.f_291812_.m_293199_().m_295643_()) {
            this.f_290671_.m_295617_();
        }
        this.f_291019_.m_261056_();
    }

    public void m_260951_(ProfileKeyPair p_261475_) {
        if (this.f_291812_.m_292661_(this.f_104886_.getId()) && (this.f_252517_ == null || !this.f_252517_.f_243926_().equals((Object)p_261475_))) {
            this.f_252517_ = LocalChatSession.m_245157_((ProfileKeyPair)p_261475_);
            this.f_240902_ = this.f_252517_.m_247507_(this.f_104886_.getId());
            this.m_295327_((Packet<?>)new ServerboundChatSessionUpdatePacket(this.f_252517_.m_245584_().m_245986_()));
        }
    }

    @Nullable
    public ServerData m_245416_() {
        return this.f_291024_;
    }

    public FeatureFlagSet m_247016_() {
        return this.f_244039_;
    }

    public boolean m_246351_(FeatureFlagSet p_250605_) {
        return p_250605_.m_247715_(this.m_247016_());
    }
}

