/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.game.ClientboundBossEventPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;

@OnlyIn(value=Dist.CLIENT)
public class BossHealthOverlay {
    private static final int f_168805_ = 182;
    private static final int f_168806_ = 5;
    private static final ResourceLocation[] f_290930_ = new ResourceLocation[]{new ResourceLocation("boss_bar/pink_background"), new ResourceLocation("boss_bar/blue_background"), new ResourceLocation("boss_bar/red_background"), new ResourceLocation("boss_bar/green_background"), new ResourceLocation("boss_bar/yellow_background"), new ResourceLocation("boss_bar/purple_background"), new ResourceLocation("boss_bar/white_background")};
    private static final ResourceLocation[] f_290575_ = new ResourceLocation[]{new ResourceLocation("boss_bar/pink_progress"), new ResourceLocation("boss_bar/blue_progress"), new ResourceLocation("boss_bar/red_progress"), new ResourceLocation("boss_bar/green_progress"), new ResourceLocation("boss_bar/yellow_progress"), new ResourceLocation("boss_bar/purple_progress"), new ResourceLocation("boss_bar/white_progress")};
    private static final ResourceLocation[] f_291445_ = new ResourceLocation[]{new ResourceLocation("boss_bar/notched_6_background"), new ResourceLocation("boss_bar/notched_10_background"), new ResourceLocation("boss_bar/notched_12_background"), new ResourceLocation("boss_bar/notched_20_background")};
    private static final ResourceLocation[] f_290640_ = new ResourceLocation[]{new ResourceLocation("boss_bar/notched_6_progress"), new ResourceLocation("boss_bar/notched_10_progress"), new ResourceLocation("boss_bar/notched_12_progress"), new ResourceLocation("boss_bar/notched_20_progress")};
    private final Minecraft f_93698_;
    final Map<UUID, LerpingBossEvent> f_93699_ = Maps.newLinkedHashMap();

    public BossHealthOverlay(Minecraft p_93702_) {
        this.f_93698_ = p_93702_;
    }

    public void m_280652_(GuiGraphics p_283175_) {
        if (!this.f_93699_.isEmpty()) {
            int i = p_283175_.m_280182_();
            int j = 12;
            for (LerpingBossEvent lerpingbossevent : this.f_93699_.values()) {
                int k = i / 2 - 91;
                CustomizeGuiOverlayEvent.BossEventProgress event = ForgeHooksClient.onCustomizeBossEventProgress((GuiGraphics)p_283175_, (Window)this.f_93698_.m_91268_(), (LerpingBossEvent)lerpingbossevent, (int)k, (int)j, (int)(10 + this.f_93698_.f_91062_.f_92710_));
                if (!event.isCanceled()) {
                    this.m_280106_(p_283175_, k, j, (BossEvent)lerpingbossevent);
                    Component component = lerpingbossevent.m_18861_();
                    int l = this.f_93698_.f_91062_.m_92852_((FormattedText)component);
                    int i1 = i / 2 - l / 2;
                    int j1 = j - 9;
                    p_283175_.m_280430_(this.f_93698_.f_91062_, component, i1, j1, 0xFFFFFF);
                }
                if ((j += event.getIncrement()) < p_283175_.m_280206_() / 3) continue;
                break;
            }
        }
    }

    private void m_280106_(GuiGraphics p_283672_, int p_283570_, int p_283306_, BossEvent p_283156_) {
        this.m_280093_(p_283672_, p_283570_, p_283306_, p_283156_, 182, f_290930_, f_291445_);
        int i = Mth.m_295919_((float)p_283156_.m_142717_(), (int)0, (int)182);
        if (i > 0) {
            this.m_280093_(p_283672_, p_283570_, p_283306_, p_283156_, i, f_290575_, f_290640_);
        }
    }

    private void m_280093_(GuiGraphics p_281657_, int p_283675_, int p_282498_, BossEvent p_281288_, int p_283619_, ResourceLocation[] p_298746_, ResourceLocation[] p_298698_) {
        p_281657_.m_294122_(p_298746_[p_281288_.m_18862_().ordinal()], 182, 5, 0, 0, p_283675_, p_282498_, p_283619_, 5);
        if (p_281288_.m_18863_() != BossEvent.BossBarOverlay.PROGRESS) {
            RenderSystem.enableBlend();
            p_281657_.m_294122_(p_298698_[p_281288_.m_18863_().ordinal() - 1], 182, 5, 0, 0, p_283675_, p_282498_, p_283619_, 5);
            RenderSystem.disableBlend();
        }
    }

    public void m_93711_(ClientboundBossEventPacket p_93712_) {
        p_93712_.m_178643_(new ClientboundBossEventPacket.Handler(){

            public void m_142107_(UUID p_168824_, Component p_168825_, float p_168826_, BossEvent.BossBarColor p_168827_, BossEvent.BossBarOverlay p_168828_, boolean p_168829_, boolean p_168830_, boolean p_168831_) {
                BossHealthOverlay.this.f_93699_.put(p_168824_, new LerpingBossEvent(p_168824_, p_168825_, p_168826_, p_168827_, p_168828_, p_168829_, p_168830_, p_168831_));
            }

            public void m_142751_(UUID p_168812_) {
                BossHealthOverlay.this.f_93699_.remove(p_168812_);
            }

            public void m_142653_(UUID p_168814_, float p_168815_) {
                BossHealthOverlay.this.f_93699_.get(p_168814_).m_142711_(p_168815_);
            }

            public void m_142366_(UUID p_168821_, Component p_168822_) {
                BossHealthOverlay.this.f_93699_.get(p_168821_).m_6456_(p_168822_);
            }

            public void m_142358_(UUID p_168817_, BossEvent.BossBarColor p_168818_, BossEvent.BossBarOverlay p_168819_) {
                LerpingBossEvent lerpingbossevent = BossHealthOverlay.this.f_93699_.get(p_168817_);
                lerpingbossevent.m_6451_(p_168818_);
                lerpingbossevent.m_5648_(p_168819_);
            }

            public void m_142513_(UUID p_168833_, boolean p_168834_, boolean p_168835_, boolean p_168836_) {
                LerpingBossEvent lerpingbossevent = BossHealthOverlay.this.f_93699_.get(p_168833_);
                lerpingbossevent.m_7003_(p_168834_);
                lerpingbossevent.m_7005_(p_168835_);
                lerpingbossevent.m_7006_(p_168836_);
            }
        });
    }

    public void m_93703_() {
        this.f_93699_.clear();
    }

    public boolean m_93713_() {
        if (!this.f_93699_.isEmpty()) {
            for (BossEvent bossEvent : this.f_93699_.values()) {
                if (!bossEvent.m_18865_()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean m_93714_() {
        if (!this.f_93699_.isEmpty()) {
            for (BossEvent bossEvent : this.f_93699_.values()) {
                if (!bossEvent.m_18864_()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean m_93715_() {
        if (!this.f_93699_.isEmpty()) {
            for (BossEvent bossEvent : this.f_93699_.values()) {
                if (!bossEvent.m_18866_()) continue;
                return true;
            }
        }
        return false;
    }
}

