/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.jarjar.metadata.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Iterator;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.Restriction;
import org.apache.maven.artifact.versioning.VersionRange;

public class VersionRangeSerializer
implements JsonSerializer<VersionRange>,
JsonDeserializer<VersionRange> {
    public VersionRange deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonPrimitive()) {
            try {
                return VersionRange.createFromVersionSpec((String)json.getAsString());
            }
            catch (InvalidVersionSpecificationException e) {
                throw new JsonParseException("Failed to parse version spec from: " + json.getAsString(), (Throwable)e);
            }
        }
        throw new JsonParseException("Expected a string or primitive value");
    }

    public JsonElement serialize(VersionRange src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(this.serializeRange(src));
    }

    private String serializeRange(VersionRange src) {
        if (src.getRecommendedVersion() != null) {
            return src.getRecommendedVersion().toString();
        }
        StringBuilder buf = new StringBuilder();
        Iterator i = src.getRestrictions().iterator();
        while (i.hasNext()) {
            Restriction r = (Restriction)i.next();
            buf.append(this.serializeRestriction(r));
            if (!i.hasNext()) continue;
            buf.append(',');
        }
        return buf.toString();
    }

    private String serializeRestriction(Restriction src) {
        StringBuilder buf = new StringBuilder();
        buf.append(src.isLowerBoundInclusive() ? (char)'[' : '(');
        if (src.getLowerBound().equals(src.getUpperBound())) {
            buf.append(src.getLowerBound().toString());
        } else {
            if (src.getLowerBound() != null) {
                buf.append(src.getLowerBound().toString());
            }
            buf.append(',');
            if (src.getUpperBound() != null) {
                buf.append(src.getUpperBound().toString());
            }
        }
        buf.append(src.isUpperBoundInclusive() ? (char)']' : ')');
        return buf.toString();
    }
}

