/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class ApplyBonusCount
extends LootItemConditionalFunction {
    private static final Map<ResourceLocation, FormulaType> f_79898_ = Stream.of(BinomialWithBonusCount.f_79947_, OreDrops.f_79973_, UniformBonusCount.f_80012_).collect(Collectors.toMap(FormulaType::f_291058_, Function.identity()));
    static final Codec<FormulaType> f_291576_ = ResourceLocation.f_135803_.comapFlatMap(p_297073_ -> {
        FormulaType $$1 = f_79898_.get(p_297073_);
        if ($$1 != null) {
            return DataResult.success((Object)$$1);
        }
        return DataResult.error(() -> "No formula type with id: '" + p_297073_ + "'");
    }, FormulaType::f_291058_);
    private static final MapCodec<Formula> f_290648_ = new MapCodec<Formula>(){
        private static final String f_290340_ = "formula";
        private static final String f_291858_ = "parameters";

        public <T> Stream<T> keys(DynamicOps<T> p_299919_) {
            return Stream.of(p_299919_.createString(f_290340_), p_299919_.createString(f_291858_));
        }

        public <T> DataResult<Formula> decode(DynamicOps<T> p_297405_, MapLike<T> p_298221_) {
            Object $$2 = p_298221_.get(f_290340_);
            if ($$2 == null) {
                return DataResult.error(() -> "Missing type for formula in: " + p_298221_);
            }
            return f_291576_.decode(p_297405_, $$2).flatMap(p_298653_ -> {
                Object $$3 = Objects.requireNonNullElseGet(p_298221_.get(f_291858_), () -> ((DynamicOps)p_297405_).emptyMap());
                return ((FormulaType)p_298653_.getFirst()).f_291691_().decode(p_297405_, $$3).map(Pair::getFirst);
            });
        }

        public <T> RecordBuilder<T> encode(Formula p_299009_, DynamicOps<T> p_298702_, RecordBuilder<T> p_298118_) {
            FormulaType $$3 = p_299009_.m_5713_();
            p_298118_.add(f_290340_, f_291576_.encodeStart(p_298702_, (Object)$$3));
            DataResult<T> $$4 = this.m_293891_($$3.f_291691_(), p_299009_, p_298702_);
            if ($$4.result().isEmpty() || !Objects.equals($$4.result().get(), p_298702_.emptyMap())) {
                p_298118_.add(f_291858_, $$4);
            }
            return p_298118_;
        }

        private <T, F extends Formula> DataResult<T> m_293891_(Codec<F> p_298015_, Formula p_298974_, DynamicOps<T> p_298875_) {
            return p_298015_.encodeStart(p_298875_, (Object)p_298974_);
        }

        public /* synthetic */ RecordBuilder encode(Object object, DynamicOps dynamicOps, RecordBuilder recordBuilder) {
            return this.encode((Formula)object, dynamicOps, recordBuilder);
        }
    };
    public static final Codec<ApplyBonusCount> f_291250_ = RecordCodecBuilder.create(p_297066_ -> ApplyBonusCount.m_294820_(p_297066_).and(p_297066_.group((App)BuiltInRegistries.f_256876_.m_206110_().fieldOf("enchantment").forGetter(p_297072_ -> p_297072_.f_79899_), (App)f_290648_.forGetter(p_297058_ -> p_297058_.f_79900_))).apply((Applicative)p_297066_, ApplyBonusCount::new));
    private final Holder<Enchantment> f_79899_;
    private final Formula f_79900_;

    private ApplyBonusCount(List<LootItemCondition> p_298095_, Holder<Enchantment> p_298508_, Formula p_79905_) {
        super(p_298095_);
        this.f_79899_ = p_298508_;
        this.f_79900_ = p_79905_;
    }

    @Override
    public LootItemFunctionType m_7162_() {
        return LootItemFunctions.f_80750_;
    }

    @Override
    public Set<LootContextParam<?>> m_6231_() {
        return ImmutableSet.of(LootContextParams.f_81463_);
    }

    @Override
    public ItemStack m_7372_(ItemStack p_79913_, LootContext p_79914_) {
        ItemStack $$2 = p_79914_.m_78953_(LootContextParams.f_81463_);
        if ($$2 != null) {
            int $$3 = EnchantmentHelper.m_44843_(this.f_79899_.m_203334_(), $$2);
            int $$4 = this.f_79900_.m_213779_(p_79914_.m_230907_(), p_79913_.m_41613_(), $$3);
            p_79913_.m_41764_($$4);
        }
        return p_79913_;
    }

    public static LootItemConditionalFunction.Builder<?> m_79917_(Enchantment p_79918_, float p_79919_, int p_79920_) {
        return ApplyBonusCount.m_80683_(p_297062_ -> new ApplyBonusCount((List<LootItemCondition>)p_297062_, (Holder<Enchantment>)p_79918_.m_292589_(), new BinomialWithBonusCount(p_79920_, p_79919_)));
    }

    public static LootItemConditionalFunction.Builder<?> m_79915_(Enchantment p_79916_) {
        return ApplyBonusCount.m_80683_(p_297064_ -> new ApplyBonusCount((List<LootItemCondition>)p_297064_, (Holder<Enchantment>)p_79916_.m_292589_(), new OreDrops()));
    }

    public static LootItemConditionalFunction.Builder<?> m_79939_(Enchantment p_79940_) {
        return ApplyBonusCount.m_80683_(p_297068_ -> new ApplyBonusCount((List<LootItemCondition>)p_297068_, (Holder<Enchantment>)p_79940_.m_292589_(), new UniformBonusCount(1)));
    }

    public static LootItemConditionalFunction.Builder<?> m_79921_(Enchantment p_79922_, int p_79923_) {
        return ApplyBonusCount.m_80683_(p_297071_ -> new ApplyBonusCount((List<LootItemCondition>)p_297071_, (Holder<Enchantment>)p_79922_.m_292589_(), new UniformBonusCount(p_79923_)));
    }

    static interface Formula {
        public int m_213779_(RandomSource var1, int var2, int var3);

        public FormulaType m_5713_();
    }

    record UniformBonusCount(int f_80013_) implements Formula
    {
        public static final Codec<UniformBonusCount> f_290477_ = RecordCodecBuilder.create(p_297464_ -> p_297464_.group((App)Codec.INT.fieldOf("bonusMultiplier").forGetter(UniformBonusCount::f_80013_)).apply((Applicative)p_297464_, UniformBonusCount::new));
        public static final FormulaType f_80012_ = new FormulaType(new ResourceLocation("uniform_bonus_count"), f_290477_);

        @Override
        public int m_213779_(RandomSource p_230976_, int p_230977_, int p_230978_) {
            return p_230977_ + p_230976_.m_188503_(this.f_80013_ * p_230978_ + 1);
        }

        @Override
        public FormulaType m_5713_() {
            return f_80012_;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{UniformBonusCount.class, "bonusMultiplier", "f_80013_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{UniformBonusCount.class, "bonusMultiplier", "f_80013_"}, this);
        }

        @Override
        public final boolean equals(Object p_301407_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{UniformBonusCount.class, "bonusMultiplier", "f_80013_"}, this, p_301407_);
        }
    }

    record OreDrops() implements Formula
    {
        public static final Codec<OreDrops> f_291282_ = Codec.unit(OreDrops::new);
        public static final FormulaType f_79973_ = new FormulaType(new ResourceLocation("ore_drops"), f_291282_);

        @Override
        public int m_213779_(RandomSource p_230972_, int p_230973_, int p_230974_) {
            if (p_230974_ > 0) {
                int $$3 = p_230972_.m_188503_(p_230974_ + 2) - 1;
                if ($$3 < 0) {
                    $$3 = 0;
                }
                return p_230973_ * ($$3 + 1);
            }
            return p_230973_;
        }

        @Override
        public FormulaType m_5713_() {
            return f_79973_;
        }
    }

    record BinomialWithBonusCount(int f_79948_, float f_79949_) implements Formula
    {
        private static final Codec<BinomialWithBonusCount> f_290700_ = RecordCodecBuilder.create(p_299643_ -> p_299643_.group((App)Codec.INT.fieldOf("extra").forGetter(BinomialWithBonusCount::f_79948_), (App)Codec.FLOAT.fieldOf("probability").forGetter(BinomialWithBonusCount::f_79949_)).apply((Applicative)p_299643_, BinomialWithBonusCount::new));
        public static final FormulaType f_79947_ = new FormulaType(new ResourceLocation("binomial_with_bonus_count"), f_290700_);

        @Override
        public int m_213779_(RandomSource p_230965_, int p_230966_, int p_230967_) {
            for (int $$3 = 0; $$3 < p_230967_ + this.f_79948_; ++$$3) {
                if (!(p_230965_.m_188501_() < this.f_79949_)) continue;
                ++p_230966_;
            }
            return p_230966_;
        }

        @Override
        public FormulaType m_5713_() {
            return f_79947_;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{BinomialWithBonusCount.class, "extraRounds;probability", "f_79948_", "f_79949_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BinomialWithBonusCount.class, "extraRounds;probability", "f_79948_", "f_79949_"}, this);
        }

        @Override
        public final boolean equals(Object p_299236_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BinomialWithBonusCount.class, "extraRounds;probability", "f_79948_", "f_79949_"}, this, p_299236_);
        }
    }

    record FormulaType(ResourceLocation f_291058_, Codec<? extends Formula> f_291691_) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{FormulaType.class, "id;codec", "f_291058_", "f_291691_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{FormulaType.class, "id;codec", "f_291058_", "f_291691_"}, this);
        }

        @Override
        public final boolean equals(Object p_299998_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{FormulaType.class, "id;codec", "f_291058_", "f_291691_"}, this, p_299998_);
        }
    }
}

