/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.dimension.end;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.EndFeatures;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TheEndPortalBlockEntity;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockPredicate;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.end.DragonRespawnAnimation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.EndPodiumFeature;
import net.minecraft.world.level.levelgen.feature.SpikeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.phys.AABB;
import org.slf4j.Logger;

public class EndDragonFight {
    private static final Logger f_64058_ = LogUtils.getLogger();
    private static final int f_156737_ = 1200;
    private static final int f_156738_ = 100;
    public static final int f_156739_ = 20;
    private static final int f_156740_ = 8;
    public static final int f_156735_ = 9;
    private static final int f_156741_ = 20;
    private static final int f_156742_ = 96;
    public static final int f_156736_ = 128;
    private final Predicate<Entity> f_286991_;
    private final ServerBossEvent f_64060_ = (ServerBossEvent)new ServerBossEvent(Component.m_237115_("entity.minecraft.ender_dragon"), BossEvent.BossBarColor.PINK, BossEvent.BossBarOverlay.PROGRESS).m_7005_(true).m_7006_(true);
    private final ServerLevel f_64061_;
    private final BlockPos f_286985_;
    private final ObjectArrayList<Integer> f_64062_ = new ObjectArrayList();
    private final BlockPattern f_64063_;
    private int f_64064_;
    private int f_64065_;
    private int f_64066_;
    private int f_64067_ = 21;
    private boolean f_64068_;
    private boolean f_64069_;
    private boolean f_286982_ = false;
    @Nullable
    private UUID f_64070_;
    private boolean f_64071_ = true;
    @Nullable
    private BlockPos f_64072_;
    @Nullable
    private DragonRespawnAnimation f_64073_;
    private int f_64074_;
    @Nullable
    private List<EndCrystal> f_64075_;

    public EndDragonFight(ServerLevel p_289759_, long p_289805_, Data p_289800_) {
        this(p_289759_, p_289805_, p_289800_, BlockPos.f_121853_);
    }

    public EndDragonFight(ServerLevel p_289771_, long p_289793_, Data p_289768_, BlockPos p_289794_) {
        this.f_64061_ = p_289771_;
        this.f_286985_ = p_289794_;
        this.f_286991_ = EntitySelector.f_20402_.and(EntitySelector.m_20410_(p_289794_.m_123341_(), 128 + p_289794_.m_123342_(), p_289794_.m_123343_(), 192.0));
        this.f_64071_ = p_289768_.f_289710_;
        this.f_64070_ = p_289768_.f_289702_.orElse(null);
        this.f_64068_ = p_289768_.f_289711_;
        this.f_64069_ = p_289768_.f_289704_;
        if (p_289768_.f_289703_) {
            this.f_64073_ = DragonRespawnAnimation.START;
        }
        this.f_64072_ = p_289768_.f_289708_.orElse(null);
        this.f_64062_.addAll((Collection)p_289768_.f_289705_.orElseGet(() -> {
            ObjectArrayList $$1 = new ObjectArrayList((Collection)ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(20)), (DiscreteDomain)DiscreteDomain.integers()));
            Util.m_214673_($$1, RandomSource.m_216335_(p_289793_));
            return $$1;
        }));
        this.f_64063_ = BlockPatternBuilder.m_61243_().m_61247_("       ", "       ", "       ", "   #   ", "       ", "       ", "       ").m_61247_("       ", "       ", "       ", "   #   ", "       ", "       ", "       ").m_61247_("       ", "       ", "       ", "   #   ", "       ", "       ", "       ").m_61247_("  ###  ", " #   # ", "#     #", "#  #  #", "#     #", " #   # ", "  ###  ").m_61247_("       ", "  ###  ", " ##### ", " ##### ", " ##### ", "  ###  ", "       ").m_61244_('#', BlockInWorld.m_61169_(BlockPredicate.m_61275_(Blocks.f_50752_))).m_61249_();
    }

    @Deprecated
    @VisibleForTesting
    public void m_287277_() {
        this.f_286982_ = true;
    }

    public Data m_289745_() {
        return new Data(this.f_64071_, this.f_64068_, this.f_64069_, false, Optional.ofNullable(this.f_64070_), Optional.ofNullable(this.f_64072_), Optional.of(this.f_64062_));
    }

    public void m_64095_() {
        this.f_64060_.m_8321_(!this.f_64068_);
        if (++this.f_64067_ >= 20) {
            this.m_64107_();
            this.f_64067_ = 0;
        }
        if (!this.f_64060_.m_8324_().isEmpty()) {
            this.f_64061_.m_7726_().m_8387_(TicketType.f_9443_, new ChunkPos(0, 0), 9, Unit.INSTANCE);
            boolean $$0 = this.m_64106_();
            if (this.f_64071_ && $$0) {
                this.m_64102_();
                this.f_64071_ = false;
            }
            if (this.f_64073_ != null) {
                if (this.f_64075_ == null && $$0) {
                    this.f_64073_ = null;
                    this.m_64100_();
                }
                this.f_64073_.m_6363_(this.f_64061_, this, this.f_64075_, this.f_64074_++, this.f_64072_);
            }
            if (!this.f_64068_) {
                if ((this.f_64070_ == null || ++this.f_64064_ >= 1200) && $$0) {
                    this.m_64103_();
                    this.f_64064_ = 0;
                }
                if (++this.f_64066_ >= 100 && $$0) {
                    this.m_64108_();
                    this.f_64066_ = 0;
                }
            }
        } else {
            this.f_64061_.m_7726_().m_8438_(TicketType.f_9443_, new ChunkPos(0, 0), 9, Unit.INSTANCE);
        }
    }

    private void m_64102_() {
        f_64058_.info("Scanning for legacy world dragon fight...");
        boolean $$0 = this.m_64104_();
        if ($$0) {
            f_64058_.info("Found that the dragon has been killed in this world already.");
            this.f_64069_ = true;
        } else {
            f_64058_.info("Found that the dragon has not yet been killed in this world.");
            this.f_64069_ = false;
            if (this.m_64105_() == null) {
                this.m_64093_(false);
            }
        }
        List<? extends EnderDragon> $$1 = this.f_64061_.m_8857_();
        if ($$1.isEmpty()) {
            this.f_64068_ = true;
        } else {
            EnderDragon $$2 = $$1.get(0);
            this.f_64070_ = $$2.m_20148_();
            f_64058_.info("Found that there's a dragon still alive ({})", (Object)$$2);
            this.f_64068_ = false;
            if (!$$0) {
                f_64058_.info("But we didn't have a portal, let's remove it.");
                $$2.m_146870_();
                this.f_64070_ = null;
            }
        }
        if (!this.f_64069_ && this.f_64068_) {
            this.f_64068_ = false;
        }
    }

    private void m_64103_() {
        List<? extends EnderDragon> $$0 = this.f_64061_.m_8857_();
        if ($$0.isEmpty()) {
            f_64058_.debug("Haven't seen the dragon, respawning it");
            this.m_64110_();
        } else {
            f_64058_.debug("Haven't seen our dragon, but found another one to use.");
            this.f_64070_ = $$0.get(0).m_20148_();
        }
    }

    protected void m_64087_(DragonRespawnAnimation p_64088_) {
        if (this.f_64073_ == null) {
            throw new IllegalStateException("Dragon respawn isn't in progress, can't skip ahead in the animation.");
        }
        this.f_64074_ = 0;
        if (p_64088_ == DragonRespawnAnimation.END) {
            this.f_64073_ = null;
            this.f_64068_ = false;
            EnderDragon $$1 = this.m_64110_();
            if ($$1 != null) {
                for (ServerPlayer $$2 : this.f_64060_.m_8324_()) {
                    CriteriaTriggers.f_10580_.m_68256_($$2, $$1);
                }
            }
        } else {
            this.f_64073_ = p_64088_;
        }
    }

    private boolean m_64104_() {
        for (int $$0 = -8; $$0 <= 8; ++$$0) {
            for (int $$1 = -8; $$1 <= 8; ++$$1) {
                LevelChunk $$2 = this.f_64061_.m_6325_($$0, $$1);
                for (BlockEntity $$3 : $$2.m_62954_().values()) {
                    if (!($$3 instanceof TheEndPortalBlockEntity)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    private BlockPattern.BlockPatternMatch m_64105_() {
        int $$8;
        ChunkPos $$0 = new ChunkPos(this.f_286985_);
        for (int $$1 = -8 + $$0.f_45578_; $$1 <= 8 + $$0.f_45578_; ++$$1) {
            for (int $$2 = -8 + $$0.f_45579_; $$2 <= 8 + $$0.f_45579_; ++$$2) {
                LevelChunk $$3 = this.f_64061_.m_6325_($$1, $$2);
                for (BlockEntity $$4 : $$3.m_62954_().values()) {
                    BlockPattern.BlockPatternMatch $$5;
                    if (!($$4 instanceof TheEndPortalBlockEntity) || ($$5 = this.f_64063_.m_61184_(this.f_64061_, $$4.m_58899_())) == null) continue;
                    BlockPos $$6 = $$5.m_61229_(3, 3, 3).m_61176_();
                    if (this.f_64072_ == null) {
                        this.f_64072_ = $$6;
                    }
                    return $$5;
                }
            }
        }
        BlockPos $$7 = EndPodiumFeature.m_287210_(this.f_286985_);
        for (int $$9 = $$8 = this.f_64061_.m_5452_(Heightmap.Types.MOTION_BLOCKING, $$7).m_123342_(); $$9 >= this.f_64061_.m_141937_(); --$$9) {
            BlockPattern.BlockPatternMatch $$10 = this.f_64063_.m_61184_(this.f_64061_, new BlockPos($$7.m_123341_(), $$9, $$7.m_123343_()));
            if ($$10 == null) continue;
            if (this.f_64072_ == null) {
                this.f_64072_ = $$10.m_61229_(3, 3, 3).m_61176_();
            }
            return $$10;
        }
        return null;
    }

    private boolean m_64106_() {
        if (this.f_286982_) {
            return true;
        }
        ChunkPos $$0 = new ChunkPos(this.f_286985_);
        for (int $$1 = -8 + $$0.f_45578_; $$1 <= 8 + $$0.f_45578_; ++$$1) {
            for (int $$2 = 8 + $$0.f_45579_; $$2 <= 8 + $$0.f_45579_; ++$$2) {
                ChunkAccess $$3 = this.f_64061_.m_6522_($$1, $$2, ChunkStatus.f_62326_, false);
                if (!($$3 instanceof LevelChunk)) {
                    return false;
                }
                FullChunkStatus $$4 = ((LevelChunk)$$3).m_287138_();
                if ($$4.m_287205_(FullChunkStatus.BLOCK_TICKING)) continue;
                return false;
            }
        }
        return true;
    }

    private void m_64107_() {
        HashSet $$0 = Sets.newHashSet();
        for (ServerPlayer $$1 : this.f_64061_.m_8795_(this.f_286991_)) {
            this.f_64060_.m_6543_($$1);
            $$0.add($$1);
        }
        HashSet $$2 = Sets.newHashSet(this.f_64060_.m_8324_());
        $$2.removeAll($$0);
        for (ServerPlayer $$3 : $$2) {
            this.f_64060_.m_6539_($$3);
        }
    }

    private void m_64108_() {
        this.f_64066_ = 0;
        this.f_64065_ = 0;
        for (SpikeFeature.EndSpike $$0 : SpikeFeature.m_66858_(this.f_64061_)) {
            this.f_64065_ += this.f_64061_.m_45976_(EndCrystal.class, $$0.m_66905_()).size();
        }
        f_64058_.debug("Found {} end crystals still alive", (Object)this.f_64065_);
    }

    public void m_64085_(EnderDragon p_64086_) {
        if (p_64086_.m_20148_().equals(this.f_64070_)) {
            this.f_64060_.m_142711_(0.0f);
            this.f_64060_.m_8321_(false);
            this.m_64093_(true);
            this.m_64109_();
            if (!this.f_64069_) {
                this.f_64061_.m_46597_(this.f_64061_.m_5452_(Heightmap.Types.MOTION_BLOCKING, EndPodiumFeature.m_287210_(this.f_286985_)), Blocks.f_50260_.m_49966_());
            }
            this.f_64069_ = true;
            this.f_64068_ = true;
        }
    }

    @Deprecated
    @VisibleForTesting
    public void m_287238_() {
        this.f_64062_.clear();
    }

    private void m_64109_() {
        if (this.f_64062_.isEmpty()) {
            return;
        }
        int $$0 = (Integer)this.f_64062_.remove(this.f_64062_.size() - 1);
        int $$1 = Mth.m_14107_(96.0 * Math.cos(2.0 * (-Math.PI + 0.15707963267948966 * (double)$$0)));
        int $$2 = Mth.m_14107_(96.0 * Math.sin(2.0 * (-Math.PI + 0.15707963267948966 * (double)$$0)));
        this.m_64089_(new BlockPos($$1, 75, $$2));
    }

    private void m_64089_(BlockPos p_64090_) {
        this.f_64061_.m_46796_(3000, p_64090_, 0);
        this.f_64061_.m_9598_().m_6632_(Registries.f_256911_).flatMap(p_258993_ -> p_258993_.m_203636_(EndFeatures.f_194984_)).ifPresent(p_256486_ -> ((ConfiguredFeature)p_256486_.m_203334_()).m_224953_(this.f_64061_, this.f_64061_.m_7726_().m_8481_(), RandomSource.m_216327_(), p_64090_));
    }

    private void m_64093_(boolean p_64094_) {
        EndPodiumFeature $$1 = new EndPodiumFeature(p_64094_);
        if (this.f_64072_ == null) {
            this.f_64072_ = this.f_64061_.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.m_287210_(this.f_286985_)).m_7495_();
            while (this.f_64061_.m_8055_(this.f_64072_).m_60713_(Blocks.f_50752_) && this.f_64072_.m_123342_() > this.f_64061_.m_5736_()) {
                this.f_64072_ = this.f_64072_.m_7495_();
            }
        }
        if ($$1.m_225028_(FeatureConfiguration.f_67737_, this.f_64061_, this.f_64061_.m_7726_().m_8481_(), RandomSource.m_216327_(), this.f_64072_)) {
            int $$2 = Mth.m_184652_(4, 16);
            this.f_64061_.m_7726_().f_8325_.m_293872_(new ChunkPos(this.f_64072_), $$2);
        }
    }

    @Nullable
    private EnderDragon m_64110_() {
        this.f_64061_.m_46745_(new BlockPos(this.f_286985_.m_123341_(), 128 + this.f_286985_.m_123342_(), this.f_286985_.m_123343_()));
        EnderDragon $$0 = EntityType.f_20565_.m_20615_(this.f_64061_);
        if ($$0 != null) {
            $$0.m_287231_(this);
            $$0.m_287266_(this.f_286985_);
            $$0.m_31157_().m_31416_(EnderDragonPhase.f_31377_);
            $$0.m_7678_(this.f_286985_.m_123341_(), 128 + this.f_286985_.m_123342_(), this.f_286985_.m_123343_(), this.f_64061_.f_46441_.m_188501_() * 360.0f, 0.0f);
            this.f_64061_.m_7967_($$0);
            this.f_64070_ = $$0.m_20148_();
        }
        return $$0;
    }

    public void m_64096_(EnderDragon p_64097_) {
        if (p_64097_.m_20148_().equals(this.f_64070_)) {
            this.f_64060_.m_142711_(p_64097_.m_21223_() / p_64097_.m_21233_());
            this.f_64064_ = 0;
            if (p_64097_.m_8077_()) {
                this.f_64060_.m_6456_(p_64097_.m_5446_());
            }
        }
    }

    public int m_64098_() {
        return this.f_64065_;
    }

    public void m_64082_(EndCrystal p_64083_, DamageSource p_64084_) {
        if (this.f_64073_ != null && this.f_64075_.contains(p_64083_)) {
            f_64058_.debug("Aborting respawn sequence");
            this.f_64073_ = null;
            this.f_64074_ = 0;
            this.m_64101_();
            this.m_64093_(true);
        } else {
            this.m_64108_();
            Entity $$2 = this.f_64061_.m_8791_(this.f_64070_);
            if ($$2 instanceof EnderDragon) {
                ((EnderDragon)$$2).m_31124_(p_64083_, p_64083_.m_20183_(), p_64084_);
            }
        }
    }

    public boolean m_64099_() {
        return this.f_64069_;
    }

    public void m_64100_() {
        if (this.f_64068_ && this.f_64073_ == null) {
            BlockPos $$0 = this.f_64072_;
            if ($$0 == null) {
                f_64058_.debug("Tried to respawn, but need to find the portal first.");
                BlockPattern.BlockPatternMatch $$1 = this.m_64105_();
                if ($$1 == null) {
                    f_64058_.debug("Couldn't find a portal, so we made one.");
                    this.m_64093_(true);
                } else {
                    f_64058_.debug("Found the exit portal & saved its location for next time.");
                }
                $$0 = this.f_64072_;
            }
            ArrayList $$2 = Lists.newArrayList();
            BlockPos $$3 = $$0.m_6630_(1);
            for (Direction $$4 : Direction.Plane.HORIZONTAL) {
                List<EndCrystal> $$5 = this.f_64061_.m_45976_(EndCrystal.class, new AABB($$3.m_5484_($$4, 2)));
                if ($$5.isEmpty()) {
                    return;
                }
                $$2.addAll($$5);
            }
            f_64058_.debug("Found all crystals, respawning dragon.");
            this.m_64091_($$2);
        }
    }

    private void m_64091_(List<EndCrystal> p_64092_) {
        if (this.f_64068_ && this.f_64073_ == null) {
            BlockPattern.BlockPatternMatch $$1 = this.m_64105_();
            while ($$1 != null) {
                for (int $$2 = 0; $$2 < this.f_64063_.m_61203_(); ++$$2) {
                    for (int $$3 = 0; $$3 < this.f_64063_.m_61202_(); ++$$3) {
                        for (int $$4 = 0; $$4 < this.f_64063_.m_61183_(); ++$$4) {
                            BlockInWorld $$5 = $$1.m_61229_($$2, $$3, $$4);
                            if (!$$5.m_61168_().m_60713_(Blocks.f_50752_) && !$$5.m_61168_().m_60713_(Blocks.f_50257_)) continue;
                            this.f_64061_.m_46597_($$5.m_61176_(), Blocks.f_50259_.m_49966_());
                        }
                    }
                }
                $$1 = this.m_64105_();
            }
            this.f_64073_ = DragonRespawnAnimation.START;
            this.f_64074_ = 0;
            this.m_64093_(false);
            this.f_64075_ = p_64092_;
        }
    }

    public void m_64101_() {
        for (SpikeFeature.EndSpike $$0 : SpikeFeature.m_66858_(this.f_64061_)) {
            List<EndCrystal> $$1 = this.f_64061_.m_45976_(EndCrystal.class, $$0.m_66905_());
            for (EndCrystal $$2 : $$1) {
                $$2.m_20331_(false);
                $$2.m_31052_(null);
            }
        }
    }

    @Nullable
    public UUID m_288211_() {
        return this.f_64070_;
    }

    public record Data(boolean f_289710_, boolean f_289711_, boolean f_289704_, boolean f_289703_, Optional<UUID> f_289702_, Optional<BlockPos> f_289708_, Optional<List<Integer>> f_289705_) {
        public static final Codec<Data> f_289707_ = RecordCodecBuilder.create(p_289803_ -> p_289803_.group((App)Codec.BOOL.fieldOf("NeedsStateScanning").orElse((Object)true).forGetter(Data::f_289710_), (App)Codec.BOOL.fieldOf("DragonKilled").orElse((Object)false).forGetter(Data::f_289711_), (App)Codec.BOOL.fieldOf("PreviouslyKilled").orElse((Object)false).forGetter(Data::f_289704_), (App)Codec.BOOL.optionalFieldOf("IsRespawning", (Object)false).forGetter(Data::f_289703_), (App)UUIDUtil.f_235867_.optionalFieldOf("Dragon").forGetter(Data::f_289702_), (App)BlockPos.f_121852_.optionalFieldOf("ExitPortalLocation").forGetter(Data::f_289708_), (App)Codec.list((Codec)Codec.INT).optionalFieldOf("Gateways").forGetter(Data::f_289705_)).apply((Applicative)p_289803_, Data::new));
        public static final Data f_289709_ = new Data(true, false, false, false, Optional.empty(), Optional.empty(), Optional.empty());

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Data.class, "needsStateScanning;dragonKilled;previouslyKilled;isRespawning;dragonUUID;exitPortalLocation;gateways", "f_289710_", "f_289711_", "f_289704_", "f_289703_", "f_289702_", "f_289708_", "f_289705_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Data.class, "needsStateScanning;dragonKilled;previouslyKilled;isRespawning;dragonUUID;exitPortalLocation;gateways", "f_289710_", "f_289711_", "f_289704_", "f_289703_", "f_289702_", "f_289708_", "f_289705_"}, this);
        }

        @Override
        public final boolean equals(Object p_289779_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Data.class, "needsStateScanning;dragonKilled;previouslyKilled;isRespawning;dragonUUID;exitPortalLocation;gateways", "f_289710_", "f_289711_", "f_289704_", "f_289703_", "f_289702_", "f_289708_", "f_289705_"}, this, p_289779_);
        }
    }
}

