/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.datafix.fixes.BlockStateData;
import net.minecraft.util.datafix.fixes.ItemStackTheFlatteningFix;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.schemas.V1451_6;
import org.apache.commons.lang3.StringUtils;

public class StatsCounterFix
extends DataFix {
    private static final Set<String> f_291555_ = Set.of("dummy", "trigger", "deathCount", "playerKillCount", "totalKillCount", "health", "food", "air", "armor", "xp", "level", "killedByTeam.aqua", "killedByTeam.black", "killedByTeam.blue", "killedByTeam.dark_aqua", "killedByTeam.dark_blue", "killedByTeam.dark_gray", "killedByTeam.dark_green", "killedByTeam.dark_purple", "killedByTeam.dark_red", "killedByTeam.gold", "killedByTeam.gray", "killedByTeam.green", "killedByTeam.light_purple", "killedByTeam.red", "killedByTeam.white", "killedByTeam.yellow", "teamkill.aqua", "teamkill.black", "teamkill.blue", "teamkill.dark_aqua", "teamkill.dark_blue", "teamkill.dark_gray", "teamkill.dark_green", "teamkill.dark_purple", "teamkill.dark_red", "teamkill.gold", "teamkill.gray", "teamkill.green", "teamkill.light_purple", "teamkill.red", "teamkill.white", "teamkill.yellow");
    private static final Set<String> f_16932_ = ImmutableSet.builder().add((Object)"stat.craftItem.minecraft.spawn_egg").add((Object)"stat.useItem.minecraft.spawn_egg").add((Object)"stat.breakItem.minecraft.spawn_egg").add((Object)"stat.pickup.minecraft.spawn_egg").add((Object)"stat.drop.minecraft.spawn_egg").build();
    private static final Map<String, String> f_16933_ = ImmutableMap.builder().put((Object)"stat.leaveGame", (Object)"minecraft:leave_game").put((Object)"stat.playOneMinute", (Object)"minecraft:play_one_minute").put((Object)"stat.timeSinceDeath", (Object)"minecraft:time_since_death").put((Object)"stat.sneakTime", (Object)"minecraft:sneak_time").put((Object)"stat.walkOneCm", (Object)"minecraft:walk_one_cm").put((Object)"stat.crouchOneCm", (Object)"minecraft:crouch_one_cm").put((Object)"stat.sprintOneCm", (Object)"minecraft:sprint_one_cm").put((Object)"stat.swimOneCm", (Object)"minecraft:swim_one_cm").put((Object)"stat.fallOneCm", (Object)"minecraft:fall_one_cm").put((Object)"stat.climbOneCm", (Object)"minecraft:climb_one_cm").put((Object)"stat.flyOneCm", (Object)"minecraft:fly_one_cm").put((Object)"stat.diveOneCm", (Object)"minecraft:dive_one_cm").put((Object)"stat.minecartOneCm", (Object)"minecraft:minecart_one_cm").put((Object)"stat.boatOneCm", (Object)"minecraft:boat_one_cm").put((Object)"stat.pigOneCm", (Object)"minecraft:pig_one_cm").put((Object)"stat.horseOneCm", (Object)"minecraft:horse_one_cm").put((Object)"stat.aviateOneCm", (Object)"minecraft:aviate_one_cm").put((Object)"stat.jump", (Object)"minecraft:jump").put((Object)"stat.drop", (Object)"minecraft:drop").put((Object)"stat.damageDealt", (Object)"minecraft:damage_dealt").put((Object)"stat.damageTaken", (Object)"minecraft:damage_taken").put((Object)"stat.deaths", (Object)"minecraft:deaths").put((Object)"stat.mobKills", (Object)"minecraft:mob_kills").put((Object)"stat.animalsBred", (Object)"minecraft:animals_bred").put((Object)"stat.playerKills", (Object)"minecraft:player_kills").put((Object)"stat.fishCaught", (Object)"minecraft:fish_caught").put((Object)"stat.talkedToVillager", (Object)"minecraft:talked_to_villager").put((Object)"stat.tradedWithVillager", (Object)"minecraft:traded_with_villager").put((Object)"stat.cakeSlicesEaten", (Object)"minecraft:eat_cake_slice").put((Object)"stat.cauldronFilled", (Object)"minecraft:fill_cauldron").put((Object)"stat.cauldronUsed", (Object)"minecraft:use_cauldron").put((Object)"stat.armorCleaned", (Object)"minecraft:clean_armor").put((Object)"stat.bannerCleaned", (Object)"minecraft:clean_banner").put((Object)"stat.brewingstandInteraction", (Object)"minecraft:interact_with_brewingstand").put((Object)"stat.beaconInteraction", (Object)"minecraft:interact_with_beacon").put((Object)"stat.dropperInspected", (Object)"minecraft:inspect_dropper").put((Object)"stat.hopperInspected", (Object)"minecraft:inspect_hopper").put((Object)"stat.dispenserInspected", (Object)"minecraft:inspect_dispenser").put((Object)"stat.noteblockPlayed", (Object)"minecraft:play_noteblock").put((Object)"stat.noteblockTuned", (Object)"minecraft:tune_noteblock").put((Object)"stat.flowerPotted", (Object)"minecraft:pot_flower").put((Object)"stat.trappedChestTriggered", (Object)"minecraft:trigger_trapped_chest").put((Object)"stat.enderchestOpened", (Object)"minecraft:open_enderchest").put((Object)"stat.itemEnchanted", (Object)"minecraft:enchant_item").put((Object)"stat.recordPlayed", (Object)"minecraft:play_record").put((Object)"stat.furnaceInteraction", (Object)"minecraft:interact_with_furnace").put((Object)"stat.craftingTableInteraction", (Object)"minecraft:interact_with_crafting_table").put((Object)"stat.chestOpened", (Object)"minecraft:open_chest").put((Object)"stat.sleepInBed", (Object)"minecraft:sleep_in_bed").put((Object)"stat.shulkerBoxOpened", (Object)"minecraft:open_shulker_box").build();
    private static final String f_145695_ = "stat.mineBlock";
    private static final String f_145696_ = "minecraft:mined";
    private static final Map<String, String> f_16934_ = ImmutableMap.builder().put((Object)"stat.craftItem", (Object)"minecraft:crafted").put((Object)"stat.useItem", (Object)"minecraft:used").put((Object)"stat.breakItem", (Object)"minecraft:broken").put((Object)"stat.pickup", (Object)"minecraft:picked_up").put((Object)"stat.drop", (Object)"minecraft:dropped").build();
    private static final Map<String, String> f_16935_ = ImmutableMap.builder().put((Object)"stat.entityKilledBy", (Object)"minecraft:killed_by").put((Object)"stat.killEntity", (Object)"minecraft:killed").build();
    private static final Map<String, String> f_16936_ = ImmutableMap.builder().put((Object)"Bat", (Object)"minecraft:bat").put((Object)"Blaze", (Object)"minecraft:blaze").put((Object)"CaveSpider", (Object)"minecraft:cave_spider").put((Object)"Chicken", (Object)"minecraft:chicken").put((Object)"Cow", (Object)"minecraft:cow").put((Object)"Creeper", (Object)"minecraft:creeper").put((Object)"Donkey", (Object)"minecraft:donkey").put((Object)"ElderGuardian", (Object)"minecraft:elder_guardian").put((Object)"Enderman", (Object)"minecraft:enderman").put((Object)"Endermite", (Object)"minecraft:endermite").put((Object)"EvocationIllager", (Object)"minecraft:evocation_illager").put((Object)"Ghast", (Object)"minecraft:ghast").put((Object)"Guardian", (Object)"minecraft:guardian").put((Object)"Horse", (Object)"minecraft:horse").put((Object)"Husk", (Object)"minecraft:husk").put((Object)"Llama", (Object)"minecraft:llama").put((Object)"LavaSlime", (Object)"minecraft:magma_cube").put((Object)"MushroomCow", (Object)"minecraft:mooshroom").put((Object)"Mule", (Object)"minecraft:mule").put((Object)"Ozelot", (Object)"minecraft:ocelot").put((Object)"Parrot", (Object)"minecraft:parrot").put((Object)"Pig", (Object)"minecraft:pig").put((Object)"PolarBear", (Object)"minecraft:polar_bear").put((Object)"Rabbit", (Object)"minecraft:rabbit").put((Object)"Sheep", (Object)"minecraft:sheep").put((Object)"Shulker", (Object)"minecraft:shulker").put((Object)"Silverfish", (Object)"minecraft:silverfish").put((Object)"SkeletonHorse", (Object)"minecraft:skeleton_horse").put((Object)"Skeleton", (Object)"minecraft:skeleton").put((Object)"Slime", (Object)"minecraft:slime").put((Object)"Spider", (Object)"minecraft:spider").put((Object)"Squid", (Object)"minecraft:squid").put((Object)"Stray", (Object)"minecraft:stray").put((Object)"Vex", (Object)"minecraft:vex").put((Object)"Villager", (Object)"minecraft:villager").put((Object)"VindicationIllager", (Object)"minecraft:vindication_illager").put((Object)"Witch", (Object)"minecraft:witch").put((Object)"WitherSkeleton", (Object)"minecraft:wither_skeleton").put((Object)"Wolf", (Object)"minecraft:wolf").put((Object)"ZombieHorse", (Object)"minecraft:zombie_horse").put((Object)"PigZombie", (Object)"minecraft:zombie_pigman").put((Object)"ZombieVillager", (Object)"minecraft:zombie_villager").put((Object)"Zombie", (Object)"minecraft:zombie").build();
    private static final String f_145697_ = "minecraft:custom";

    public StatsCounterFix(Schema p_16939_, boolean p_16940_) {
        super(p_16939_, p_16940_);
    }

    @Nullable
    private static StatType m_292993_(String p_300248_) {
        if (f_16932_.contains(p_300248_)) {
            return null;
        }
        String $$1 = f_16933_.get(p_300248_);
        if ($$1 != null) {
            return new StatType(f_145697_, $$1);
        }
        int $$2 = StringUtils.ordinalIndexOf((CharSequence)p_300248_, (CharSequence)".", (int)2);
        if ($$2 < 0) {
            return null;
        }
        String $$3 = p_300248_.substring(0, $$2);
        if (f_145695_.equals($$3)) {
            String $$4 = StatsCounterFix.m_16950_(p_300248_.substring($$2 + 1).replace('.', ':'));
            return new StatType(f_145696_, $$4);
        }
        String $$5 = f_16934_.get($$3);
        if ($$5 != null) {
            String $$6 = p_300248_.substring($$2 + 1).replace('.', ':');
            String $$7 = StatsCounterFix.m_16948_($$6);
            String $$8 = $$7 == null ? $$6 : $$7;
            return new StatType($$5, $$8);
        }
        String $$9 = f_16935_.get($$3);
        if ($$9 != null) {
            String $$10 = p_300248_.substring($$2 + 1).replace('.', ':');
            String $$11 = f_16936_.getOrDefault($$10, $$10);
            return new StatType($$9, $$11);
        }
        return null;
    }

    public TypeRewriteRule makeRule() {
        return TypeRewriteRule.seq((TypeRewriteRule)this.m_295355_(), (TypeRewriteRule)this.m_293029_());
    }

    private TypeRewriteRule m_295355_() {
        Type $$0 = this.getInputSchema().getType(References.f_16777_);
        Type $$1 = this.getOutputSchema().getType(References.f_16777_);
        return this.fixTypeEverywhereTyped("StatsCounterFix", $$0, $$1, p_296638_ -> {
            Dynamic $$2 = (Dynamic)p_296638_.get(DSL.remainderFinder());
            HashMap $$3 = Maps.newHashMap();
            Optional $$4 = $$2.getMapValues().result();
            if ($$4.isPresent()) {
                for (Map.Entry $$5 : ((Map)$$4.get()).entrySet()) {
                    String $$6;
                    StatType $$7;
                    if (!((Dynamic)$$5.getValue()).asNumber().result().isPresent() || ($$7 = StatsCounterFix.m_292993_($$6 = ((Dynamic)$$5.getKey()).asString(""))) == null) continue;
                    Dynamic $$8 = $$2.createString($$7.f_291011_());
                    Dynamic $$9 = $$3.computeIfAbsent($$8, p_145701_ -> $$2.emptyMap());
                    $$3.put($$8, $$9.set($$7.f_291079_(), (Dynamic)$$5.getValue()));
                }
            }
            return (Typed)((Pair)$$1.readTyped($$2.emptyMap().set("stats", $$2.createMap((Map)$$3))).result().orElseThrow(() -> new IllegalStateException("Could not parse new stats object."))).getFirst();
        });
    }

    private TypeRewriteRule m_293029_() {
        Type $$0 = this.getInputSchema().getType(References.f_16791_);
        Type $$1 = this.getOutputSchema().getType(References.f_16791_);
        return this.fixTypeEverywhereTyped("ObjectiveStatFix", $$0, $$1, p_296641_ -> {
            Dynamic $$2 = (Dynamic)p_296641_.get(DSL.remainderFinder());
            Dynamic $$3 = $$2.update("CriteriaName", p_296639_ -> (Dynamic)DataFixUtils.orElse(p_296639_.asString().result().map(p_296636_ -> {
                if (f_291555_.contains(p_296636_)) {
                    return p_296636_;
                }
                StatType $$1 = StatsCounterFix.m_292993_(p_296636_);
                if ($$1 == null) {
                    return "dummy";
                }
                return V1451_6.m_293010_($$1.f_291011_) + ":" + V1451_6.m_293010_($$1.f_291079_);
            }).map(arg_0 -> ((Dynamic)p_296639_).createString(arg_0)), (Object)p_296639_));
            return (Typed)((Pair)$$1.readTyped($$3).result().orElseThrow(() -> new IllegalStateException("Could not parse new objective object."))).getFirst();
        });
    }

    @Nullable
    private static String m_16948_(String p_16949_) {
        return ItemStackTheFlatteningFix.m_16122_(p_16949_, 0);
    }

    private static String m_16950_(String p_16951_) {
        return BlockStateData.m_14950_(p_16951_);
    }

    record StatType(String f_291011_, String f_291079_) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{StatType.class, "type;typeKey", "f_291011_", "f_291079_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{StatType.class, "type;typeKey", "f_291011_", "f_291079_"}, this);
        }

        @Override
        public final boolean equals(Object p_300634_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{StatType.class, "type;typeKey", "f_291011_", "f_291079_"}, this, p_300634_);
        }
    }
}

