/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.BaseMapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Base64;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.HolderSet;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.joml.AxisAngle4f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class ExtraCodecs {
    public static final Codec<JsonElement> f_252400_ = Codec.PASSTHROUGH.xmap(p_253507_ -> (JsonElement)p_253507_.convert((DynamicOps)JsonOps.INSTANCE).getValue(), p_253513_ -> new Dynamic((DynamicOps)JsonOps.INSTANCE, p_253513_));
    public static final Codec<Component> f_252442_ = ExtraCodecs.m_293657_(Component.Serializer::m_130691_, Component.Serializer::m_130716_);
    public static final Codec<Component> f_276686_ = Codec.STRING.flatXmap(p_277276_ -> {
        try {
            return DataResult.success((Object)Component.Serializer.m_130701_(p_277276_));
        }
        catch (JsonParseException $$1) {
            return DataResult.error($$1::getMessage);
        }
    }, p_277277_ -> {
        try {
            return DataResult.success((Object)Component.Serializer.m_130703_(p_277277_));
        }
        catch (IllegalArgumentException $$1) {
            return DataResult.error($$1::getMessage);
        }
    });
    public static final Codec<Vector3f> f_252432_ = Codec.FLOAT.listOf().comapFlatMap(p_253502_ -> Util.m_143795_(p_253502_, 3).map(p_253489_ -> new Vector3f(((Float)p_253489_.get(0)).floatValue(), ((Float)p_253489_.get(1)).floatValue(), ((Float)p_253489_.get(2)).floatValue())), p_269787_ -> List.of(Float.valueOf(p_269787_.x()), Float.valueOf(p_269787_.y()), Float.valueOf(p_269787_.z())));
    public static final Codec<Quaternionf> f_268572_ = Codec.FLOAT.listOf().comapFlatMap(p_269773_ -> Util.m_143795_(p_269773_, 4).map(p_269785_ -> new Quaternionf(((Float)p_269785_.get(0)).floatValue(), ((Float)p_269785_.get(1)).floatValue(), ((Float)p_269785_.get(2)).floatValue(), ((Float)p_269785_.get(3)).floatValue())), p_269780_ -> List.of(Float.valueOf(p_269780_.x), Float.valueOf(p_269780_.y), Float.valueOf(p_269780_.z), Float.valueOf(p_269780_.w)));
    public static final Codec<AxisAngle4f> f_268751_ = RecordCodecBuilder.create(p_269774_ -> p_269774_.group((App)Codec.FLOAT.fieldOf("angle").forGetter(p_269776_ -> Float.valueOf(p_269776_.angle)), (App)f_252432_.fieldOf("axis").forGetter(p_269778_ -> new Vector3f(p_269778_.x, p_269778_.y, p_269778_.z))).apply((Applicative)p_269774_, AxisAngle4f::new));
    public static final Codec<Quaternionf> f_268538_ = ExtraCodecs.m_293304_(f_268572_, f_268751_.xmap(Quaternionf::new, AxisAngle4f::new));
    public static Codec<Matrix4f> f_268748_ = Codec.FLOAT.listOf().comapFlatMap(p_269788_ -> Util.m_143795_(p_269788_, 16).map(p_269777_ -> {
        Matrix4f $$1 = new Matrix4f();
        for (int $$2 = 0; $$2 < p_269777_.size(); ++$$2) {
            $$1.setRowColumn($$2 >> 2, $$2 & 3, ((Float)p_269777_.get($$2)).floatValue());
        }
        return $$1.determineProperties();
    }), p_269775_ -> {
        FloatArrayList $$1 = new FloatArrayList(16);
        for (int $$2 = 0; $$2 < 16; ++$$2) {
            $$1.add(p_269775_.getRowColumn($$2 >> 2, $$2 & 3));
        }
        return $$1;
    });
    public static final Codec<Integer> f_144628_ = ExtraCodecs.m_144633_(0, Integer.MAX_VALUE, p_275703_ -> "Value must be non-negative: " + p_275703_);
    public static final Codec<Integer> f_144629_ = ExtraCodecs.m_144633_(1, Integer.MAX_VALUE, p_274847_ -> "Value must be positive: " + p_274847_);
    public static final Codec<Float> f_184349_ = ExtraCodecs.m_184350_(0.0f, Float.MAX_VALUE, p_274876_ -> "Value must be positive: " + p_274876_);
    public static final Codec<Pattern> f_216158_ = Codec.STRING.comapFlatMap(p_274857_ -> {
        try {
            return DataResult.success((Object)Pattern.compile(p_274857_));
        }
        catch (PatternSyntaxException $$1) {
            return DataResult.error(() -> "Invalid regex pattern '" + p_274857_ + "': " + $$1.getMessage());
        }
    }, Pattern::pattern);
    public static final Codec<Instant> f_216159_ = ExtraCodecs.m_216170_(DateTimeFormatter.ISO_INSTANT).xmap(Instant::from, Function.identity());
    public static final Codec<byte[]> f_216160_ = Codec.STRING.comapFlatMap(p_274852_ -> {
        try {
            return DataResult.success((Object)Base64.getDecoder().decode((String)p_274852_));
        }
        catch (IllegalArgumentException $$1) {
            return DataResult.error(() -> "Malformed base64 string");
        }
    }, p_216180_ -> Base64.getEncoder().encodeToString((byte[])p_216180_));
    public static final Codec<String> f_291683_ = Codec.STRING.comapFlatMap(p_296617_ -> DataResult.success((Object)StringEscapeUtils.unescapeJava((String)p_296617_)), StringEscapeUtils::escapeJava);
    public static final Codec<TagOrElementLocation> f_216161_ = Codec.STRING.comapFlatMap(p_216169_ -> p_216169_.startsWith("#") ? ResourceLocation.m_135837_(p_216169_.substring(1)).map(p_216182_ -> new TagOrElementLocation((ResourceLocation)p_216182_, true)) : ResourceLocation.m_135837_(p_216169_).map(p_216165_ -> new TagOrElementLocation((ResourceLocation)p_216165_, false)), TagOrElementLocation::m_216202_);
    public static final Function<Optional<Long>, OptionalLong> f_216162_ = p_216176_ -> p_216176_.map(OptionalLong::of).orElseGet(OptionalLong::empty);
    public static final Function<OptionalLong, Optional<Long>> f_216163_ = p_216178_ -> p_216178_.isPresent() ? Optional.of(p_216178_.getAsLong()) : Optional.empty();
    public static final Codec<BitSet> f_252419_ = Codec.LONG_STREAM.xmap(p_253514_ -> BitSet.valueOf(p_253514_.toArray()), p_253493_ -> Arrays.stream(p_253493_.toLongArray()));
    private static final Codec<Property> f_252501_ = RecordCodecBuilder.create(p_253491_ -> p_253491_.group((App)Codec.STRING.fieldOf("name").forGetter(Property::name), (App)Codec.STRING.fieldOf("value").forGetter(Property::value), (App)Codec.STRING.optionalFieldOf("signature").forGetter(p_296611_ -> Optional.ofNullable(p_296611_.signature()))).apply((Applicative)p_253491_, (p_253494_, p_253495_, p_253496_) -> new Property(p_253494_, p_253495_, (String)p_253496_.orElse(null))));
    @VisibleForTesting
    public static final Codec<PropertyMap> f_252500_ = Codec.either((Codec)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING.listOf()), (Codec)f_252501_.listOf()).xmap(p_253515_ -> {
        PropertyMap $$1 = new PropertyMap();
        p_253515_.ifLeft(p_253506_ -> p_253506_.forEach((p_253500_, p_253501_) -> {
            for (String $$3 : p_253501_) {
                $$1.put(p_253500_, (Object)new Property(p_253500_, $$3));
            }
        })).ifRight(p_296607_ -> {
            for (Property $$2 : p_296607_) {
                $$1.put((Object)$$2.name(), (Object)$$2);
            }
        });
        return $$1;
    }, p_253504_ -> Either.right(p_253504_.values().stream().toList()));
    private static final MapCodec<GameProfile> f_291490_ = RecordCodecBuilder.mapCodec(p_296612_ -> p_296612_.group((App)UUIDUtil.f_252480_.fieldOf("id").forGetter(GameProfile::getId), (App)Codec.STRING.fieldOf("name").forGetter(GameProfile::getName)).apply((Applicative)p_296612_, GameProfile::new));
    public static final Codec<GameProfile> f_252453_ = RecordCodecBuilder.create(p_296608_ -> p_296608_.group((App)f_291490_.forGetter(Function.identity()), (App)f_252500_.optionalFieldOf("properties", (Object)new PropertyMap()).forGetter(GameProfile::getProperties)).apply((Applicative)p_296608_, (p_253518_, p_253519_) -> {
        p_253519_.forEach((p_253511_, p_253512_) -> p_253518_.getProperties().put(p_253511_, p_253512_));
        return p_253518_;
    }));
    public static final Codec<String> f_263723_ = ExtraCodecs.m_264370_(Codec.STRING, p_274858_ -> p_274858_.isEmpty() ? DataResult.error(() -> "Expected non-empty string") : DataResult.success((Object)p_274858_));
    public static final Codec<Integer> f_283896_ = Codec.STRING.comapFlatMap(p_284688_ -> {
        int[] $$1 = p_284688_.codePoints().toArray();
        if ($$1.length != 1) {
            return DataResult.error(() -> "Expected one codepoint, got: " + p_284688_);
        }
        return DataResult.success((Object)$$1[0]);
    }, Character::toString);
    public static Codec<String> f_291300_ = ExtraCodecs.m_264370_(Codec.STRING, p_296613_ -> {
        if (!ResourceLocation.m_135841_(p_296613_)) {
            return DataResult.error(() -> "Invalid string to use as a resource path element: " + p_296613_);
        }
        return DataResult.success((Object)p_296613_);
    });

    @Deprecated
    public static <T> Codec<T> m_293657_(Function<JsonElement, T> p_301013_, Function<T, JsonElement> p_297664_) {
        return f_252400_.flatXmap(p_296625_ -> {
            try {
                return DataResult.success(p_301013_.apply((JsonElement)p_296625_));
            }
            catch (JsonParseException $$2) {
                return DataResult.error($$2::getMessage);
            }
        }, p_296615_ -> {
            try {
                return DataResult.success((Object)((JsonElement)p_297664_.apply(p_296615_)));
            }
            catch (IllegalArgumentException $$2) {
                return DataResult.error($$2::getMessage);
            }
        });
    }

    public static <F, S> Codec<Either<F, S>> m_144639_(Codec<F> p_144640_, Codec<S> p_144641_) {
        return new XorCodec<F, S>(p_144640_, p_144641_);
    }

    public static <P, I> Codec<I> m_184361_(Codec<P> p_184362_, String p_184363_, String p_184364_, BiFunction<P, P, DataResult<I>> p_184365_, Function<I, P> p_184366_, Function<I, P> p_184367_) {
        Codec $$6 = Codec.list(p_184362_).comapFlatMap(p_184398_ -> Util.m_143795_(p_184398_, 2).flatMap(p_184445_ -> {
            Object $$2 = p_184445_.get(0);
            Object $$3 = p_184445_.get(1);
            return (DataResult)p_184365_.apply($$2, $$3);
        }), p_184459_ -> ImmutableList.of(p_184366_.apply(p_184459_), p_184367_.apply(p_184459_)));
        Codec $$7 = RecordCodecBuilder.create(p_184360_ -> p_184360_.group((App)p_184362_.fieldOf(p_184363_).forGetter(Pair::getFirst), (App)p_184362_.fieldOf(p_184364_).forGetter(Pair::getSecond)).apply((Applicative)p_184360_, Pair::of)).comapFlatMap(p_184392_ -> (DataResult)p_184365_.apply(p_184392_.getFirst(), p_184392_.getSecond()), p_184449_ -> Pair.of(p_184366_.apply(p_184449_), p_184367_.apply(p_184449_)));
        Codec $$8 = ExtraCodecs.m_293304_($$6, $$7);
        return Codec.either(p_184362_, $$8).comapFlatMap(p_184389_ -> (DataResult)p_184389_.map(p_184395_ -> (DataResult)p_184365_.apply(p_184395_, p_184395_), DataResult::success), p_184411_ -> {
            Object $$4;
            Object $$3 = p_184366_.apply(p_184411_);
            if (Objects.equals($$3, $$4 = p_184367_.apply(p_184411_))) {
                return Either.left($$3);
            }
            return Either.right((Object)p_184411_);
        });
    }

    public static <A> Codec.ResultFunction<A> m_184381_(final A p_184382_) {
        return new Codec.ResultFunction<A>(){

            public <T> DataResult<Pair<A, T>> apply(DynamicOps<T> p_184466_, T p_184467_, DataResult<Pair<A, T>> p_184468_) {
                MutableObject $$3 = new MutableObject();
                Optional $$4 = p_184468_.resultOrPartial(arg_0 -> ((MutableObject)$$3).setValue(arg_0));
                if ($$4.isPresent()) {
                    return p_184468_;
                }
                return DataResult.error(() -> "(" + (String)$$3.getValue() + " -> using default)", (Object)Pair.of((Object)p_184382_, p_184467_));
            }

            public <T> DataResult<T> coApply(DynamicOps<T> p_184470_, A p_184471_, DataResult<T> p_184472_) {
                return p_184472_;
            }

            public String toString() {
                return "OrElsePartial[" + p_184382_ + "]";
            }
        };
    }

    public static <E> Codec<E> m_184421_(ToIntFunction<E> p_184422_, IntFunction<E> p_184423_, int p_184424_) {
        return Codec.INT.flatXmap(p_184414_ -> Optional.ofNullable(p_184423_.apply((int)p_184414_)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown element id: " + p_184414_)), p_274850_ -> {
            int $$3 = p_184422_.applyAsInt(p_274850_);
            return $$3 == p_184424_ ? DataResult.error(() -> "Element with unknown id: " + p_274850_) : DataResult.success((Object)$$3);
        });
    }

    public static <E> Codec<E> m_184405_(Function<E, String> p_184406_, Function<String, E> p_184407_) {
        return Codec.STRING.flatXmap(p_184404_ -> Optional.ofNullable(p_184407_.apply((String)p_184404_)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown element name:" + p_184404_)), p_184401_ -> Optional.ofNullable((String)p_184406_.apply(p_184401_)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Element with unknown name: " + p_184401_)));
    }

    public static <E> Codec<E> m_184425_(final Codec<E> p_184426_, final Codec<E> p_184427_) {
        return new Codec<E>(){

            public <T> DataResult<T> encode(E p_184483_, DynamicOps<T> p_184484_, T p_184485_) {
                if (p_184484_.compressMaps()) {
                    return p_184427_.encode(p_184483_, p_184484_, p_184485_);
                }
                return p_184426_.encode(p_184483_, p_184484_, p_184485_);
            }

            public <T> DataResult<Pair<E, T>> decode(DynamicOps<T> p_184480_, T p_184481_) {
                if (p_184480_.compressMaps()) {
                    return p_184427_.decode(p_184480_, p_184481_);
                }
                return p_184426_.decode(p_184480_, p_184481_);
            }

            public String toString() {
                return p_184426_ + " orCompressed " + p_184427_;
            }
        };
    }

    public static <E> Codec<E> m_184368_(Codec<E> p_184369_, final Function<E, Lifecycle> p_184370_, final Function<E, Lifecycle> p_184371_) {
        return p_184369_.mapResult(new Codec.ResultFunction<E>(){

            public <T> DataResult<Pair<E, T>> apply(DynamicOps<T> p_184497_, T p_184498_, DataResult<Pair<E, T>> p_184499_) {
                return p_184499_.result().map(p_184495_ -> p_184499_.setLifecycle((Lifecycle)p_184370_.apply(p_184495_.getFirst()))).orElse(p_184499_);
            }

            public <T> DataResult<T> coApply(DynamicOps<T> p_184501_, E p_184502_, DataResult<T> p_184503_) {
                return p_184503_.setLifecycle((Lifecycle)p_184371_.apply(p_184502_));
            }

            public String toString() {
                return "WithLifecycle[" + p_184370_ + " " + p_184371_ + "]";
            }
        });
    }

    public static <F, S> EitherCodec<F, S> m_294448_(Codec<F> p_298040_, Codec<S> p_300729_) {
        return new EitherCodec<F, S>(p_298040_, p_300729_);
    }

    public static <K, V> StrictUnboundedMapCodec<K, V> m_295464_(Codec<K> p_298880_, Codec<V> p_297369_) {
        return new StrictUnboundedMapCodec<K, V>(p_298880_, p_297369_);
    }

    public static <T> Codec<T> m_264370_(Codec<T> p_265690_, Function<T, DataResult<T>> p_265223_) {
        if (p_265690_ instanceof MapCodec.MapCodecCodec) {
            MapCodec.MapCodecCodec $$2 = (MapCodec.MapCodecCodec)p_265690_;
            return ExtraCodecs.m_285994_($$2.codec(), p_265223_).codec();
        }
        return p_265690_.flatXmap(p_265223_, p_265223_);
    }

    public static <T> MapCodec<T> m_285994_(MapCodec<T> p_286613_, Function<T, DataResult<T>> p_286875_) {
        return p_286613_.flatXmap(p_286875_, p_286875_);
    }

    private static Codec<Integer> m_144633_(int p_144634_, int p_144635_, Function<Integer, String> p_144636_) {
        return ExtraCodecs.m_264370_(Codec.INT, p_274889_ -> {
            if (p_274889_.compareTo(p_144634_) >= 0 && p_274889_.compareTo(p_144635_) <= 0) {
                return DataResult.success((Object)p_274889_);
            }
            return DataResult.error(() -> (String)p_144636_.apply((Integer)p_274889_));
        });
    }

    public static Codec<Integer> m_269197_(int p_270883_, int p_270323_) {
        return ExtraCodecs.m_144633_(p_270883_, p_270323_, p_269784_ -> "Value must be within range [" + p_270883_ + ";" + p_270323_ + "]: " + p_269784_);
    }

    private static Codec<Float> m_184350_(float p_184351_, float p_184352_, Function<Float, String> p_184353_) {
        return ExtraCodecs.m_264370_(Codec.FLOAT, p_274865_ -> {
            if (p_274865_.compareTo(Float.valueOf(p_184351_)) > 0 && p_274865_.compareTo(Float.valueOf(p_184352_)) <= 0) {
                return DataResult.success((Object)p_274865_);
            }
            return DataResult.error(() -> (String)p_184353_.apply((Float)p_274865_));
        });
    }

    public static <T> Codec<List<T>> m_144637_(Codec<List<T>> p_144638_) {
        return ExtraCodecs.m_264370_(p_144638_, p_274853_ -> p_274853_.isEmpty() ? DataResult.error(() -> "List must have contents") : DataResult.success((Object)p_274853_));
    }

    public static <T> Codec<HolderSet<T>> m_203982_(Codec<HolderSet<T>> p_203983_) {
        return ExtraCodecs.m_264370_(p_203983_, p_274860_ -> {
            if (p_274860_.m_203440_().right().filter(List::isEmpty).isPresent()) {
                return DataResult.error(() -> "List must have contents");
            }
            return DataResult.success((Object)p_274860_);
        });
    }

    public static <T> Codec<T> m_293376_(Function<Codec<T>, Codec<T>> p_298069_) {
        return new RecursiveCodec<T>(p_298069_);
    }

    public static <A> Codec<A> m_184415_(Supplier<Codec<A>> p_184416_) {
        return new RecursiveCodec(p_296623_ -> (Codec)p_184416_.get());
    }

    public static <A> MapCodec<Optional<A>> m_294263_(Codec<A> p_298284_, String p_297262_) {
        return new StrictOptionalFieldCodec<A>(p_297262_, p_298284_);
    }

    public static <A> MapCodec<A> m_295827_(Codec<A> p_298122_, String p_301181_, A p_300795_) {
        return ExtraCodecs.m_294263_(p_298122_, p_301181_).xmap(p_296619_ -> p_296619_.orElse(p_300795_), p_296610_ -> Objects.equals(p_296610_, p_300795_) ? Optional.empty() : Optional.of(p_296610_));
    }

    public static <E> MapCodec<E> m_203976_(Function<DynamicOps<?>, DataResult<E>> p_203977_) {
        class ContextRetrievalCodec
        extends MapCodec<E> {
            final /* synthetic */ Function f_203986_;

            ContextRetrievalCodec(Function function) {
                this.f_203986_ = function;
            }

            public <T> RecordBuilder<T> encode(E p_203993_, DynamicOps<T> p_203994_, RecordBuilder<T> p_203995_) {
                return p_203995_;
            }

            public <T> DataResult<E> decode(DynamicOps<T> p_203990_, MapLike<T> p_203991_) {
                return (DataResult)this.f_203986_.apply(p_203990_);
            }

            public String toString() {
                return "ContextRetrievalCodec[" + this.f_203986_ + "]";
            }

            public <T> Stream<T> keys(DynamicOps<T> p_203997_) {
                return Stream.empty();
            }
        }
        return new ContextRetrievalCodec(p_203977_);
    }

    public static <E, L extends Collection<E>, T> Function<L, DataResult<L>> m_203984_(Function<E, T> p_203985_) {
        return p_203980_ -> {
            Iterator $$2 = p_203980_.iterator();
            if ($$2.hasNext()) {
                Object $$3 = p_203985_.apply($$2.next());
                while ($$2.hasNext()) {
                    Object $$4 = $$2.next();
                    Object $$5 = p_203985_.apply($$4);
                    if ($$5 == $$3) continue;
                    return DataResult.error(() -> "Mixed type list: element " + $$4 + " had type " + $$5 + ", but list is of type " + $$3);
                }
            }
            return DataResult.success((Object)p_203980_, (Lifecycle)Lifecycle.stable());
        };
    }

    public static <A> Codec<A> m_216185_(final Codec<A> p_216186_) {
        return Codec.of(p_216186_, (Decoder)new Decoder<A>(){

            public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> p_216193_, T p_216194_) {
                try {
                    return p_216186_.decode(p_216193_, p_216194_);
                }
                catch (Exception $$2) {
                    return DataResult.error(() -> "Caught exception decoding " + p_216194_ + ": " + $$2.getMessage());
                }
            }
        });
    }

    public static Codec<TemporalAccessor> m_216170_(DateTimeFormatter p_216171_) {
        return Codec.STRING.comapFlatMap(p_296605_ -> {
            try {
                return DataResult.success((Object)p_216171_.parse((CharSequence)p_296605_));
            }
            catch (Exception $$2) {
                return DataResult.error($$2::getMessage);
            }
        }, p_216171_::format);
    }

    public static MapCodec<OptionalLong> m_216166_(MapCodec<Optional<Long>> p_216167_) {
        return p_216167_.xmap(f_216162_, f_216163_);
    }

    public static Codec<String> m_264337_(int p_265773_, int p_265217_) {
        return ExtraCodecs.m_264370_(Codec.STRING, p_274879_ -> {
            int $$3 = p_274879_.length();
            if ($$3 < p_265773_) {
                return DataResult.error(() -> "String \"" + p_274879_ + "\" is too short: " + $$3 + ", expected range [" + p_265773_ + "-" + p_265217_ + "]");
            }
            if ($$3 > p_265217_) {
                return DataResult.error(() -> "String \"" + p_274879_ + "\" is too long: " + $$3 + ", expected range [" + p_265773_ + "-" + p_265217_ + "]");
            }
            return DataResult.success((Object)p_274879_);
        });
    }

    public static <T> Codec<T> m_293304_(Codec<T> p_300585_, Codec<? extends T> p_300484_) {
        return Codec.either(p_300585_, p_300484_).xmap(p_184355_ -> p_184355_.map(p_184461_ -> p_184461_, p_184455_ -> p_184455_), Either::left);
    }

    public static <T, U> Codec<T> m_292858_(Codec<T> p_299945_, Codec<U> p_299401_, Function<U, T> p_297361_) {
        return Codec.either(p_299945_, p_299401_).xmap(p_296621_ -> p_296621_.map(p_300206_ -> p_300206_, p_297361_), Either::left);
    }

    public static <T> Codec<Object2BooleanMap<T>> m_293159_(Codec<T> p_300841_) {
        return Codec.unboundedMap(p_300841_, (Codec)Codec.BOOL).xmap(Object2BooleanOpenHashMap::new, Object2ObjectOpenHashMap::new);
    }

    record XorCodec<F, S>(Codec<F> f_144657_, Codec<S> f_144658_) implements Codec<Either<F, S>>
    {
        public <T> DataResult<Pair<Either<F, S>, T>> decode(DynamicOps<T> p_144679_, T p_144680_) {
            DataResult $$2 = this.f_144657_.decode(p_144679_, p_144680_).map(p_144673_ -> p_144673_.mapFirst(Either::left));
            DataResult $$3 = this.f_144658_.decode(p_144679_, p_144680_).map(p_144667_ -> p_144667_.mapFirst(Either::right));
            Optional $$4 = $$2.result();
            Optional $$5 = $$3.result();
            if ($$4.isPresent() && $$5.isPresent()) {
                return DataResult.error(() -> "Both alternatives read successfully, can not pick the correct one; first: " + $$4.get() + " second: " + $$5.get(), (Object)((Pair)$$4.get()));
            }
            if ($$4.isPresent()) {
                return $$2;
            }
            if ($$5.isPresent()) {
                return $$3;
            }
            return $$2.apply2((p_296626_, p_296627_) -> p_296627_, $$3);
        }

        public <T> DataResult<T> encode(Either<F, S> p_144663_, DynamicOps<T> p_144664_, T p_144665_) {
            return (DataResult)p_144663_.map(p_144677_ -> this.f_144657_.encode(p_144677_, p_144664_, p_144665_), p_144671_ -> this.f_144658_.encode(p_144671_, p_144664_, p_144665_));
        }

        @Override
        public String toString() {
            return "XorCodec[" + this.f_144657_ + ", " + this.f_144658_ + "]";
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{XorCodec.class, "first;second", "f_144657_", "f_144658_"}, this);
        }

        @Override
        public final boolean equals(Object p_144686_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{XorCodec.class, "first;second", "f_144657_", "f_144658_"}, this, p_144686_);
        }

        public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
            return this.encode((Either)object, dynamicOps, object2);
        }
    }

    public static final class EitherCodec<F, S>
    implements Codec<Either<F, S>> {
        private final Codec<F> f_184505_;
        private final Codec<S> f_184506_;

        public EitherCodec(Codec<F> p_184508_, Codec<S> p_184509_) {
            this.f_184505_ = p_184508_;
            this.f_184506_ = p_184509_;
        }

        public <T> DataResult<Pair<Either<F, S>, T>> decode(DynamicOps<T> p_184530_, T p_184531_) {
            DataResult $$2 = this.f_184505_.decode(p_184530_, p_184531_).map(p_184524_ -> p_184524_.mapFirst(Either::left));
            if ($$2.error().isEmpty()) {
                return $$2;
            }
            DataResult $$3 = this.f_184506_.decode(p_184530_, p_184531_).map(p_184515_ -> p_184515_.mapFirst(Either::right));
            if ($$3.error().isEmpty()) {
                return $$3;
            }
            return $$2.apply2((p_184517_, p_184518_) -> p_184518_, $$3);
        }

        public <T> DataResult<T> encode(Either<F, S> p_184511_, DynamicOps<T> p_184512_, T p_184513_) {
            return (DataResult)p_184511_.map(p_184528_ -> this.f_184505_.encode(p_184528_, p_184512_, p_184513_), p_184522_ -> this.f_184506_.encode(p_184522_, p_184512_, p_184513_));
        }

        public boolean equals(Object p_184537_) {
            if (this == p_184537_) {
                return true;
            }
            if (p_184537_ == null || this.getClass() != p_184537_.getClass()) {
                return false;
            }
            EitherCodec $$1 = (EitherCodec)p_184537_;
            return Objects.equals(this.f_184505_, $$1.f_184505_) && Objects.equals(this.f_184506_, $$1.f_184506_);
        }

        public int hashCode() {
            return Objects.hash(this.f_184505_, this.f_184506_);
        }

        public String toString() {
            return "EitherCodec[" + this.f_184505_ + ", " + this.f_184506_ + "]";
        }

        public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
            return this.encode((Either)object, dynamicOps, object2);
        }
    }

    public static final class StrictUnboundedMapCodec<K, V>
    extends Record
    implements Codec<Map<K, V>>,
    BaseMapCodec<K, V> {
        private final Codec<K> f_291761_;
        private final Codec<V> f_291744_;

        public StrictUnboundedMapCodec(Codec<K> f_291761_, Codec<V> f_291744_) {
            this.f_291761_ = f_291761_;
            this.f_291744_ = f_291744_;
        }

        public <T> DataResult<Map<K, V>> decode(DynamicOps<T> p_298061_, MapLike<T> p_299914_) {
            ImmutableMap.Builder $$2 = ImmutableMap.builder();
            for (Pair $$3 : p_299914_.entries().toList()) {
                DataResult $$5;
                DataResult $$4 = this.keyCodec().parse(p_298061_, $$3.getFirst());
                DataResult $$6 = $$4.apply2stable(Pair::of, $$5 = this.elementCodec().parse(p_298061_, $$3.getSecond()));
                if ($$6.error().isPresent()) {
                    return DataResult.error(() -> {
                        String $$4;
                        DataResult.PartialResult $$2 = (DataResult.PartialResult)$$6.error().get();
                        if ($$4.result().isPresent()) {
                            String $$3 = "Map entry '" + $$4.result().get() + "' : " + $$2.message();
                        } else {
                            $$4 = $$2.message();
                        }
                        return $$4;
                    });
                }
                if ($$6.result().isPresent()) {
                    Pair $$7 = (Pair)$$6.result().get();
                    $$2.put($$7.getFirst(), $$7.getSecond());
                    continue;
                }
                return DataResult.error(() -> "Empty or invalid map contents are not allowed");
            }
            ImmutableMap $$8 = $$2.build();
            return DataResult.success((Object)$$8);
        }

        public <T> DataResult<Pair<Map<K, V>, T>> decode(DynamicOps<T> p_299262_, T p_297460_) {
            return p_299262_.getMap(p_297460_).setLifecycle(Lifecycle.stable()).flatMap(p_297301_ -> this.decode(p_299262_, (Object)p_297301_)).map(p_300226_ -> Pair.of((Object)p_300226_, (Object)p_297460_));
        }

        public <T> DataResult<T> encode(Map<K, V> p_301091_, DynamicOps<T> p_298442_, T p_300447_) {
            return this.encode(p_301091_, p_298442_, p_298442_.mapBuilder()).build(p_300447_);
        }

        @Override
        public String toString() {
            return "StrictUnboundedMapCodec[" + this.f_291761_ + " -> " + this.f_291744_ + "]";
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{StrictUnboundedMapCodec.class, "keyCodec;elementCodec", "f_291761_", "f_291744_"}, this);
        }

        @Override
        public final boolean equals(Object p_299864_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{StrictUnboundedMapCodec.class, "keyCodec;elementCodec", "f_291761_", "f_291744_"}, this, p_299864_);
        }

        public Codec<K> keyCodec() {
            return this.f_291761_;
        }

        public Codec<V> elementCodec() {
            return this.f_291744_;
        }

        public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
            return this.encode((Map)object, dynamicOps, object2);
        }
    }

    static class RecursiveCodec<T>
    implements Codec<T> {
        private final Supplier<Codec<T>> f_291731_ = Suppliers.memoize(() -> (Codec)p_300700_.apply(this));

        RecursiveCodec(Function<Codec<T>, Codec<T>> p_300700_) {
        }

        public <S> DataResult<Pair<T, S>> decode(DynamicOps<S> p_298423_, S p_298846_) {
            return this.f_291731_.get().decode(p_298423_, p_298846_);
        }

        public <S> DataResult<S> encode(T p_297845_, DynamicOps<S> p_300705_, S p_299581_) {
            return this.f_291731_.get().encode(p_297845_, p_300705_, p_299581_);
        }

        public String toString() {
            return "RecursiveCodec[" + this.f_291731_ + "]";
        }
    }

    static final class StrictOptionalFieldCodec<A>
    extends MapCodec<Optional<A>> {
        private final String f_291177_;
        private final Codec<A> f_291168_;

        public StrictOptionalFieldCodec(String p_298144_, Codec<A> p_301114_) {
            this.f_291177_ = p_298144_;
            this.f_291168_ = p_301114_;
        }

        public <T> DataResult<Optional<A>> decode(DynamicOps<T> p_299736_, MapLike<T> p_298150_) {
            Object $$2 = p_298150_.get(this.f_291177_);
            if ($$2 == null) {
                return DataResult.success(Optional.empty());
            }
            return this.f_291168_.parse(p_299736_, $$2).map(Optional::of);
        }

        public <T> RecordBuilder<T> encode(Optional<A> p_299100_, DynamicOps<T> p_299809_, RecordBuilder<T> p_300932_) {
            if (p_299100_.isPresent()) {
                return p_300932_.add(this.f_291177_, this.f_291168_.encodeStart(p_299809_, p_299100_.get()));
            }
            return p_300932_;
        }

        public <T> Stream<T> keys(DynamicOps<T> p_300796_) {
            return Stream.of(p_300796_.createString(this.f_291177_));
        }

        public boolean equals(Object p_300958_) {
            if (this == p_300958_) {
                return true;
            }
            if (p_300958_ instanceof StrictOptionalFieldCodec) {
                StrictOptionalFieldCodec $$1 = (StrictOptionalFieldCodec)((Object)p_300958_);
                return Objects.equals(this.f_291177_, $$1.f_291177_) && Objects.equals(this.f_291168_, $$1.f_291168_);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.f_291177_, this.f_291168_);
        }

        public String toString() {
            return "StrictOptionalFieldCodec[" + this.f_291177_ + ": " + this.f_291168_ + "]";
        }

        public /* synthetic */ RecordBuilder encode(Object object, DynamicOps dynamicOps, RecordBuilder recordBuilder) {
            return this.encode((Optional)object, dynamicOps, recordBuilder);
        }
    }

    public record TagOrElementLocation(ResourceLocation f_216195_, boolean f_216196_) {
        @Override
        public String toString() {
            return this.m_216202_();
        }

        private String m_216202_() {
            return this.f_216196_ ? "#" + this.f_216195_ : this.f_216195_.toString();
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TagOrElementLocation.class, "id;tag", "f_216195_", "f_216196_"}, this);
        }

        @Override
        public final boolean equals(Object p_216204_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TagOrElementLocation.class, "id;tag", "f_216195_", "f_216196_"}, this, p_216204_);
        }
    }
}

